/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.stc;

import groovy.lang.GroovyRuntimeException;
import groovy.lang.IntRange;
import groovy.lang.ObjectRange;
import groovy.transform.TypeChecked;
import groovy.transform.TypeCheckingMode;
import java.beans.Introspector;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.ast.tools.WideningCategories;
import org.codehaus.groovy.classgen.ReturnAdder;
import org.codehaus.groovy.classgen.asm.BytecodeHelper;
import org.codehaus.groovy.classgen.asm.InvocationWriter;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.EncodingGroovyMethods;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.transform.stc.ExtensionMethodNode;
import org.codehaus.groovy.transform.stc.SharedVariableCollector;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;
import org.codehaus.groovy.transform.stc.TypeCheckerPlugin;
import org.codehaus.groovy.transform.stc.TypeCheckerPluginFactory;
import org.codehaus.groovy.transform.stc.UnionTypeClassNode;
import org.codehaus.groovy.util.ListHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticTypeCheckingVisitor
extends ClassCodeVisitorSupport {
    private static final ClassNode ITERABLE_TYPE = ClassHelper.make(Iterable.class);
    private static final List<MethodNode> EMPTY_METHODNODE_LIST = Collections.emptyList();
    private static final ClassNode TYPECHECKED_CLASSNODE = ClassHelper.make(TypeChecked.class);
    private static final ClassNode[] TYPECHECKING_ANNOTATIONS = new ClassNode[]{TYPECHECKED_CLASSNODE};
    private static final ClassNode TYPECHECKING_INFO_NODE = ClassHelper.make(TypeChecked.TypeCheckingInfo.class);
    private static final ClassNode DGM_CLASSNODE = ClassHelper.make(DefaultGroovyMethods.class);
    private static final int CURRENT_SIGNATURE_PROTOCOL_VERSION = 1;
    private static final Expression CURRENT_SIGNATURE_PROTOCOL = new ConstantExpression(1, true);
    public static final MethodNode CLOSURE_CALL_NO_ARG = ClassHelper.CLOSURE_TYPE.getDeclaredMethod("call", Parameter.EMPTY_ARRAY);
    public static final MethodNode CLOSURE_CALL_ONE_ARG = ClassHelper.CLOSURE_TYPE.getDeclaredMethod("call", new Parameter[]{new Parameter(ClassHelper.OBJECT_TYPE, "arg")});
    public static final MethodNode CLOSURE_CALL_VARGS = ClassHelper.CLOSURE_TYPE.getDeclaredMethod("call", new Parameter[]{new Parameter(ClassHelper.OBJECT_TYPE.makeArray(), "args")});
    private SourceUnit source;
    private ClassNode classNode;
    private MethodNode methodNode;
    private Set<MethodNode> methodsToBeVisited = Collections.emptySet();
    private ErrorCollector errorCollector;
    private ClosureExpression closureExpression;
    private List<ClassNode> closureReturnTypes;
    private LinkedList<ClassNode> withReceiverList = new LinkedList();
    private ClassNode lastImplicitItType;
    private Map<VariableExpression, List<ClassNode>> ifElseForWhileAssignmentTracker = null;
    private Stack<Map<Object, List<ClassNode>>> temporaryIfBranchTypeInformation;
    private Set<MethodNode> alreadyVisitedMethods = new HashSet<MethodNode>();
    private final LinkedHashSet<Expression> secondPassExpressions = new LinkedHashSet();
    private final Map<VariableExpression, List<ClassNode>> closureSharedVariablesAssignmentTypes = new HashMap<VariableExpression, List<ClassNode>>();
    private final TypeCheckerPluginFactory pluginFactory;
    private Map<Parameter, ClassNode> forLoopVariableTypes = new HashMap<Parameter, ClassNode>();
    private final Set<Long> reportedErrors = new TreeSet<Long>();
    private final ReturnAdder returnAdder = new ReturnAdder(new ReturnAdder.ReturnStatementListener(){

        public void returnStatementAdded(ReturnStatement returnStatement) {
            if (returnStatement.getExpression().equals(ConstantExpression.NULL)) {
                return;
            }
            ClassNode returnType = StaticTypeCheckingVisitor.this.checkReturnType(returnStatement);
            if (StaticTypeCheckingVisitor.this.methodNode != null) {
                ClassNode previousType;
                ClassNode mrt = StaticTypeCheckingVisitor.this.methodNode.getReturnType();
                if (!returnType.implementsInterface(mrt) && !returnType.isDerivedFrom(mrt)) {
                    returnType = mrt;
                }
                ClassNode inferred = (previousType = (ClassNode)StaticTypeCheckingVisitor.this.methodNode.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE)) == null ? returnType : WideningCategories.lowestUpperBound(returnType, previousType);
                StaticTypeCheckingVisitor.this.methodNode.putNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE, inferred);
            }
        }
    });
    private final ReturnAdder closureReturnAdder = new ReturnAdder(new ReturnAdder.ReturnStatementListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void returnStatementAdded(ReturnStatement returnStatement) {
            if (returnStatement.getExpression().equals(ConstantExpression.NULL)) {
                return;
            }
            MethodNode currentNode = StaticTypeCheckingVisitor.this.methodNode;
            StaticTypeCheckingVisitor.this.methodNode = null;
            try {
                StaticTypeCheckingVisitor.this.checkReturnType(returnStatement);
                if (StaticTypeCheckingVisitor.this.closureExpression != null) {
                    StaticTypeCheckingVisitor.this.addClosureReturnType(StaticTypeCheckingVisitor.this.getType(returnStatement.getExpression()));
                }
            }
            finally {
                StaticTypeCheckingVisitor.this.methodNode = currentNode;
            }
        }
    });

    public StaticTypeCheckingVisitor(SourceUnit source, ClassNode cn, TypeCheckerPluginFactory pluginFactory) {
        this.source = source;
        this.classNode = cn;
        this.temporaryIfBranchTypeInformation = new Stack();
        this.pluginFactory = pluginFactory;
        this.errorCollector = source.getErrorCollector();
        this.pushTemporaryTypeInfo();
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.source;
    }

    public void setErrorCollector(ErrorCollector errorCollector) {
        this.errorCollector = errorCollector;
    }

    @Override
    public void visitClass(ClassNode node) {
        if (this.shouldSkipClassNode(node)) {
            return;
        }
        ClassNode oldCN = this.classNode;
        this.classNode = node;
        Set<MethodNode> oldVisitedMethod = this.alreadyVisitedMethods;
        this.alreadyVisitedMethods = new LinkedHashSet<MethodNode>();
        super.visitClass(node);
        Iterator<InnerClassNode> innerClasses = this.classNode.getInnerClasses();
        while (innerClasses.hasNext()) {
            InnerClassNode innerClassNode = innerClasses.next();
            this.visitClass(innerClassNode);
        }
        this.alreadyVisitedMethods = oldVisitedMethod;
        this.classNode = oldCN;
        node.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, node);
    }

    protected boolean shouldSkipClassNode(ClassNode node) {
        Object type = node.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
        if (type != null) {
            return true;
        }
        return this.isSkipMode(node);
    }

    protected ClassNode[] getTypeCheckingAnnotations() {
        return TYPECHECKING_ANNOTATIONS;
    }

    public boolean isSkipMode(AnnotatedNode node) {
        if (node == null) {
            return false;
        }
        for (ClassNode tca : this.getTypeCheckingAnnotations()) {
            List<AnnotationNode> annotations = node.getAnnotations(tca);
            if (annotations == null) continue;
            for (AnnotationNode annotation : annotations) {
                Expression value = annotation.getMember("value");
                if (value == null) continue;
                if (value instanceof ConstantExpression) {
                    ConstantExpression ce = (ConstantExpression)value;
                    if (!TypeCheckingMode.SKIP.toString().equals(ce.getValue().toString())) continue;
                    return true;
                }
                if (!(value instanceof PropertyExpression)) continue;
                PropertyExpression pe = (PropertyExpression)value;
                if (!TypeCheckingMode.SKIP.toString().equals(pe.getPropertyAsString())) continue;
                return true;
            }
        }
        if (node instanceof MethodNode) {
            return this.isSkipMode(node.getDeclaringClass());
        }
        return false;
    }

    @Override
    public void visitClassExpression(ClassExpression expression) {
        super.visitClassExpression(expression);
        ClassNode cn = (ClassNode)expression.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
        if (cn == null) {
            this.storeType(expression, this.getType(expression));
        }
    }

    @Override
    public void visitVariableExpression(VariableExpression vexp) {
        super.visitVariableExpression(vexp);
        if (vexp != VariableExpression.THIS_EXPRESSION && vexp != VariableExpression.SUPER_EXPRESSION) {
            if (vexp.getName().equals("this")) {
                this.storeType(vexp, this.classNode);
            }
            if (vexp.getName().equals("super")) {
                this.storeType(vexp, this.classNode.getSuperClass());
            }
        }
        if (vexp.getAccessedVariable() instanceof DynamicVariable) {
            ClassNode type;
            TypeCheckerPlugin plugin;
            DynamicVariable dyn = (DynamicVariable)vexp.getAccessedVariable();
            String dynName = dyn.getName();
            LinkedList<ClassNode> checkList = new LinkedList<ClassNode>(this.withReceiverList);
            checkList.add(this.classNode);
            for (ClassNode node : checkList) {
                if (node.getProperty(dynName) != null) {
                    this.storeType(vexp, node.getProperty(dynName).getType());
                    return;
                }
                if (node.getField(dynName) == null) continue;
                this.storeType(vexp, node.getField(dynName).getType());
                return;
            }
            if (this.pluginFactory != null && (plugin = this.pluginFactory.getTypeCheckerPlugin(this.classNode)) != null && (type = plugin.resolveDynamicVariableType(dyn)) != null) {
                this.storeType(vexp, type);
                return;
            }
            this.addStaticTypeError("The variable [" + vexp.getName() + "] is undeclared.", vexp);
        }
    }

    @Override
    public void visitPropertyExpression(PropertyExpression pexp) {
        super.visitPropertyExpression(pexp);
        if (!this.existsProperty(pexp, true)) {
            Expression objectExpression = pexp.getObjectExpression();
            this.addStaticTypeError("No such property: " + pexp.getPropertyAsString() + " for class: " + this.findCurrentInstanceOfClass(objectExpression, this.getType(objectExpression)).toString(false), pexp);
        }
    }

    @Override
    public void visitAttributeExpression(AttributeExpression expression) {
        super.visitAttributeExpression(expression);
        if (!this.existsProperty(expression, true)) {
            Expression objectExpression = expression.getObjectExpression();
            this.addStaticTypeError("No such property: " + expression.getPropertyAsString() + " for class: " + this.findCurrentInstanceOfClass(objectExpression, objectExpression.getType()), expression);
        }
    }

    @Override
    public void visitRangeExpression(RangeExpression expression) {
        super.visitRangeExpression(expression);
        ClassNode fromType = ClassHelper.getWrapper(this.getType(expression.getFrom()));
        ClassNode toType = ClassHelper.getWrapper(this.getType(expression.getTo()));
        if (ClassHelper.Integer_TYPE.equals(fromType) && ClassHelper.Integer_TYPE.equals(toType)) {
            this.storeType(expression, ClassHelper.make(IntRange.class));
        } else {
            this.storeType(expression, ClassHelper.make(ObjectRange.class));
        }
    }

    @Override
    public void visitBinaryExpression(BinaryExpression expression) {
        boolean isEmptyDeclaration;
        int op;
        ClassNode resultType;
        super.visitBinaryExpression(expression);
        Expression leftExpression = expression.getLeftExpression();
        ClassNode lType = this.getType(leftExpression);
        Expression rightExpression = expression.getRightExpression();
        ClassNode rType = this.getType(rightExpression);
        if (rightExpression instanceof ConstantExpression && ((ConstantExpression)rightExpression).getValue() == null && !ClassHelper.isPrimitiveType(lType)) {
            rType = StaticTypeCheckingSupport.UNKNOWN_PARAMETER_TYPE;
        }
        if ((resultType = this.getResultType(lType, op = expression.getOperation().getType(), rType, expression)) == null) {
            resultType = lType;
        }
        boolean bl = isEmptyDeclaration = expression instanceof DeclarationExpression && rightExpression instanceof EmptyExpression;
        if (!isEmptyDeclaration) {
            this.storeType(expression, resultType);
        }
        if (!isEmptyDeclaration && StaticTypeCheckingSupport.isAssignment(op)) {
            Variable accessedVariable;
            if (rightExpression instanceof ConstructorCallExpression) {
                this.inferDiamondType((ConstructorCallExpression)rightExpression, lType);
            }
            ClassNode originType = this.getOriginalDeclarationType(leftExpression);
            this.typeCheckAssignment(expression, leftExpression, originType, rightExpression, resultType);
            if (!StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(ClassHelper.getWrapper(resultType), ClassHelper.getWrapper(originType))) {
                resultType = originType;
            } else if (lType.isUsingGenerics() && !lType.isEnum() && this.hasRHSIncompleteGenericTypeInfo(resultType)) {
                resultType = lType;
            }
            if (this.ifElseForWhileAssignmentTracker != null && leftExpression instanceof VariableExpression && (accessedVariable = ((VariableExpression)leftExpression).getAccessedVariable()) instanceof VariableExpression) {
                VariableExpression var = (VariableExpression)accessedVariable;
                List<ClassNode> types = this.ifElseForWhileAssignmentTracker.get(var);
                if (types == null) {
                    types = new LinkedList<ClassNode>();
                    ClassNode type = (ClassNode)var.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
                    if (type != null) {
                        types.add(type);
                    }
                    this.ifElseForWhileAssignmentTracker.put(var, types);
                }
                types.add(resultType);
            }
            this.storeType(leftExpression, resultType);
            if (leftExpression instanceof VariableExpression && rightExpression instanceof ClosureExpression) {
                Parameter[] parameters = ((ClosureExpression)rightExpression).getParameters();
                leftExpression.putNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS, parameters);
            }
        } else if (op == 544) {
            this.pushInstanceOfTypeInfo(leftExpression, rightExpression);
        }
    }

    private ClassNode getOriginalDeclarationType(Expression lhs) {
        if (lhs instanceof VariableExpression) {
            Variable var = StaticTypeCheckingSupport.findTargetVariable((VariableExpression)lhs);
            if (var instanceof DynamicVariable) {
                return this.getType(lhs);
            }
            return var.getOriginType();
        }
        if (lhs instanceof FieldExpression) {
            return ((FieldExpression)lhs).getField().getOriginType();
        }
        return this.getType(lhs);
    }

    private void inferDiamondType(ConstructorCallExpression cce, ClassNode lType) {
        ClassNode node = cce.getType();
        if (node.isUsingGenerics() && node.getGenericsTypes().length == 0) {
            ArgumentListExpression argumentListExpression = InvocationWriter.makeArgumentList(cce.getArguments());
            if (argumentListExpression.getExpressions().isEmpty()) {
                GenericsType[] genericsTypes = lType.getGenericsTypes();
                GenericsType[] copy = new GenericsType[genericsTypes.length];
                for (int i = 0; i < genericsTypes.length; ++i) {
                    GenericsType genericsType = genericsTypes[i];
                    copy[i] = new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(genericsType.getType()), genericsType.getUpperBounds(), genericsType.getLowerBound());
                }
                node.setGenericsTypes(copy);
            } else {
                ClassNode type = this.getType(argumentListExpression.getExpression(0));
                if (type.isUsingGenerics()) {
                    GenericsType[] genericsTypes = type.getGenericsTypes();
                    GenericsType[] copy = new GenericsType[genericsTypes.length];
                    for (int i = 0; i < genericsTypes.length; ++i) {
                        GenericsType genericsType = genericsTypes[i];
                        copy[i] = new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(genericsType.getType()), genericsType.getUpperBounds(), genericsType.getLowerBound());
                    }
                    node.setGenericsTypes(copy);
                }
            }
        }
    }

    private void pushInstanceOfTypeInfo(Expression objectOfInstanceOf, Expression typeExpression) {
        Object key;
        Map<Object, List<ClassNode>> tempo = this.temporaryIfBranchTypeInformation.peek();
        List<ClassNode> potentialTypes = tempo.get(key = this.extractTemporaryTypeInfoKey(objectOfInstanceOf));
        if (potentialTypes == null) {
            potentialTypes = new LinkedList<ClassNode>();
            tempo.put(key, potentialTypes);
        }
        potentialTypes.add(typeExpression.getType());
    }

    private void typeCheckAssignment(BinaryExpression assignmentExpression, Expression leftExpression, ClassNode leftExpressionType, Expression rightExpression, ClassNode inferredRightExpressionType) {
        ClassNode leftRedirect = StaticTypeCheckingSupport.isArrayAccessExpression(leftExpression) || leftExpression instanceof PropertyExpression || leftExpression instanceof VariableExpression && ((VariableExpression)leftExpression).getAccessedVariable() instanceof DynamicVariable ? leftExpressionType : (leftExpression instanceof VariableExpression && ClassHelper.isPrimitiveType(((VariableExpression)leftExpression).getOriginType()) ? leftExpressionType : leftExpression.getType().redirect());
        if (leftExpression instanceof TupleExpression) {
            if (!(rightExpression instanceof ListExpression)) {
                this.addStaticTypeError("Multiple assignments without list expressions on the right hand side are unsupported in static type checking mode", rightExpression);
                return;
            }
            TupleExpression tuple = (TupleExpression)leftExpression;
            ListExpression list = (ListExpression)rightExpression;
            List<Expression> listExpressions = list.getExpressions();
            List<Expression> tupleExpressions = tuple.getExpressions();
            if (listExpressions.size() < tupleExpressions.size()) {
                this.addStaticTypeError("Incorrect number of values. Expected:" + tupleExpressions.size() + " Was:" + listExpressions.size(), list);
                return;
            }
            int tupleExpressionsSize = tupleExpressions.size();
            for (int i = 0; i < tupleExpressionsSize; ++i) {
                ClassNode tupleType;
                Expression tupleExpression = tupleExpressions.get(i);
                Expression listExpression = listExpressions.get(i);
                ClassNode elemType = this.getType(listExpression);
                if (StaticTypeCheckingSupport.isAssignableTo(elemType, tupleType = this.getType(tupleExpression))) continue;
                this.addStaticTypeError("Cannot assign value of type " + elemType.getText() + " to variable of type " + tupleType.getText(), rightExpression);
                break;
            }
            return;
        }
        boolean compatible = StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(leftRedirect, inferredRightExpressionType, rightExpression);
        if (leftExpression.getNodeMetaData((Object)StaticTypesMarker.READONLY_PROPERTY) != null && leftExpression instanceof PropertyExpression) {
            this.addStaticTypeError("Cannot set read-only property: " + ((PropertyExpression)leftExpression).getPropertyAsString(), leftExpression);
        }
        if (!compatible) {
            this.addAssignmentError(leftExpressionType, inferredRightExpressionType, assignmentExpression);
        } else {
            GenericsType gt;
            boolean incomplete;
            ClassNode[] args;
            ArgumentListExpression argList;
            Object type;
            if (rightExpression instanceof ClosureExpression && (type = rightExpression.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE)) != null) {
                leftExpression.putNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE, type);
            }
            boolean possibleLooseOfPrecision = false;
            if (ClassHelper.isNumberType(leftRedirect) && ClassHelper.isNumberType(inferredRightExpressionType) && (possibleLooseOfPrecision = StaticTypeCheckingSupport.checkPossibleLooseOfPrecision(leftRedirect, inferredRightExpressionType, rightExpression))) {
                this.addStaticTypeError("Possible loose of precision from " + inferredRightExpressionType + " to " + leftRedirect, rightExpression);
            }
            if (!possibleLooseOfPrecision && leftExpressionType.isArray()) {
                ClassNode leftComponentType = leftExpressionType.getComponentType();
                ClassNode rightRedirect = rightExpression.getType().redirect();
                if (rightRedirect.isArray()) {
                    ClassNode rightComponentType = rightRedirect.getComponentType();
                    if (!StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(leftComponentType, rightComponentType)) {
                        this.addStaticTypeError("Cannot assign value of type " + rightComponentType.getText() + " into array of type " + leftExpressionType.getText(), assignmentExpression);
                    }
                } else if (rightExpression instanceof ListExpression) {
                    for (Expression element : ((ListExpression)rightExpression).getExpressions()) {
                        ClassNode rightComponentType = element.getType().redirect();
                        if (StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(leftComponentType, rightComponentType)) continue;
                        this.addStaticTypeError("Cannot assign value of type " + rightComponentType.getText() + " into array of type " + leftExpressionType.getText(), assignmentExpression);
                    }
                }
            }
            if (!StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(leftRedirect, ClassHelper.LIST_TYPE) && rightExpression instanceof ListExpression) {
                argList = new ArgumentListExpression(((ListExpression)rightExpression).getExpressions());
                args = this.getArgumentTypes(argList);
                this.checkGroovyStyleConstructor(leftRedirect, args);
            } else if (!StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(inferredRightExpressionType, leftRedirect) && StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(inferredRightExpressionType, ClassHelper.LIST_TYPE)) {
                this.addAssignmentError(leftExpressionType, inferredRightExpressionType, assignmentExpression);
            }
            if (!(StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(leftRedirect, ClassHelper.MAP_TYPE) || !(rightExpression instanceof MapExpression) || leftExpression instanceof VariableExpression && ((VariableExpression)leftExpression).isDynamicTyped())) {
                argList = new ArgumentListExpression(rightExpression);
                args = this.getArgumentTypes(argList);
                this.checkGroovyStyleConstructor(leftRedirect, args);
                MapExpression mapExpression = (MapExpression)rightExpression;
                this.checkGroovyConstructorMap(leftExpression, leftRedirect, mapExpression);
            }
            if (leftExpressionType.isUsingGenerics() && !leftExpressionType.isEnum() && !(incomplete = this.hasRHSIncompleteGenericTypeInfo(inferredRightExpressionType)) && !(gt = GenericsUtils.buildWildcardType(leftExpressionType)).isCompatibleWith(inferredRightExpressionType)) {
                this.addStaticTypeError("Incompatible generic argument types. Cannot assign " + inferredRightExpressionType.toString(false) + " to: " + leftExpressionType.toString(false), assignmentExpression);
            }
        }
    }

    private void addAssignmentError(ClassNode leftType, ClassNode rightType, Expression assignmentExpression) {
        this.addStaticTypeError("Cannot assign value of type " + rightType.getText() + " to variable of type " + leftType.getText(), assignmentExpression);
    }

    private void checkGroovyConstructorMap(Expression receiver, ClassNode receiverType, MapExpression mapExpression) {
        for (MapEntryExpression entryExpression : mapExpression.getMapEntryExpressions()) {
            Expression keyExpr = entryExpression.getKeyExpression();
            if (!(keyExpr instanceof ConstantExpression)) {
                this.addStaticTypeError("Dynamic keys in map-style constructors are unsupported in static type checking", keyExpr);
                continue;
            }
            String property = keyExpr.getText();
            PropertyNode propertyNode = null;
            for (ClassNode currentNode = receiverType; propertyNode == null && currentNode != null; currentNode = currentNode.getSuperClass()) {
                propertyNode = currentNode.getProperty(property);
            }
            if (propertyNode == null) {
                this.addStaticTypeError("No such property: " + property + " for class: " + receiverType.getName(), receiver);
                continue;
            }
            if (propertyNode == null) continue;
            ClassNode valueType = this.getType(entryExpression.getValueExpression());
            if (StaticTypeCheckingSupport.isAssignableTo(propertyNode.getType(), valueType)) continue;
            this.addAssignmentError(propertyNode.getType(), valueType, entryExpression);
        }
    }

    private boolean hasRHSIncompleteGenericTypeInfo(ClassNode inferredRightExpressionType) {
        boolean replaceType = false;
        GenericsType[] genericsTypes = inferredRightExpressionType.getGenericsTypes();
        if (genericsTypes != null) {
            for (GenericsType genericsType : genericsTypes) {
                if (!genericsType.isPlaceholder()) continue;
                replaceType = true;
                break;
            }
        }
        return replaceType;
    }

    private void checkGroovyStyleConstructor(ClassNode node, ClassNode[] arguments) {
        if (node.equals(ClassHelper.OBJECT_TYPE) || node.equals(ClassHelper.DYNAMIC_TYPE)) {
            return;
        }
        List<ConstructorNode> constructors = node.getDeclaredConstructors();
        if (constructors.isEmpty() && arguments.length == 0) {
            return;
        }
        List<MethodNode> constructorList = this.findMethod(node, "<init>", arguments);
        if (constructorList.isEmpty()) {
            this.addStaticTypeError("No matching constructor found: " + node + StaticTypeCheckingSupport.toMethodParametersString("<init>", arguments), this.classNode);
        }
    }

    private Object extractTemporaryTypeInfoKey(Expression expression) {
        return expression instanceof VariableExpression ? StaticTypeCheckingSupport.findTargetVariable((VariableExpression)expression) : expression.getText();
    }

    private ClassNode findCurrentInstanceOfClass(Expression expr, ClassNode type) {
        List<ClassNode> nodes;
        if (!this.temporaryIfBranchTypeInformation.empty() && (nodes = this.getTemporaryTypesForExpression(expr)) != null && nodes.size() == 1) {
            return nodes.get(0);
        }
        return type;
    }

    private boolean existsProperty(PropertyExpression pexp, boolean checkForReadOnly) {
        return this.existsProperty(pexp, checkForReadOnly, null);
    }

    private boolean existsProperty(PropertyExpression pexp, boolean checkForReadOnly, ClassCodeVisitorSupport visitor) {
        String propertyName;
        List<ClassNode> classNodes;
        Expression objectExpression = pexp.getObjectExpression();
        ClassNode clazz = this.getType(objectExpression);
        if (clazz.isArray() && "length".equals(pexp.getPropertyAsString())) {
            if (visitor != null) {
                PropertyNode node = new PropertyNode("length", 17, ClassHelper.int_TYPE, clazz, null, null, null);
                this.storeType(pexp, ClassHelper.int_TYPE);
                visitor.visitProperty(node);
            }
            return true;
        }
        LinkedList<ClassNode> tests = new LinkedList<ClassNode>();
        tests.add(clazz);
        if (clazz.equals(ClassHelper.CLASS_Type) && clazz.getGenericsTypes() != null) {
            tests.add(clazz.getGenericsTypes()[0].getType());
        }
        if (!this.temporaryIfBranchTypeInformation.empty() && (classNodes = this.getTemporaryTypesForExpression(objectExpression)) != null) {
            tests.addAll(classNodes);
        }
        if (this.lastImplicitItType != null && pexp.getObjectExpression() instanceof VariableExpression && ((VariableExpression)pexp.getObjectExpression()).getName().equals("it")) {
            tests.add(this.lastImplicitItType);
        }
        if ((propertyName = pexp.getPropertyAsString()) == null) {
            return false;
        }
        String capName = MetaClassHelper.capitalize(propertyName);
        boolean isAttributeExpression = pexp instanceof AttributeExpression;
        for (ClassNode testClass : tests) {
            if (!StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(testClass, ClassHelper.MAP_TYPE) && !StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(testClass, ClassHelper.LIST_TYPE)) {
                ClassNode current = testClass;
                while (current != null) {
                    FieldNode field;
                    MethodNode setterMethod;
                    PropertyNode propertyNode = (current = current.redirect()).getProperty(propertyName);
                    if (propertyNode != null) {
                        if (visitor != null) {
                            visitor.visitProperty(propertyNode);
                        }
                        this.storeType(pexp, propertyNode.getOriginType());
                        return true;
                    }
                    MethodNode getter = current.getGetterMethod("get" + capName);
                    if (getter == null) {
                        getter = current.getGetterMethod("is" + capName);
                    }
                    if (getter != null && (setterMethod = current.getSetterMethod("set" + capName)) != null) {
                        if (visitor != null) {
                            visitor.visitMethod(getter);
                        }
                        this.storeType(pexp, getter.getReturnType());
                        return true;
                    }
                    if (!isAttributeExpression && (field = current.getDeclaredField(propertyName)) != null) {
                        if (visitor != null) {
                            visitor.visitField(field);
                        }
                        this.storeType(pexp, field.getOriginType());
                        return true;
                    }
                    current = isAttributeExpression ? null : current.getSuperClass();
                }
                if (!checkForReadOnly) continue;
                current = testClass;
                while (current != null) {
                    PropertyNode result;
                    TypeCheckerPlugin plugin;
                    MethodNode getter = (current = current.redirect()).getGetterMethod("get" + capName);
                    if (getter == null) {
                        getter = current.getGetterMethod("is" + capName);
                    }
                    if (getter != null) {
                        if (visitor != null) {
                            visitor.visitMethod(getter);
                        }
                        pexp.putNodeMetaData((Object)StaticTypesMarker.READONLY_PROPERTY, Boolean.TRUE);
                        this.storeType(pexp, getter.getReturnType());
                        return true;
                    }
                    if (this.pluginFactory != null && (plugin = this.pluginFactory.getTypeCheckerPlugin(this.classNode)) != null && (result = plugin.resolveProperty(current, propertyName)) != null) {
                        if (visitor != null) {
                            visitor.visitProperty(result);
                        }
                        this.storeType(pexp, result.getType());
                        return true;
                    }
                    current = isAttributeExpression ? null : current.getSuperClass();
                }
                continue;
            }
            if (visitor != null) {
                PropertyNode node = new PropertyNode(propertyName, 1, ClassHelper.OBJECT_TYPE, clazz, null, null, null);
                visitor.visitProperty(node);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitForLoop(ForStatement forLoop) {
        HashMap<VariableExpression, ClassNode> varOrigType = new HashMap<VariableExpression, ClassNode>();
        forLoop.getLoopBlock().visit(new VariableExpressionTypeMemoizer(varOrigType));
        Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
        Expression collectionExpression = forLoop.getCollectionExpression();
        if (collectionExpression instanceof ClosureListExpression) {
            super.visitForLoop(forLoop);
        } else {
            collectionExpression.visit(this);
            ClassNode collectionType = this.getType(collectionExpression);
            ClassNode componentType = StaticTypeCheckingVisitor.inferLoopElementType(collectionType);
            if (ClassHelper.getUnwrapper(componentType) == forLoop.getVariableType()) {
                componentType = forLoop.getVariableType();
            }
            this.forLoopVariableTypes.put(forLoop.getVariable(), componentType);
            if (!StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(forLoop.getVariableType(), componentType)) {
                this.addStaticTypeError("Cannot loop with element of type " + forLoop.getVariableType() + " with collection of type " + collectionType, forLoop);
            }
            try {
                super.visitForLoop(forLoop);
            }
            finally {
                this.forLoopVariableTypes.remove(forLoop.getVariable());
            }
        }
        boolean typeChanged = this.isSecondPassNeededForControlStructure(varOrigType, oldTracker);
        if (typeChanged) {
            this.visitForLoop(forLoop);
        }
    }

    public static ClassNode inferLoopElementType(ClassNode collectionType) {
        ClassNode componentType = collectionType.getComponentType();
        if (componentType == null) {
            if (collectionType.implementsInterface(ITERABLE_TYPE)) {
                ClassNode intf = GenericsUtils.parameterizeInterfaceGenerics(collectionType, ITERABLE_TYPE);
                GenericsType[] genericsTypes = intf.getGenericsTypes();
                componentType = genericsTypes[0].getType();
            } else {
                componentType = collectionType == ClassHelper.STRING_TYPE ? ClassHelper.Character_TYPE : ClassHelper.OBJECT_TYPE;
            }
        }
        return componentType;
    }

    private boolean isSecondPassNeededForControlStructure(Map<VariableExpression, ClassNode> varOrigType, Map<VariableExpression, List<ClassNode>> oldTracker) {
        Map<VariableExpression, ClassNode> assignedVars = this.popAssignmentTracking(oldTracker);
        for (Map.Entry<VariableExpression, ClassNode> entry : assignedVars.entrySet()) {
            Variable key = StaticTypeCheckingSupport.findTargetVariable(entry.getKey());
            if (!(key instanceof VariableExpression)) continue;
            ClassNode origType = varOrigType.get((VariableExpression)key);
            ClassNode newType = entry.getValue();
            if (!varOrigType.containsKey(key) || origType != null && newType.equals(origType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visitWhileLoop(WhileStatement loop) {
        Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
        super.visitWhileLoop(loop);
        this.popAssignmentTracking(oldTracker);
    }

    @Override
    public void visitBitwiseNegationExpression(BitwiseNegationExpression expression) {
        ClassNode resultType;
        super.visitBitwiseNegationExpression(expression);
        ClassNode type = this.getType(expression);
        ClassNode typeRe = type.redirect();
        if (WideningCategories.isBigIntCategory(typeRe)) {
            resultType = type;
        } else if (typeRe == ClassHelper.STRING_TYPE || typeRe == ClassHelper.GSTRING_TYPE) {
            resultType = ClassHelper.PATTERN_TYPE;
        } else if (typeRe == StaticTypeCheckingSupport.ArrayList_TYPE) {
            resultType = StaticTypeCheckingSupport.ArrayList_TYPE;
        } else {
            MethodNode mn = this.findMethodOrFail(expression, type, "bitwiseNegate", new ClassNode[0]);
            resultType = mn.getReturnType();
        }
        this.storeType(expression, resultType);
    }

    @Override
    public void visitUnaryPlusExpression(UnaryPlusExpression expression) {
        super.visitUnaryPlusExpression(expression);
        this.negativeOrPositiveUnary(expression, "positive");
    }

    @Override
    public void visitUnaryMinusExpression(UnaryMinusExpression expression) {
        super.visitUnaryMinusExpression(expression);
        this.negativeOrPositiveUnary(expression, "negative");
    }

    @Override
    public void visitPostfixExpression(PostfixExpression expression) {
        String name;
        super.visitPostfixExpression(expression);
        Expression inner = expression.getExpression();
        ClassNode exprType = this.getType(inner);
        int type = expression.getOperation().getType();
        if (ClassHelper.isPrimitiveType(exprType) || ClassHelper.isPrimitiveType(ClassHelper.getUnwrapper(exprType))) {
            if (type == 250 || type == 260) {
                return;
            }
            this.addStaticTypeError("Unsupported postfix operation type [" + expression.getOperation() + "]", expression);
            return;
        }
        String string = type == 250 ? "next" : (name = type == 260 ? "previous" : null);
        if (name == null) {
            this.addStaticTypeError("Unsupported postfix operation type [" + expression.getOperation() + "]", expression);
            return;
        }
        MethodNode node = this.findMethodOrFail(inner, exprType, name, new ClassNode[0]);
        if (node != null) {
            this.storeTargetMethod(expression, node);
        }
    }

    @Override
    public void visitPrefixExpression(PrefixExpression expression) {
        String name;
        super.visitPrefixExpression(expression);
        Expression inner = expression.getExpression();
        ClassNode exprType = this.getType(inner);
        int type = expression.getOperation().getType();
        if (ClassHelper.isPrimitiveType(exprType) || ClassHelper.isPrimitiveType(ClassHelper.getUnwrapper(exprType))) {
            if (type == 250 || type == 260) {
                return;
            }
            this.addStaticTypeError("Unsupported prefix operation type [" + expression.getOperation() + "]", expression);
            return;
        }
        String string = type == 250 ? "next" : (name = type == 260 ? "previous" : null);
        if (name == null) {
            this.addStaticTypeError("Unsupported prefix operation type [" + expression.getOperation() + "]", expression);
            return;
        }
        MethodNode node = this.findMethodOrFail(inner, exprType, name, new ClassNode[0]);
        if (node != null) {
            this.storeTargetMethod(expression, node);
        }
    }

    private void negativeOrPositiveUnary(Expression expression, String name) {
        MethodNode mn;
        ClassNode type = this.getType(expression);
        ClassNode typeRe = type.redirect();
        ClassNode resultType = WideningCategories.isDoubleCategory(ClassHelper.getUnwrapper(typeRe)) ? type : (typeRe == StaticTypeCheckingSupport.ArrayList_TYPE ? StaticTypeCheckingSupport.ArrayList_TYPE : ((mn = this.findMethodOrFail(expression, type, name, new ClassNode[0])) != null ? mn.getReturnType() : type));
        this.storeType(expression, resultType);
    }

    @Override
    protected void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        MethodNode old = this.methodNode;
        this.methodNode = node;
        super.visitConstructorOrMethod(node, isConstructor);
        if (!isConstructor) {
            this.returnAdder.visitMethod(node);
        }
        this.methodNode = old;
    }

    @Override
    public void visitReturnStatement(ReturnStatement statement) {
        super.visitReturnStatement(statement);
        this.checkReturnType(statement);
        if (this.closureExpression != null && statement.getExpression() != ConstantExpression.NULL) {
            this.addClosureReturnType(this.getType(statement.getExpression()));
        }
    }

    private ClassNode checkReturnType(ReturnStatement statement) {
        ClassNode type = this.getType(statement.getExpression());
        if (this.methodNode != null) {
            if (!(this.methodNode.isVoidMethod() || type.equals(ClassHelper.void_WRAPPER_TYPE) || type.equals(ClassHelper.VOID_TYPE) || StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(this.methodNode.getReturnType(), type))) {
                this.addStaticTypeError("Cannot return value of type " + type + " on method returning type " + this.methodNode.getReturnType(), statement.getExpression());
            } else if (!this.methodNode.isVoidMethod()) {
                ClassNode inferred;
                ClassNode previousType = (ClassNode)this.methodNode.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE);
                ClassNode classNode = inferred = previousType == null ? type : WideningCategories.lowestUpperBound(type, previousType);
                if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(inferred, this.methodNode.getReturnType())) {
                    this.methodNode.putNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE, inferred);
                } else {
                    this.methodNode.putNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE, this.methodNode.getReturnType());
                }
            }
        }
        return type;
    }

    private void addClosureReturnType(ClassNode returnType) {
        if (this.closureReturnTypes == null) {
            this.closureReturnTypes = new LinkedList<ClassNode>();
        }
        this.closureReturnTypes.add(returnType);
    }

    @Override
    public void visitConstructorCallExpression(ConstructorCallExpression call) {
        super.visitConstructorCallExpression(call);
        ClassNode receiver = call.isThisCall() ? this.classNode : (call.isSuperCall() ? this.classNode.getSuperClass() : call.getType());
        Expression arguments = call.getArguments();
        ClassNode[] args = this.getArgumentTypes(InvocationWriter.makeArgumentList(arguments));
        MethodNode node = this.findMethodOrFail(call, receiver, "<init>", args);
        if (node != null) {
            Expression expression;
            TupleExpression texp;
            List<Expression> expressions;
            if (node.getParameters().length == 0 && args.length == 1 && StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(args[0], ClassHelper.MAP_TYPE) && arguments instanceof TupleExpression && (expressions = (texp = (TupleExpression)arguments).getExpressions()).size() == 1 && (expression = expressions.get(0)) instanceof MapExpression) {
                MapExpression argList = (MapExpression)expression;
                this.checkGroovyConstructorMap(call, receiver, argList);
                node = new ConstructorNode(1, new Parameter[]{new Parameter(ClassHelper.MAP_TYPE, "map")}, ClassNode.EMPTY_ARRAY, EmptyStatement.INSTANCE);
                node.setDeclaringClass(receiver);
            }
            this.storeTargetMethod(call, node);
        }
    }

    private ClassNode[] getArgumentTypes(ArgumentListExpression args) {
        List<Expression> arglist = args.getExpressions();
        ClassNode[] ret = new ClassNode[arglist.size()];
        int i = 0;
        Map<Object, List<ClassNode>> info = this.temporaryIfBranchTypeInformation.empty() ? null : this.temporaryIfBranchTypeInformation.peek();
        for (Expression exp : arglist) {
            if (exp instanceof ConstantExpression && ((ConstantExpression)exp).getValue() == null) {
                ret[i] = StaticTypeCheckingSupport.UNKNOWN_PARAMETER_TYPE;
            } else {
                List<ClassNode> classNodes;
                ret[i] = this.getType(exp);
                if (exp instanceof VariableExpression && info != null && (classNodes = this.getTemporaryTypesForExpression(exp)) != null && !classNodes.isEmpty()) {
                    ArrayList<ClassNode> arr = new ArrayList<ClassNode>(classNodes.size() + 1);
                    arr.add(ret[i]);
                    arr.addAll(classNodes);
                    ret[i] = new UnionTypeClassNode(arr.toArray(new ClassNode[arr.size()]));
                }
            }
            ++i;
        }
        return ret;
    }

    @Override
    public void visitClosureExpression(ClosureExpression expression) {
        HashMap<VariableExpression, ClassNode> varOrigType = new HashMap<VariableExpression, ClassNode>();
        Statement code = expression.getCode();
        code.visit(new VariableExpressionTypeMemoizer(varOrigType));
        Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
        SharedVariableCollector collector = new SharedVariableCollector(this.getSourceUnit());
        collector.visitClosureExpression(expression);
        Set<VariableExpression> closureSharedExpressions = collector.getClosureSharedExpressions();
        HashMap<VariableExpression, ListHashMap> typesBeforeVisit = null;
        if (!closureSharedExpressions.isEmpty()) {
            typesBeforeVisit = new HashMap<VariableExpression, ListHashMap>();
            this.saveVariableExpressionMetadata(closureSharedExpressions, typesBeforeVisit);
        }
        ClosureExpression oldClosureExpr = this.closureExpression;
        List<ClassNode> oldClosureReturnTypes = this.closureReturnTypes;
        this.closureExpression = expression;
        super.visitClosureExpression(expression);
        MethodNode node = new MethodNode("dummy", 0, ClassHelper.OBJECT_TYPE, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, code);
        this.closureReturnAdder.visitMethod(node);
        if (this.closureReturnTypes != null) {
            expression.putNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE, WideningCategories.lowestUpperBound(this.closureReturnTypes));
        }
        this.closureExpression = oldClosureExpr;
        this.closureReturnTypes = oldClosureReturnTypes;
        boolean typeChanged = this.isSecondPassNeededForControlStructure(varOrigType, oldTracker);
        if (typeChanged) {
            this.visitClosureExpression(expression);
        }
        this.restoreVariableExpressionMetadata(typesBeforeVisit);
    }

    private void restoreVariableExpressionMetadata(Map<VariableExpression, ListHashMap> typesBeforeVisit) {
        if (typesBeforeVisit != null) {
            for (Map.Entry<VariableExpression, ListHashMap> entry : typesBeforeVisit.entrySet()) {
                VariableExpression ve = entry.getKey();
                ListHashMap metadata = entry.getValue();
                for (StaticTypesMarker marker : StaticTypesMarker.values()) {
                    ve.removeNodeMetaData((Object)marker);
                    Object value = metadata.get((Object)marker);
                    if (value == null) continue;
                    ve.setNodeMetaData((Object)marker, value);
                }
            }
        }
    }

    private void saveVariableExpressionMetadata(Set<VariableExpression> closureSharedExpressions, Map<VariableExpression, ListHashMap> typesBeforeVisit) {
        for (VariableExpression ve : closureSharedExpressions) {
            ListHashMap<StaticTypesMarker, Object> metadata = new ListHashMap<StaticTypesMarker, Object>();
            for (StaticTypesMarker marker : StaticTypesMarker.values()) {
                Object value = ve.getNodeMetaData((Object)marker);
                if (value == null) continue;
                metadata.put(marker, value);
            }
            typesBeforeVisit.put(ve, metadata);
            Variable accessedVariable = ve.getAccessedVariable();
            if (accessedVariable == ve || !(accessedVariable instanceof VariableExpression)) continue;
            this.saveVariableExpressionMetadata(Collections.singleton((VariableExpression)accessedVariable), typesBeforeVisit);
        }
    }

    @Override
    public void visitMethod(MethodNode node) {
        if (this.isSkipMode(node)) {
            return;
        }
        if (this.alreadyVisitedMethods.contains(node)) {
            return;
        }
        this.alreadyVisitedMethods.add(node);
        if (!this.methodsToBeVisited.isEmpty() && !this.methodsToBeVisited.contains(node)) {
            return;
        }
        super.visitMethod(node);
        this.addTypeCheckingInfoAnnotation(node);
    }

    protected void addTypeCheckingInfoAnnotation(MethodNode node) {
        ClassNode rtype = (ClassNode)node.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE);
        if (rtype != null && rtype.getAnnotations(TYPECHECKING_INFO_NODE).isEmpty()) {
            AnnotationNode anno = new AnnotationNode(TYPECHECKING_INFO_NODE);
            anno.setMember("version", CURRENT_SIGNATURE_PROTOCOL);
            SignatureCodec codec = SignatureCodecFactory.getCodec(1);
            String genericsSignature = codec.encode(rtype);
            if (genericsSignature != null) {
                ConstantExpression signature = new ConstantExpression(genericsSignature);
                signature.setType(ClassHelper.STRING_TYPE);
                anno.setMember("inferredType", signature);
                node.addAnnotation(anno);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitStaticMethodCallExpression(StaticMethodCallExpression call) {
        String name = call.getMethod();
        if (name == null) {
            this.addStaticTypeError("cannot resolve dynamic method name at compile time.", call);
            return;
        }
        ClassNode rememberLastItType = this.lastImplicitItType;
        Expression callArguments = call.getArguments();
        boolean isWithCall = StaticTypeCheckingSupport.isWithCall(name, callArguments);
        if (!isWithCall) {
            callArguments.visit(this);
        }
        ClassNode[] args = this.getArgumentTypes(InvocationWriter.makeArgumentList(callArguments));
        ClassNode receiver = call.getOwnerType();
        if (isWithCall) {
            this.withReceiverList.add(0, receiver);
            this.lastImplicitItType = receiver;
            if (callArguments instanceof ArgumentListExpression) {
                Parameter param;
                ArgumentListExpression argList = (ArgumentListExpression)callArguments;
                ClosureExpression closure = (ClosureExpression)argList.getExpression(0);
                Parameter[] parameters = closure.getParameters();
                if (parameters.length > 1) {
                    this.addStaticTypeError("Unexpected number of parameters for a with call", argList);
                } else if (parameters.length == 1 && !(param = parameters[0]).isDynamicTyped() && !StaticTypeCheckingSupport.isAssignableTo(receiver, param.getType().redirect())) {
                    this.addStaticTypeError("Expected parameter type: " + receiver.toString(false) + " but was: " + param.getType().redirect().toString(false), param);
                }
            }
        }
        try {
            if (isWithCall) {
                callArguments.visit(this);
            }
            LinkedList<ClassNode> receivers = new LinkedList<ClassNode>();
            if (!this.withReceiverList.isEmpty()) {
                receivers.addAll(this.withReceiverList);
            }
            receivers.add(receiver);
            List<MethodNode> mn = null;
            ClassNode chosenReceiver = null;
            for (ClassNode currentReceiver : receivers) {
                mn = this.findMethod(currentReceiver, name, args);
                if (mn.isEmpty()) continue;
                if (mn.size() == 1) {
                    this.typeCheckMethodsWithGenerics(currentReceiver, args, mn.get(0), call);
                }
                chosenReceiver = currentReceiver;
                break;
            }
            if (mn.isEmpty()) {
                this.addStaticTypeError("Cannot find matching method " + receiver.getText() + "#" + StaticTypeCheckingSupport.toMethodParametersString(name, args), call);
            } else if (mn.size() == 1) {
                MethodNode directMethodCallCandidate = mn.get(0);
                ClassNode currentClassNode = this.classNode;
                this.classNode = directMethodCallCandidate.getDeclaringClass();
                for (ClassNode node : this.source.getAST().getClasses()) {
                    if (!StaticTypeCheckingVisitor.isClassInnerClassOrEqualTo(this.classNode, node)) continue;
                    this.silentlyVisitMethodNode(directMethodCallCandidate);
                    break;
                }
                this.pickInferredTypeFromMethodAnnotation(directMethodCallCandidate);
                this.classNode = currentClassNode;
                ClassNode returnType = this.getType(directMethodCallCandidate);
                if (returnType.isUsingGenerics() && !returnType.isEnum()) {
                    ClassNode irtg = this.inferReturnTypeGenerics(chosenReceiver, directMethodCallCandidate, callArguments);
                    returnType = irtg != null && StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(irtg, returnType) ? irtg : returnType;
                }
                this.storeType(call, returnType);
                this.storeTargetMethod(call, directMethodCallCandidate);
            } else {
                this.addAmbiguousOrDynamicErrorMessage(mn, name, args, call);
            }
        }
        finally {
            if (isWithCall) {
                this.lastImplicitItType = rememberLastItType;
                this.withReceiverList.removeFirst();
            }
        }
    }

    private void pickInferredTypeFromMethodAnnotation(MethodNode node) {
        if (node.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE) == null && !node.getAnnotations(TYPECHECKING_INFO_NODE).isEmpty()) {
            List<AnnotationNode> annotations = node.getAnnotations(TYPECHECKING_INFO_NODE);
            AnnotationNode head = annotations.get(0);
            int version = Integer.valueOf(head.getMember("version").getText());
            String signature = head.getMember("inferredType").getText();
            SignatureCodec codec = SignatureCodecFactory.getCodec(version);
            ClassNode result = codec.decode(signature);
            node.putNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void silentlyVisitMethodNode(MethodNode directMethodCallCandidate) {
        ErrorCollector currentCollector = this.errorCollector;
        this.errorCollector = new ErrorCollector(new CompilerConfiguration());
        try {
            this.visitMethod(directMethodCallCandidate);
        }
        finally {
            this.errorCollector = currentCollector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitMethodCallExpression(MethodCallExpression call) {
        Parameter[] parameters;
        String name = call.getMethodAsString();
        if (name == null) {
            this.addStaticTypeError("cannot resolve dynamic method name at compile time.", call.getMethod());
            return;
        }
        Expression objectExpression = call.getObjectExpression();
        objectExpression.visit(this);
        call.getMethod().visit(this);
        if (call.isSpreadSafe()) {
            ClassNode expressionType = this.getType(objectExpression);
            if (!expressionType.equals(StaticTypeCheckingSupport.Collection_TYPE) && !expressionType.implementsInterface(StaticTypeCheckingSupport.Collection_TYPE)) {
                this.addStaticTypeError("Spread operator can only be used on collection types", expressionType);
                return;
            }
            ClassNode componentType = this.inferComponentType(expressionType);
            MethodCallExpression subcall = new MethodCallExpression((Expression)new CastExpression(componentType, EmptyExpression.INSTANCE), name, call.getArguments());
            subcall.setLineNumber(call.getLineNumber());
            subcall.setColumnNumber(call.getColumnNumber());
            this.visitMethodCallExpression(subcall);
            ClassNode subcallReturnType = this.getType(subcall);
            ClassNode listNode = ClassHelper.LIST_TYPE.getPlainNodeReference();
            listNode.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(subcallReturnType))});
            this.storeType(call, listNode);
            this.storeTargetMethod(call, (MethodNode)subcall.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET));
            return;
        }
        ClassNode rememberLastItType = this.lastImplicitItType;
        Expression callArguments = call.getArguments();
        boolean isWithCall = StaticTypeCheckingSupport.isWithCall(name, callArguments);
        if (!isWithCall) {
            callArguments.visit(this);
        }
        ClassNode[] args = this.getArgumentTypes(InvocationWriter.makeArgumentList(callArguments));
        boolean isCallOnClosure = this.isClosureCall(name, objectExpression, callArguments);
        ClassNode receiver = this.getType(objectExpression);
        if (isWithCall) {
            this.withReceiverList.add(0, receiver);
            this.lastImplicitItType = receiver;
            if (callArguments instanceof ArgumentListExpression) {
                Parameter param;
                ArgumentListExpression argList = (ArgumentListExpression)callArguments;
                ClosureExpression closure = (ClosureExpression)argList.getExpression(0);
                parameters = closure.getParameters();
                if (parameters.length > 1) {
                    this.addStaticTypeError("Unexpected number of parameters for a with call", argList);
                } else if (parameters.length == 1 && !(param = parameters[0]).isDynamicTyped() && !StaticTypeCheckingSupport.isAssignableTo(receiver, param.getType().redirect())) {
                    this.addStaticTypeError("Expected parameter type: " + receiver.toString(false) + " but was: " + param.getType().redirect().toString(false), param);
                }
            }
        }
        try {
            if (isWithCall) {
                callArguments.visit(this);
            }
            if (isCallOnClosure) {
                Object data;
                if (objectExpression == VariableExpression.THIS_EXPRESSION) {
                    FieldNode field = this.classNode.getDeclaredField(name);
                    ClassNode closureReturnType = field.getType().getGenericsTypes()[0].getType();
                    Object data2 = field.getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS);
                    if (data2 != null) {
                        Parameter[] parameters2 = (Parameter[])data2;
                        this.typeCheckClosureCall(callArguments, args, parameters2);
                    }
                    this.storeType(call, closureReturnType);
                } else if (objectExpression instanceof VariableExpression) {
                    Variable variable = StaticTypeCheckingSupport.findTargetVariable((VariableExpression)objectExpression);
                    if (variable instanceof Expression) {
                        Object type;
                        data = ((Expression)((Object)variable)).getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS);
                        if (data != null) {
                            parameters = (Parameter[])data;
                            this.typeCheckClosureCall(callArguments, args, parameters);
                        }
                        if ((type = ((Expression)((Object)variable)).getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE)) == null && variable.getType().equals(ClassHelper.CLOSURE_TYPE)) {
                            GenericsType[] genericsTypes = variable.getType().getGenericsTypes();
                            type = genericsTypes != null && !genericsTypes[0].isPlaceholder() ? genericsTypes[0].getType() : ClassHelper.OBJECT_TYPE;
                        }
                        if (type != null) {
                            this.storeType(call, (ClassNode)type);
                        }
                    }
                } else if (objectExpression instanceof ClosureExpression) {
                    Parameter[] parameters3 = ((ClosureExpression)objectExpression).getParameters();
                    this.typeCheckClosureCall(callArguments, args, parameters3);
                    data = objectExpression.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE);
                    if (data != null) {
                        this.storeType(call, (ClassNode)data);
                    }
                }
                int nbOfArgs = 0;
                if (callArguments instanceof ArgumentListExpression) {
                    ArgumentListExpression list = (ArgumentListExpression)callArguments;
                    nbOfArgs = list.getExpressions().size();
                } else {
                    nbOfArgs = 0;
                }
                this.storeTargetMethod(call, nbOfArgs == 0 ? CLOSURE_CALL_NO_ARG : (nbOfArgs == 1 ? CLOSURE_CALL_ONE_ARG : CLOSURE_CALL_VARGS));
            } else {
                List<ClassNode> potentialReceiverType;
                LinkedList<ClassNode> receivers = new LinkedList<ClassNode>();
                if (!this.withReceiverList.isEmpty()) {
                    receivers.addAll(this.withReceiverList);
                }
                receivers.add(receiver);
                if (receiver.equals(ClassHelper.CLASS_Type) && receiver.getGenericsTypes() != null) {
                    GenericsType clazzGT = receiver.getGenericsTypes()[0];
                    receivers.add(clazzGT.getType());
                }
                if (!this.temporaryIfBranchTypeInformation.empty() && (potentialReceiverType = this.getTemporaryTypesForExpression(objectExpression)) != null) {
                    receivers.addAll(potentialReceiverType);
                }
                List<MethodNode> mn = null;
                ClassNode chosenReceiver = null;
                for (ClassNode currentReceiver : receivers) {
                    mn = this.findMethod(currentReceiver, name, args);
                    if (mn.isEmpty()) continue;
                    if (mn.size() == 1) {
                        this.typeCheckMethodsWithGenerics(currentReceiver, args, mn.get(0), call);
                    }
                    chosenReceiver = currentReceiver;
                    break;
                }
                if (mn.isEmpty()) {
                    this.addStaticTypeError("Cannot find matching method " + receiver.getText() + "#" + StaticTypeCheckingSupport.toMethodParametersString(name, args), call);
                } else if (mn.size() == 1) {
                    VariableExpression var;
                    MethodNode directMethodCallCandidate = mn.get(0);
                    ClassNode currentClassNode = this.classNode;
                    this.classNode = directMethodCallCandidate.getDeclaringClass();
                    for (ClassNode node : this.source.getAST().getClasses()) {
                        if (!StaticTypeCheckingVisitor.isClassInnerClassOrEqualTo(this.classNode, node)) continue;
                        this.silentlyVisitMethodNode(directMethodCallCandidate);
                        break;
                    }
                    this.pickInferredTypeFromMethodAnnotation(directMethodCallCandidate);
                    this.classNode = currentClassNode;
                    ClassNode returnType = this.getType(directMethodCallCandidate);
                    if (StaticTypeCheckingSupport.isUsingGenericsOrIsArrayUsingGenerics(returnType)) {
                        ClassNode irtg = this.inferReturnTypeGenerics(chosenReceiver, directMethodCallCandidate, callArguments);
                        returnType = irtg != null && StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(irtg, returnType) ? irtg : returnType;
                    }
                    this.storeType(call, returnType);
                    this.storeTargetMethod(call, directMethodCallCandidate);
                    if (objectExpression instanceof VariableExpression && (var = (VariableExpression)objectExpression).isClosureSharedVariable()) {
                        this.secondPassExpressions.add(call);
                    }
                } else {
                    this.addAmbiguousOrDynamicErrorMessage(mn, name, args, call);
                }
            }
        }
        finally {
            if (isWithCall) {
                this.lastImplicitItType = rememberLastItType;
                this.withReceiverList.removeFirst();
            }
        }
    }

    private List<ClassNode> getTemporaryTypesForExpression(Expression objectExpression) {
        List classNodes = null;
        int depth = this.temporaryIfBranchTypeInformation.size();
        while (classNodes == null && depth > 0) {
            Map tempo = (Map)this.temporaryIfBranchTypeInformation.get(--depth);
            Object key = this.extractTemporaryTypeInfoKey(objectExpression);
            classNodes = (List)tempo.get(key);
        }
        return classNodes;
    }

    private void storeTargetMethod(Expression call, MethodNode directMethodCallCandidate) {
        call.putNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET, directMethodCallCandidate);
    }

    private boolean isClosureCall(String name, Expression objectExpression, Expression arguments) {
        if (objectExpression instanceof ClosureExpression) {
            return true;
        }
        if (objectExpression == VariableExpression.THIS_EXPRESSION) {
            ClassNode type;
            FieldNode fieldNode = this.classNode.getDeclaredField(name);
            if (fieldNode != null && ClassHelper.CLOSURE_TYPE.equals(type = fieldNode.getType()) && !this.classNode.hasPossibleMethod(name, arguments)) {
                return true;
            }
        } else if (!"call".equals(name) && !"doCall".equals(name)) {
            return false;
        }
        return this.getType(objectExpression).equals(ClassHelper.CLOSURE_TYPE);
    }

    private void typeCheckClosureCall(Expression callArguments, ClassNode[] args, Parameter[] parameters) {
        if (StaticTypeCheckingSupport.allParametersAndArgumentsMatch(parameters, args) < 0 && StaticTypeCheckingSupport.lastArgMatchesVarg(parameters, args) < 0) {
            StringBuilder sb = new StringBuilder("[");
            int parametersLength = parameters.length;
            for (int i = 0; i < parametersLength; ++i) {
                Parameter parameter = parameters[i];
                sb.append(parameter.getType().getName());
                if (i >= parametersLength - 1) continue;
                sb.append(", ");
            }
            sb.append("]");
            this.addStaticTypeError("Closure argument types: " + sb + " do not match with parameter types: " + StaticTypeCheckingVisitor.formatArgumentList(args), callArguments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitIfElse(IfStatement ifElse) {
        Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
        try {
            this.pushTemporaryTypeInfo();
            this.visitStatement(ifElse);
            ifElse.getBooleanExpression().visit(this);
            ifElse.getIfBlock().visit(this);
            this.temporaryIfBranchTypeInformation.pop();
            Statement elseBlock = ifElse.getElseBlock();
            if (elseBlock instanceof EmptyStatement) {
                this.visitEmptyStatement((EmptyStatement)elseBlock);
            } else {
                elseBlock.visit(this);
            }
        }
        finally {
            this.popAssignmentTracking(oldTracker);
        }
    }

    private Map<VariableExpression, ClassNode> popAssignmentTracking(Map<VariableExpression, List<ClassNode>> oldTracker) {
        HashMap<VariableExpression, ClassNode> assignments = new HashMap<VariableExpression, ClassNode>();
        if (!this.ifElseForWhileAssignmentTracker.isEmpty()) {
            for (Map.Entry<VariableExpression, List<ClassNode>> entry : this.ifElseForWhileAssignmentTracker.entrySet()) {
                VariableExpression key = entry.getKey();
                ClassNode cn = WideningCategories.lowestUpperBound(entry.getValue());
                this.storeType(key, cn);
                assignments.put(key, cn);
            }
        }
        this.ifElseForWhileAssignmentTracker = oldTracker;
        return assignments;
    }

    private Map<VariableExpression, List<ClassNode>> pushAssignmentTracking() {
        Map<VariableExpression, List<ClassNode>> oldTracker = this.ifElseForWhileAssignmentTracker;
        this.ifElseForWhileAssignmentTracker = new HashMap<VariableExpression, List<ClassNode>>();
        return oldTracker;
    }

    @Override
    public void visitCastExpression(CastExpression expression) {
        super.visitCastExpression(expression);
        if (!expression.isCoerce()) {
            ClassNode targetType = expression.getType();
            Expression source = expression.getExpression();
            ClassNode expressionType = this.getType(source);
            if (!this.checkCast(targetType, source)) {
                this.addStaticTypeError("Inconvertible types: cannot cast " + expressionType.toString(false) + " to " + targetType.getName(), expression);
            }
        }
        this.storeType(expression, expression.getType());
    }

    private boolean checkCast(ClassNode targetType, Expression source) {
        boolean sourceIsNull = source instanceof ConstantExpression && ((ConstantExpression)source).getValue() == null;
        ClassNode expressionType = this.getType(source);
        if (targetType.isArray() && expressionType.isArray()) {
            return this.checkCast(targetType.getComponentType(), new VariableExpression("foo", expressionType.getComponentType()));
        }
        if (!(targetType.equals(ClassHelper.char_TYPE) && expressionType == ClassHelper.STRING_TYPE && source instanceof ConstantExpression && source.getText().length() == 1 || targetType.equals(ClassHelper.Character_TYPE) && (expressionType == ClassHelper.STRING_TYPE || sourceIsNull) && (sourceIsNull || source instanceof ConstantExpression && source.getText().length() == 1) || WideningCategories.isNumberCategory(ClassHelper.getWrapper(targetType)) && (WideningCategories.isNumberCategory(ClassHelper.getWrapper(expressionType)) || ClassHelper.char_TYPE == expressionType) || sourceIsNull && !ClassHelper.isPrimitiveType(targetType))) {
            if (sourceIsNull && ClassHelper.isPrimitiveType(targetType)) {
                return false;
            }
            if (!StaticTypeCheckingSupport.isAssignableTo(targetType, expressionType) && !StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(expressionType, targetType)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void visitTernaryExpression(TernaryExpression expression) {
        Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
        this.pushTemporaryTypeInfo();
        expression.getBooleanExpression().visit(this);
        expression.getTrueExpression().visit(this);
        this.temporaryIfBranchTypeInformation.pop();
        expression.getFalseExpression().visit(this);
        ClassNode typeOfTrue = this.getType(expression.getTrueExpression());
        ClassNode typeOfFalse = this.getType(expression.getFalseExpression());
        this.storeType(expression, WideningCategories.lowestUpperBound(typeOfTrue, typeOfFalse));
        this.popAssignmentTracking(oldTracker);
    }

    private void pushTemporaryTypeInfo() {
        HashMap potentialTypes = new HashMap();
        this.temporaryIfBranchTypeInformation.push(potentialTypes);
    }

    private void storeType(Expression exp, ClassNode cn) {
        if (cn == StaticTypeCheckingSupport.UNKNOWN_PARAMETER_TYPE) {
            this.storeType(exp, this.getOriginalDeclarationType(exp));
            return;
        }
        ClassNode oldValue = (ClassNode)exp.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, cn);
        if (oldValue != null) {
            ClassNode oldDIT = (ClassNode)exp.getNodeMetaData((Object)StaticTypesMarker.DECLARATION_INFERRED_TYPE);
            if (oldDIT != null) {
                exp.putNodeMetaData((Object)StaticTypesMarker.DECLARATION_INFERRED_TYPE, WideningCategories.lowestUpperBound(oldDIT, cn));
            } else {
                exp.putNodeMetaData((Object)StaticTypesMarker.DECLARATION_INFERRED_TYPE, WideningCategories.lowestUpperBound(oldValue, cn));
            }
        }
        if (exp instanceof VariableExpression) {
            List<ClassNode> temporaryTypesForExpression;
            VariableExpression var = (VariableExpression)exp;
            Variable accessedVariable = var.getAccessedVariable();
            if (accessedVariable != null && accessedVariable != exp && accessedVariable instanceof VariableExpression) {
                this.storeType((Expression)((Object)accessedVariable), cn);
            }
            if (var.isClosureSharedVariable()) {
                List<ClassNode> assignedTypes = this.closureSharedVariablesAssignmentTypes.get(var);
                if (assignedTypes == null) {
                    assignedTypes = new LinkedList<ClassNode>();
                    this.closureSharedVariablesAssignmentTypes.put(var, assignedTypes);
                }
                assignedTypes.add(cn);
            }
            if (!this.temporaryIfBranchTypeInformation.empty() && (temporaryTypesForExpression = this.getTemporaryTypesForExpression(exp)) != null && !temporaryTypesForExpression.isEmpty()) {
                temporaryTypesForExpression.clear();
            }
        }
    }

    private ClassNode getResultType(ClassNode left, int op, ClassNode right, BinaryExpression expr) {
        String operationName;
        ClassNode leftRedirect = left.redirect();
        ClassNode rightRedirect = right.redirect();
        Expression leftExpression = expr.getLeftExpression();
        if (op == 100 || op == 1100) {
            ClassNode initialType;
            if (leftRedirect.isArray() && !rightRedirect.isArray()) {
                return leftRedirect;
            }
            if (leftRedirect.implementsInterface(StaticTypeCheckingSupport.Collection_TYPE) && rightRedirect.implementsInterface(StaticTypeCheckingSupport.Collection_TYPE)) {
                List<Expression> list;
                if (expr.getRightExpression() instanceof ListExpression && (list = ((ListExpression)expr.getRightExpression()).getExpressions()).isEmpty()) {
                    return left;
                }
                return right;
            }
            if (rightRedirect.implementsInterface(StaticTypeCheckingSupport.Collection_TYPE) && rightRedirect.isDerivedFrom(leftRedirect)) {
                return right;
            }
            if (leftExpression instanceof VariableExpression && (ClassHelper.STRING_TYPE.equals(initialType = this.getOriginalDeclarationType(leftExpression).redirect()) || ClassHelper.CLASS_Type.equals(initialType) || ClassHelper.Boolean_TYPE.equals(initialType))) {
                return initialType;
            }
            return right;
        }
        if (StaticTypeCheckingSupport.isBoolIntrinsicOp(op)) {
            return ClassHelper.boolean_TYPE;
        }
        if (StaticTypeCheckingSupport.isArrayOp(op)) {
            if (ClassHelper.STRING_TYPE.equals(left)) {
                return ClassHelper.STRING_TYPE;
            }
            return this.inferComponentType(left);
        }
        if (op == 90) {
            return StaticTypeCheckingSupport.Matcher_TYPE;
        }
        if (ClassHelper.isNumberType(leftRedirect) && ClassHelper.isNumberType(rightRedirect)) {
            if (StaticTypeCheckingSupport.isOperationInGroup(op)) {
                if (WideningCategories.isIntCategory(leftRedirect) && WideningCategories.isIntCategory(rightRedirect)) {
                    return ClassHelper.int_TYPE;
                }
                if (WideningCategories.isLongCategory(leftRedirect) && WideningCategories.isLongCategory(rightRedirect)) {
                    return ClassHelper.long_TYPE;
                }
                if (WideningCategories.isFloat(leftRedirect) && WideningCategories.isFloat(rightRedirect)) {
                    return ClassHelper.float_TYPE;
                }
                if (WideningCategories.isDouble(leftRedirect) && WideningCategories.isDouble(rightRedirect)) {
                    return ClassHelper.double_TYPE;
                }
            } else {
                if (StaticTypeCheckingSupport.isPowerOperator(op)) {
                    return ClassHelper.Number_TYPE;
                }
                if (StaticTypeCheckingSupport.isBitOperator(op)) {
                    if (WideningCategories.isIntCategory(leftRedirect) && WideningCategories.isIntCategory(rightRedirect)) {
                        return ClassHelper.int_TYPE;
                    }
                    if (WideningCategories.isLongCategory(leftRedirect) && WideningCategories.isLongCategory(rightRedirect)) {
                        return ClassHelper.Long_TYPE;
                    }
                    if (WideningCategories.isBigIntCategory(leftRedirect) && WideningCategories.isBigIntCategory(rightRedirect)) {
                        return ClassHelper.BigInteger_TYPE;
                    }
                } else if (StaticTypeCheckingSupport.isCompareToBoolean(op) || op == 123) {
                    return ClassHelper.boolean_TYPE;
                }
            }
        }
        if (StaticTypeCheckingSupport.isShiftOperation(operationName = StaticTypeCheckingSupport.getOperationName(op)) && WideningCategories.isNumberCategory(leftRedirect) && (WideningCategories.isIntCategory(rightRedirect) || WideningCategories.isLongCategory(rightRedirect))) {
            return leftRedirect;
        }
        if (203 == op || 213 == op) {
            if (WideningCategories.isFloatingCategory(leftRedirect) || WideningCategories.isFloatingCategory(rightRedirect)) {
                if (!ClassHelper.isPrimitiveType(leftRedirect) || !ClassHelper.isPrimitiveType(rightRedirect)) {
                    return ClassHelper.Double_TYPE;
                }
                return ClassHelper.double_TYPE;
            }
            if (203 == op) {
                return ClassHelper.BigDecimal_TYPE;
            }
            return leftRedirect;
        }
        if (StaticTypeCheckingSupport.isOperationInGroup(op) && WideningCategories.isNumberCategory(ClassHelper.getWrapper(leftRedirect)) && WideningCategories.isNumberCategory(ClassHelper.getWrapper(rightRedirect))) {
            return StaticTypeCheckingVisitor.getGroupOperationResultType(leftRedirect, rightRedirect);
        }
        if (205 == op || 215 == op) {
            return leftRedirect;
        }
        MethodNode method = this.findMethodOrFail(expr, left, operationName, right);
        if (method != null) {
            this.typeCheckMethodsWithGenerics(left, new ClassNode[]{right}, method, expr);
            if (StaticTypeCheckingSupport.isAssignment(op)) {
                return left;
            }
            if (StaticTypeCheckingSupport.isCompareToBoolean(op)) {
                return ClassHelper.boolean_TYPE;
            }
            if (op == 128) {
                return ClassHelper.int_TYPE;
            }
            return this.inferReturnTypeGenerics(left, method, new ArgumentListExpression(expr.getRightExpression()));
        }
        return null;
    }

    private static ClassNode getGroupOperationResultType(ClassNode a, ClassNode b) {
        if (WideningCategories.isBigIntCategory(a) && WideningCategories.isBigIntCategory(b)) {
            return ClassHelper.BigInteger_TYPE;
        }
        if (WideningCategories.isBigDecCategory(a) && WideningCategories.isBigDecCategory(b)) {
            return ClassHelper.BigDecimal_TYPE;
        }
        if (ClassHelper.BigDecimal_TYPE.equals(a) || ClassHelper.BigDecimal_TYPE.equals(b)) {
            return ClassHelper.BigDecimal_TYPE;
        }
        if (ClassHelper.BigInteger_TYPE.equals(a) || ClassHelper.BigInteger_TYPE.equals(b)) {
            if (WideningCategories.isBigIntCategory(a) && WideningCategories.isBigIntCategory(b)) {
                return ClassHelper.BigInteger_TYPE;
            }
            return ClassHelper.BigDecimal_TYPE;
        }
        if (ClassHelper.double_TYPE.equals(a) || ClassHelper.double_TYPE.equals(b)) {
            return ClassHelper.double_TYPE;
        }
        if (ClassHelper.Double_TYPE.equals(a) || ClassHelper.Double_TYPE.equals(b)) {
            return ClassHelper.Double_TYPE;
        }
        if (ClassHelper.float_TYPE.equals(a) || ClassHelper.float_TYPE.equals(b)) {
            return ClassHelper.float_TYPE;
        }
        if (ClassHelper.Float_TYPE.equals(a) || ClassHelper.Float_TYPE.equals(b)) {
            return ClassHelper.Float_TYPE;
        }
        if (ClassHelper.long_TYPE.equals(a) || ClassHelper.long_TYPE.equals(b)) {
            return ClassHelper.long_TYPE;
        }
        if (ClassHelper.Long_TYPE.equals(a) || ClassHelper.Long_TYPE.equals(b)) {
            return ClassHelper.Long_TYPE;
        }
        if (ClassHelper.int_TYPE.equals(a) || ClassHelper.int_TYPE.equals(b)) {
            return ClassHelper.int_TYPE;
        }
        if (ClassHelper.Integer_TYPE.equals(a) || ClassHelper.Integer_TYPE.equals(b)) {
            return ClassHelper.Integer_TYPE;
        }
        if (ClassHelper.short_TYPE.equals(a) || ClassHelper.short_TYPE.equals(b)) {
            return ClassHelper.short_TYPE;
        }
        if (ClassHelper.Short_TYPE.equals(a) || ClassHelper.Short_TYPE.equals(b)) {
            return ClassHelper.Short_TYPE;
        }
        if (ClassHelper.byte_TYPE.equals(a) || ClassHelper.byte_TYPE.equals(b)) {
            return ClassHelper.byte_TYPE;
        }
        if (ClassHelper.Byte_TYPE.equals(a) || ClassHelper.Byte_TYPE.equals(b)) {
            return ClassHelper.Byte_TYPE;
        }
        if (ClassHelper.char_TYPE.equals(a) || ClassHelper.char_TYPE.equals(b)) {
            return ClassHelper.char_TYPE;
        }
        if (ClassHelper.Character_TYPE.equals(a) || ClassHelper.Character_TYPE.equals(b)) {
            return ClassHelper.Character_TYPE;
        }
        return ClassHelper.Number_TYPE;
    }

    private ClassNode inferComponentType(ClassNode containerType) {
        ClassNode componentType = containerType.getComponentType();
        if (componentType == null) {
            GenericsType[] types = containerType.getGenericsTypes();
            if (types != null && types.length == 1) {
                GenericsType type = types[0];
                if (type.isWildcard()) {
                    ClassNode[] upperBounds = type.getUpperBounds();
                    if (upperBounds.length == 1) {
                        return upperBounds[0];
                    }
                    ClassNode lowerBound = type.getLowerBound();
                    if (lowerBound != null) {
                        return lowerBound;
                    }
                }
                return type.getType();
            }
            return ClassHelper.OBJECT_TYPE;
        }
        return componentType;
    }

    protected MethodNode findMethodOrFail(Expression expr, ClassNode receiver, String name, ClassNode ... args) {
        List<MethodNode> methods = this.findMethod(receiver, name, args);
        if (methods.isEmpty()) {
            this.addStaticTypeError("Cannot find matching method " + receiver.getText() + "#" + StaticTypeCheckingSupport.toMethodParametersString(name, args), expr);
        } else {
            if (methods.size() == 1) {
                return methods.get(0);
            }
            this.addAmbiguousOrDynamicErrorMessage(methods, name, args, expr);
        }
        return null;
    }

    private void addAmbiguousOrDynamicErrorMessage(List<MethodNode> foundMethods, String name, ClassNode[] args, Expression expr) {
        boolean category = false;
        if ("use".equals(name) && args != null && args.length == 2 && args[1].equals(ClassHelper.CLOSURE_TYPE)) {
            category = true;
            for (MethodNode method : foundMethods) {
                if (method instanceof ExtensionMethodNode && ((ExtensionMethodNode)method).getExtensionMethodNode().getDeclaringClass().equals(DGM_CLASSNODE)) continue;
                category = false;
            }
        }
        if (category) {
            this.addStaticTypeError("Due to their dynamic nature, usage of categories is not possible with static type checking active", expr);
        } else {
            this.addStaticTypeError("Reference to method is ambiguous. Cannot choose between " + foundMethods, expr);
        }
    }

    private List<MethodNode> findMethod(ClassNode receiver, String name, ClassNode ... args) {
        List<MethodNode> methodNodes;
        TypeCheckerPlugin plugin;
        List<MethodNode> chosen;
        List<MethodNode> methods;
        if (ClassHelper.isPrimitiveType(receiver)) {
            receiver = ClassHelper.getWrapper(receiver);
        }
        if ("<init>".equals(name)) {
            methods = new ArrayList<ConstructorNode>(receiver.getDeclaredConstructors());
            if (methods.isEmpty()) {
                ConstructorNode node = new ConstructorNode(1, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, EmptyStatement.INSTANCE);
                node.setDeclaringClass(receiver);
                return Collections.singletonList(node);
            }
        } else {
            String pname;
            methods = receiver.getMethods(name);
            if (this.closureExpression == null) {
                ClassNode parent = receiver;
                while (parent instanceof InnerClassNode && !parent.isStaticClass()) {
                    parent = receiver.getOuterClass();
                    methods.addAll(parent.getMethods(name));
                }
            }
            if (methods.isEmpty() && (args == null || args.length == 0)) {
                pname = null;
                if (name.startsWith("get")) {
                    pname = Introspector.decapitalize(name.substring(3));
                } else if (name.startsWith("is")) {
                    pname = Introspector.decapitalize(name.substring(2));
                }
                if (pname != null) {
                    PropertyNode property = null;
                    for (ClassNode curNode = receiver; property == null && curNode != null; curNode = curNode.getSuperClass()) {
                        property = curNode.getProperty(pname);
                    }
                    if (property != null) {
                        MethodNode node = new MethodNode(name, 1, property.getType(), Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, EmptyStatement.INSTANCE);
                        node.setDeclaringClass(receiver);
                        return Collections.singletonList(node);
                    }
                }
            } else if (methods.isEmpty() && args != null && args.length == 1 && name.startsWith("set")) {
                pname = Introspector.decapitalize(name.substring(3));
                PropertyNode property = null;
                for (ClassNode curNode = receiver; property == null && curNode != null; curNode = curNode.getSuperClass()) {
                    property = curNode.getProperty(pname);
                }
                if (property != null) {
                    ClassNode type = property.getOriginType();
                    if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(args[0], type)) {
                        MethodNode node = new MethodNode(name, 1, ClassHelper.VOID_TYPE, new Parameter[]{new Parameter(type, "arg")}, ClassNode.EMPTY_ARRAY, EmptyStatement.INSTANCE);
                        node.setDeclaringClass(receiver);
                        return Collections.singletonList(node);
                    }
                    System.out.println();
                }
            }
        }
        if (!(chosen = StaticTypeCheckingSupport.chooseBestMethod(receiver, methods, args)).isEmpty()) {
            return chosen;
        }
        methods.clear();
        chosen = StaticTypeCheckingSupport.findDGMMethodsByNameAndArguments(receiver, name, args, methods);
        if (!chosen.isEmpty()) {
            return chosen;
        }
        if (receiver == ClassHelper.GSTRING_TYPE) {
            return this.findMethod(ClassHelper.STRING_TYPE, name, args);
        }
        if (this.pluginFactory != null && (plugin = this.pluginFactory.getTypeCheckerPlugin(this.classNode)) != null && (methodNodes = plugin.findMethod(receiver, name, args)) != null && !methodNodes.isEmpty()) {
            return methodNodes;
        }
        return EMPTY_METHODNODE_LIST;
    }

    protected ClassNode getType(ASTNode exp) {
        ClassNode irt;
        ClassNode cn = (ClassNode)exp.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
        if (cn != null) {
            return cn;
        }
        if (exp instanceof ClassExpression) {
            ClassNode node = ClassHelper.CLASS_Type.getPlainNodeReference();
            node.setGenericsTypes(new GenericsType[]{new GenericsType(((ClassExpression)exp).getType())});
            return node;
        }
        if (exp instanceof VariableExpression) {
            Parameter parameter;
            ClassNode type;
            VariableExpression vexp = (VariableExpression)exp;
            if (vexp == VariableExpression.THIS_EXPRESSION) {
                return this.classNode;
            }
            if (vexp == VariableExpression.SUPER_EXPRESSION) {
                return this.classNode.getSuperClass();
            }
            Variable variable = vexp.getAccessedVariable();
            if (variable != null && variable != vexp && variable instanceof VariableExpression) {
                return this.getType((Expression)((Object)variable));
            }
            if (variable instanceof Parameter && (type = this.forLoopVariableTypes.get(parameter = (Parameter)variable)) != null) {
                return type;
            }
        } else if (exp instanceof PropertyExpression) {
            PropertyExpression pexp = (PropertyExpression)exp;
            ClassNode objectExpType = this.getType(pexp.getObjectExpression());
            if ((ClassHelper.LIST_TYPE.equals(objectExpType) || objectExpType.implementsInterface(ClassHelper.LIST_TYPE)) && pexp.isSpreadSafe()) {
                return ClassHelper.LIST_TYPE;
            }
            if ((objectExpType.equals(ClassHelper.MAP_TYPE) || objectExpType.implementsInterface(ClassHelper.MAP_TYPE)) && pexp.isSpreadSafe()) {
                String propertyName = pexp.getPropertyAsString();
                GenericsType[] types = objectExpType.getGenericsTypes();
                if ("key".equals(propertyName)) {
                    if (types.length == 2) {
                        ClassNode listKey = ClassHelper.LIST_TYPE.getPlainNodeReference();
                        listKey.setGenericsTypes(new GenericsType[]{types[0]});
                        return listKey;
                    }
                } else if ("value".equals(propertyName)) {
                    if (types.length == 2) {
                        ClassNode listValue = ClassHelper.LIST_TYPE.getPlainNodeReference();
                        listValue.setGenericsTypes(new GenericsType[]{types[1]});
                        return listValue;
                    }
                } else {
                    this.addStaticTypeError("Spread operator on map only allows one of [key,value]", pexp);
                }
                return ClassHelper.LIST_TYPE;
            }
            if (objectExpType.isEnum()) {
                return objectExpType;
            }
            AtomicReference<ClassNode> result = new AtomicReference<ClassNode>(ClassHelper.VOID_TYPE);
            this.existsProperty(pexp, false, new PropertyLookupVisitor(result));
            return result.get();
        }
        if (exp instanceof ListExpression) {
            return this.inferListExpressionType((ListExpression)exp);
        }
        if (exp instanceof MapExpression) {
            return this.inferMapExpressionType((MapExpression)exp);
        }
        if (exp instanceof MethodNode) {
            ClassNode ret = (ClassNode)exp.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE);
            return ret != null ? ret : ((MethodNode)exp).getReturnType();
        }
        if (exp instanceof ClosureExpression && (irt = (ClassNode)exp.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE)) != null) {
            irt = StaticTypeCheckingVisitor.wrapTypeIfNecessary(irt);
            ClassNode result = ClassHelper.CLOSURE_TYPE.getPlainNodeReference();
            result.setGenericsTypes(new GenericsType[]{new GenericsType(irt)});
            return result;
        }
        if (exp instanceof RangeExpression) {
            ClassNode toType;
            ClassNode plain = ClassHelper.RANGE_TYPE.getPlainNodeReference();
            RangeExpression re = (RangeExpression)exp;
            ClassNode fromType = this.getType(re.getFrom());
            if (fromType.equals(toType = this.getType(re.getTo()))) {
                plain.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(fromType))});
            } else {
                plain.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(WideningCategories.lowestUpperBound(fromType, toType)))});
            }
            return plain;
        }
        if (exp instanceof UnaryPlusExpression) {
            return this.getType(((UnaryPlusExpression)exp).getExpression());
        }
        if (exp instanceof UnaryMinusExpression) {
            return this.getType(((UnaryMinusExpression)exp).getExpression());
        }
        if (exp instanceof BitwiseNegationExpression) {
            return this.getType(((BitwiseNegationExpression)exp).getExpression());
        }
        return exp instanceof VariableExpression ? ((VariableExpression)exp).getOriginType() : ((Expression)exp).getType();
    }

    private ClassNode inferListExpressionType(ListExpression list) {
        List<Expression> expressions = list.getExpressions();
        if (expressions.isEmpty()) {
            return list.getType();
        }
        ClassNode listType = list.getType();
        GenericsType[] genericsTypes = listType.getGenericsTypes();
        if ((genericsTypes == null || genericsTypes.length == 0 || genericsTypes.length == 1 && ClassHelper.OBJECT_TYPE.equals(genericsTypes[0].getType())) && !expressions.isEmpty()) {
            LinkedList<ClassNode> nodes = new LinkedList<ClassNode>();
            for (Expression expression : expressions) {
                if (expression instanceof ConstantExpression && ((ConstantExpression)expression).getValue() == null) continue;
                nodes.add(this.getType(expression));
            }
            if (nodes.isEmpty()) {
                return listType;
            }
            ClassNode superType = ClassHelper.getWrapper(WideningCategories.lowestUpperBound(nodes));
            ClassNode inferred = listType.getPlainNodeReference();
            inferred.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(superType))});
            return inferred;
        }
        return listType;
    }

    private ClassNode inferMapExpressionType(MapExpression map) {
        ClassNode mapType = map.getType();
        List<MapEntryExpression> entryExpressions = map.getMapEntryExpressions();
        if (entryExpressions.isEmpty()) {
            return mapType;
        }
        GenericsType[] genericsTypes = mapType.getGenericsTypes();
        if (genericsTypes == null || genericsTypes.length < 2 || genericsTypes.length == 2 && ClassHelper.OBJECT_TYPE.equals(genericsTypes[0].getType()) && ClassHelper.OBJECT_TYPE.equals(genericsTypes[1].getType())) {
            LinkedList<ClassNode> keyTypes = new LinkedList<ClassNode>();
            LinkedList<ClassNode> valueTypes = new LinkedList<ClassNode>();
            for (MapEntryExpression entryExpression : entryExpressions) {
                keyTypes.add(this.getType(entryExpression.getKeyExpression()));
                valueTypes.add(this.getType(entryExpression.getValueExpression()));
            }
            ClassNode keyType = ClassHelper.getWrapper(WideningCategories.lowestUpperBound(keyTypes));
            ClassNode valueType = ClassHelper.getWrapper(WideningCategories.lowestUpperBound(valueTypes));
            if (!ClassHelper.OBJECT_TYPE.equals(keyType) || !ClassHelper.OBJECT_TYPE.equals(valueType)) {
                ClassNode inferred = mapType.getPlainNodeReference();
                inferred.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(keyType)), new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(valueType))});
                return inferred;
            }
        }
        return mapType;
    }

    private ClassNode inferReturnTypeGenerics(ClassNode receiver, MethodNode method, Expression arguments) {
        ExtensionMethodNode emn;
        MethodNode dgmMethod;
        ClassNode firstParam;
        ClassNode returnType = method.getReturnType();
        if (method instanceof ExtensionMethodNode && (returnType.isGenericsPlaceHolder() || returnType.isArray() && returnType.getComponentType().isGenericsPlaceHolder()) && ((firstParam = (dgmMethod = (emn = (ExtensionMethodNode)method).getExtensionMethodNode()).getParameters()[0].getOriginType()).isGenericsPlaceHolder() || firstParam.isArray() && firstParam.getComponentType().isGenericsPlaceHolder())) {
            ClassNode returnTypeComp;
            ClassNode paramType = firstParam.isArray() ? firstParam.getComponentType() : firstParam;
            ClassNode classNode = returnTypeComp = returnType.isArray() ? returnType.getComponentType() : returnType;
            if (paramType.getName().equals(returnTypeComp.getName())) {
                return returnType.isArray() ? receiver : receiver.getComponentType();
            }
        }
        if (!StaticTypeCheckingSupport.isUsingGenericsOrIsArrayUsingGenerics(returnType)) {
            return returnType;
        }
        GenericsType[] returnTypeGenerics = returnType.isArray() ? returnType.getComponentType().getGenericsTypes() : returnType.getGenericsTypes();
        LinkedList<GenericsType> placeholders = new LinkedList<GenericsType>();
        for (GenericsType returnTypeGeneric : returnTypeGenerics) {
            if (!returnTypeGeneric.isPlaceholder() && !returnTypeGeneric.isWildcard()) continue;
            placeholders.add(returnTypeGeneric);
        }
        if (placeholders.isEmpty()) {
            return returnType;
        }
        HashMap<String, GenericsType> resolvedPlaceholders = new HashMap<String, GenericsType>();
        GenericsUtils.extractPlaceholders(receiver, resolvedPlaceholders);
        GenericsUtils.extractPlaceholders(method.getReturnType(), resolvedPlaceholders);
        Parameter[] parameters = method.getParameters();
        boolean isVargs = StaticTypeCheckingSupport.isVargs(parameters);
        ArgumentListExpression argList = InvocationWriter.makeArgumentList(arguments);
        List<Expression> expressions = argList.getExpressions();
        int paramLength = parameters.length;
        if (expressions.size() >= paramLength) {
            for (int i = 0; i < paramLength; ++i) {
                boolean lastArg = i == paramLength - 1;
                ClassNode type = parameters[i].getType();
                if (!type.isUsingGenerics() && type.isArray()) {
                    type = type.getComponentType();
                }
                if (!type.isUsingGenerics()) continue;
                ClassNode actualType = this.getType(expressions.get(i));
                if (isVargs && lastArg && actualType.isArray()) {
                    actualType = actualType.getComponentType();
                }
                actualType = StaticTypeCheckingVisitor.wrapTypeIfNecessary(actualType);
                Map<String, GenericsType> typePlaceholders = GenericsUtils.extractPlaceholders(type.isArray() ? type.getComponentType() : type);
                if (ClassHelper.OBJECT_TYPE.equals(type)) {
                    for (String key : typePlaceholders.keySet()) {
                        resolvedPlaceholders.put(key, new GenericsType(actualType));
                    }
                    continue;
                }
                while (!actualType.equals(type)) {
                    Set<ClassNode> interfaces = actualType.getAllInterfaces();
                    boolean intf = false;
                    for (ClassNode anInterface : interfaces) {
                        if (!anInterface.equals(type)) continue;
                        intf = true;
                        actualType = GenericsUtils.parameterizeInterfaceGenerics(actualType, anInterface);
                    }
                    if (intf) continue;
                    actualType = actualType.getUnresolvedSuperClass();
                }
                Map<String, GenericsType> actualTypePlaceholders = GenericsUtils.extractPlaceholders(actualType);
                for (Map.Entry<String, GenericsType> typeEntry : actualTypePlaceholders.entrySet()) {
                    String key = typeEntry.getKey();
                    GenericsType value = typeEntry.getValue();
                    GenericsType alias = typePlaceholders.get(key);
                    if (alias == null || !alias.isPlaceholder()) continue;
                    resolvedPlaceholders.put(alias.getName(), value);
                }
            }
        }
        GenericsType[] copy = new GenericsType[returnTypeGenerics.length];
        for (int i = 0; i < copy.length; ++i) {
            GenericsType returnTypeGeneric = returnTypeGenerics[i];
            if (returnTypeGeneric.isPlaceholder() || returnTypeGeneric.isWildcard()) {
                GenericsType resolved = (GenericsType)resolvedPlaceholders.get(returnTypeGeneric.getName());
                if (resolved == null) {
                    resolved = returnTypeGeneric;
                }
                copy[i] = resolved;
                continue;
            }
            copy[i] = returnTypeGeneric;
        }
        if (returnType.equals(ClassHelper.OBJECT_TYPE)) {
            if (copy[0].getType().isGenericsPlaceHolder()) {
                return ClassHelper.OBJECT_TYPE;
            }
            return copy[0].getType();
        }
        if (returnType.isArray()) {
            returnType = returnType.getComponentType().getPlainNodeReference();
            returnType.setGenericsTypes(copy);
            if (ClassHelper.OBJECT_TYPE.equals(returnType)) {
                returnType = copy[0].getType();
            }
            returnType = returnType.makeArray();
        } else {
            returnType = returnType.getPlainNodeReference();
            returnType.setGenericsTypes(copy);
        }
        if (returnType.equals(ClassHelper.Annotation_TYPE) && returnType.getGenericsTypes() != null && !returnType.getGenericsTypes()[0].isPlaceholder()) {
            return returnType.getGenericsTypes()[0].getType();
        }
        return returnType;
    }

    private void typeCheckMethodsWithGenerics(ClassNode receiver, ClassNode[] arguments, MethodNode candidateMethod, Expression location) {
        if (!StaticTypeCheckingSupport.isUsingGenericsOrIsArrayUsingGenerics(receiver)) {
            return;
        }
        boolean failure = false;
        GenericsType[] methodGenericTypes = null;
        ClassNode methodNodeReceiver = candidateMethod.getDeclaringClass();
        if (!StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(receiver, methodNodeReceiver) || !StaticTypeCheckingSupport.isUsingGenericsOrIsArrayUsingGenerics(methodNodeReceiver)) {
            return;
        }
        Parameter[] parameters = candidateMethod.getParameters();
        int argNum = 0;
        for (Parameter parameter : parameters) {
            ClassNode actualType;
            ClassNode type = parameter.getType();
            if (type.isUsingGenerics()) {
                methodGenericTypes = GenericsUtils.alignGenericTypes(receiver.redirect().getGenericsTypes(), receiver.getGenericsTypes(), type.getGenericsTypes());
                if (methodGenericTypes.length == 1) {
                    ClassNode nodeType = ClassHelper.getWrapper(methodGenericTypes[0].getType());
                    GenericsType[] argumentGenericTypes = arguments[argNum].getGenericsTypes();
                    ClassNode classNode = actualType = argumentGenericTypes != null ? ClassHelper.getWrapper(argumentGenericTypes[0].getType()) : nodeType;
                    if (!StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(actualType, nodeType)) {
                        failure = true;
                    }
                }
            } else if (type.isArray() && type.getComponentType().isUsingGenerics()) {
                ClassNode componentType = type.getComponentType();
                methodGenericTypes = GenericsUtils.alignGenericTypes(receiver.redirect().getGenericsTypes(), receiver.getGenericsTypes(), componentType.getGenericsTypes());
                if (methodGenericTypes.length == 1) {
                    ClassNode nodeType = ClassHelper.getWrapper(methodGenericTypes[0].getType());
                    actualType = ClassHelper.getWrapper(arguments[argNum].getComponentType());
                    if (!StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(actualType, nodeType)) {
                        failure = true;
                        GenericsType baseGT = methodGenericTypes[0];
                        methodGenericTypes[0] = new GenericsType(baseGT.getType(), baseGT.getUpperBounds(), baseGT.getLowerBound());
                        methodGenericTypes[0].setType(methodGenericTypes[0].getType().makeArray());
                    }
                }
            }
            ++argNum;
        }
        if (failure) {
            ClassNode[] parameterTypes = new ClassNode[methodGenericTypes.length];
            for (int i = 0; i < methodGenericTypes.length; ++i) {
                parameterTypes[i] = methodGenericTypes[i].getType();
            }
            this.addStaticTypeError("Cannot call " + receiver.getName() + "#" + StaticTypeCheckingSupport.toMethodParametersString(candidateMethod.getName(), parameterTypes) + " with arguments " + StaticTypeCheckingVisitor.formatArgumentList(arguments), location);
        }
    }

    private static String formatArgumentList(ClassNode[] nodes) {
        if (nodes == null) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(24 * nodes.length);
        sb.append("[");
        for (ClassNode node : nodes) {
            sb.append(node.toString(false));
            sb.append(", ");
        }
        if (sb.length() > 1) {
            sb.setCharAt(sb.length() - 2, ']');
        }
        return sb.toString();
    }

    @Override
    protected void addError(String msg, ASTNode expr) {
        int line = expr.getLineNumber();
        int col = expr.getColumnNumber();
        Long err = (long)expr.getLineNumber() << 16 + expr.getColumnNumber();
        if (!this.reportedErrors.contains(err)) {
            this.errorCollector.addErrorAndContinue(new SyntaxErrorMessage(new SyntaxException(msg + '\n', line, col), this.source));
            this.reportedErrors.add(err);
        }
    }

    protected void addStaticTypeError(String msg, ASTNode expr) {
        if (expr.getColumnNumber() > 0 && expr.getLineNumber() > 0) {
            this.addError("[Static type checking] - " + msg, expr);
        }
    }

    public void setMethodsToBeVisited(Set<MethodNode> methodsToBeVisited) {
        this.methodsToBeVisited = methodsToBeVisited;
    }

    public void performSecondPass() {
        for (Expression expression : this.secondPassExpressions) {
            VariableExpression var;
            List<ClassNode> classNodes;
            Variable target;
            MethodCallExpression call;
            Expression objectExpression;
            if (!(expression instanceof MethodCallExpression) || !((objectExpression = (call = (MethodCallExpression)expression).getObjectExpression()) instanceof VariableExpression) || !((target = StaticTypeCheckingSupport.findTargetVariable((VariableExpression)objectExpression)) instanceof VariableExpression) || (classNodes = this.closureSharedVariablesAssignmentTypes.get(var = (VariableExpression)target)) == null || classNodes.size() <= 1) continue;
            ClassNode lub = WideningCategories.lowestUpperBound(classNodes);
            MethodNode methodNode = (MethodNode)call.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
            Parameter[] parameters = methodNode.getParameters();
            ClassNode[] params = new ClassNode[parameters.length];
            for (int i = 0; i < params.length; ++i) {
                params[i] = parameters[i].getType();
            }
            List<MethodNode> method = this.findMethod(lub, methodNode.getName(), params);
            if (method.size() == 1) continue;
            this.addStaticTypeError("A closure shared variable [" + target.getName() + "] has been assigned with various types and the method" + " [" + StaticTypeCheckingSupport.toMethodParametersString(methodNode.getName(), params) + "]" + " does not exist in the lowest upper bound of those types: [" + lub.toString(false) + "]. In general, this is a bad practice (variable reuse) because the compiler cannot" + " determine safely what is the type of the variable at the moment of the call in a multithreaded context.", call);
        }
    }

    private static ClassNode wrapTypeIfNecessary(ClassNode type) {
        if (ClassHelper.isPrimitiveType(type)) {
            return ClassHelper.getWrapper(type);
        }
        return type;
    }

    private static boolean isClassInnerClassOrEqualTo(ClassNode toBeChecked, ClassNode start) {
        if (start == toBeChecked) {
            return true;
        }
        if (start instanceof InnerClassNode) {
            return StaticTypeCheckingVisitor.isClassInnerClassOrEqualTo(toBeChecked, start.getOuterClass());
        }
        return false;
    }

    protected static class SignatureCodecFactory {
        protected SignatureCodecFactory() {
        }

        static SignatureCodec getCodec(int version) {
            switch (version) {
                case 1: {
                    return new SignatureCodecVersion1();
                }
            }
            return null;
        }
    }

    private static class SignatureCodecVersion1
    implements SignatureCodec {
        private SignatureCodecVersion1() {
        }

        private void doEncode(ClassNode node, DataOutputStream dos) throws IOException {
            dos.writeUTF(node.getClass().getSimpleName());
            if (node instanceof UnionTypeClassNode) {
                UnionTypeClassNode union = (UnionTypeClassNode)node;
                ClassNode[] delegates = union.getDelegates();
                dos.writeInt(delegates.length);
                for (ClassNode delegate : delegates) {
                    this.doEncode(delegate, dos);
                }
                return;
            }
            if (node instanceof WideningCategories.LowestUpperBoundClassNode) {
                WideningCategories.LowestUpperBoundClassNode lub = (WideningCategories.LowestUpperBoundClassNode)node;
                dos.writeUTF(lub.getLubName());
                this.doEncode(lub.getUnresolvedSuperClass(), dos);
                ClassNode[] interfaces = lub.getInterfaces();
                if (interfaces == null) {
                    dos.writeInt(-1);
                } else {
                    dos.writeInt(interfaces.length);
                    for (ClassNode anInterface : interfaces) {
                        this.doEncode(anInterface, dos);
                    }
                }
                return;
            }
            if (node.isArray()) {
                dos.writeBoolean(true);
                this.doEncode(node.getComponentType(), dos);
            } else {
                dos.writeBoolean(false);
                dos.writeUTF(BytecodeHelper.getTypeDescription(node));
                dos.writeBoolean(node.isUsingGenerics());
                GenericsType[] genericsTypes = node.getGenericsTypes();
                if (genericsTypes == null) {
                    dos.writeInt(-1);
                } else {
                    dos.writeInt(genericsTypes.length);
                    for (GenericsType type : genericsTypes) {
                        dos.writeBoolean(type.isPlaceholder());
                        dos.writeBoolean(type.isWildcard());
                        this.doEncode(type.getType(), dos);
                        ClassNode lb = type.getLowerBound();
                        if (lb == null) {
                            dos.writeBoolean(false);
                        } else {
                            dos.writeBoolean(true);
                            this.doEncode(lb, dos);
                        }
                        ClassNode[] upperBounds = type.getUpperBounds();
                        if (upperBounds == null) {
                            dos.writeInt(-1);
                            continue;
                        }
                        dos.writeInt(upperBounds.length);
                        for (ClassNode bound : upperBounds) {
                            this.doEncode(bound, dos);
                        }
                    }
                }
            }
        }

        public String encode(ClassNode node) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(128);
            DataOutputStream dos = new DataOutputStream(baos);
            StringWriter wrt = new StringWriter();
            String encoded = null;
            try {
                this.doEncode(node, dos);
                EncodingGroovyMethods.encodeBase64(baos.toByteArray()).writeTo(wrt);
                encoded = wrt.toString();
            }
            catch (IOException e) {
                throw new GroovyRuntimeException("Unable to serialize type information", e);
            }
            return encoded;
        }

        private ClassNode doDecode(DataInputStream dis) throws IOException {
            String classNodeType = dis.readUTF();
            if (UnionTypeClassNode.class.getSimpleName().equals(classNodeType)) {
                int len = dis.readInt();
                ClassNode[] delegates = new ClassNode[len];
                for (int i = 0; i < len; ++i) {
                    delegates[i] = this.doDecode(dis);
                }
                return new UnionTypeClassNode(delegates);
            }
            if (WideningCategories.LowestUpperBoundClassNode.class.getSimpleName().equals(classNodeType)) {
                String name = dis.readUTF();
                ClassNode upper = this.doDecode(dis);
                int len = dis.readInt();
                ClassNode[] interfaces = null;
                if (len >= 0) {
                    interfaces = new ClassNode[len];
                    for (int i = 0; i < len; ++i) {
                        interfaces[i] = this.doDecode(dis);
                    }
                }
                return new WideningCategories.LowestUpperBoundClassNode(name, upper, interfaces);
            }
            boolean makeArray = dis.readBoolean();
            if (makeArray) {
                return this.doDecode(dis).makeArray();
            }
            String typedesc = dis.readUTF();
            char typeCode = typedesc.charAt(0);
            ClassNode result = ClassHelper.OBJECT_TYPE;
            if (typeCode == 'L') {
                String className = typedesc.replace('/', '.').substring(1, typedesc.length() - 1);
                try {
                    result = ClassHelper.make(Class.forName(className)).getPlainNodeReference();
                }
                catch (ClassNotFoundException e) {
                    result = ClassHelper.make(className);
                }
                result.setUsingGenerics(dis.readBoolean());
                int len = dis.readInt();
                if (len >= 0) {
                    GenericsType[] gts = new GenericsType[len];
                    for (int i = 0; i < len; ++i) {
                        boolean placeholder = dis.readBoolean();
                        boolean wildcard = dis.readBoolean();
                        ClassNode type = this.doDecode(dis);
                        boolean low = dis.readBoolean();
                        ClassNode lb = null;
                        if (low) {
                            lb = this.doDecode(dis);
                        }
                        int upc = dis.readInt();
                        ClassNode[] ups = null;
                        if (upc >= 0) {
                            ups = new ClassNode[upc];
                            for (int j = 0; j < upc; ++j) {
                                ups[j] = this.doDecode(dis);
                            }
                        }
                        GenericsType gt = new GenericsType(type, ups, lb);
                        gt.setPlaceholder(placeholder);
                        gt.setWildcard(wildcard);
                        gts[i] = gt;
                    }
                    result.setGenericsTypes(gts);
                }
            } else {
                switch (typeCode) {
                    case 'I': {
                        result = ClassHelper.int_TYPE;
                        break;
                    }
                    case 'Z': {
                        result = ClassHelper.boolean_TYPE;
                        break;
                    }
                    case 'B': {
                        result = ClassHelper.byte_TYPE;
                        break;
                    }
                    case 'C': {
                        result = ClassHelper.char_TYPE;
                        break;
                    }
                    case 'S': {
                        result = ClassHelper.short_TYPE;
                        break;
                    }
                    case 'D': {
                        result = ClassHelper.double_TYPE;
                        break;
                    }
                    case 'F': {
                        result = ClassHelper.float_TYPE;
                        break;
                    }
                    case 'J': {
                        result = ClassHelper.long_TYPE;
                        break;
                    }
                    case 'V': {
                        result = ClassHelper.VOID_TYPE;
                    }
                }
            }
            return result;
        }

        public ClassNode decode(String signature) {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(EncodingGroovyMethods.decodeBase64(signature)));
            try {
                return this.doDecode(dis);
            }
            catch (IOException e) {
                throw new GroovyRuntimeException("Unable to read type information", e);
            }
        }
    }

    protected static interface SignatureCodec {
        public String encode(ClassNode var1);

        public ClassNode decode(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VariableExpressionTypeMemoizer
    extends ClassCodeVisitorSupport {
        private final Map<VariableExpression, ClassNode> varOrigType;

        public VariableExpressionTypeMemoizer(Map<VariableExpression, ClassNode> varOrigType) {
            this.varOrigType = varOrigType;
        }

        @Override
        protected SourceUnit getSourceUnit() {
            return StaticTypeCheckingVisitor.this.source;
        }

        @Override
        public void visitVariableExpression(VariableExpression expression) {
            super.visitVariableExpression(expression);
            Variable var = StaticTypeCheckingSupport.findTargetVariable(expression);
            if (var instanceof VariableExpression) {
                VariableExpression ve = (VariableExpression)var;
                this.varOrigType.put(ve, (ClassNode)ve.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PropertyLookupVisitor
    extends ClassCodeVisitorSupport {
        private final AtomicReference<ClassNode> result;

        public PropertyLookupVisitor(AtomicReference<ClassNode> result) {
            this.result = result;
        }

        @Override
        protected SourceUnit getSourceUnit() {
            return null;
        }

        @Override
        public void visitMethod(MethodNode node) {
            this.result.set(node.getReturnType());
        }

        @Override
        public void visitProperty(PropertyNode node) {
            this.result.set(node.getType());
        }

        @Override
        public void visitField(FieldNode field) {
            this.result.set(field.getType());
        }
    }
}

