/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.tools.GenericsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericsType
extends ASTNode {
    protected ClassNode[] upperBounds;
    protected ClassNode lowerBound;
    protected ClassNode type;
    protected String name;
    protected boolean placeholder;
    private boolean resolved;
    private boolean wildcard;

    public GenericsType(ClassNode type, ClassNode[] upperBounds, ClassNode lowerBound) {
        this.type = type;
        this.name = type.isGenericsPlaceHolder() ? type.getUnresolvedName() : type.getName();
        this.upperBounds = upperBounds;
        this.lowerBound = lowerBound;
        this.placeholder = type.isGenericsPlaceHolder();
        this.resolved = false;
    }

    public GenericsType() {
    }

    public String toDetailsString() {
        StringBuilder s = new StringBuilder();
        s.append("GenericsType[name=").append(this.name).append(",placeholder=").append(this.placeholder);
        s.append(",resolved=").append(this.resolved).append(",wildcard=").append(this.wildcard);
        s.append(",type=").append(this.type);
        if (this.lowerBound != null) {
            s.append(",lowerBound=").append(this.lowerBound);
        }
        if (this.upperBounds != null) {
            s.append(",upperBounds=[");
            int i = 0;
            while (i < this.upperBounds.length) {
                if (i > 0) {
                    s.append(",");
                }
                s.append(this.upperBounds[i]);
                ++i;
            }
        }
        s.append("]]");
        s.append(this.getClass().getName());
        return s.toString();
    }

    public GenericsType(ClassNode basicType) {
        this(basicType, null, null);
    }

    public ClassNode getType() {
        return this.type;
    }

    public void setType(ClassNode type) {
        this.type = type;
    }

    public String toString() {
        HashSet<String> visited = new HashSet<String>();
        return this.toString(visited);
    }

    private String toString(Set<String> visited) {
        String ret;
        if (this.placeholder) {
            visited.add(this.name);
        }
        String string = ret = this.type == null || this.placeholder || this.wildcard ? this.name : this.genericsBounds(this.type, visited);
        if (this.upperBounds != null) {
            ret = String.valueOf(ret) + " extends ";
            int i = 0;
            while (i < this.upperBounds.length) {
                ret = String.valueOf(ret) + this.genericsBounds(this.upperBounds[i], visited);
                if (i + 1 < this.upperBounds.length) {
                    ret = String.valueOf(ret) + " & ";
                }
                ++i;
            }
        } else if (this.lowerBound != null) {
            ret = String.valueOf(ret) + " super " + this.genericsBounds(this.lowerBound, visited);
        }
        return ret;
    }

    private String genericsBounds(ClassNode theType, Set<String> visited) {
        String ret = theType.isArray() ? String.valueOf(theType.getComponentType().getName()) + "[]" : theType.getName();
        GenericsType[] genericsTypes = theType.getGenericsTypes();
        if (genericsTypes == null || genericsTypes.length == 0) {
            return ret;
        }
        if (genericsTypes.length == 1 && genericsTypes[0].isPlaceholder() && theType.getName().equals("java.lang.Object")) {
            return genericsTypes[0].getName();
        }
        ret = String.valueOf(ret) + "<";
        int i = 0;
        while (i < genericsTypes.length) {
            GenericsType type;
            if (i != 0) {
                ret = String.valueOf(ret) + ", ";
            }
            ret = (type = genericsTypes[i]).isPlaceholder() && visited.contains(type.getName()) ? String.valueOf(ret) + type.getName() : String.valueOf(ret) + type.toString(visited);
            ++i;
        }
        ret = String.valueOf(ret) + ">";
        return ret;
    }

    public ClassNode[] getUpperBounds() {
        return this.upperBounds;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(boolean placeholder) {
        this.placeholder = placeholder;
        this.type.setGenericsPlaceHolder(placeholder);
    }

    public boolean isResolved() {
        return this.resolved || this.placeholder;
    }

    public void setResolved(boolean res) {
        this.resolved = res;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isWildcard() {
        return this.wildcard;
    }

    public void setWildcard(boolean wildcard) {
        this.wildcard = wildcard;
    }

    public ClassNode getLowerBound() {
        return this.lowerBound;
    }

    public boolean isCompatibleWith(ClassNode classNode) {
        return new GenericsTypeMatcher().matches(classNode);
    }

    public void setUpperBounds(ClassNode[] bounds) {
        this.upperBounds = bounds;
    }

    public void setLowerBound(ClassNode bound) {
        this.lowerBound = bound;
    }

    private class GenericsTypeMatcher {
        private GenericsTypeMatcher() {
        }

        public boolean matches(ClassNode classNode) {
            if (classNode.isGenericsPlaceHolder()) {
                GenericsType[] genericsTypes = classNode.getGenericsTypes();
                if (genericsTypes == null) {
                    return true;
                }
                if (GenericsType.this.isWildcard()) {
                    if (GenericsType.this.lowerBound != null) {
                        return genericsTypes[0].getName().equals(GenericsType.this.lowerBound.getUnresolvedName());
                    }
                    if (GenericsType.this.upperBounds != null) {
                        ClassNode[] classNodeArray = GenericsType.this.upperBounds;
                        int n = GenericsType.this.upperBounds.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ClassNode upperBound = classNodeArray[n2];
                            if (genericsTypes[0].getName().equals(upperBound.getUnresolvedName())) {
                                return true;
                            }
                            ++n2;
                        }
                        return false;
                    }
                }
                return genericsTypes[0].getName().equals(GenericsType.this.name);
            }
            if (GenericsType.this.wildcard || GenericsType.this.placeholder) {
                if (GenericsType.this.upperBounds != null) {
                    boolean upIsOk = true;
                    int i = 0;
                    int upperBoundsLength = GenericsType.this.upperBounds.length;
                    while (i < upperBoundsLength && upIsOk) {
                        ClassNode upperBound = GenericsType.this.upperBounds[i];
                        upIsOk = classNode.isDerivedFrom(upperBound) || upperBound.isInterface() && classNode.implementsInterface(upperBound);
                        ++i;
                    }
                    upIsOk = upIsOk && this.checkGenerics(classNode);
                    return upIsOk;
                }
                if (GenericsType.this.lowerBound != null) {
                    return (GenericsType.this.lowerBound.isDerivedFrom(classNode) || classNode.isInterface() && GenericsType.this.lowerBound.implementsInterface(GenericsType.this.lowerBound)) && this.checkGenerics(classNode);
                }
            }
            if (GenericsType.this.type != null && !GenericsType.this.type.equals(classNode)) {
                return false;
            }
            return GenericsType.this.type == null || this.compareGenericsWithBound(classNode, GenericsType.this.type);
        }

        private boolean checkGenerics(ClassNode classNode) {
            if (GenericsType.this.upperBounds != null) {
                ClassNode[] classNodeArray = GenericsType.this.upperBounds;
                int n = GenericsType.this.upperBounds.length;
                int n2 = 0;
                while (n2 < n) {
                    ClassNode upperBound = classNodeArray[n2];
                    if (!this.compareGenericsWithBound(classNode, upperBound)) {
                        return false;
                    }
                    ++n2;
                }
            }
            return GenericsType.this.lowerBound == null || GenericsType.this.lowerBound.redirect().isUsingGenerics() || this.compareGenericsWithBound(classNode, GenericsType.this.lowerBound);
        }

        private boolean compareGenericsWithBound(ClassNode classNode, ClassNode bound) {
            if (classNode == null) {
                return false;
            }
            if (!bound.isUsingGenerics()) {
                return true;
            }
            if (!classNode.equals(bound)) {
                if (bound.isInterface()) {
                    Set<ClassNode> interfaces = classNode.getAllInterfaces();
                    for (ClassNode anInterface : interfaces) {
                        if (!anInterface.equals(bound)) continue;
                        ClassNode node = GenericsUtils.parameterizeInterfaceGenerics(classNode, anInterface);
                        return this.compareGenericsWithBound(node, bound);
                    }
                }
                return this.compareGenericsWithBound(classNode.getUnresolvedSuperClass(), bound);
            }
            GenericsType[] cnTypes = classNode.getGenericsTypes();
            if (cnTypes == null && classNode.isRedirectNode()) {
                cnTypes = classNode.redirect().getGenericsTypes();
            }
            if (cnTypes == null) {
                return true;
            }
            GenericsType[] redirectBoundGenericTypes = bound.redirect().getGenericsTypes();
            Map<String, GenericsType> classNodePlaceholders = GenericsUtils.extractPlaceholders(classNode);
            Map<String, GenericsType> boundPlaceHolders = GenericsUtils.extractPlaceholders(bound);
            boolean match = true;
            int i = 0;
            while (i < redirectBoundGenericTypes.length && match) {
                String name;
                GenericsType redirectBoundType = redirectBoundGenericTypes[i];
                GenericsType classNodeType = cnTypes[i];
                if (classNodeType.isWildcard()) {
                    ClassNode[] classNodeArray = classNodeType.getUpperBounds();
                    int n = classNodeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ClassNode node = classNodeArray[n2];
                        match = this.compareGenericsWithBound(node, bound);
                        if (!match) {
                            return false;
                        }
                        ++n2;
                    }
                } else if (classNodeType.isPlaceholder()) {
                    if (redirectBoundType.isPlaceholder()) {
                        match = classNodeType.getName().equals(redirectBoundType.getName());
                    } else {
                        name = classNodeType.getName();
                        if (classNodePlaceholders.containsKey(name)) {
                            classNodeType = classNodePlaceholders.get(name);
                        }
                        match = classNodeType.isCompatibleWith(redirectBoundType.getType());
                    }
                } else if (redirectBoundType.isPlaceholder()) {
                    if (classNodeType.isPlaceholder()) {
                        match = classNodeType.getName().equals(redirectBoundType.getName());
                    } else {
                        name = redirectBoundType.getName();
                        if (boundPlaceHolders.containsKey(name)) {
                            redirectBoundType = boundPlaceHolders.get(name);
                            boolean wildcard = redirectBoundType.isWildcard();
                            boolean placeholder = redirectBoundType.isPlaceholder();
                            if (placeholder || wildcard) {
                                if (wildcard) {
                                    if (redirectBoundType.lowerBound != null) {
                                        GenericsType gt = new GenericsType(redirectBoundType.lowerBound);
                                        if (gt.isPlaceholder() && classNodePlaceholders.containsKey(gt.getName())) {
                                            gt = classNodePlaceholders.get(gt.getName());
                                        }
                                        boolean bl = match = gt.getType().isDerivedFrom(classNodeType.getType()) || gt.getType().implementsInterface(classNodeType.getType());
                                    }
                                    if (match && redirectBoundType.upperBounds != null) {
                                        ClassNode[] classNodeArray = redirectBoundType.upperBounds;
                                        int n = redirectBoundType.upperBounds.length;
                                        int n3 = 0;
                                        while (n3 < n) {
                                            ClassNode upperBound = classNodeArray[n3];
                                            GenericsType gt = new GenericsType(upperBound);
                                            if (gt.isPlaceholder() && classNodePlaceholders.containsKey(gt.getName())) {
                                                gt = classNodePlaceholders.get(gt.getName());
                                            }
                                            match = match && (classNodeType.getType().isDerivedFrom(gt.getType()) || classNodeType.getType().implementsInterface(gt.getType()));
                                            ++n3;
                                        }
                                    }
                                    return match;
                                }
                                redirectBoundType = classNodePlaceholders.get(name);
                            }
                        }
                        match = redirectBoundType.isCompatibleWith(classNodeType.getType());
                    }
                } else {
                    match = classNodeType.isCompatibleWith(redirectBoundType.getType());
                }
                ++i;
            }
            return match;
        }
    }
}

