/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import groovy.lang.GroovyObjectSupport;
import groovy.lang.Tuple;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.runtime.DateGroovyMethods;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.DefaultGroovyStaticMethods;
import org.codehaus.groovy.runtime.EncodingGroovyMethods;
import org.codehaus.groovy.runtime.ProcessGroovyMethods;
import org.codehaus.groovy.runtime.SwingGroovyMethods;
import org.codehaus.groovy.runtime.XmlGroovyMethods;
import org.codehaus.jdt.groovy.internal.compiler.ast.LazyGenericsType;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.groovy.search.GenericsMapper;
import org.eclipse.jdt.internal.core.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableScope {
    public static final ClassNode OBJECT_CLASS_NODE = ClassHelper.OBJECT_TYPE;
    public static final ClassNode LIST_CLASS_NODE = ClassHelper.LIST_TYPE;
    public static final ClassNode RANGE_CLASS_NODE = ClassHelper.RANGE_TYPE;
    public static final ClassNode TUPLE_CLASS_NODE = ClassHelper.make(Tuple.class);
    public static final ClassNode PATTERN_CLASS_NODE = ClassHelper.PATTERN_TYPE;
    public static final ClassNode MATCHER_CLASS_NODE = ClassHelper.make(Matcher.class);
    public static final ClassNode MAP_CLASS_NODE = ClassHelper.MAP_TYPE;
    public static final ClassNode STRING_CLASS_NODE = ClassHelper.STRING_TYPE;
    public static final ClassNode GSTRING_CLASS_NODE = ClassHelper.GSTRING_TYPE;
    public static final ClassNode VOID_CLASS_NODE = ClassHelper.make(Void.TYPE);
    public static final ClassNode VOID_WRAPPER_CLASS_NODE = ClassHelper.void_WRAPPER_TYPE;
    public static final ClassNode NUMBER_CLASS_NODE = ClassHelper.make(Number.class);
    public static final ClassNode ITERATOR_CLASS = ClassHelper.make(Iterator.class);
    public static final ClassNode ENUMERATION_CLASS = ClassHelper.make(Enumeration.class);
    public static final ClassNode INPUT_STREAM_CLASS = ClassHelper.make(InputStream.class);
    public static final ClassNode OUTPUT_STREAM_CLASS = ClassHelper.make(OutputStream.class);
    public static final ClassNode DATA_INPUT_STREAM_CLASS = ClassHelper.make(DataInputStream.class);
    public static final ClassNode DATA_OUTPUT_STREAM_CLASS = ClassHelper.make(DataOutputStream.class);
    public static final ClassNode OBJECT_OUTPUT_STREAM = ClassHelper.make(ObjectOutputStream.class);
    public static final ClassNode OBJECT_INPUT_STREAM = ClassHelper.make(ObjectInputStream.class);
    public static final ClassNode FILE_CLASS_NODE = ClassHelper.make(File.class);
    public static final ClassNode BUFFERED_READER_CLASS_NODE = ClassHelper.make(BufferedReader.class);
    public static final ClassNode BUFFERED_WRITER_CLASS_NODE = ClassHelper.make(BufferedWriter.class);
    public static final ClassNode PRINT_WRITER_CLASS_NODE = ClassHelper.make(PrintWriter.class);
    public static final ClassNode CLOSURE_CLASS = ClassHelper.CLOSURE_TYPE;
    public static final ClassNode GROOVY_OBJECT_SUPPORT = ClassHelper.make(GroovyObjectSupport.class);
    public static final ClassNode DGM_CLASS_NODE = ClassHelper.make(DefaultGroovyMethods.class);
    public static final ClassNode EGM_CLASS_NODE = ClassHelper.make(EncodingGroovyMethods.class);
    public static final ClassNode PGM_CLASS_NODE = ClassHelper.make(ProcessGroovyMethods.class);
    public static final ClassNode SGM_CLASS_NODE = ClassHelper.make(SwingGroovyMethods.class);
    public static final ClassNode XGM_CLASS_NODE = ClassHelper.make(XmlGroovyMethods.class);
    public static final ClassNode DGSM_CLASS_NODE = ClassHelper.make(DefaultGroovyStaticMethods.class);
    public static final ClassNode DATE_GM_CLASS_NODE = ClassHelper.make(DateGroovyMethods.class);
    public static final Set<ClassNode> ALL_DEFAULT_CATEGORIES = Collections.unmodifiableSet(new LinkedHashSet<ClassNode>(Arrays.asList(DGM_CLASS_NODE, DGSM_CLASS_NODE, EGM_CLASS_NODE, PGM_CLASS_NODE, SGM_CLASS_NODE, XGM_CLASS_NODE, DATE_GM_CLASS_NODE)));
    public static final ClassNode CLASS_CLASS_NODE = ClassHelper.makeWithoutCaching(Class.class);
    public static final ClassNode INTEGER_CLASS_NODE;
    public static final ClassNode LONG_CLASS_NODE;
    public static final ClassNode SHORT_CLASS_NODE;
    public static final ClassNode FLOAT_CLASS_NODE;
    public static final ClassNode DOUBLE_CLASS_NODE;
    public static final ClassNode BYTE_CLASS_NODE;
    public static final ClassNode BOOLEAN_CLASS_NODE;
    public static final ClassNode CHARACTER_CLASS_NODE;
    public static ClassNode NO_CATEGORY;
    private VariableScope parent;
    private SharedState shared;
    private ASTNode scopeNode;
    private Map<String, VariableInfo> nameVariableMap = new HashMap<String, VariableInfo>();
    private boolean isStaticScope;
    private final ClosureExpression enclosingClosure;
    private ClassNode categoryBeingDeclared;
    int methodCallNumberOfArguments = -1;
    public static final GenericsType[] NO_GENERICS;

    static {
        VariableScope.initializeProperties(CLASS_CLASS_NODE);
        INTEGER_CLASS_NODE = ClassHelper.Integer_TYPE;
        LONG_CLASS_NODE = ClassHelper.Long_TYPE;
        SHORT_CLASS_NODE = ClassHelper.Short_TYPE;
        FLOAT_CLASS_NODE = ClassHelper.Float_TYPE;
        DOUBLE_CLASS_NODE = ClassHelper.Double_TYPE;
        BYTE_CLASS_NODE = ClassHelper.Byte_TYPE;
        BOOLEAN_CLASS_NODE = ClassHelper.Boolean_TYPE;
        CHARACTER_CLASS_NODE = ClassHelper.Character_TYPE;
        NO_CATEGORY = null;
        NO_GENERICS = new GenericsType[0];
    }

    public VariableScope(VariableScope parent, ASTNode enclosingNode, boolean isStatic) {
        this.parent = parent;
        this.scopeNode = enclosingNode;
        this.shared = parent != null ? parent.shared : new SharedState();
        if (enclosingNode instanceof MethodNode) {
            this.shared.isRunMethod = ((MethodNode)enclosingNode).isScriptBody();
        } else if (enclosingNode instanceof FieldNode || enclosingNode instanceof ClassNode) {
            this.shared.isRunMethod = false;
        }
        this.isStaticScope = isStatic || parent != null && parent.isStaticScope;
        this.enclosingClosure = enclosingNode instanceof ClosureExpression ? (ClosureExpression)enclosingNode : null;
    }

    public Map<String, Object> getWormhole() {
        return this.shared.wormhole;
    }

    public boolean isMethodCall() {
        return this.methodCallNumberOfArguments >= 0;
    }

    public ASTNode getEnclosingNode() {
        if (this.shared.nodeStack.size() > 1) {
            ASTNode current = this.shared.nodeStack.pop();
            ASTNode enclosing = this.shared.nodeStack.peek();
            this.shared.nodeStack.push(current);
            return enclosing;
        }
        return null;
    }

    public void setCurrentNode(ASTNode currentNode) {
        this.shared.nodeStack.push(currentNode);
    }

    public void forgetCurrentNode() {
        if (!this.shared.nodeStack.isEmpty()) {
            this.shared.nodeStack.pop();
        }
    }

    public ASTNode getCurrentNode() {
        if (!this.shared.nodeStack.isEmpty()) {
            return this.shared.nodeStack.peek();
        }
        return null;
    }

    public Set<ClassNode> getCategoryNames() {
        if (this.parent != null) {
            Set<ClassNode> categories = this.parent.getCategoryNames();
            if (this.parent.isCategoryBeingDeclared()) {
                categories.add(this.parent.categoryBeingDeclared);
            }
            return categories;
        }
        return new HashSet<ClassNode>(ALL_DEFAULT_CATEGORIES);
    }

    private boolean isCategoryBeingDeclared() {
        return this.categoryBeingDeclared != null;
    }

    public void setCategoryBeingDeclared(ClassNode categoryBeingDeclared) {
        this.categoryBeingDeclared = categoryBeingDeclared;
    }

    public VariableInfo lookupName(String name) {
        VariableInfo var;
        if ("super".equals(name) && (var = this.lookupName("this")) != null) {
            ClassNode superType = var.declaringType.getSuperClass();
            return new VariableInfo(superType, superType);
        }
        var = this.lookupNameInCurrentScope(name);
        if (var == null && this.parent != null) {
            var = this.parent.lookupName(name);
        }
        return var;
    }

    public VariableInfo lookupNameInCurrentScope(String name) {
        return this.nameVariableMap.get(name);
    }

    public boolean isThisOrSuper(Variable var) {
        return var.getName().equals("this") || var.getName().equals("super");
    }

    public void addVariable(String name, ClassNode type, ClassNode declaringType) {
        this.nameVariableMap.put(name, new VariableInfo(type, declaringType != null ? declaringType : OBJECT_CLASS_NODE));
    }

    public void addVariable(Variable var) {
        this.addVariable(var.getName(), var.getType(), var.getOriginType());
    }

    public ModuleNode getEnclosingModuleNode() {
        if (this.scopeNode instanceof ModuleNode) {
            return (ModuleNode)this.scopeNode;
        }
        if (this.parent != null) {
            return this.parent.getEnclosingModuleNode();
        }
        return null;
    }

    public ClassNode getEnclosingTypeDeclaration() {
        if (this.scopeNode instanceof ClassNode) {
            return (ClassNode)this.scopeNode;
        }
        if (this.parent != null) {
            return this.parent.getEnclosingTypeDeclaration();
        }
        return null;
    }

    public FieldNode getEnclosingFieldDeclaration() {
        if (this.scopeNode instanceof FieldNode) {
            return (FieldNode)this.scopeNode;
        }
        if (this.parent != null) {
            return this.parent.getEnclosingFieldDeclaration();
        }
        return null;
    }

    public MethodNode getEnclosingMethodDeclaration() {
        if (this.scopeNode instanceof MethodNode) {
            return (MethodNode)this.scopeNode;
        }
        if (this.parent != null) {
            return this.parent.getEnclosingMethodDeclaration();
        }
        return null;
    }

    public static ClassNode maybeConvertFromPrimitive(ClassNode type) {
        if (ClassHelper.isPrimitiveType(type)) {
            return ClassHelper.getWrapper(type);
        }
        return type;
    }

    private static PropertyNode createPropertyNodeForMethodNode(MethodNode methodNode) {
        ClassNode propertyType = methodNode.getReturnType();
        String methodName = methodNode.getName();
        StringBuffer propertyName = new StringBuffer();
        propertyName.append(Character.toLowerCase(methodName.charAt(3)));
        if (methodName.length() > 4) {
            propertyName.append(methodName.substring(4));
        }
        int mods = methodNode.getModifiers();
        ClassNode declaringClass = methodNode.getDeclaringClass();
        PropertyNode property = new PropertyNode(propertyName.toString(), mods, propertyType, declaringClass, null, null, null);
        property.setDeclaringClass(declaringClass);
        property.getField().setDeclaringClass(declaringClass);
        return property;
    }

    private static boolean isGetter(MethodNode methodNode) {
        return methodNode.getReturnType() != VOID_CLASS_NODE && methodNode.getParameters().length == 0 && (methodNode.getName().startsWith("get") && methodNode.getName().length() > 3 || methodNode.getName().startsWith("is") && methodNode.getName().length() > 2);
    }

    private static void initializeProperties(ClassNode node) {
        for (MethodNode methodNode : node.getMethods()) {
            if (!VariableScope.isGetter(methodNode)) continue;
            node.addProperty(VariableScope.createPropertyNodeForMethodNode(methodNode));
        }
    }

    public static boolean isVoidOrObject(ClassNode maybeVoid) {
        return maybeVoid != null && (maybeVoid.getName().equals(VOID_CLASS_NODE.getName()) || maybeVoid.getName().equals(VOID_WRAPPER_CLASS_NODE.getName()) || maybeVoid.getName().equals(OBJECT_CLASS_NODE.getName()));
    }

    public void updateOrAddVariable(String name, ClassNode type, ClassNode declaringType) {
        if (!this.internalUpdateVariable(name, type, declaringType)) {
            this.addVariable(name, type, declaringType);
        }
    }

    public boolean updateVariable(String name, ClassNode type, ClassNode declaringType) {
        return this.internalUpdateVariable(name, type, declaringType);
    }

    private boolean internalUpdateVariable(String name, ClassNode type, ClassNode declaringType) {
        VariableInfo info = this.lookupNameInCurrentScope(name);
        if (info != null) {
            this.nameVariableMap.put(name, new VariableInfo(type, declaringType == null ? info.declaringType : declaringType));
            return true;
        }
        if (this.parent != null) {
            return this.parent.internalUpdateVariable(name, type, declaringType);
        }
        return false;
    }

    public static ClassNode resolveTypeParameterization(GenericsMapper mapper, ClassNode typeToParameterize) {
        if (!mapper.hasGenerics()) {
            return typeToParameterize;
        }
        GenericsType[] typesToParameterize = typeToParameterize.getGenericsTypes();
        if (typesToParameterize == null) {
            return typeToParameterize;
        }
        int i = 0;
        while (i < typesToParameterize.length) {
            GenericsType genericsToParameterize = typesToParameterize[i];
            if (genericsToParameterize instanceof LazyGenericsType) {
                Util.log(new RuntimeException(), "Found a JDTClassNode while resolving type parameters.  This shouldn't happen.  Not trying to resolve any further and continuing.  Type: " + typeToParameterize);
            } else {
                VariableScope.resolveTypeParameterization(mapper, genericsToParameterize.getType());
                String toParameterizeName = genericsToParameterize.getName();
                ClassNode resolved = mapper.findParameter(toParameterizeName, genericsToParameterize.getType());
                if (VariableScope.typeParameterExistsInRedirected(typeToParameterize, toParameterizeName)) {
                    Assert.isLegal(typeToParameterize.redirect() != typeToParameterize, "Error: trying to resolve type parameters of a type declaration: " + typeToParameterize);
                    typeToParameterize.getGenericsTypes()[i].setType(resolved);
                    genericsToParameterize.setName(genericsToParameterize.getType().getName());
                    genericsToParameterize.setUpperBounds(null);
                    genericsToParameterize.setLowerBound(null);
                } else {
                    typeToParameterize = resolved;
                    break;
                }
            }
            ++i;
        }
        return typeToParameterize;
    }

    private static boolean typeParameterExistsInRedirected(ClassNode type, String toParameterizeName) {
        ClassNode redirect = type.redirect();
        GenericsType[] genericsTypes = redirect.getGenericsTypes();
        return genericsTypes != null;
    }

    private static boolean isValidGenerics(GenericsType[] resolvedGenerics, GenericsType[] unresolvedGenerics, ClassNode type) {
        GenericsType[] thisTypeGenerics = type.getGenericsTypes();
        if (thisTypeGenerics == null || thisTypeGenerics.length == 0) {
            return false;
        }
        return resolvedGenerics != null && unresolvedGenerics != null && unresolvedGenerics.length == resolvedGenerics.length && resolvedGenerics.length > 0;
    }

    public static ClassNode clone(ClassNode type) {
        return VariableScope.cloneInternal(type, 0);
    }

    public static ClassNode clonedMap() {
        ClassNode clone = VariableScope.clone(MAP_CLASS_NODE);
        VariableScope.cleanGenerics(clone.getGenericsTypes()[0]);
        VariableScope.cleanGenerics(clone.getGenericsTypes()[1]);
        return clone;
    }

    public static ClassNode clonedList() {
        ClassNode clone = VariableScope.clone(LIST_CLASS_NODE);
        VariableScope.cleanGenerics(clone.getGenericsTypes()[0]);
        return clone;
    }

    public static ClassNode clonedRange() {
        ClassNode clone = VariableScope.clone(RANGE_CLASS_NODE);
        VariableScope.cleanGenerics(clone.getGenericsTypes()[0]);
        return clone;
    }

    public static ClassNode clonedTuple() {
        return VariableScope.clonedList();
    }

    private static void cleanGenerics(GenericsType gt) {
        gt.getType().setGenericsTypes(null);
        gt.setName("java.lang.Object");
        gt.setPlaceholder(false);
        gt.setWildcard(false);
        gt.setResolved(true);
        gt.setUpperBounds(null);
        gt.setLowerBound(null);
    }

    private static ClassNode cloneInternal(ClassNode type, int depth) {
        if (type == null) {
            return type;
        }
        ClassNode newType = type.getPlainNodeReference();
        newType.setRedirect(type.redirect());
        ClassNode[] origIFaces = type.getInterfaces();
        if (origIFaces != null) {
            ClassNode[] newIFaces = new ClassNode[origIFaces.length];
            int i = 0;
            while (i < newIFaces.length) {
                newIFaces[i] = origIFaces[i];
                ++i;
            }
            newType.setInterfaces(newIFaces);
        }
        newType.setSourcePosition(type);
        if (depth > 10) {
            return newType;
        }
        GenericsType[] origgts = type.getGenericsTypes();
        if (origgts != null) {
            GenericsType[] newgts = new GenericsType[origgts.length];
            int i = 0;
            while (i < origgts.length) {
                newgts[i] = VariableScope.clone(origgts[i], depth);
                ++i;
            }
            newType.setGenericsTypes(newgts);
        }
        return newType;
    }

    private static GenericsType clone(GenericsType origgt, int depth) {
        GenericsType newgt = new GenericsType();
        newgt.setType(VariableScope.cloneInternal(origgt.getType(), depth + 1));
        newgt.setLowerBound(VariableScope.cloneInternal(origgt.getLowerBound(), depth + 1));
        ClassNode[] oldUpperBounds = origgt.getUpperBounds();
        if (oldUpperBounds != null) {
            ClassNode[] newUpperBounds = new ClassNode[oldUpperBounds.length];
            int i = 0;
            while (i < newUpperBounds.length) {
                newUpperBounds[i] = oldUpperBounds[i].getName().equals(newgt.getType().getName()) ? OBJECT_CLASS_NODE : VariableScope.cloneInternal(oldUpperBounds[i], depth + 1);
                ++i;
            }
            newgt.setUpperBounds(newUpperBounds);
        }
        newgt.setName(origgt.getName());
        newgt.setPlaceholder(origgt.isPlaceholder());
        newgt.setWildcard(origgt.isWildcard());
        newgt.setResolved(origgt.isResolved());
        newgt.setSourcePosition(origgt);
        return newgt;
    }

    public boolean isStatic() {
        return this.isStaticScope;
    }

    public ClosureExpression getEnclosingClosure() {
        if (this.enclosingClosure == null && this.parent != null) {
            return this.parent.getEnclosingClosure();
        }
        return this.enclosingClosure;
    }

    public List<CallAndType> getAllEnclosingMethodCallExpressions() {
        return this.shared.enclosingCallStack;
    }

    public CallAndType getEnclosingMethodCallExpression() {
        if (this.shared.enclosingCallStack.isEmpty()) {
            return null;
        }
        return this.shared.enclosingCallStack.peek();
    }

    public void addEnclosingMethodCall(CallAndType enclosingMethodCall) {
        this.shared.enclosingCallStack.push(enclosingMethodCall);
    }

    public void forgetEnclosingMethodCall() {
        this.shared.enclosingCallStack.pop();
    }

    public boolean isTopLevel() {
        return this.parent == null;
    }

    public boolean containsInThisScope(String name) {
        return this.nameVariableMap.containsKey(name);
    }

    public Iterator<Map.Entry<String, VariableInfo>> variablesIterator() {
        return new Iterator<Map.Entry<String, VariableInfo>>(){
            VariableScope currentScope;
            Iterator<Map.Entry<String, VariableInfo>> currentIter;
            {
                this.currentScope = VariableScope.this;
                this.currentIter = this.currentScope.nameVariableMap.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.currentIter == null) {
                    return false;
                }
                if (!this.currentIter.hasNext()) {
                    this.currentScope = this.currentScope.parent;
                    Iterator<Map.Entry<Object, Object>> iterator = this.currentIter = this.currentScope == null ? null : this.currentScope.nameVariableMap.entrySet().iterator();
                }
                return this.currentIter != null && this.currentIter.hasNext();
            }

            @Override
            public Map.Entry<String, VariableInfo> next() {
                if (!this.currentIter.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.currentIter.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static void findAllInterfaces(ClassNode type, LinkedHashSet<ClassNode> allInterfaces, boolean useResolved) {
        if (!useResolved) {
            type = type.redirect();
        }
        if (!type.isInterface() || !allInterfaces.contains(type)) {
            ClassNode[] interfaces;
            if (type.isInterface()) {
                allInterfaces.add(type);
            }
            if ((interfaces = useResolved ? type.getUnresolvedInterfaces() : type.getInterfaces()) != null) {
                ClassNode[] classNodeArray = interfaces;
                int n = interfaces.length;
                int n2 = 0;
                while (n2 < n) {
                    ClassNode superInterface = classNodeArray[n2];
                    VariableScope.findAllInterfaces(superInterface, allInterfaces, useResolved);
                    ++n2;
                }
            }
        }
    }

    public static void createTypeHierarchy(ClassNode type, LinkedHashSet<ClassNode> allClasses, boolean useResolved) {
        if (!useResolved) {
            type = type.redirect();
        }
        if (!allClasses.contains(type)) {
            if (!type.isInterface()) {
                allClasses.add(type);
                ClassNode superClass = useResolved ? type.getUnresolvedSuperClass() : type.getSuperClass();
                if (superClass != null) {
                    VariableScope.createTypeHierarchy(superClass, allClasses, useResolved);
                }
            }
            VariableScope.findAllInterfaces(type, allClasses, useResolved);
        }
    }

    public static ClassNode extractElementType(ClassNode collectionType) {
        if (collectionType.isArray()) {
            return collectionType.getComponentType();
        }
        MethodNode iterator = collectionType.getMethod("iterator", new Parameter[0]);
        ClassNode typeToResolve = null;
        if (iterator == null && collectionType.isInterface()) {
            MethodNode entrySetMethod;
            if (collectionType.implementsInterface(LIST_CLASS_NODE) && collectionType.getGenericsTypes() != null && collectionType.getGenericsTypes().length == 1) {
                typeToResolve = collectionType;
            } else if (collectionType.declaresInterface(ITERATOR_CLASS) || collectionType.equals(ITERATOR_CLASS) || collectionType.declaresInterface(ENUMERATION_CLASS) || collectionType.equals(ENUMERATION_CLASS)) {
                typeToResolve = collectionType;
            } else if ((collectionType.declaresInterface(MAP_CLASS_NODE) || collectionType.equals(MAP_CLASS_NODE)) && (entrySetMethod = collectionType.getMethod("entrySet", new Parameter[0])) != null) {
                typeToResolve = entrySetMethod.getReturnType();
            }
        } else if (iterator != null) {
            typeToResolve = iterator.getReturnType();
        }
        if (typeToResolve != null) {
            typeToResolve = VariableScope.clone(typeToResolve);
            ClassNode unresolvedCollectionType = collectionType.redirect();
            GenericsMapper mapper = GenericsMapper.gatherGenerics(collectionType, unresolvedCollectionType);
            ClassNode resolved = VariableScope.resolveTypeParameterization(mapper, typeToResolve);
            GenericsType[] resolvedReturnGenerics = resolved.getGenericsTypes();
            if (resolvedReturnGenerics != null && resolvedReturnGenerics.length > 0) {
                return resolvedReturnGenerics[0].getType();
            }
        }
        if (collectionType.declaresInterface(INPUT_STREAM_CLASS) || collectionType.declaresInterface(DATA_INPUT_STREAM_CLASS) || collectionType.equals(INPUT_STREAM_CLASS) || collectionType.equals(DATA_INPUT_STREAM_CLASS)) {
            return BYTE_CLASS_NODE;
        }
        return collectionType;
    }

    public boolean inScriptRunMethod() {
        return this.shared.isRunMethod;
    }

    public static class CallAndType {
        public final MethodCallExpression call;
        public final ClassNode declaringType;

        public CallAndType(MethodCallExpression call, ClassNode declaringType) {
            this.call = call;
            this.declaringType = declaringType;
        }
    }

    private class SharedState {
        final Map<String, Object> wormhole = new HashMap<String, Object>();
        final Stack<CallAndType> enclosingCallStack = new Stack();
        final Stack<ASTNode> nodeStack = new Stack();
        boolean isRunMethod;

        private SharedState() {
        }
    }

    public static class VariableInfo {
        public final ClassNode type;
        public final ClassNode declaringType;

        public VariableInfo(ClassNode type, ClassNode declaringType) {
            this.type = type;
            this.declaringType = declaringType;
        }

        public String getTypeSignature() {
            String typeName = this.type.getName();
            if (typeName.startsWith("[")) {
                return typeName;
            }
            return Signature.createTypeSignature(typeName, true);
        }
    }
}

