/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.jdt.groovy.search.ITypeLookup;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.groovy.search.VariableScope;

public class InferenceByAssignmentStatement
implements ITypeLookup {
    public TypeLookupResult lookupType(Expression node, VariableScope scope, ClassNode objectExpressionType) {
        BinaryExpression assign;
        if (node instanceof DeclarationExpression) {
            DeclarationExpression declExpr = (DeclarationExpression)node;
            if (declExpr.isMultipleAssignmentDeclaration()) {
                TupleExpression tuple = (TupleExpression)declExpr.getLeftExpression();
                this.handleMultiAssignment(scope, objectExpressionType, declExpr, tuple);
                return null;
            }
            VariableExpression variableExpression = declExpr.getVariableExpression();
            ClassNode varType = variableExpression.getOriginType() != null ? variableExpression.getOriginType() : variableExpression.getType();
            ClassNode typeToStore = !VariableScope.isVoidOrObject(varType) && !varType.equals(VariableScope.OBJECT_CLASS_NODE) ? varType : (objectExpressionType != null ? objectExpressionType : VariableScope.OBJECT_CLASS_NODE);
            scope.addVariable(variableExpression.getName(), typeToStore, null);
        } else if (node instanceof BinaryExpression && this.isInterestingOperation(assign = (BinaryExpression)node) && !VariableScope.isVoidOrObject(objectExpressionType)) {
            if (assign.getLeftExpression() instanceof VariableExpression) {
                VariableExpression var = (VariableExpression)assign.getLeftExpression();
                ClassNode declaringType = this.findDeclaringType(var);
                if (scope.inScriptRunMethod()) {
                    scope.updateOrAddVariable(var.getName(), objectExpressionType, declaringType);
                } else {
                    scope.updateVariable(var.getName(), objectExpressionType, declaringType);
                }
                return new TypeLookupResult(objectExpressionType, declaringType, assign.getLeftExpression(), TypeLookupResult.TypeConfidence.INFERRED, scope);
            }
            if (assign.getLeftExpression() instanceof TupleExpression) {
                TupleExpression tuple = (TupleExpression)assign.getLeftExpression();
                this.handleMultiAssignment(scope, objectExpressionType, assign, tuple);
                return null;
            }
        }
        return null;
    }

    private void handleMultiAssignment(VariableScope scope, ClassNode objectExpressionType, BinaryExpression binaryExpr, TupleExpression tuple) {
        ClassNode maybeType = this.findComponentType(objectExpressionType);
        ListExpression rhs = binaryExpr.getRightExpression() instanceof ListExpression ? (ListExpression)binaryExpr.getRightExpression() : null;
        List<Object> lhsExprs = tuple == null ? Collections.emptyList() : tuple.getExpressions();
        List<Object> rhsExprs = rhs == null ? Collections.emptyList() : rhs.getExpressions();
        int i = 0;
        int lhsSize = lhsExprs.size();
        int rhsSize = rhsExprs.size();
        while (i < lhsSize) {
            Expression rhsExpr;
            Expression lhsExpr = (Expression)lhsExprs.get(i);
            Expression expression = rhsExpr = i < rhsSize ? (Expression)rhsExprs.get(i) : null;
            if (lhsExpr instanceof VariableExpression) {
                scope.addVariable(((Variable)((Object)lhsExpr)).getName(), rhsExpr == null ? maybeType : rhsExpr.getType(), null);
            }
            ++i;
        }
    }

    private ClassNode findComponentType(ClassNode objectExpressionType) {
        if (objectExpressionType == null) {
            return VariableScope.OBJECT_CLASS_NODE;
        }
        return VariableScope.extractElementType(objectExpressionType);
    }

    private boolean isInterestingOperation(BinaryExpression assign) {
        switch (assign.getOperation().getType()) {
            case 100: {
                return true;
            }
        }
        return false;
    }

    private ClassNode findDeclaringType(VariableExpression var) {
        return var.getAccessedVariable() instanceof AnnotatedNode ? ((AnnotatedNode)((Object)var.getAccessedVariable())).getDeclaringClass() : null;
    }

    public TypeLookupResult lookupType(FieldNode node, VariableScope scope) {
        Expression init = node.getInitialExpression();
        if (!this.isObjectType(init)) {
            scope.addVariable(node.getName(), init.getType(), node.getDeclaringClass());
        }
        return null;
    }

    public TypeLookupResult lookupType(MethodNode node, VariableScope scope) {
        return null;
    }

    public TypeLookupResult lookupType(AnnotationNode node, VariableScope scope) {
        return null;
    }

    public TypeLookupResult lookupType(ImportNode node, VariableScope scope) {
        block6: {
            List<MethodNode> methods;
            ClassNode type;
            block5: {
                type = node.getType();
                if (!node.isStar() || type == null) break block5;
                List<FieldNode> fields = type.getFields();
                for (FieldNode field : fields) {
                    if (!field.isStatic()) continue;
                    scope.addVariable(field.getName(), field.getType(), type);
                }
                List<MethodNode> methods2 = node.getType().getMethods();
                for (MethodNode method : methods2) {
                    if (!method.isStatic()) continue;
                    scope.addVariable(method.getName(), method.getReturnType(), type);
                }
                break block6;
            }
            if (!node.isStatic() || type == null || node.getFieldName() == null) break block6;
            FieldNode field = type.getField(node.getFieldName());
            if (field != null) {
                scope.addVariable(field.getName(), field.getType(), type);
            }
            if ((methods = type.getDeclaredMethods(node.getFieldName())) != null) {
                for (MethodNode method : methods) {
                    scope.addVariable(method.getName(), method.getReturnType(), type);
                }
            }
        }
        return null;
    }

    public TypeLookupResult lookupType(ClassNode node, VariableScope scope) {
        return null;
    }

    public TypeLookupResult lookupType(Parameter node, VariableScope scope) {
        scope.addVariable(node);
        return null;
    }

    private boolean isObjectType(Expression init) {
        return init == null || ClassHelper.OBJECT_TYPE.equals(init.getType());
    }

    public void initialize(GroovyCompilationUnit unit, VariableScope topLevelScope) {
    }
}

