/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools;

import groovy.lang.GroovyResourceLoader;
import groovy.lang.GroovySystem;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ConfigurationException;
import org.codehaus.groovy.tools.ErrorReporter;
import org.codehaus.groovy.tools.javac.JavaAwareCompilationUnit;

public class FileSystemCompiler {
    private final CompilationUnit unit;
    private static boolean displayStackTraceOnError = false;

    public FileSystemCompiler(CompilerConfiguration configuration) throws ConfigurationException {
        this(configuration, null);
    }

    public FileSystemCompiler(CompilerConfiguration configuration, CompilationUnit cu) throws ConfigurationException {
        this.unit = cu != null ? cu : (configuration.getJointCompilationOptions() != null ? new JavaAwareCompilationUnit(configuration) : new CompilationUnit(configuration));
        this.unit.getClassLoader().setResourceLoader(new GroovyResourceLoader(){

            public URL loadGroovySource(String filename) throws MalformedURLException {
                return null;
            }
        });
    }

    public void compile(String[] paths) throws Exception {
        this.unit.addSources(paths);
        this.unit.compile();
    }

    public void compile(File[] files) throws Exception {
        this.unit.addSources(files);
        this.unit.compile();
    }

    public static void displayHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(80, "groovyc [options] <source-files>", "options:", options, "");
    }

    public static void displayVersion() {
        String version = GroovySystem.getVersion();
        System.err.println("Groovy compiler version " + version);
        System.err.println("Copyright 2003-2010 The Codehaus. http://groovy.codehaus.org/");
        System.err.println("");
    }

    public static int checkFiles(String[] filenames) {
        int errors = 0;
        for (String filename : filenames) {
            File file = new File(filename);
            if (!file.exists()) {
                System.err.println("error: file not found: " + file);
                ++errors;
                continue;
            }
            if (file.canRead()) continue;
            System.err.println("error: file not readable: " + file);
            ++errors;
        }
        return errors;
    }

    public static boolean validateFiles(String[] filenames) {
        return FileSystemCompiler.checkFiles(filenames) == 0;
    }

    public static void commandLineCompile(String[] args) throws Exception {
        boolean fileNameErrors;
        PosixParser cliParser = new PosixParser();
        Options options = FileSystemCompiler.createCompilationOptions();
        CommandLine cli = cliParser.parse(options, args);
        if (cli.hasOption('h')) {
            FileSystemCompiler.displayHelp(options);
            return;
        }
        if (cli.hasOption('v')) {
            FileSystemCompiler.displayVersion();
            return;
        }
        displayStackTraceOnError = cli.hasOption('e');
        CompilerConfiguration configuration = FileSystemCompiler.generateCompilerConfigurationFromOptions(cli);
        String[] filenames = FileSystemCompiler.generateFileNamesFromOptions(cli);
        boolean bl = fileNameErrors = filenames == null;
        if (!fileNameErrors && filenames.length == 0) {
            FileSystemCompiler.displayHelp(options);
            return;
        }
        boolean bl2 = fileNameErrors = fileNameErrors && !FileSystemCompiler.validateFiles(filenames);
        if (!fileNameErrors) {
            FileSystemCompiler.doCompilation(configuration, null, filenames);
        }
    }

    public static void main(String[] args) {
        try {
            FileSystemCompiler.commandLineCompile(args);
        }
        catch (Throwable e) {
            new ErrorReporter(e, displayStackTraceOnError).write(System.err);
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doCompilation(CompilerConfiguration configuration, CompilationUnit unit, String[] filenames) throws Exception {
        File tmpDir = null;
        try {
            if (configuration.getJointCompilationOptions() != null && !configuration.getJointCompilationOptions().containsKey("stubDir")) {
                tmpDir = FileSystemCompiler.createTempDir();
                configuration.getJointCompilationOptions().put("stubDir", tmpDir);
            }
            FileSystemCompiler compiler = new FileSystemCompiler(configuration, unit);
            compiler.compile(filenames);
        }
        catch (Throwable throwable) {
            try {
                if (tmpDir != null) {
                    FileSystemCompiler.deleteRecursive(tmpDir);
                }
            }
            catch (Throwable t) {
                System.err.println("error: could not delete temp files - " + tmpDir.getPath());
            }
            throw throwable;
        }
        try {
            if (tmpDir != null) {
                FileSystemCompiler.deleteRecursive(tmpDir);
            }
        }
        catch (Throwable t) {
            System.err.println("error: could not delete temp files - " + tmpDir.getPath());
        }
    }

    public static String[] generateFileNamesFromOptions(CommandLine cli) {
        String[] filenames = cli.getArgs();
        ArrayList<String> fileList = new ArrayList<String>(filenames.length);
        boolean errors = false;
        for (String filename : filenames) {
            if (filename.startsWith("@")) {
                try {
                    String file;
                    BufferedReader br = new BufferedReader(new FileReader(filename.substring(1)));
                    while ((file = br.readLine()) != null) {
                        fileList.add(file);
                    }
                    continue;
                }
                catch (IOException ioe) {
                    System.err.println("error: file not readable: " + filename.substring(1));
                    errors = true;
                    continue;
                }
            }
            fileList.addAll(Arrays.asList(filenames));
        }
        if (errors) {
            return null;
        }
        return fileList.toArray(new String[fileList.size()]);
    }

    public static CompilerConfiguration generateCompilerConfigurationFromOptions(CommandLine cli) {
        CompilerConfiguration configuration = new CompilerConfiguration();
        if (cli.hasOption("classpath")) {
            configuration.setClasspath(cli.getOptionValue("classpath"));
        }
        if (cli.hasOption('d')) {
            configuration.setTargetDirectory(cli.getOptionValue('d'));
        }
        if (cli.hasOption("encoding")) {
            configuration.setSourceEncoding(cli.getOptionValue("encoding"));
        }
        if (cli.hasOption('j')) {
            HashMap<String, Object> compilerOptions = new HashMap<String, Object>();
            String[] opts = cli.getOptionValues("J");
            compilerOptions.put("namedValues", opts);
            opts = cli.getOptionValues("F");
            compilerOptions.put("flags", opts);
            configuration.setJointCompilationOptions(compilerOptions);
        }
        return configuration;
    }

    public static Options createCompilationOptions() {
        Options options = new Options();
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.withDescription((String)"Specify where to find the class files - must be first argument");
        options.addOption(OptionBuilder.create((String)"classpath"));
        OptionBuilder.withLongOpt((String)"classpath");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.withDescription((String)"Aliases for '-classpath'");
        options.addOption(OptionBuilder.create((String)"cp"));
        OptionBuilder.withLongOpt((String)"sourcepath");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.withDescription((String)"Specify where to find the source files");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"temp");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"temp");
        OptionBuilder.withDescription((String)"Specify temporary directory");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"encoding");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"encoding");
        OptionBuilder.withDescription((String)"Specify the encoding of the user class files");
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Specify where to place generated class files");
        options.addOption(OptionBuilder.create((char)'d'));
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"Print a synopsis of standard options");
        options.addOption(OptionBuilder.create((char)'h'));
        OptionBuilder.withLongOpt((String)"version");
        OptionBuilder.withDescription((String)"Print the version");
        options.addOption(OptionBuilder.create((char)'v'));
        OptionBuilder.withLongOpt((String)"exception");
        OptionBuilder.withDescription((String)"Print stack trace on error");
        options.addOption(OptionBuilder.create((char)'e'));
        OptionBuilder.withLongOpt((String)"jointCompilation");
        OptionBuilder.withDescription((String)"Attach javac compiler to compile .java files");
        options.addOption(OptionBuilder.create((char)'j'));
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withDescription((String)"name-value pairs to pass to javac");
        options.addOption(OptionBuilder.create((String)"J"));
        OptionBuilder.withArgName((String)"flag");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"passed to javac for joint compilation");
        options.addOption(OptionBuilder.create((String)"F"));
        return options;
    }

    public static File createTempDir() throws IOException {
        int MAXTRIES = 3;
        int accessDeniedCounter = 0;
        File tempFile = null;
        for (int i = 0; i < 3; ++i) {
            try {
                tempFile = File.createTempFile("groovy-generated-", "-java-source");
                tempFile.delete();
                tempFile.mkdirs();
                break;
            }
            catch (IOException ioe) {
                if (ioe.getMessage().startsWith("Access is denied")) {
                    ++accessDeniedCounter;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                if (i != 2) continue;
                if (accessDeniedCounter == 3) {
                    String msg = "Access is denied.\nWe tried " + accessDeniedCounter + " times to create a temporary directory" + " and failed each time. If you are on Windows" + " you are possibly victim to" + " http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=6325169. " + " this is no bug in Groovy.";
                    throw new IOException(msg);
                }
                throw ioe;
            }
        }
        return tempFile;
    }

    public static void deleteRecursive(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
        } else if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                FileSystemCompiler.deleteRecursive(files[i]);
            }
            file.delete();
        }
    }
}

