/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import java.util.List;
import org.codehaus.groovy.ast.MultiLineComment;
import org.codehaus.groovy.ast.SingleLineComment;
import org.codehaus.groovy.ast.TaskEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Comment {
    protected static final boolean debug = false;
    protected static final int BLOCK = 0;
    protected static final int LINE = 1;
    protected static final int JAVADOC = 2;
    protected String comment;
    private int kind;
    public int sline;
    public int scol;
    public int eline;
    public int ecol;

    public Comment(int kind, int sline, int scol, int eline, int ecol, String string) {
        this.kind = kind;
        this.sline = sline;
        this.scol = scol;
        this.eline = eline;
        this.ecol = ecol;
        this.comment = string;
    }

    public int getLastLine() {
        return this.eline;
    }

    public static Comment makeSingleLineComment(int sline, int scol, int eline, int ecol, String string) {
        return new SingleLineComment(sline, scol, eline, ecol, string);
    }

    public static Comment makeMultiLineComment(int sline, int scol, int eline, int ecol, String string) {
        return new MultiLineComment(sline, scol, eline, ecol, string);
    }

    public abstract List<TaskEntry> getPositionsOf(String var1, String var2, int[] var3, boolean var4);

    public int[] getPositions(int[] lineseps) {
        int offsetToStartLine = this.sline == 1 ? 0 : lineseps[this.sline - 2] + 1;
        int start = offsetToStartLine + (this.scol - 1);
        int offsetToEndLine = this.eline == 1 ? 0 : lineseps[this.eline - 2] + 1;
        int end = offsetToEndLine + (this.ecol - 1);
        if (this.kind == 1) {
            return new int[]{-start, -end};
        }
        if (this.kind == 0) {
            return new int[]{start, -end};
        }
        return new int[]{start, end};
    }

    public String toString() {
        return this.comment;
    }

    protected boolean isValidStartLocationForTask(String text, int index, String taskTag) {
        int tagLen = taskTag.length();
        if (this.comment.charAt(index - 1) == '@') {
            return false;
        }
        if (Character.isJavaIdentifierStart(this.comment.charAt(index)) && Character.isJavaIdentifierPart(this.comment.charAt(index - 1))) {
            return false;
        }
        return index + tagLen >= this.comment.length() || !Character.isJavaIdentifierStart(this.comment.charAt(index + tagLen - 1)) || !Character.isJavaIdentifierPart(this.comment.charAt(index + tagLen));
    }

    protected int findTaskTag(String text, String tag, boolean caseSensitive, int fromIndex) {
        if (caseSensitive) {
            return text.indexOf(tag, fromIndex);
        }
        int taglen = tag.length();
        String lcTag = tag.toLowerCase();
        char firstChar = lcTag.charAt(0);
        int p = fromIndex;
        int max = text.length() - tag.length() + 1;
        while (p < max) {
            if (Character.toLowerCase(text.charAt(p)) == firstChar) {
                boolean matched = true;
                int t = 1;
                while (t < taglen) {
                    if (Character.toLowerCase(text.charAt(p + t)) != lcTag.charAt(t)) {
                        matched = false;
                        break;
                    }
                    ++t;
                }
                if (matched) {
                    return p;
                }
            }
            ++p;
        }
        return -1;
    }

    public boolean isJavadoc() {
        return this.kind == 2;
    }
}

