/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.groovy.search.GenericsMapper;
import org.eclipse.jdt.groovy.search.ITypeLookup;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.groovy.search.VariableScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTypeLookup
implements ITypeLookup {
    private GroovyCompilationUnit unit;

    @Override
    public void initialize(GroovyCompilationUnit unit, VariableScope topLevelScope) {
        this.unit = unit;
    }

    @Override
    public TypeLookupResult lookupType(Expression node, VariableScope scope, ClassNode objectExpressionType) {
        TypeLookupResult.TypeConfidence[] confidence = new TypeLookupResult.TypeConfidence[]{TypeLookupResult.TypeConfidence.EXACT};
        ClassNode declaringType = objectExpressionType != null ? objectExpressionType : this.findDeclaringType(node, scope, confidence);
        TypeLookupResult result = this.findType(node, objectExpressionType, declaringType, scope, confidence[0]);
        return result;
    }

    @Override
    public TypeLookupResult lookupType(FieldNode node, VariableScope scope) {
        return new TypeLookupResult(node.getType(), node.getDeclaringClass(), node, TypeLookupResult.TypeConfidence.EXACT, scope);
    }

    @Override
    public TypeLookupResult lookupType(MethodNode node, VariableScope scope) {
        return new TypeLookupResult(node.getReturnType(), node.getDeclaringClass(), node, TypeLookupResult.TypeConfidence.EXACT, scope);
    }

    @Override
    public TypeLookupResult lookupType(AnnotationNode node, VariableScope scope) {
        ClassNode baseType = node.getClassNode();
        return new TypeLookupResult(baseType, baseType, baseType, TypeLookupResult.TypeConfidence.EXACT, scope);
    }

    @Override
    public TypeLookupResult lookupType(ImportNode node, VariableScope scope) {
        ClassNode baseType = node.getType();
        if (baseType != null) {
            return new TypeLookupResult(baseType, baseType, baseType, TypeLookupResult.TypeConfidence.EXACT, scope);
        }
        return new TypeLookupResult(VariableScope.OBJECT_CLASS_NODE, VariableScope.OBJECT_CLASS_NODE, VariableScope.OBJECT_CLASS_NODE, TypeLookupResult.TypeConfidence.INFERRED, scope);
    }

    @Override
    public TypeLookupResult lookupType(ClassNode node, VariableScope scope) {
        return new TypeLookupResult(node, node, node, TypeLookupResult.TypeConfidence.EXACT, scope);
    }

    @Override
    public TypeLookupResult lookupType(Parameter node, VariableScope scope) {
        VariableScope.VariableInfo info = scope.lookupNameInCurrentScope(node.getName());
        ClassNode type = info != null ? info.type : node.getType();
        return new TypeLookupResult(type, scope.getEnclosingTypeDeclaration(), node, TypeLookupResult.TypeConfidence.EXACT, scope);
    }

    private ClassNode findDeclaringType(Expression node, VariableScope scope, TypeLookupResult.TypeConfidence[] confidence) {
        if (node instanceof ClassExpression || node instanceof ConstructorCallExpression) {
            return node.getType();
        }
        if (node instanceof FieldExpression) {
            return ((FieldExpression)node).getField().getDeclaringClass();
        }
        if (node instanceof MethodCallExpression) {
            return ((MethodCallExpression)node).getObjectExpression().getType();
        }
        if (node instanceof StaticMethodCallExpression) {
            return ((StaticMethodCallExpression)node).getOwnerType();
        }
        if (node instanceof VariableExpression) {
            Variable var = ((VariableExpression)node).getAccessedVariable();
            if (var instanceof DynamicVariable) {
                VariableScope.VariableInfo info;
                ASTNode declaration = this.findDeclaration(var.getName(), scope.getEnclosingTypeDeclaration());
                ClassNode type = declaration == null ? ((info = scope.lookupName("this")) == null ? VariableScope.OBJECT_CLASS_NODE : info.declaringType) : this.declaringTypeFromDeclaration(declaration, var.getType());
                confidence[0] = TypeLookupResult.TypeConfidence.findLessPrecise(confidence[0], TypeLookupResult.TypeConfidence.INFERRED);
                return type;
            }
            if (var instanceof FieldNode) {
                return ((FieldNode)var).getDeclaringClass();
            }
            if (var instanceof PropertyNode) {
                return ((PropertyNode)var).getDeclaringClass();
            }
            if (scope.isThisOrSuper((VariableExpression)node)) {
                return scope.lookupName((String)((VariableExpression)node).getName()).declaringType;
            }
        } else if (node instanceof DeclarationExpression) {
            return ((DeclarationExpression)node).getLeftExpression().getType();
        }
        return VariableScope.OBJECT_CLASS_NODE;
    }

    private TypeLookupResult findType(Expression node, ClassNode objectExpressionType, ClassNode declaringType, VariableScope scope, TypeLookupResult.TypeConfidence confidence) {
        StaticMethodCallExpression expr;
        List<MethodNode> methods;
        if (node instanceof VariableExpression) {
            return this.findTypeForVariable((VariableExpression)node, scope, confidence, declaringType);
        }
        ClassNode nodeType = node.getType();
        if (objectExpressionType != null) {
            if (node instanceof ConstantExpression) {
                return this.findTypeForNameWithKnownObjectExpression(((ConstantExpression)node).getText(), nodeType, objectExpressionType, scope, confidence);
            }
            if (node instanceof BinaryExpression && ((BinaryExpression)node).getOperation().getType() == 100) {
                return new TypeLookupResult(objectExpressionType, declaringType, null, confidence, scope);
            }
            if (node instanceof TernaryExpression) {
                return new TypeLookupResult(objectExpressionType, declaringType, null, confidence, scope);
            }
        }
        if (node instanceof ConstantExpression) {
            ConstantExpression constExpr = (ConstantExpression)node;
            if (constExpr.isTrueExpression() || constExpr.isFalseExpression()) {
                return new TypeLookupResult(VariableScope.BOOLEAN_CLASS_NODE, null, null, confidence, scope);
            }
            if (constExpr.isNullExpression()) {
                return new TypeLookupResult(VariableScope.VOID_CLASS_NODE, null, null, confidence, scope);
            }
            if (constExpr.isEmptyStringExpression()) {
                return new TypeLookupResult(VariableScope.STRING_CLASS_NODE, null, null, confidence, scope);
            }
            if (ClassHelper.isNumberType(nodeType) || nodeType == ClassHelper.BigDecimal_TYPE || nodeType == ClassHelper.BigInteger_TYPE) {
                return new TypeLookupResult(nodeType, null, null, confidence, scope);
            }
            if (node.getText().startsWith("$")) {
                String realName = node.getText().substring(1);
                if (realName.startsWith("{") && realName.endsWith("}")) {
                    realName = realName.substring(1, realName.length() - 1);
                }
                return this.findTypeForNameWithKnownObjectExpression(realName, nodeType, scope.getEnclosingTypeDeclaration(), scope, confidence);
            }
            if (nodeType.equals(VariableScope.STRING_CLASS_NODE)) {
                return new TypeLookupResult(nodeType, null, node, confidence, scope);
            }
            return new TypeLookupResult(nodeType, null, null, TypeLookupResult.TypeConfidence.UNKNOWN, scope);
        }
        if (node instanceof TupleExpression || node instanceof ListExpression || node instanceof RangeExpression) {
            ClassNode parameterized = this.parameterizeThisList(node);
            return new TypeLookupResult(parameterized, null, null, confidence, scope);
        }
        if (node instanceof BinaryExpression) {
            return new TypeLookupResult(((BinaryExpression)node).getLeftExpression().getType(), null, null, confidence, scope);
        }
        if (node instanceof BooleanExpression || node instanceof NotExpression) {
            return new TypeLookupResult(VariableScope.BOOLEAN_CLASS_NODE, null, null, confidence, scope);
        }
        if (node instanceof GStringExpression) {
            return new TypeLookupResult(VariableScope.STRING_CLASS_NODE, null, null, confidence, scope);
        }
        if (node instanceof MapExpression) {
            ClassNode parameterized = this.parameterizeThisMap((MapExpression)node);
            return new TypeLookupResult(parameterized, null, null, confidence, scope);
        }
        if (node instanceof PostfixExpression || node instanceof PrefixExpression) {
            return new TypeLookupResult(VariableScope.INTEGER_CLASS_NODE, null, null, confidence, scope);
        }
        if (node instanceof BitwiseNegationExpression) {
            ClassNode type = ((BitwiseNegationExpression)node).getExpression().getType();
            if (type.getName().equals(VariableScope.STRING_CLASS_NODE.getName())) {
                return new TypeLookupResult(VariableScope.PATTERN_CLASS_NODE, null, null, confidence, scope);
            }
            return new TypeLookupResult(type, null, null, confidence, scope);
        }
        if (node instanceof ClassExpression) {
            if (this.nodeIsDotClassReference(node)) {
                return new TypeLookupResult(VariableScope.CLASS_CLASS_NODE, VariableScope.CLASS_CLASS_NODE, VariableScope.CLASS_CLASS_NODE, TypeLookupResult.TypeConfidence.EXACT, scope);
            }
            return new TypeLookupResult(nodeType, declaringType, nodeType, confidence, scope);
        }
        if (node instanceof StaticMethodCallExpression && (methods = (expr = (StaticMethodCallExpression)node).getOwnerType().getMethods(expr.getMethod())).size() > 0) {
            MethodNode method = methods.get(0);
            return new TypeLookupResult(method.getReturnType(), declaringType, method, confidence, scope);
        }
        if (!(node instanceof MethodCallExpression || node instanceof ConstructorCallExpression || node instanceof MapEntryExpression || node instanceof PropertyExpression || node instanceof TupleExpression || !nodeType.equals(VariableScope.OBJECT_CLASS_NODE))) {
            confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
        }
        return new TypeLookupResult(nodeType, declaringType, null, confidence, scope);
    }

    private ClassNode parameterizeThisMap(MapExpression node) {
        if (node.getMapEntryExpressions().size() > 0) {
            MapEntryExpression entry = node.getMapEntryExpressions().get(0);
            ClassNode map = VariableScope.clone(VariableScope.MAP_CLASS_NODE);
            GenericsType[] unresolvedGenericsForMap = this.unresolvedGenericsForType(map);
            unresolvedGenericsForMap[0].setType(entry.getKeyExpression().getType());
            unresolvedGenericsForMap[0].setName(entry.getKeyExpression().getType().getName());
            unresolvedGenericsForMap[1].setType(entry.getValueExpression().getType());
            unresolvedGenericsForMap[1].setName(entry.getValueExpression().getType().getName());
            return map;
        }
        return VariableScope.clone(VariableScope.MAP_CLASS_NODE);
    }

    private ClassNode parameterizeThisList(Expression node) {
        if (node instanceof TupleExpression) {
            TupleExpression tuple = (TupleExpression)node;
            if (tuple.getExpressions().size() > 0) {
                ClassNode list = VariableScope.clone(VariableScope.LIST_CLASS_NODE);
                GenericsType[] unresolvedGenericsForList = this.unresolvedGenericsForType(list);
                unresolvedGenericsForList[0].setType(tuple.getExpression(0).getType());
                unresolvedGenericsForList[0].setName(tuple.getExpression(0).getType().getName());
                return list;
            }
        } else if (node instanceof ListExpression) {
            ListExpression listExpr = (ListExpression)node;
            if (listExpr.getExpressions().size() > 0) {
                ClassNode list = VariableScope.clone(VariableScope.LIST_CLASS_NODE);
                GenericsType[] unresolvedGenericsForList = this.unresolvedGenericsForType(list);
                unresolvedGenericsForList[0].setType(listExpr.getExpression(0).getType());
                unresolvedGenericsForList[0].setName(listExpr.getExpression(0).getType().getName());
                return list;
            }
        } else if (node instanceof RangeExpression) {
            Expression expr;
            RangeExpression rangeExpr = (RangeExpression)node;
            Expression expression = expr = rangeExpr.getFrom() != null ? rangeExpr.getFrom() : rangeExpr.getTo();
            if (expr != null) {
                ClassNode list = VariableScope.clone(VariableScope.LIST_CLASS_NODE);
                GenericsType[] unresolvedGenericsForList = this.unresolvedGenericsForType(list);
                unresolvedGenericsForList[0].setType(expr.getType());
                unresolvedGenericsForList[0].setName(expr.getType().getName());
                return list;
            }
        }
        return VariableScope.LIST_CLASS_NODE;
    }

    private boolean nodeIsDotClassReference(Expression node) {
        int end = node.getEnd();
        int start = node.getStart();
        char[] contents = this.unit.getContents();
        if (contents.length >= end) {
            char[] realText = new char[end - start];
            System.arraycopy(contents, start, realText, 0, end - start);
            String realTextStr = String.valueOf(realText).trim();
            return realTextStr.endsWith(".class") || realTextStr.endsWith(".class.");
        }
        return false;
    }

    private TypeLookupResult findTypeForNameWithKnownObjectExpression(String name, ClassNode type, ClassNode declaringType, VariableScope scope, TypeLookupResult.TypeConfidence confidence) {
        VariableScope.VariableInfo varInfo;
        ClassNode realDeclaringType;
        ASTNode declaration = this.findDeclaration(name, declaringType);
        if (declaration != null) {
            type = this.typeFromDeclaration(declaration, declaringType);
            realDeclaringType = this.declaringTypeFromDeclaration(declaration, declaringType);
        } else if (this.checkDeclaringType(declaringType, scope) && (varInfo = scope.lookupName(name)) != null) {
            type = varInfo.type;
            realDeclaringType = varInfo.declaringType;
            declaration = this.findDeclaration(name, realDeclaringType);
            if (declaration == null) {
                declaration = varInfo.declaringType;
            }
        } else if (name.equals("call")) {
            realDeclaringType = declaringType;
            declaration = realDeclaringType;
        } else {
            realDeclaringType = declaringType;
            confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
        }
        return new TypeLookupResult(type, realDeclaringType, declaration, confidence, scope);
    }

    private boolean checkDeclaringType(ClassNode declaringType, VariableScope scope) {
        VariableScope.CallAndType callAndType;
        if (declaringType.equals(scope.getEnclosingTypeDeclaration())) {
            return true;
        }
        return scope.getEnclosingClosure() != null && (callAndType = scope.getEnclosingMethodCallExpression()) != null && declaringType.equals(callAndType.declaringType);
    }

    private TypeLookupResult findTypeForVariable(VariableExpression var, VariableScope scope, TypeLookupResult.TypeConfidence confidence, ClassNode declaringType) {
        ClassNode type;
        ASTNode declaration = var;
        Variable accessedVar = var.getAccessedVariable();
        if (accessedVar instanceof ASTNode) {
            declaration = (ASTNode)((Object)accessedVar);
        }
        VariableScope.VariableInfo info = scope.lookupName(var.getName());
        TypeLookupResult.TypeConfidence origConfidence = confidence;
        if (accessedVar instanceof DynamicVariable) {
            ASTNode maybeDeclaration = this.findDeclaration(accessedVar.getName(), this.getMorePreciseType(declaringType, info));
            if (maybeDeclaration != null) {
                declaration = maybeDeclaration;
                declaringType = this.declaringTypeFromDeclaration(declaration, info != null ? info.declaringType : VariableScope.OBJECT_CLASS_NODE);
            } else {
                confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
            }
        }
        if (info != null) {
            confidence = TypeLookupResult.TypeConfidence.findLessPrecise(origConfidence, TypeLookupResult.TypeConfidence.INFERRED);
            type = info.type;
            declaringType = this.getMorePreciseType(declaringType, info);
            if (scope.isThisOrSuper(var)) {
                declaration = type;
            }
        } else {
            type = accessedVar instanceof DynamicVariable ? this.typeFromDeclaration(declaration, declaringType) : var.getType();
        }
        return new TypeLookupResult(type, declaringType, declaration, confidence, scope);
    }

    private ClassNode getMorePreciseType(ClassNode declaringType, VariableScope.VariableInfo info) {
        ClassNode maybeDeclaringType;
        ClassNode classNode = maybeDeclaringType = info != null ? info.declaringType : VariableScope.OBJECT_CLASS_NODE;
        if (maybeDeclaringType.equals(VariableScope.OBJECT_CLASS_NODE) && !VariableScope.OBJECT_CLASS_NODE.equals(declaringType)) {
            return declaringType;
        }
        return maybeDeclaringType;
    }

    private ClassNode declaringTypeFromDeclaration(ASTNode declaration, ClassNode resolvedTypeOfDeclaration) {
        ClassNode typeOfDeclaration = declaration instanceof FieldNode ? ((FieldNode)declaration).getDeclaringClass() : (declaration instanceof MethodNode ? ((MethodNode)declaration).getDeclaringClass() : (declaration instanceof PropertyNode ? ((PropertyNode)declaration).getDeclaringClass() : VariableScope.OBJECT_CLASS_NODE));
        if (typeOfDeclaration.getName().equals(resolvedTypeOfDeclaration.getName())) {
            return resolvedTypeOfDeclaration;
        }
        return typeOfDeclaration;
    }

    private ClassNode typeFromDeclaration(ASTNode declaration, ClassNode resolvedType) {
        ClassNode declaringType = this.declaringTypeFromDeclaration(declaration, resolvedType);
        ClassNode typeOfDeclaration = declaration instanceof FieldNode ? ((FieldNode)declaration).getType() : (declaration instanceof MethodNode ? ((MethodNode)declaration).getReturnType() : (declaration instanceof PropertyNode ? ((PropertyNode)declaration).getType() : (declaration instanceof Expression ? ((Expression)declaration).getType() : VariableScope.OBJECT_CLASS_NODE)));
        GenericsMapper mapper = GenericsMapper.gatherGenerics(resolvedType, declaringType.redirect());
        ClassNode resolvedTypeOfDeclaration = VariableScope.resolveTypeParameterization(mapper, VariableScope.clone(typeOfDeclaration));
        return resolvedTypeOfDeclaration;
    }

    protected GenericsType[] unresolvedGenericsForType(ClassNode unresolvedType) {
        ClassNode candidate = unresolvedType;
        GenericsType[] gts = candidate.getGenericsTypes();
        gts = gts == null ? VariableScope.NO_GENERICS : gts;
        ArrayList<GenericsType> allGs = new ArrayList<GenericsType>(2);
        while (candidate != null) {
            gts = candidate.getGenericsTypes();
            GenericsType[] genericsTypeArray = gts = gts == null ? VariableScope.NO_GENERICS : gts;
            int n = gts.length;
            int n2 = 0;
            while (n2 < n) {
                GenericsType gt = genericsTypeArray[n2];
                allGs.add(gt);
                ++n2;
            }
            candidate = candidate.getSuperClass();
        }
        return allGs.toArray(VariableScope.NO_GENERICS);
    }

    private ASTNode findDeclaration(String name, ClassNode declaringType) {
        String getter;
        FieldNode constantFromSuper;
        if (declaringType.isArray()) {
            if (name.equals("length")) {
                return this.createLengthField(declaringType);
            }
            return this.findDeclaration(name, VariableScope.OBJECT_CLASS_NODE);
        }
        LinkedHashSet<ClassNode> allClasses = new LinkedHashSet<ClassNode>();
        this.createTypeHierarchy(declaringType, allClasses);
        AnnotatedNode maybe = this.findPropertyInClass(name, allClasses);
        if (maybe != null) {
            return maybe;
        }
        List<MethodNode> maybeMethods = declaringType.getMethods(name);
        if (maybeMethods != null && maybeMethods.size() > 0) {
            return maybeMethods.get(0);
        }
        maybe = declaringType.getField(name);
        if (maybe != null) {
            return maybe;
        }
        if (declaringType.isInterface()) {
            LinkedHashSet<ClassNode> allInterfaces = new LinkedHashSet<ClassNode>();
            this.findAllInterfaces(declaringType, allInterfaces);
            MethodNode interfaceMethod = this.findMethodInInterface(name, allInterfaces);
            if (interfaceMethod != null) {
                return interfaceMethod;
            }
            PropertyNode interfaceProperty = this.findPropertyInInterface(name, allInterfaces);
            if (interfaceProperty != null) {
                return interfaceProperty;
            }
        }
        if ((constantFromSuper = this.findConstantInClass(name, allClasses)) != null) {
            return constantFromSuper;
        }
        if (!name.startsWith("get") && name.length() > 0 && (maybeMethods = declaringType.getMethods(getter = "get" + Character.toUpperCase(name.charAt(0)) + (name.length() > 1 ? name.substring(1) : ""))) != null && maybeMethods.size() > 0) {
            return maybeMethods.get(0);
        }
        return null;
    }

    private ASTNode createLengthField(ClassNode declaringType) {
        FieldNode lengthField = new FieldNode("length", 1, VariableScope.INTEGER_CLASS_NODE, declaringType, null);
        lengthField.setType(VariableScope.INTEGER_CLASS_NODE);
        lengthField.setDeclaringClass(declaringType);
        return lengthField;
    }

    private MethodNode findMethodInInterface(String name, Set<ClassNode> allInterfaces) {
        for (ClassNode interf : allInterfaces) {
            List<MethodNode> methods = interf.getDeclaredMethods(name);
            if (methods == null || methods.size() <= 0) continue;
            return methods.get(0);
        }
        return null;
    }

    private PropertyNode findPropertyInClass(String name, Set<ClassNode> allClasses) {
        for (ClassNode clazz : allClasses) {
            PropertyNode prop = clazz.getProperty(name);
            if (prop == null) continue;
            return prop;
        }
        return null;
    }

    private FieldNode findConstantInClass(String name, Set<ClassNode> allClasses) {
        for (ClassNode clazz : allClasses) {
            FieldNode field = clazz.getField(name);
            if (field == null || !Flags.isFinal(field.getModifiers()) || !field.isStatic()) continue;
            return field;
        }
        return null;
    }

    private PropertyNode findPropertyInInterface(String name, Set<ClassNode> allInterfaces) {
        for (ClassNode interf : allInterfaces) {
            PropertyNode prop = interf.getProperty(name);
            if (prop == null) continue;
            return prop;
        }
        return null;
    }

    private void findAllInterfaces(ClassNode interf, Set<ClassNode> allInterfaces) {
        if (!allInterfaces.contains(interf) && interf.getInterfaces() != null) {
            allInterfaces.add(interf);
            ClassNode[] classNodeArray = interf.getInterfaces();
            int n = classNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ClassNode superInterface = classNodeArray[n2];
                this.findAllInterfaces(superInterface, allInterfaces);
                ++n2;
            }
        }
    }

    private void createTypeHierarchy(ClassNode clazz, Set<ClassNode> allClasses) {
        if (!allClasses.contains(clazz)) {
            allClasses.add(clazz);
            if (clazz.getSuperClass() != null) {
                this.createTypeHierarchy(clazz.getSuperClass(), allClasses);
            }
            if (clazz.getInterfaces() != null) {
                ClassNode[] classNodeArray = clazz.getInterfaces();
                int n = classNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ClassNode superInterface = classNodeArray[n2];
                    this.findAllInterfaces(superInterface, allClasses);
                    ++n2;
                }
            }
        }
    }
}

