/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import java.lang.reflect.Modifier;
import java.util.List;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.runtime.MetaClassHelper;

public class ClassCompletionVerifier
extends ClassCodeVisitorSupport {
    private ClassNode currentClass;
    private SourceUnit source;
    private boolean inConstructor = false;
    private boolean inStaticConstructor = false;

    public ClassCompletionVerifier(SourceUnit source) {
        this.source = source;
    }

    public ClassNode getClassNode() {
        return this.currentClass;
    }

    public void visitClass(ClassNode node) {
        ClassNode oldClass = this.currentClass;
        this.currentClass = node;
        this.checkImplementsAndExtends(node);
        if (this.source != null && !this.source.getErrorCollector().hasErrors()) {
            this.checkClassForIncorrectModifiers(node);
            this.checkClassForOverwritingFinal(node);
            this.checkMethodsForIncorrectModifiers(node);
            this.checkMethodsForWeakerAccess(node);
            this.checkMethodsForOverridingFinal(node);
            this.checkNoAbstractMethodsNonabstractClass(node);
        }
        super.visitClass(node);
        this.currentClass = oldClass;
    }

    private void checkNoAbstractMethodsNonabstractClass(ClassNode node) {
        if (Modifier.isAbstract(node.getModifiers())) {
            return;
        }
        List<MethodNode> abstractMethods = node.getAbstractMethods();
        if (abstractMethods == null) {
            return;
        }
        for (MethodNode method : abstractMethods) {
            this.addTypeError("Can't have an abstract method in a non-abstract class. The " + this.getDescription(node) + " must be declared abstract or" + " the " + this.getDescription(method) + " must be implemented.", node);
        }
    }

    private void checkClassForIncorrectModifiers(ClassNode node) {
        this.checkClassForAbstractAndFinal(node);
        this.checkClassForOtherModifiers(node);
    }

    private void checkClassForAbstractAndFinal(ClassNode node) {
        if (!Modifier.isAbstract(node.getModifiers())) {
            return;
        }
        if (!Modifier.isFinal(node.getModifiers())) {
            return;
        }
        if (node.isInterface()) {
            this.addError("The " + this.getDescription(node) + " must not be final. It is by definition abstract.", node);
        } else {
            this.addError("The " + this.getDescription(node) + " must not be both final and abstract.", node);
        }
    }

    private void checkClassForOtherModifiers(ClassNode node) {
        this.checkClassForModifier(node, Modifier.isTransient(node.getModifiers()), "transient");
        this.checkClassForModifier(node, Modifier.isVolatile(node.getModifiers()), "volatile");
        this.checkClassForModifier(node, Modifier.isNative(node.getModifiers()), "native");
        if (!(node instanceof InnerClassNode)) {
            this.checkClassForModifier(node, Modifier.isStatic(node.getModifiers()), "static");
        }
    }

    private void checkMethodForModifier(MethodNode node, boolean condition, String modifierName) {
        if (!condition) {
            return;
        }
        this.addError("The " + this.getDescription(node) + " has an incorrect modifier " + modifierName + ".", node);
    }

    private void checkClassForModifier(ClassNode node, boolean condition, String modifierName) {
        if (!condition) {
            return;
        }
        this.addError("The " + this.getDescription(node) + " has an incorrect modifier " + modifierName + ".", node);
    }

    private String getDescription(ClassNode node) {
        return String.valueOf(node.isInterface() ? "interface" : "class") + " '" + node.getName() + "'";
    }

    private String getDescription(MethodNode node) {
        return "method '" + node.getTypeDescriptor() + "'";
    }

    private String getDescription(FieldNode node) {
        return "field '" + node.getName() + "'";
    }

    private void checkAbstractDeclaration(MethodNode methodNode) {
        if (!Modifier.isAbstract(methodNode.getModifiers())) {
            return;
        }
        if (Modifier.isAbstract(this.currentClass.getModifiers())) {
            return;
        }
        this.addError("Can't have an abstract method in a non-abstract class. The " + this.getDescription(this.currentClass) + " must be declared abstract or the method '" + methodNode.getTypeDescriptor() + "' must not be abstract.", methodNode);
    }

    private void checkClassForOverwritingFinal(ClassNode cn) {
        ClassNode superCN = cn.getSuperClass();
        if (superCN == null) {
            return;
        }
        if (!Modifier.isFinal(superCN.getModifiers())) {
            return;
        }
        StringBuffer msg = new StringBuffer();
        msg.append("You are not allowed to overwrite the final ");
        msg.append(this.getDescription(superCN));
        msg.append(".");
        this.addError(msg.toString(), cn);
    }

    private void checkImplementsAndExtends(ClassNode node) {
        ClassNode cn = node.getSuperClass();
        if (cn.isInterface() && !node.isInterface()) {
            this.addTypeError("You are not allowed to extend the " + this.getDescription(cn) + ", use implements instead.", node);
        }
        ClassNode[] classNodeArray = node.getInterfaces();
        int n = classNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClassNode anInterface = classNodeArray[n2];
            cn = anInterface;
            if (!cn.isInterface()) {
                this.addTypeError("You are not allowed to implement the " + this.getDescription(cn) + ", use extends instead.", node);
            }
            ++n2;
        }
    }

    private void checkMethodsForIncorrectModifiers(ClassNode cn) {
        if (!cn.isInterface()) {
            return;
        }
        for (MethodNode method : cn.getMethods()) {
            if (Modifier.isFinal(method.getModifiers())) {
                this.addError("The " + this.getDescription(method) + " from " + this.getDescription(cn) + " must not be final. It is by definition abstract.", method);
            }
            if (!Modifier.isStatic(method.getModifiers()) || this.isConstructor(method)) continue;
            this.addError("The " + this.getDescription(method) + " from " + this.getDescription(cn) + " must not be static. Only fields may be static in an interface.", method);
        }
    }

    private void checkMethodsForWeakerAccess(ClassNode cn) {
        for (MethodNode method : cn.getMethods()) {
            this.checkMethodForWeakerAccessPrivileges(method, cn);
        }
    }

    private boolean isConstructor(MethodNode method) {
        return method.getName().equals("<clinit>");
    }

    private void checkMethodsForOverridingFinal(ClassNode cn) {
        block0: for (MethodNode method : cn.getMethods()) {
            Parameter[] params = method.getParameters();
            for (MethodNode superMethod : cn.getSuperClass().getMethods(method.getName())) {
                Parameter[] superParams = superMethod.getParameters();
                if (!this.hasEqualParameterTypes(params, superParams)) continue;
                if (!Modifier.isFinal(superMethod.getModifiers())) continue block0;
                this.addInvalidUseOfFinalError(method, params, superMethod.getDeclaringClass());
                return;
            }
        }
    }

    private void addInvalidUseOfFinalError(MethodNode method, Parameter[] parameters, ClassNode superCN) {
        StringBuffer msg = new StringBuffer();
        msg.append("You are not allowed to override the final method ").append(method.getName());
        msg.append("(");
        boolean needsComma = false;
        Parameter[] parameterArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter parameter = parameterArray[n2];
            if (needsComma) {
                msg.append(",");
            } else {
                needsComma = true;
            }
            msg.append(parameter.getType());
            ++n2;
        }
        msg.append(") from ").append(this.getDescription(superCN));
        msg.append(".");
        this.addError(msg.toString(), method);
    }

    private void addWeakerAccessError(ClassNode cn, MethodNode method, Parameter[] parameters, MethodNode superMethod) {
        StringBuffer msg = new StringBuffer();
        msg.append(method.getName());
        msg.append("(");
        boolean needsComma = false;
        Parameter[] parameterArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter parameter = parameterArray[n2];
            if (needsComma) {
                msg.append(",");
            } else {
                needsComma = true;
            }
            msg.append(parameter.getType());
            ++n2;
        }
        msg.append(") in ");
        msg.append(cn.getName());
        msg.append(" cannot override ");
        msg.append(superMethod.getName());
        msg.append(" in ");
        msg.append(superMethod.getDeclaringClass().getName());
        msg.append("; attempting to assign weaker access privileges; was ");
        msg.append(Modifier.isPublic(superMethod.getModifiers()) ? "public" : "protected");
        this.addError(msg.toString(), method);
    }

    private boolean hasEqualParameterTypes(Parameter[] first, Parameter[] second) {
        if (first.length != second.length) {
            return false;
        }
        int i = 0;
        while (i < first.length) {
            String st;
            String ft = first[i].getType().getName();
            if (!ft.equals(st = second[i].getType().getName())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected SourceUnit getSourceUnit() {
        return this.source;
    }

    public void visitMethod(MethodNode node) {
        this.inConstructor = false;
        this.inStaticConstructor = node.isStaticConstructor();
        this.checkAbstractDeclaration(node);
        this.checkRepetitiveMethod(node);
        this.checkOverloadingPrivateAndPublic(node);
        this.checkMethodModifiers(node);
        super.visitMethod(node);
    }

    private void checkMethodModifiers(MethodNode node) {
        if ((this.currentClass.getModifiers() & 0x200) != 0) {
            this.checkMethodForModifier(node, Modifier.isStrict(node.getModifiers()), "strictfp");
            this.checkMethodForModifier(node, Modifier.isSynchronized(node.getModifiers()), "synchronized");
            this.checkMethodForModifier(node, Modifier.isNative(node.getModifiers()), "native");
        }
    }

    private void checkMethodForWeakerAccessPrivileges(MethodNode mn, ClassNode cn) {
        Parameter[] params = mn.getParameters();
        for (MethodNode superMethod : cn.getSuperClass().getMethods(mn.getName())) {
            Parameter[] superParams = superMethod.getParameters();
            if (!this.hasEqualParameterTypes(params, superParams) || (!Modifier.isPrivate(mn.getModifiers()) || Modifier.isPrivate(superMethod.getModifiers())) && (!Modifier.isProtected(mn.getModifiers()) || !Modifier.isPublic(superMethod.getModifiers()))) continue;
            this.addWeakerAccessError(cn, mn, params, superMethod);
            return;
        }
    }

    private void checkOverloadingPrivateAndPublic(MethodNode node) {
        if (this.isConstructor(node)) {
            return;
        }
        boolean hasPrivate = false;
        boolean hasPublic = false;
        for (MethodNode method : this.currentClass.getMethods(node.getName())) {
            if (method == node || !method.getDeclaringClass().equals(node.getDeclaringClass())) continue;
            int modifiers = method.getModifiers();
            if (Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers)) {
                hasPublic = true;
                continue;
            }
            hasPrivate = true;
        }
        if (hasPrivate && hasPublic) {
            this.addError("Mixing private and public/protected methods of the same name causes multimethods to be disabled and is forbidden to avoid surprising behaviour. Renaming the private methods will solve the problem.", node);
        }
    }

    private void checkRepetitiveMethod(MethodNode node) {
        if (this.isConstructor(node)) {
            return;
        }
        for (MethodNode method : this.currentClass.getMethods(node.getName())) {
            Parameter[] p2;
            Parameter[] p1;
            if (method == node || !method.getDeclaringClass().equals(node.getDeclaringClass()) || (p1 = node.getParameters()).length != (p2 = method.getParameters()).length) continue;
            this.addErrorIfParamsAndReturnTypeEqual(p2, p1, node, method);
        }
    }

    private void addErrorIfParamsAndReturnTypeEqual(Parameter[] p2, Parameter[] p1, MethodNode node, MethodNode element) {
        boolean isEqual = true;
        int i = 0;
        while (i < p2.length) {
            isEqual &= p1[i].getType().equals(p2[i].getType());
            ++i;
        }
        if (isEqual &= node.getReturnType().equals(element.getReturnType())) {
            this.addError("Repetitive method name/signature for " + this.getDescription(node) + " in " + this.getDescription(this.currentClass) + ".", node);
        }
    }

    public void visitField(FieldNode node) {
        if (this.currentClass.getDeclaredField(node.getName()) != node) {
            this.addError("The " + this.getDescription(node) + " is declared multiple times.", node);
        }
        this.checkInterfaceFieldModifiers(node);
        super.visitField(node);
    }

    public void visitProperty(PropertyNode node) {
        this.checkDuplicateProperties(node);
        super.visitProperty(node);
    }

    private void checkDuplicateProperties(PropertyNode node) {
        ClassNode cn = node.getDeclaringClass();
        String name = node.getName();
        String getterName = "get" + MetaClassHelper.capitalize(name);
        if (Character.isUpperCase(name.charAt(0))) {
            for (PropertyNode propNode : cn.getProperties()) {
                String otherName = propNode.getField().getName();
                String otherGetterName = "get" + MetaClassHelper.capitalize(otherName);
                if (node == propNode || !getterName.equals(otherGetterName)) continue;
                String msg = "The field " + name + " and " + otherName + " on the class " + cn.getName() + " will result in duplicate JavaBean properties, which is not allowed";
                this.addError(msg, node);
            }
        }
    }

    private void checkInterfaceFieldModifiers(FieldNode node) {
        if (!this.currentClass.isInterface()) {
            return;
        }
        if ((node.getModifiers() & 0x19) == 0) {
            this.addError("The " + this.getDescription(node) + " is not 'public final static' but is defined in the " + this.getDescription(this.currentClass) + ".", node);
        }
    }

    public void visitBinaryExpression(BinaryExpression expression) {
        if (expression.getOperation().getType() == 30 && expression.getRightExpression() instanceof MapEntryExpression) {
            this.addError("You tried to use a map entry for an index operation, this is not allowed. Maybe something should be set in parentheses or a comma is missing?", expression.getRightExpression());
        }
        super.visitBinaryExpression(expression);
        switch (expression.getOperation().getType()) {
            case 100: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 285: 
            case 286: 
            case 287: 
            case 350: 
            case 351: 
            case 352: {
                this.checkFinalFieldAccess(expression.getLeftExpression());
                break;
            }
        }
    }

    private void checkFinalFieldAccess(Expression expression) {
        if (!(expression instanceof VariableExpression) && !(expression instanceof PropertyExpression)) {
            return;
        }
        Variable v = null;
        if (expression instanceof VariableExpression) {
            VariableExpression ve = (VariableExpression)expression;
            v = ve.getAccessedVariable();
        } else {
            VariableExpression varExp;
            PropertyExpression propExp = (PropertyExpression)expression;
            Expression objectExpression = propExp.getObjectExpression();
            if (objectExpression instanceof VariableExpression && (varExp = (VariableExpression)objectExpression).isThisExpression()) {
                v = this.currentClass.getDeclaredField(propExp.getPropertyAsString());
            }
        }
        if (v instanceof FieldNode) {
            boolean error;
            FieldNode fn = (FieldNode)v;
            int modifiers = fn.getModifiers();
            boolean isFinal = (modifiers & 0x10) != 0;
            boolean isStatic = (modifiers & 8) != 0;
            boolean bl = error = isFinal && (isStatic && !this.inStaticConstructor || !isStatic && !this.inConstructor);
            if (error) {
                this.addError("cannot modify" + (isStatic ? " static" : "") + " final field '" + fn.getName() + "' outside of " + (isStatic ? "static initialization block." : "constructor."), expression);
            }
        }
    }

    public void visitConstructor(ConstructorNode node) {
        this.inConstructor = true;
        this.inStaticConstructor = node.isStaticConstructor();
        super.visitConstructor(node);
    }

    public void visitCatchStatement(CatchStatement cs) {
        if (!cs.getExceptionType().isDerivedFrom(ClassHelper.make(Throwable.class))) {
            this.addError("Catch statement parameter type is not a subclass of Throwable.", cs);
        }
        super.visitCatchStatement(cs);
    }

    public void visitMethodCallExpression(MethodCallExpression mce) {
        super.visitMethodCallExpression(mce);
        Expression aexp = mce.getArguments();
        if (aexp instanceof TupleExpression) {
            TupleExpression arguments = (TupleExpression)aexp;
            for (Expression e : arguments.getExpressions()) {
                this.checkForInvalidDeclaration(e);
            }
        } else {
            this.checkForInvalidDeclaration(aexp);
        }
    }

    public void visitDeclarationExpression(DeclarationExpression expression) {
        super.visitDeclarationExpression(expression);
        if (expression.isMultipleAssignmentDeclaration()) {
            return;
        }
        if ((expression.getVariableExpression().getModifiers() & 8) != 0) {
            this.addError("Variable definition has an incorrect modifier 'static'.", expression);
        }
    }

    private void checkForInvalidDeclaration(Expression exp) {
        if (!(exp instanceof DeclarationExpression)) {
            return;
        }
        this.addError("Invalid use of declaration inside method call.", exp);
    }

    public void visitConstantExpression(ConstantExpression expression) {
        super.visitConstantExpression(expression);
        this.checkStringExceedingMaximumLength(expression);
    }

    public void visitGStringExpression(GStringExpression expression) {
        super.visitGStringExpression(expression);
        for (ConstantExpression ce : expression.getStrings()) {
            this.checkStringExceedingMaximumLength(ce);
        }
    }

    private void checkStringExceedingMaximumLength(ConstantExpression expression) {
        String s;
        Object value = expression.getValue();
        if (value instanceof String && (s = (String)value).length() > 65535) {
            this.addError("String too long. The given string is " + s.length() + " Unicode code units long, but only a maximum of 65535 is allowed.", expression);
        }
    }
}

