/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovySystem;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.customizers.ASTTransformationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.codehaus.jdt.groovy.control.EclipseSourceUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;

public class Grails20TestSupport {
    private static final String GRAILS_UTIL_BUILD_SETTINGS = "grails.util.BuildSettings";
    private static final String GRAILS_UTIL_BUILD_SETTINGS_HOLDER = "grails.util.BuildSettingsHolder";
    CompilerOptions options;
    GroovyClassLoader gcl;

    public Grails20TestSupport(CompilerOptions options, GroovyClassLoader gcl) {
        this.options = options;
        this.gcl = gcl;
    }

    public void addGrailsTestCompilerCustomizers(CompilationUnit groovyCompilationUnit) {
        if (GroovySystem.getVersion().startsWith("1.8")) {
            ImportCustomizer importCustomizer = new ImportCustomizer(){

                public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
                    if (Grails20TestSupport.isInGrailsUnitTestSourceFolder(source)) {
                        super.call(source, context, classNode);
                    }
                }
            };
            importCustomizer.addStarImports("grails.test.mixin");
            importCustomizer.addStarImports("org.junit");
            importCustomizer.addStaticStars("org.junit.Assert");
            groovyCompilationUnit.addPhaseOperation(importCustomizer, importCustomizer.getPhase().getPhaseNumber());
            Class<?> testForClass = null;
            try {
                testForClass = Class.forName("grails.test.mixin.TestFor", false, this.gcl);
                if (testForClass != null) {
                    ASTTransformationCustomizer astTransformationCustomizer = new ASTTransformationCustomizer(testForClass){

                        public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
                            if (Grails20TestSupport.isInGrailsUnitTestSourceFolder(source)) {
                                super.call(source, context, classNode);
                            }
                        }
                    };
                    groovyCompilationUnit.addPhaseOperation(astTransformationCustomizer, astTransformationCustomizer.getPhase().getPhaseNumber());
                    this.ensureGrailsBuildSettings();
                }
            }
            catch (LinkageError astTransformationCustomizer) {
            }
            catch (ClassNotFoundException astTransformationCustomizer) {
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    void ensureGrailsBuildSettings() {
        try {
            Class<?> buildSettingsHolder;
            Object buildSettings;
            String projectName = this.options.groovyProjectName;
            if (projectName != null && (buildSettings = Grails20TestSupport.getBuildSettings(buildSettingsHolder = this.gcl.loadClass(GRAILS_UTIL_BUILD_SETTINGS_HOLDER))) == null) {
                buildSettings = this.createBuildSettings();
                Grails20TestSupport.setBuildSettings(buildSettingsHolder, buildSettings);
                Object object = Grails20TestSupport.getBuildSettings(buildSettingsHolder);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Object createBuildSettings() throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> buildSettingsClass = this.gcl.loadClass(GRAILS_UTIL_BUILD_SETTINGS);
        Constructor<?> constructor = buildSettingsClass.getConstructor(File.class, File.class);
        return constructor.newInstance(this.getGrailsHome(), this.getProjectHome());
    }

    private Object getGrailsHome() {
        return null;
    }

    private File getProjectHome() {
        IProject project;
        IPath location;
        String projectName = this.options.groovyProjectName;
        if (projectName != null && (location = (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)).getLocation()) != null) {
            return location.toFile();
        }
        return null;
    }

    private static Object getBuildSettings(Class buildSettingsHolder) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method m = buildSettingsHolder.getMethod("getSettings", new Class[0]);
        return m.invoke(null, new Object[0]);
    }

    private static synchronized void setBuildSettings(Class buildSettingsHolder, Object buildSettings) throws SecurityException, NoSuchMethodException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method m = buildSettingsHolder.getMethod("setSettings", buildSettingsHolder.getClassLoader().loadClass(GRAILS_UTIL_BUILD_SETTINGS));
        m.invoke(null, buildSettings);
        Assert.isTrue(Grails20TestSupport.getBuildSettings(buildSettingsHolder) == buildSettings);
    }

    static boolean isInGrailsUnitTestSourceFolder(SourceUnit source) {
        EclipseSourceUnit eclipseSource;
        IFile file;
        if (source instanceof EclipseSourceUnit && (file = (eclipseSource = (EclipseSourceUnit)source).getEclipseFile()) != null) {
            IPath path = file.getProjectRelativePath();
            return new Path("test/unit").isPrefixOf(path);
        }
        return false;
    }
}

