/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.core.search.TypeDeclarationMatch;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.matching.TypeDeclarationPattern;
import org.eclipse.jdt.internal.core.util.Util;

public class TypeDeclarationSearchRequestor
implements ITypeRequestor,
IIndexConstants {
    private final String simpleName;
    private final char typeSuffix;
    private final SearchRequestor requestor;
    private final SearchParticipant participant;

    public TypeDeclarationSearchRequestor(TypeDeclarationPattern pattern, SearchRequestor requestor, SearchParticipant participant) {
        this.simpleName = new String(pattern.simpleName);
        this.typeSuffix = pattern.typeSuffix;
        this.requestor = requestor;
        this.participant = participant;
    }

    public ITypeRequestor.VisitStatus acceptASTNode(ASTNode node, TypeLookupResult result, IJavaElement enclosingElement) {
        ClassNode redirect;
        ClassNode orig;
        if (node instanceof ClassNode && (orig = (ClassNode)node) == (redirect = orig.redirect()) && orig.getNameWithoutPackage().equalsIgnoreCase(this.simpleName)) {
            boolean matchFound;
            switch (this.typeSuffix) {
                case 'C': {
                    matchFound = this.isClass(orig);
                    break;
                }
                case '\n': {
                    matchFound = orig.isInterface() || this.isClass(orig);
                    break;
                }
                case '\t': {
                    matchFound = orig.isInterface() || orig.isEnum();
                    break;
                }
                case 'I': {
                    matchFound = orig.isInterface();
                    break;
                }
                case '\u000b': {
                    matchFound = orig.isInterface() || orig.isAnnotationDefinition();
                    break;
                }
                case 'E': {
                    matchFound = orig.isEnum();
                    break;
                }
                case 'A': {
                    matchFound = orig.isAnnotationDefinition();
                    break;
                }
                default: {
                    matchFound = true;
                }
            }
            if (matchFound) {
                try {
                    this.requestor.acceptSearchMatch(new TypeDeclarationMatch(enclosingElement, 0, orig.getNameStart(), orig.getNameEnd() - orig.getNameStart() + 1, this.participant, enclosingElement.getResource()));
                }
                catch (CoreException e) {
                    Util.log(e, "Exception with groovy search requestor");
                }
            }
        }
        return ITypeRequestor.VisitStatus.CONTINUE;
    }

    private boolean isClass(ClassNode orig) {
        return !orig.isInterface() && !orig.isAnnotationDefinition() && !orig.isEnum();
    }
}

