/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.internal.core.util.Util;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.jdt.groovy.core";
    private static Activator plugin;
    private IEclipsePreferences instanceScope;
    public static final String GROOVY_SCRIPT_FILTERS = "groovy.script.filters";
    public static final String GROOVY_SCRIPT_FILTERS_ENABLED = "groovy.script.filters.enabled";
    public static final String DEFAULT_GROOVY_SCRIPT_FILTER = "scripts/**/*.groovy,y,src/main/resources/**/*.groovy,y,src/test/resources/**/*.groovy,y";

    @Override
    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    @Override
    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public void setPreference(String key, List<String> vals) {
        String concat;
        if (vals == null) {
            concat = "";
        } else {
            StringBuilder sb = new StringBuilder();
            Iterator<String> valIter = vals.iterator();
            while (valIter.hasNext()) {
                sb.append(valIter.next());
                if (!valIter.hasNext()) continue;
                sb.append(",");
            }
            concat = sb.toString();
        }
        this.getPreferences().put(key, concat);
        try {
            this.getPreferences().flush();
        }
        catch (BackingStoreException e) {
            Util.log(e);
        }
    }

    public void setPreference(String key, String val) {
        if (val == null) {
            val = "";
        }
        this.getPreferences().put(key, val);
        try {
            this.getPreferences().flush();
        }
        catch (BackingStoreException e) {
            Util.log(e);
        }
    }

    public List<String> getListStringPreference(String key, String def) {
        String result = this.getPreferences().get(key, def);
        if (result == null) {
            result = "";
        }
        String[] splits = result.split(",");
        return Arrays.asList(splits);
    }

    public String getStringPreference(String key, String def) {
        return this.getPreferences().get(key, def);
    }

    public IEclipsePreferences getPreferences() {
        if (this.instanceScope == null) {
            this.instanceScope = new InstanceScope().getNode(PLUGIN_ID);
        }
        return this.instanceScope;
    }

    public boolean getBooleanPreference(String key, boolean def) {
        return this.getPreferences().getBoolean(key, def);
    }
}

