/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.indexing;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.jdt.internal.core.search.indexing.SaveIndex;
import org.eclipse.jdt.internal.core.search.processing.JobManager;
import org.eclipse.jdt.internal.core.util.Util;

public class IndexAllProject
extends IndexRequest {
    IProject project;

    public IndexAllProject(IProject project, IndexManager manager) {
        super(project.getFullPath(), manager);
        this.project = project;
    }

    public boolean equals(Object o) {
        if (o instanceof IndexAllProject) {
            return this.project.equals(((IndexAllProject)o).project);
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor progressMonitor) {
        if (this.isCancelled != false) return true;
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        if (!this.project.isAccessible()) {
            return true;
        }
        monitor = null;
        javaProject = (JavaProject)JavaCore.create(this.project);
        entries = javaProject.getRawClasspath();
        length = entries.length;
        sourceEntries = new IClasspathEntry[length];
        sourceEntriesNumber = 0;
        i = 0;
        while (true) {
            block27: {
                if (i < length) break block27;
                if (sourceEntriesNumber != 0) ** GOTO lbl54
                projectPath = javaProject.getPath();
                i = 0;
                if (true) ** GOTO lbl46
            }
            entry = entries[i];
            if (entry.getEntryKind() == 3) {
                sourceEntries[sourceEntriesNumber++] = entry;
            }
            ++i;
        }
        {
            catch (CoreException e) {
                if (JobManager.VERBOSE) {
                    Util.verbose("-> failed to index " + this.project + " because of the following exception:", System.err);
                    e.printStackTrace();
                }
                this.manager.removeIndex(this.containerPath);
                return false;
            }
            catch (IOException e) {
                if (JobManager.VERBOSE) {
                    Util.verbose("-> failed to index " + this.project + " because of the following exception:", System.err);
                    e.printStackTrace();
                }
                this.manager.removeIndex(this.containerPath);
                return false;
            }
        }
lbl40:
        // 4 sources

        while (true) {
            if (monitor == null) return true;
            monitor.exitRead();
            return true;
        }
        {
            do {
                ++i;
lbl46:
                // 2 sources

                if (i < length) continue;
                index = this.manager.getIndexForUpdate(this.containerPath, true, true);
                if (index == null) ** GOTO lbl40
                this.manager.saveIndex(index);
                ** GOTO lbl40
            } while ((entry = entries[i]).getEntryKind() != 1 || !entry.getPath().equals(projectPath));
            this.manager.indexLibrary(projectPath, this.project);
            ** GOTO lbl40
lbl54:
            // 1 sources

            if (sourceEntriesNumber != length) {
                v0 = sourceEntries;
                sourceEntries = new IClasspathEntry[sourceEntriesNumber];
                System.arraycopy(v0, 0, sourceEntries, 0, sourceEntriesNumber);
            }
            if ((index = this.manager.getIndexForUpdate(this.containerPath, true, true)) != null && (monitor = index.monitor) != null) ** break;
            ** continue;
            monitor.enterRead();
            paths = index.queryDocumentNames("");
            max = paths == null ? 0 : paths.length;
            indexedFileNames = new SimpleLookupTable(max == 0 ? 33 : max + 11);
            if (paths != null) {
                i = 0;
                while (i < max) {
                    indexedFileNames.put(paths[i], "DELETED");
                    ++i;
                }
            }
            indexLastModified = max == 0 ? 0L : index.getIndexFile().lastModified();
            root = this.project.getWorkspace().getRoot();
        }
        i = 0;
        if (i < sourceEntriesNumber) {
        }
        parser = this.manager.getSourceElementParser(javaProject, null);
        names = indexedFileNames.keyTable;
        values = indexedFileNames.valueTable;
        i = 0;
        namesLength = names.length;
        while (true) {
            if (i >= namesLength) {
                this.manager.request(new SaveIndex(this.containerPath, this.manager));
                return true;
            }
            name = (String)names[i];
            if (name != null) {
                if (this.isCancelled) {
                    return false;
                }
                value = values[i];
                if (value != "OK") {
                    if (value == "DELETED") {
                        this.manager.remove(name, this.containerPath);
                    } else {
                        this.manager.addSource((IFile)value, this.containerPath, parser);
                    }
                }
            }
            ++i;
        }
    }

    public int hashCode() {
        return this.project.hashCode();
    }

    protected Integer updatedIndexState() {
        return IndexManager.REBUILDING_STATE;
    }

    public String toString() {
        return "indexing project " + this.project.getFullPath();
    }
}

