/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.util;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;

public class CompilerUtils {
    public static final int IsGrails = 1;

    public static void configureOptionsBasedOnNature(CompilerOptions compilerOptions, IJavaProject javaProject) {
        if (javaProject == null) {
            compilerOptions.buildGroovyFiles = 1;
            compilerOptions.groovyFlags = 0;
            return;
        }
        IProject project = javaProject.getProject();
        try {
            if (CompilerUtils.isGroovyNaturedProject(project)) {
                compilerOptions.storeAnnotations = true;
                compilerOptions.buildGroovyFiles = 2;
                CompilerUtils.setGroovyClasspath(compilerOptions, javaProject);
                compilerOptions.groovyFlags = CompilerUtils.isProbablyGrailsProject(project) ? 1 : 0;
            } else {
                compilerOptions.buildGroovyFiles = 1;
                compilerOptions.groovyFlags = 0;
            }
        }
        catch (CoreException coreException) {
            compilerOptions.buildGroovyFiles = 1;
            compilerOptions.groovyFlags = 0;
        }
    }

    public static void configureOptionsBasedOnNature(Map optionMap, IJavaProject javaProject) {
        IProject project = javaProject.getProject();
        try {
            if (CompilerUtils.isGroovyNaturedProject(project)) {
                optionMap.put("org.eclipse.jdt.core.compiler.groovy.buildGroovyFiles", "enabled");
                CompilerUtils.setGroovyClasspath(optionMap, javaProject);
                if (CompilerUtils.isProbablyGrailsProject(project)) {
                    optionMap.put("org.eclipse.jdt.core.compiler.groovy.projectFlags", Integer.toString(1));
                } else {
                    optionMap.put("org.eclipse.jdt.core.compiler.groovy.projectFlags", "0");
                }
            } else {
                optionMap.put("org.eclipse.jdt.core.compiler.groovy.buildGroovyFiles", "disabled");
                optionMap.put("org.eclipse.jdt.core.compiler.groovy.projectFlags", "0");
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            optionMap.put("org.eclipse.jdt.core.compiler.groovy.buildGroovyFiles", "disabled");
            optionMap.put("org.eclipse.jdt.core.compiler.groovy.projectFlags", "0");
        }
    }

    private static boolean isProbablyGrailsProject(IProject project) {
        try {
            IFolder folder = project.getFolder("grails-app");
            return folder.exists();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void setGroovyClasspath(CompilerOptions compilerOptions, IJavaProject javaProject) {
        HashMap newOptions = new HashMap();
        CompilerUtils.setGroovyClasspath(newOptions, javaProject);
        compilerOptions.groovyProjectName = javaProject.getProject().getName();
        if (!newOptions.isEmpty()) {
            compilerOptions.set(newOptions);
        }
    }

    public static void setGroovyClasspath(Map optionMap, IJavaProject javaProject) {
        IFile file = javaProject.getProject().getFile("groovy.properties");
        if (file.exists()) {
            try {
                PropertyResourceBundle prb = new PropertyResourceBundle(file.getContents());
                Enumeration<String> e = prb.getKeys();
                while (e.hasMoreElements()) {
                    String k = e.nextElement();
                    String v = (String)prb.getObject(k);
                    v = CompilerUtils.fixup(v, javaProject);
                    if (!k.equals("org.eclipse.jdt.core.compiler.groovy.groovyClassLoaderPath")) continue;
                    optionMap.put("org.eclipse.jdt.core.compiler.groovy.groovyClassLoaderPath", v);
                }
            }
            catch (IOException ioe) {
                System.err.println("Problem configuring groovy classloader classpath");
                ioe.printStackTrace();
            }
            catch (CoreException ce) {
                System.err.println("Problem configuring groovy classloader classpath");
                ce.printStackTrace();
            }
            catch (Throwable t) {
                System.err.println("Problem configuring groovy classloader classpath");
                t.printStackTrace();
            }
        } else {
            try {
                String classpath = CompilerUtils.calculateClasspath(javaProject);
                optionMap.put("org.eclipse.jdt.core.compiler.groovy.groovyClassLoaderPath", classpath);
            }
            catch (Throwable t) {
                System.err.println("Problem configuring groovy classloader classpath (not using groovy.properties)");
                t.printStackTrace();
            }
        }
        optionMap.put("org.eclipse.jdt.core.compiler.groovy.groovyProjectName", javaProject.getProject().getName());
    }

    private static String fixup(String someString, IJavaProject javaProject) {
        if (someString.startsWith("%projhome%")) {
            someString = String.valueOf(javaProject.getProject().getLocation().toOSString()) + File.separator + someString.substring("%projhome%".length());
        }
        if (someString.equals("%projclasspath%")) {
            someString = CompilerUtils.calculateClasspath(javaProject);
        }
        return someString;
    }

    private static boolean isGroovyNaturedProject(IProject project) throws CoreException {
        return project.hasNature("org.eclipse.jdt.groovy.core.groovyNature");
    }

    private static String pathToString(IPath path, IProject project) {
        String realLocation = null;
        if (path != null) {
            String prefix = path.segment(0);
            if (prefix.equals(project.getName())) {
                if (path.segmentCount() == 1) {
                    IPath rawPath = project.getRawLocation();
                    if (rawPath == null) {
                        System.err.println("Failed on call to getRawLocation() against the project: " + project);
                    } else {
                        realLocation = project.getRawLocation().toOSString();
                    }
                } else {
                    realLocation = project.getFile(path.removeFirstSegments(1)).getRawLocation().toOSString();
                }
            } else {
                realLocation = path.toOSString();
            }
        }
        return realLocation;
    }

    public static String calculateClasspath(IJavaProject javaProject) {
        block15: {
            try {
                LinkedHashSet<String> accumulatedPathEntries = new LinkedHashSet<String>();
                IProject project = javaProject.getProject();
                String projectName = project.getName();
                IPath defaultOutputPath = javaProject.getOutputLocation();
                String defaultOutputLocation = CompilerUtils.pathToString(defaultOutputPath, project);
                IClasspathEntry[] cpes = javaProject.getResolvedClasspath(true);
                if (cpes == null) break block15;
                int i = 0;
                int max = cpes.length;
                while (i < max) {
                    IClasspathEntry cpe = cpes[i];
                    if (cpe.getEntryKind() != 3) {
                        IPath cpePath = cpe.getPath();
                        String pathElement = null;
                        String segmentZero = cpePath.segment(0);
                        if (segmentZero.equals(projectName)) {
                            pathElement = project.getFile(cpePath.removeFirstSegments(1)).getRawLocation().toOSString();
                        } else {
                            if (cpe.getEntryKind() == 1) {
                                try {
                                    IProject iproject = project.getWorkspace().getRoot().getProject(segmentZero);
                                    if (iproject != null) {
                                        IFile ifile = iproject.getFile(cpePath.removeFirstSegments(1));
                                        IPath ipath = ifile == null ? null : ifile.getRawLocation();
                                        pathElement = ipath == null ? null : ipath.toOSString();
                                    }
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                }
                            }
                            if (cpe.getEntryKind() == 2) {
                                CompilerUtils.computeDependenciesFromProject(project, segmentZero, accumulatedPathEntries);
                            } else if (pathElement == null) {
                                pathElement = cpe.getPath().toOSString();
                            }
                        }
                        if (pathElement != null) {
                            accumulatedPathEntries.add(pathElement);
                        }
                    }
                    ++i;
                }
                accumulatedPathEntries.add(defaultOutputLocation);
                StringBuilder sb = new StringBuilder();
                Iterator iter = accumulatedPathEntries.iterator();
                while (iter.hasNext()) {
                    sb.append((String)iter.next());
                    sb.append(File.pathSeparator);
                }
                String classpath = sb.toString();
                return classpath;
            }
            catch (JavaModelException jme) {
                System.err.println("Problem trying to determine classpath of project " + javaProject.getProject().getName() + ":");
                jme.printStackTrace();
            }
        }
        return "";
    }

    private static void computeDependenciesFromProject(IProject baseProject, String otherProject, Set accumulatedPathEntries) throws JavaModelException {
        IProject iproject = baseProject.getWorkspace().getRoot().getProject(otherProject);
        IJavaProject ijp = JavaCore.create(iproject);
        accumulatedPathEntries.add(CompilerUtils.pathToString(ijp.getOutputLocation(), iproject));
        IClasspathEntry[] cpes = ijp.getResolvedClasspath(true);
        if (cpes != null) {
            int j = 0;
            while (j < cpes.length) {
                IClasspathEntry cpe = cpes[j];
                if (cpe.getEntryKind() != 3 && cpe.isExported()) {
                    IPath cpePath = cpes[j].getPath();
                    String segmentZero = cpePath.segment(0);
                    if (segmentZero != null && segmentZero.equals(otherProject)) {
                        accumulatedPathEntries.add(iproject.getFile(cpePath.removeFirstSegments(1)).getRawLocation().toOSString());
                    } else if (cpe.getEntryKind() == 2) {
                        CompilerUtils.computeDependenciesFromProject(baseProject, segmentZero, accumulatedPathEntries);
                    } else {
                        String otherPathElement = null;
                        otherPathElement = segmentZero != null && segmentZero.equals(iproject.getName()) ? iproject.getFile(cpePath.removeFirstSegments(1)).getRawLocation().toOSString() : cpePath.toOSString();
                        accumulatedPathEntries.add(otherPathElement);
                    }
                }
                ++j;
            }
        }
    }
}

