/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.jdt.groovy.search.ITypeLookup;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.groovy.search.VariableScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryTypeLookup
implements ITypeLookup {
    @Override
    public TypeLookupResult lookupType(Expression node, VariableScope scope, ClassNode objectExpressionType) {
        if (node instanceof ConstantExpression) {
            ConstantExpression constExpr = (ConstantExpression)node;
            Set<ClassNode> categories = scope.getCategoryNames();
            ClassNode currentType = objectExpressionType != null ? objectExpressionType : scope.getEnclosingTypeDeclaration();
            HashSet<MethodNode> possibleMethods = new HashSet<MethodNode>();
            String text = constExpr.getText();
            if (text.startsWith("${") && text.endsWith("}")) {
                text = text.substring(2, text.length() - 1);
            } else if (text.startsWith("$")) {
                text = text.substring(1);
            }
            String getterName = this.createGetterName(text);
            for (ClassNode category : categories) {
                List<MethodNode> methods = category.getMethods(text);
                possibleMethods.addAll(methods);
                if (getterName == null) continue;
                methods = category.getMethods(getterName);
                possibleMethods.addAll(methods);
            }
            for (MethodNode methodNode : possibleMethods) {
                Parameter[] params = methodNode.getParameters();
                if (params == null || params.length <= 0 || !this.isAssignableFrom(VariableScope.maybeConvertFromPrimitive(currentType), params[0].getType())) continue;
                ClassNode declaringClass = methodNode.getDeclaringClass();
                return new TypeLookupResult(methodNode.getReturnType(), declaringClass, methodNode, this.getConfidence(declaringClass), scope);
            }
        }
        return null;
    }

    private String createGetterName(String name) {
        if (!name.startsWith("get") && !name.startsWith("set") && name.length() > 0) {
            return "get" + Character.toUpperCase(name.charAt(0)) + (name.length() > 1 ? name.substring(1) : "");
        }
        return null;
    }

    private TypeLookupResult.TypeConfidence getConfidence(ClassNode declaringClass) {
        return declaringClass.getName().equals(VariableScope.DGM_CLASS_NODE.getName()) || declaringClass.getName().equals(VariableScope.DGSM_CLASS_NODE.getName()) ? TypeLookupResult.TypeConfidence.LOOSELY_INFERRED : TypeLookupResult.TypeConfidence.INFERRED;
    }

    private void findAllSupers(ClassNode clazz, Set<String> allSupers) {
        if (!allSupers.contains(clazz.getName())) {
            allSupers.add(clazz.getName());
            if (clazz.getSuperClass() != null) {
                this.findAllSupers(clazz.getSuperClass(), allSupers);
            }
            if (clazz.getInterfaces() != null) {
                ClassNode[] classNodeArray = clazz.getInterfaces();
                int n = classNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ClassNode superInterface = classNodeArray[n2];
                    this.findAllSupers(superInterface, allSupers);
                    ++n2;
                }
            }
        }
    }

    private boolean isAssignableFrom(ClassNode from, ClassNode to) {
        if (from == null || to == null) {
            return false;
        }
        HashSet<String> allSupers = new HashSet<String>();
        allSupers.add("java.lang.Object");
        this.findAllSupers(from, allSupers);
        for (String supr : allSupers) {
            if (!to.getName().equals(supr)) continue;
            return true;
        }
        return false;
    }

    @Override
    public TypeLookupResult lookupType(FieldNode node, VariableScope scope) {
        return null;
    }

    @Override
    public TypeLookupResult lookupType(MethodNode node, VariableScope scope) {
        return null;
    }

    @Override
    public TypeLookupResult lookupType(AnnotationNode node, VariableScope scope) {
        return null;
    }

    @Override
    public TypeLookupResult lookupType(ImportNode node, VariableScope scope) {
        return null;
    }

    @Override
    public TypeLookupResult lookupType(ClassNode node, VariableScope scope) {
        return null;
    }

    @Override
    public TypeLookupResult lookupType(Parameter node, VariableScope scope) {
        return null;
    }

    @Override
    public void initialize(GroovyCompilationUnit unit, VariableScope topLevelScope) {
    }
}

