/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyClassScope;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.core.builder.AbortIncrementalBuildException;

public class GroovyCompilationUnitScope
extends CompilationUnitScope {
    private Map<String, ClassNode> typenameToClassNodeCache = new HashMap<String, ClassNode>();
    private static final char[][] javaLang = CharOperation.splitOn('.', "java.lang".toCharArray());
    private static final char[][] javaIo = CharOperation.splitOn('.', "java.io".toCharArray());
    private static final char[][] javaNet = CharOperation.splitOn('.', "java.net".toCharArray());
    private static final char[][] javaUtil = CharOperation.splitOn('.', "java.util".toCharArray());
    private static final char[][] groovyLang = CharOperation.splitOn('.', "groovy.lang".toCharArray());
    private static final char[][] groovyUtil = CharOperation.splitOn('.', "groovy.util".toCharArray());
    private static final char[][] javaMathBigDecimal = CharOperation.splitOn('.', "java.math.BigDecimal".toCharArray());
    private static final char[][] javaMathBigInteger = CharOperation.splitOn('.', "java.math.BigInteger".toCharArray());
    private static final char[] GROOVY = "groovy".toCharArray();
    private static final char[] LANG = "lang".toCharArray();
    private static final char[][] GROOVY_LANG_GROOVYOBJECT = new char[][]{GROOVY, LANG, "GroovyObject".toCharArray()};
    private boolean isScript = false;

    public GroovyCompilationUnitScope(GroovyCompilationUnitDeclaration compilationUnitDeclaration, LookupEnvironment lookupEnvironment) {
        super(compilationUnitDeclaration, lookupEnvironment);
    }

    protected ImportBinding[] getDefaultImports() {
        ImportBinding[] defaultImports = super.getDefaultImports();
        ArrayList<ImportBinding> importBindings = new ArrayList<ImportBinding>();
        importBindings.add(defaultImports[0]);
        PackageBinding importBinding = this.environment.createPackage(javaIo);
        importBindings.add(new ImportBinding(javaIo, true, importBinding, null));
        importBinding = this.environment.createPackage(javaNet);
        importBindings.add(new ImportBinding(javaNet, true, importBinding, null));
        importBinding = this.environment.createPackage(javaUtil);
        importBindings.add(new ImportBinding(javaUtil, true, importBinding, null));
        importBinding = this.environment.createPackage(groovyLang);
        importBindings.add(new ImportBinding(groovyLang, true, importBinding, null));
        importBinding = this.environment.createPackage(groovyUtil);
        importBindings.add(new ImportBinding(groovyUtil, true, importBinding, null));
        ReferenceBinding jmBigDecimal = this.environment.getType(javaMathBigDecimal);
        importBindings.add(new ImportBinding(javaMathBigDecimal, false, jmBigDecimal, null));
        ReferenceBinding jmBigInteger = this.environment.getType(javaMathBigInteger);
        importBindings.add(new ImportBinding(javaMathBigInteger, false, jmBigInteger, null));
        return importBindings.toArray(new ImportBinding[importBindings.size()]);
    }

    protected ClassScope buildClassScope(Scope parent, TypeDeclaration typeDecl) {
        return new GroovyClassScope(parent, typeDecl);
    }

    public void augmentTypeHierarchy() {
        int i = 0;
        int length = this.topLevelTypes.length;
        while (i < length) {
            this.augmentTypeHierarchy(this.topLevelTypes[i]);
            ++i;
        }
    }

    private void augmentTypeHierarchy(SourceTypeBinding typeBinding) {
        if (typeBinding.isAnnotationType() || typeBinding.isInterface()) {
            return;
        }
        ReferenceBinding groovyLangObjectBinding = this.getGroovyLangObjectBinding();
        if (!typeBinding.implementsInterface(groovyLangObjectBinding, true)) {
            ReferenceBinding[] superInterfaceBindings = typeBinding.superInterfaces;
            int count = superInterfaceBindings.length;
            ReferenceBinding[] referenceBindingArray = superInterfaceBindings;
            superInterfaceBindings = new ReferenceBinding[count + 1];
            System.arraycopy(referenceBindingArray, 0, superInterfaceBindings, 0, count);
            superInterfaceBindings[count] = groovyLangObjectBinding;
            typeBinding.superInterfaces = superInterfaceBindings;
        }
    }

    private final ReferenceBinding getGroovyLangObjectBinding() {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordQualifiedReference(GROOVY_LANG_GROOVYOBJECT);
        return unitScope.environment.getResolvedType(GROOVY_LANG_GROOVYOBJECT, this);
    }

    public ClassNode lookupClassNodeForSource(String typename, JDTResolver jdtResolver) {
        ProblemReferenceBinding prBinding;
        ClassNode node = this.typenameToClassNodeCache.get(typename);
        if (node != null) {
            return node;
        }
        char[][] compoundName = CharOperation.splitOn('.', typename.toCharArray());
        TypeBinding jdtBinding = null;
        try {
            jdtBinding = this.getType(compoundName, compoundName.length);
        }
        catch (AbortCompilation t) {
            if (t.silentException instanceof AbortIncrementalBuildException) {
                jdtBinding = null;
            }
            throw t;
        }
        if (jdtBinding != null) {
            if (jdtBinding instanceof SourceTypeBinding) {
                ClassNode classNode = jdtResolver.convertToClassNode(jdtBinding);
                if (classNode != null) {
                    this.typenameToClassNodeCache.put(typename, classNode);
                }
                return classNode;
            }
            if (jdtBinding instanceof BinaryTypeBinding) {
                ClassNode newNode = jdtResolver.convertToClassNode(jdtBinding);
                if (newNode != null) {
                    this.typenameToClassNodeCache.put(typename, newNode);
                }
                return newNode;
            }
        }
        if (jdtBinding != null && jdtBinding instanceof ProblemReferenceBinding && (prBinding = (ProblemReferenceBinding)jdtBinding).problemId() == 4) {
            jdtBinding = prBinding.closestMatch();
            if (jdtBinding != null && jdtBinding instanceof SourceTypeBinding) {
                return jdtResolver.convertToClassNode(jdtBinding);
            }
            if (jdtBinding != null && jdtBinding instanceof BinaryTypeBinding) {
                return jdtResolver.convertToClassNode(jdtBinding);
            }
        }
        return null;
    }

    public ClassNode lookupClassNodeForBinary(String typename, JDTResolver jdtResolver) {
        ProblemReferenceBinding prBinding;
        char[][] compoundName = CharOperation.splitOn('.', typename.toCharArray());
        TypeBinding jdtBinding = this.getType(compoundName, compoundName.length);
        if (jdtBinding != null && jdtBinding instanceof BinaryTypeBinding) {
            ClassNode classNode = jdtResolver.convertToClassNode(jdtBinding);
            return classNode;
        }
        if (jdtBinding != null && jdtBinding instanceof ProblemReferenceBinding && (prBinding = (ProblemReferenceBinding)jdtBinding).problemId() == 4 && (jdtBinding = prBinding.closestMatch()) != null && jdtBinding instanceof BinaryTypeBinding) {
            return jdtResolver.convertToClassNode(jdtBinding);
        }
        return null;
    }

    protected void checkPublicTypeNameMatchesFilename(TypeDeclaration typeDecl) {
    }

    protected void recordImportProblem(ImportReference importReference, Binding importBinding) {
    }

    protected void reportPackageIsNotExpectedPackage(CompilationUnitDeclaration compUnitDecl) {
        if (compUnitDecl != null && compUnitDecl.compilationResult != null && compUnitDecl.compilationResult.compilationUnit != null) {
            String actuallyIs;
            char[][] packageName = compUnitDecl.compilationResult.compilationUnit.getPackageName();
            String shouldBe = packageName == null ? "" : CharOperation.toString(packageName);
            String string = actuallyIs = compUnitDecl.currentPackage == null ? "" : CharOperation.toString(compUnitDecl.currentPackage.tokens);
            if (actuallyIs.length() > 0 && !shouldBe.equals(actuallyIs)) {
                this.problemReporter().packageIsNotExpectedPackage(compUnitDecl);
            }
        }
    }

    protected void checkParameterizedTypes() {
    }

    public boolean reportInvalidType(TypeReference typeReference, TypeBinding resolvedType) {
        ProblemReferenceBinding problemRefBinding;
        return resolvedType instanceof ProblemReferenceBinding && (problemRefBinding = (ProblemReferenceBinding)resolvedType).problemId() == 3;
    }

    protected void reportImportProblem(ImportReference importReference, Binding importBinding) {
        ProblemReferenceBinding problemRefBinding;
        if (importBinding instanceof ProblemReferenceBinding && (problemRefBinding = (ProblemReferenceBinding)importBinding).problemId() == 1) {
            return;
        }
        this.problemReporter().importProblem(importReference, importBinding);
    }

    public boolean canSeeEverything() {
        return true;
    }

    public boolean checkTargetCompatibility() {
        return false;
    }

    protected boolean canBeSeenBy(ReferenceBinding type, PackageBinding fPackage) {
        return true;
    }

    public boolean scannerAvailable() {
        return false;
    }

    public void setIsScript(boolean isScript) {
        this.isScript = isScript;
    }

    public boolean isScript() {
        return this.isScript;
    }

    public ReferenceBinding selectBinding(ReferenceBinding newlyFound, ReferenceBinding originallyFound, boolean isDeclaredImport) {
        if (isDeclaredImport && originallyFound.fPackage != null) {
            char[][] packageName = originallyFound.fPackage.compoundName;
            if (CharOperation.equals(javaLang, packageName) || CharOperation.equals(javaIo, packageName) || CharOperation.equals(javaNet, packageName) || CharOperation.equals(javaUtil, packageName) || CharOperation.equals(groovyLang, packageName) || CharOperation.equals(groovyUtil, packageName)) {
                return newlyFound;
            }
            return originallyFound;
        }
        return null;
    }
}

