/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.HashSet;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.core.search.TypeReferenceMatch;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.search.matching.JavaSearchPattern;
import org.eclipse.jdt.internal.core.search.matching.TypeReferencePattern;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jface.text.Position;

public class TypeReferenceSearchRequestor
implements ITypeRequestor {
    private final SearchRequestor requestor;
    private final SearchParticipant participant;
    private final String qualifier;
    private final String simpleName;
    private final boolean isCaseSensitive;
    private final boolean isCamelCase;
    private final Set<Position> acceptedPositions = new HashSet<Position>();
    private char[] cachedContents;

    public TypeReferenceSearchRequestor(TypeReferencePattern pattern, SearchRequestor requestor, SearchParticipant participant) {
        this.requestor = requestor;
        this.participant = participant;
        char[] arr = (char[])ReflectionUtils.getPrivateField(TypeReferencePattern.class, "simpleName", pattern);
        this.simpleName = arr == null ? "" : new String(arr);
        arr = (char[])ReflectionUtils.getPrivateField(TypeReferencePattern.class, "qualification", pattern);
        this.qualifier = arr == null || arr.length == 0 ? "" : String.valueOf(new String(arr)) + ".";
        this.isCaseSensitive = (Boolean)ReflectionUtils.getPrivateField(JavaSearchPattern.class, "isCaseSensitive", pattern);
        this.isCamelCase = (Boolean)ReflectionUtils.getPrivateField(JavaSearchPattern.class, "isCamelCase", pattern);
    }

    public ITypeRequestor.VisitStatus acceptASTNode(ASTNode node, TypeLookupResult result, IJavaElement enclosingElement) {
        if (node instanceof ClassExpression || node instanceof ClassNode || node instanceof ImportNode || node instanceof AnnotationNode) {
            String qualifiedName;
            ClassNode type = node instanceof ConstructorNode ? ((ConstructorNode)node).getDeclaringClass() : (node instanceof AnnotationNode ? ((AnnotationNode)node).getClassNode() : result.type);
            if (node instanceof ClassExpression && type == VariableScope.CLASS_CLASS_NODE) {
                type = ((ClassExpression)node).getType();
            }
            if (type != null && this.qualifiedNameMatches(qualifiedName = (type = this.removeArray(type)).getName()) && this.hasValidSourceLocation(node)) {
                Position position;
                int start = -1;
                int end = -1;
                boolean startEndFound = false;
                if (node instanceof ImportNode) {
                    end = node.getEnd();
                    start = node.getStart();
                } else if (node instanceof ClassExpression) {
                    end = node.getEnd();
                    start = node.getStart();
                } else if (node instanceof ClassNode) {
                    ClassNode classNode = (ClassNode)node;
                    if (classNode.getNameEnd() <= 0) {
                        if (classNode.redirect() == classNode) {
                            end = -1;
                            start = -1;
                            startEndFound = true;
                        } else {
                            classNode = this.maybeGetComponentType(classNode);
                            end = classNode.getEnd();
                            start = classNode.getStart();
                        }
                    }
                } else if (node instanceof ConstructorNode) {
                    start = ((ConstructorNode)node).getNameStart();
                    end = ((ConstructorNode)node).getNameEnd() + 1;
                    if (start == 0 && end == 1) {
                        end = -1;
                        start = -1;
                        startEndFound = true;
                    }
                } else if (node instanceof AnnotationNode) {
                    type = ((AnnotationNode)node).getClassNode();
                    end = type.getEnd();
                    start = type.getStart();
                }
                if (!startEndFound) {
                    StartEnd startEnd = this.getMatchLocation(type, enclosingElement, start, end);
                    if (startEnd != null) {
                        start = startEnd.start;
                        end = startEnd.end;
                    } else {
                        end = -1;
                        start = -1;
                    }
                }
                if (start >= 0 && end >= 0 && !this.acceptedPositions.contains(position = new Position(start, end - start))) {
                    TypeReferenceMatch match = new TypeReferenceMatch(enclosingElement, this.getAccuracy(result.confidence), start, end - start, false, this.participant, enclosingElement.getResource());
                    try {
                        this.requestor.acceptSearchMatch(match);
                        this.acceptedPositions.add(position);
                    }
                    catch (CoreException e) {
                        Util.log(e, "Error accepting search match for " + enclosingElement);
                    }
                }
            }
        }
        return ITypeRequestor.VisitStatus.CONTINUE;
    }

    private boolean hasValidSourceLocation(ASTNode node) {
        ASTNode astNodeWithSourceLocation = node instanceof ClassNode ? this.maybeGetComponentType((ClassNode)node) : node;
        return astNodeWithSourceLocation.getEnd() > 0;
    }

    private ClassNode maybeGetComponentType(ClassNode orig) {
        ClassNode componentType;
        if (orig.getComponentType() != null && (componentType = orig.getComponentType()).getColumnNumber() != -1) {
            return componentType;
        }
        return orig;
    }

    private ClassNode removeArray(ClassNode declaration) {
        return declaration.getComponentType() != null ? this.removeArray(declaration.getComponentType()) : declaration;
    }

    private boolean qualifiedNameMatches(String qualifiedName) {
        String newName = qualifiedName.replace('$', '.');
        if (!this.isCaseSensitive) {
            newName = newName.toLowerCase();
        }
        return newName.equals(String.valueOf(this.qualifier) + this.simpleName);
    }

    private StartEnd getMatchLocation(ClassNode node, IJavaElement elt, int maybeStart, int maybeEnd) {
        CompilationUnit unit = (CompilationUnit)elt.getAncestor(5);
        if (unit != null && this.cachedContents == null) {
            this.cachedContents = unit.getContents();
        }
        if (this.cachedContents != null) {
            int nameLength = maybeEnd - maybeStart;
            int start = -1;
            int end = -1;
            String name = node.getName();
            int dollarIndex = name.lastIndexOf(36);
            if ((name = name.substring(dollarIndex + 1)).length() <= nameLength) {
                start = CharOperation.indexOf(name.toCharArray(), this.cachedContents, true, maybeStart, maybeEnd + 1);
                end = start + name.length();
            }
            if (start == -1) {
                String nameWithoutPackage = node.getNameWithoutPackage();
                start = CharOperation.indexOf(nameWithoutPackage.toCharArray(), this.cachedContents, true, maybeStart, maybeEnd + 1);
                end = start + nameWithoutPackage.length();
            }
            if (start == -1) {
                return null;
            }
            return new StartEnd(start, end);
        }
        return new StartEnd(node.getStart(), node.getEnd());
    }

    private boolean shouldAlwaysBeAccurate() {
        return this.requestor.getClass().getPackage().getName().indexOf("refactoring") != -1;
    }

    private int getAccuracy(TypeLookupResult.TypeConfidence confidence) {
        if (this.shouldAlwaysBeAccurate()) {
            return 0;
        }
        switch (confidence) {
            case EXACT: {
                return 0;
            }
        }
        return 1;
    }

    private class StartEnd {
        final int start;
        final int end;

        StartEnd(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }
}

