/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.control;

import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.runtime.MetaClassHelper;

public class StaticImportVisitor
extends ClassCodeExpressionTransformer {
    private ClassNode currentClass;
    private MethodNode currentMethod;
    private SourceUnit source;
    private CompilationUnit compilationUnit;
    private boolean stillResolving;
    private boolean inSpecialConstructorCall;
    private boolean inClosure;
    private boolean inPropertyExpression;
    private Expression foundConstant;
    private Expression foundArgs;
    private boolean inAnnotation;
    private boolean inLeftExpression;

    public StaticImportVisitor(CompilationUnit cu) {
        this.compilationUnit = cu;
    }

    public void visitClass(ClassNode node, SourceUnit source) {
        this.currentClass = node;
        this.source = source;
        super.visitClass(node);
    }

    protected void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        this.currentMethod = node;
        super.visitConstructorOrMethod(node, isConstructor);
        this.currentMethod = null;
    }

    public void visitAnnotations(AnnotatedNode node) {
        boolean oldInAnnotation = this.inAnnotation;
        this.inAnnotation = true;
        super.visitAnnotations(node);
        this.inAnnotation = oldInAnnotation;
    }

    public Expression transform(Expression exp) {
        if (exp == null) {
            return null;
        }
        if (exp.getClass() == VariableExpression.class) {
            return this.transformVariableExpression((VariableExpression)exp);
        }
        if (exp.getClass() == BinaryExpression.class) {
            return this.transformBinaryExpression((BinaryExpression)exp);
        }
        if (exp.getClass() == PropertyExpression.class) {
            return this.transformPropertyExpression((PropertyExpression)exp);
        }
        if (exp.getClass() == MethodCallExpression.class) {
            return this.transformMethodCallExpression((MethodCallExpression)exp);
        }
        if (exp.getClass() == ClosureExpression.class) {
            return this.transformClosureExpression((ClosureExpression)exp);
        }
        if (exp.getClass() == ConstructorCallExpression.class) {
            return this.transformConstructorCallExpression((ConstructorCallExpression)exp);
        }
        if (exp.getClass() == ArgumentListExpression.class) {
            Expression result = exp.transformExpression(this);
            if (this.inPropertyExpression) {
                this.foundArgs = result;
            }
            return result;
        }
        if (exp instanceof ConstantExpression) {
            ConstantExpression ce;
            Expression result = exp.transformExpression(this);
            if (this.inPropertyExpression) {
                this.foundConstant = result;
            }
            if (this.inAnnotation && exp instanceof AnnotationConstantExpression && (ce = (ConstantExpression)result).getValue() instanceof AnnotationNode) {
                AnnotationNode an = (AnnotationNode)ce.getValue();
                Map<String, Expression> attributes = an.getMembers();
                for (Map.Entry<String, Expression> entry : attributes.entrySet()) {
                    Expression attrExpr = this.transform(entry.getValue());
                    entry.setValue(attrExpr);
                }
            }
            return result;
        }
        return exp.transformExpression(this);
    }

    private Expression transformMapEntryExpression(MapEntryExpression me, ClassNode constructorCallType) {
        ImportNode importNode;
        Map<String, ImportNode> importNodes;
        Expression key = me.getKeyExpression();
        Expression value = me.getValueExpression();
        ModuleNode module = this.currentClass.getModule();
        if (module != null && key instanceof ConstantExpression && (importNodes = module.getStaticImports()).containsKey(key.getText()) && (importNode = importNodes.get(key.getText())).getType().equals(constructorCallType)) {
            String newKey = importNode.getFieldName();
            return new MapEntryExpression(new ConstantExpression(newKey), value.transformExpression(this));
        }
        return me;
    }

    protected Expression transformBinaryExpression(BinaryExpression be) {
        Expression left;
        int type = be.getOperation().getType();
        Expression right = this.transform(be.getRightExpression());
        be.setRightExpression(right);
        if (type == 100) {
            boolean oldInLeftExpression = this.inLeftExpression;
            this.inLeftExpression = true;
            left = this.transform(be.getLeftExpression());
            this.inLeftExpression = oldInLeftExpression;
            if (left instanceof StaticMethodCallExpression) {
                StaticMethodCallExpression smce = (StaticMethodCallExpression)left;
                StaticMethodCallExpression result = new StaticMethodCallExpression(smce.getOwnerType(), smce.getMethod(), right);
                this.setSourcePosition(result, be);
                return result;
            }
        } else {
            left = this.transform(be.getLeftExpression());
        }
        be.setLeftExpression(left);
        return be;
    }

    protected Expression transformVariableExpression(VariableExpression ve) {
        Variable v = ve.getAccessedVariable();
        if (v != null && v instanceof DynamicVariable) {
            Expression result = this.findStaticFieldOrPropAccessorImportFromModule(v.getName());
            if (result != null) {
                this.setSourcePosition(result, ve);
                if (this.inAnnotation) {
                    result = this.transformInlineConstants(result);
                }
                return result;
            }
            if (!this.inPropertyExpression || this.inSpecialConstructorCall) {
                this.addStaticVariableError(ve);
            }
        }
        return ve;
    }

    private void setSourcePosition(Expression toSet, Expression origNode) {
        toSet.setSourcePosition(origNode);
        if (toSet instanceof PropertyExpression) {
            ((PropertyExpression)toSet).getProperty().setSourcePosition(origNode);
        }
    }

    private Expression transformInlineConstants(Expression exp) {
        if (exp instanceof PropertyExpression) {
            PropertyExpression pe = (PropertyExpression)exp;
            if (pe.getObjectExpression() instanceof ClassExpression) {
                ClassExpression ce = (ClassExpression)pe.getObjectExpression();
                ClassNode type = ce.getType();
                if (type.isEnum()) {
                    return exp;
                }
                Expression constant = this.findConstant(type.getField(pe.getPropertyAsString()));
                if (constant != null) {
                    return constant;
                }
            }
        } else if (exp instanceof ListExpression) {
            ListExpression le = (ListExpression)exp;
            ListExpression result = new ListExpression();
            for (Expression e : le.getExpressions()) {
                result.addExpression(this.transformInlineConstants(e));
            }
            return result;
        }
        return exp;
    }

    private Expression findConstant(FieldNode fn) {
        if (fn != null && !fn.isEnum() && fn.isStatic() && fn.isFinal() && fn.getInitialValueExpression() instanceof ConstantExpression) {
            return fn.getInitialValueExpression();
        }
        return null;
    }

    protected Expression transformMethodCallExpression(MethodCallExpression mce) {
        Expression args = this.transform(mce.getArguments());
        Expression method = this.transform(mce.getMethod());
        Expression object = this.transform(mce.getObjectExpression());
        boolean isExplicitThisOrSuper = false;
        if (object instanceof VariableExpression) {
            VariableExpression ve = (VariableExpression)object;
            isExplicitThisOrSuper = !mce.isImplicitThis() && (ve.getName().equals("this") || ve.getName().equals("super"));
            boolean isExplicitSuper = ve.getName().equals("super");
            if (isExplicitSuper && this.currentMethod != null && this.currentMethod.isStatic()) {
                this.addError("'super' cannot be used in a static context, use the explicit class instead.", mce);
                return mce;
            }
        }
        if (mce.isImplicitThis() || isExplicitThisOrSuper) {
            ConstantExpression ce;
            Object value;
            if (mce.isImplicitThis()) {
                String methodName;
                Expression ret = this.findStaticMethodImportFromModule(method, args);
                if (ret != null) {
                    this.setSourcePosition(ret, mce);
                    return ret;
                }
                if (method instanceof ConstantExpression && !this.inLeftExpression && (ret = this.findStaticFieldOrPropAccessorImportFromModule(methodName = (String)((ConstantExpression)method).getValue())) != null) {
                    ret = new MethodCallExpression(ret, "call", args);
                    this.setSourcePosition(ret, mce);
                    return ret;
                }
            }
            if (method instanceof ConstantExpression && (value = (ce = (ConstantExpression)method).getValue()) instanceof String) {
                boolean lookForPossibleStaticMethod;
                String methodName = (String)value;
                boolean bl = lookForPossibleStaticMethod = !methodName.equals("call");
                if (this.currentMethod != null && !this.currentMethod.isStatic() && this.currentClass.hasPossibleMethod(methodName, args)) {
                    lookForPossibleStaticMethod = false;
                }
                if (this.inSpecialConstructorCall || lookForPossibleStaticMethod && this.currentClass.hasPossibleStaticMethod(methodName, args)) {
                    StaticMethodCallExpression smce = new StaticMethodCallExpression(this.currentClass, methodName, args);
                    this.setSourcePosition(smce, mce);
                    return smce;
                }
            }
        }
        MethodCallExpression result = new MethodCallExpression(object, method, args);
        result.setSafe(mce.isSafe());
        result.setImplicitThis(mce.isImplicitThis());
        result.setSpreadSafe(mce.isSpreadSafe());
        this.setSourcePosition(result, mce);
        return result;
    }

    protected Expression transformConstructorCallExpression(ConstructorCallExpression cce) {
        TupleExpression tuple;
        this.inSpecialConstructorCall = cce.isSpecialCall();
        Expression expression = cce.getArguments();
        if (expression instanceof TupleExpression && (tuple = (TupleExpression)expression).getExpressions().size() == 1 && (expression = tuple.getExpression(0)) instanceof NamedArgumentListExpression) {
            NamedArgumentListExpression namedArgs = (NamedArgumentListExpression)expression;
            List<MapEntryExpression> entryExpressions = namedArgs.getMapEntryExpressions();
            int i = 0;
            while (i < entryExpressions.size()) {
                entryExpressions.set(i, (MapEntryExpression)this.transformMapEntryExpression(entryExpressions.get(i), cce.getType()));
                ++i;
            }
        }
        Expression ret = cce.transformExpression(this);
        this.inSpecialConstructorCall = false;
        return ret;
    }

    protected Expression transformClosureExpression(ClosureExpression ce) {
        boolean oldInClosure = this.inClosure;
        this.inClosure = true;
        Statement code = ce.getCode();
        if (code != null) {
            code.visit(this);
        }
        this.inClosure = oldInClosure;
        return ce;
    }

    protected Expression transformPropertyExpression(PropertyExpression pe) {
        Expression result;
        VariableExpression ve;
        boolean isExplicitSuper;
        boolean oldInPropertyExpression = this.inPropertyExpression;
        Expression oldFoundArgs = this.foundArgs;
        Expression oldFoundConstant = this.foundConstant;
        this.inPropertyExpression = true;
        this.foundArgs = null;
        this.foundConstant = null;
        Expression objectExpression = this.transform(pe.getObjectExpression());
        if (objectExpression instanceof VariableExpression && (isExplicitSuper = (ve = (VariableExpression)objectExpression).getName().equals("super")) && this.currentMethod != null && this.currentMethod.isStatic()) {
            this.addError("'super' cannot be used in a static context, use the explicit class instead.", pe);
            return null;
        }
        if (this.foundArgs != null && this.foundConstant != null && (result = this.findStaticMethodImportFromModule(this.foundConstant, this.foundArgs)) != null) {
            objectExpression = result;
        }
        this.inPropertyExpression = oldInPropertyExpression;
        this.foundArgs = oldFoundArgs;
        this.foundConstant = oldFoundConstant;
        pe.setObjectExpression(objectExpression);
        if (!this.inSpecialConstructorCall) {
            this.checkStaticScope(pe);
        }
        return pe;
    }

    private void checkStaticScope(PropertyExpression pe) {
        if (this.inClosure) {
            return;
        }
        Expression it = pe;
        while (it != null) {
            if (!(it instanceof PropertyExpression)) {
                if (it instanceof VariableExpression) {
                    this.addStaticVariableError((VariableExpression)it);
                }
                return;
            }
            it = it.getObjectExpression();
        }
    }

    private void addStaticVariableError(VariableExpression ve) {
        FieldNode fieldNode;
        if (!(this.inSpecialConstructorCall || !this.inClosure && ve.isInStaticContext())) {
            return;
        }
        if (this.stillResolving) {
            return;
        }
        if (ve.isThisExpression() || ve.isSuperExpression()) {
            return;
        }
        if (this.currentMethod != null && this.currentMethod.isStatic() && (fieldNode = this.currentMethod.getDeclaringClass().getField(ve.getName())) != null && fieldNode.isStatic()) {
            return;
        }
        Variable v = ve.getAccessedVariable();
        if (v != null && !(v instanceof DynamicVariable) && v.isInStaticContext()) {
            return;
        }
        this.addError("Apparent variable '" + ve.getName() + "' was found in a static scope but doesn't refer" + " to a local variable, static field or class. Possible causes:\n" + "You attempted to reference a variable in the binding or an instance variable from a static context.\n" + "You misspelled a classname or statically imported field. Please check the spelling.\n" + "You attempted to use a method '" + ve.getName() + "' but left out brackets in a place not allowed by the grammar.", ve);
    }

    private Expression findStaticFieldOrPropAccessorImportFromModule(String name) {
        Expression expression;
        ImportNode importNode2;
        ModuleNode module = this.currentClass.getModule();
        if (module == null) {
            return null;
        }
        Map<String, ImportNode> importNodes = module.getStaticImports();
        this.stillResolving = false;
        String accessorName = this.getAccessorName(name);
        if (importNodes.containsKey(accessorName)) {
            importNode2 = importNodes.get(accessorName);
            expression = this.findStaticPropertyAccessorByFullName(importNode2.getType(), importNode2.getFieldName());
            if (expression != null) {
                return expression;
            }
            expression = this.findStaticPropertyAccessor(importNode2.getType(), this.getPropNameForAccessor(importNode2.getFieldName()));
            if (expression != null) {
                return expression;
            }
        }
        if (accessorName.startsWith("get") && importNodes.containsKey(accessorName = "is" + accessorName.substring(3))) {
            importNode2 = importNodes.get(accessorName);
            expression = this.findStaticPropertyAccessorByFullName(importNode2.getType(), importNode2.getFieldName());
            if (expression != null) {
                return expression;
            }
            expression = this.findStaticPropertyAccessor(importNode2.getType(), this.getPropNameForAccessor(importNode2.getFieldName()));
            if (expression != null) {
                return expression;
            }
        }
        if (importNodes.containsKey(name)) {
            importNode2 = importNodes.get(name);
            expression = this.findStaticPropertyAccessor(importNode2.getType(), importNode2.getFieldName());
            if (expression != null) {
                return expression;
            }
            expression = this.findStaticField(importNode2.getType(), importNode2.getFieldName());
            if (expression != null) {
                return expression;
            }
        }
        for (ImportNode importNode2 : module.getStaticStarImports().values()) {
            ClassNode node = importNode2.getType();
            expression = this.findStaticPropertyAccessor(node, name);
            if (expression != null) {
                return expression;
            }
            expression = this.findStaticField(node, name);
            if (expression == null) continue;
            return expression;
        }
        return null;
    }

    private Expression findStaticMethodImportFromModule(Expression method, Expression args) {
        ClassNode starImportType;
        String propName;
        Expression expression;
        ModuleNode module = this.currentClass.getModule();
        if (module == null || !(method instanceof ConstantExpression)) {
            return null;
        }
        Map<String, ImportNode> importNodes = module.getStaticImports();
        ConstantExpression ce = (ConstantExpression)method;
        Object value = ce.getValue();
        if (!(value instanceof String)) {
            return null;
        }
        String name = (String)value;
        if (importNodes.containsKey(name)) {
            ImportNode importNode = importNodes.get(name);
            expression = this.findStaticMethod(importNode.getType(), importNode.getFieldName(), args);
            if (expression != null) {
                return expression;
            }
            expression = this.findStaticPropertyAccessorGivenArgs(importNode.getType(), this.getPropNameForAccessor(importNode.getFieldName()), args);
            if (expression != null) {
                return new StaticMethodCallExpression(importNode.getType(), importNode.getFieldName(), args);
            }
        }
        if (this.validPropName(name) && importNodes.containsKey(propName = this.getPropNameForAccessor(name))) {
            ImportNode importNode = importNodes.get(propName);
            expression = this.findStaticMethod(importNode.getType(), String.valueOf(this.prefix(name)) + MetaClassHelper.capitalize(importNode.getFieldName()), args);
            if (expression != null) {
                return expression;
            }
            expression = this.findStaticPropertyAccessorGivenArgs(importNode.getType(), importNode.getFieldName(), args);
            if (expression != null) {
                return new StaticMethodCallExpression(importNode.getType(), String.valueOf(this.prefix(name)) + MetaClassHelper.capitalize(importNode.getFieldName()), args);
            }
        }
        Map<String, ImportNode> starImports = module.getStaticStarImports();
        if (this.isEnum(this.currentClass) && starImports.containsKey(this.currentClass.getName())) {
            ImportNode importNode = starImports.get(this.currentClass.getName());
            starImportType = importNode == null ? null : importNode.getType();
            expression = this.findStaticMethod(starImportType, name, args);
            if (expression != null) {
                return expression;
            }
        } else {
            for (ImportNode importNode : starImports.values()) {
                starImportType = importNode == null ? null : importNode.getType();
                expression = this.findStaticMethod(starImportType, name, args);
                if (expression != null) {
                    return expression;
                }
                expression = this.findStaticPropertyAccessorGivenArgs(starImportType, this.getPropNameForAccessor(name), args);
                if (expression == null) continue;
                return new StaticMethodCallExpression(starImportType, name, args);
            }
        }
        return null;
    }

    private String prefix(String name) {
        return name.startsWith("is") ? "is" : name.substring(0, 3);
    }

    private String getPropNameForAccessor(String fieldName) {
        int prefixLength;
        int n = prefixLength = fieldName.startsWith("is") ? 2 : 3;
        if (fieldName.length() < prefixLength + 1) {
            return fieldName;
        }
        if (!this.validPropName(fieldName)) {
            return fieldName;
        }
        return String.valueOf(String.valueOf(fieldName.charAt(prefixLength)).toLowerCase()) + fieldName.substring(prefixLength + 1);
    }

    private boolean validPropName(String propName) {
        return propName.startsWith("get") || propName.startsWith("is") || propName.startsWith("set");
    }

    private String getAccessorName(String name) {
        return String.valueOf(this.inLeftExpression ? "set" : "get") + MetaClassHelper.capitalize(name);
    }

    private Expression findStaticPropertyAccessorGivenArgs(ClassNode staticImportType, String propName, Expression args) {
        return this.findStaticPropertyAccessor(staticImportType, propName);
    }

    private Expression findStaticPropertyAccessor(ClassNode staticImportType, String propName) {
        String accessorName = this.getAccessorName(propName);
        Expression accessor = this.findStaticPropertyAccessorByFullName(staticImportType, accessorName);
        if (accessor == null && accessorName.startsWith("get")) {
            accessor = this.findStaticPropertyAccessorByFullName(staticImportType, "is" + accessorName.substring(3));
        }
        if (accessor == null && this.hasStaticProperty(staticImportType, propName)) {
            accessor = this.inLeftExpression ? new StaticMethodCallExpression(staticImportType, accessorName, ArgumentListExpression.EMPTY_ARGUMENTS) : new PropertyExpression((Expression)new ClassExpression(staticImportType), propName);
        }
        return accessor;
    }

    private boolean hasStaticProperty(ClassNode staticImportType, String propName) {
        ClassNode classNode = staticImportType;
        while (classNode != null) {
            for (PropertyNode pn : classNode.getProperties()) {
                if (!pn.getName().equals(propName) || !pn.isStatic()) continue;
                return true;
            }
            classNode = classNode.getSuperClass();
        }
        return false;
    }

    private Expression findStaticPropertyAccessorByFullName(ClassNode staticImportType, String accessorMethodName) {
        ArgumentListExpression dummyArgs = new ArgumentListExpression();
        dummyArgs.addExpression(new EmptyExpression());
        return this.findStaticMethod(staticImportType, accessorMethodName, this.inLeftExpression ? dummyArgs : ArgumentListExpression.EMPTY_ARGUMENTS);
    }

    private Expression findStaticField(ClassNode staticImportType, String fieldName) {
        if (staticImportType.isPrimaryClassNode() || staticImportType.isResolved()) {
            staticImportType.getFields();
            FieldNode field = staticImportType.getField(fieldName);
            if (field != null && field.isStatic()) {
                return new PropertyExpression((Expression)new ClassExpression(staticImportType), fieldName);
            }
        } else {
            this.stillResolving = true;
        }
        return null;
    }

    private Expression findStaticMethod(ClassNode staticImportType, String methodName, Expression args) {
        if ((staticImportType.isPrimaryClassNode() || staticImportType.isResolved()) && staticImportType.hasPossibleStaticMethod(methodName, args)) {
            return new StaticMethodCallExpression(staticImportType, methodName, args);
        }
        return null;
    }

    protected SourceUnit getSourceUnit() {
        return this.source;
    }

    private boolean isEnum(ClassNode node) {
        return (node.getModifiers() & 0x4000) != 0;
    }
}

