/*
 * Decompiled with CFR 0.152.
 */
package griffon.builder.css;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;

public class CssClass {
    private static final String KEY_VALUE = "value";
    protected PropertyChangeSupport pcs;
    private List<String> classes = new ArrayList<String>();

    public CssClass() {
        this(new String[0]);
    }

    public CssClass(String ... cssclasses) {
        this.pcs = new PropertyChangeSupport(this);
        Collections.addAll(this.classes, cssclasses);
    }

    public boolean contains(String cssclass) {
        return this.classes.contains(cssclass);
    }

    public String toggle(String cssclass) {
        String oldValue = DefaultGroovyMethods.join(this.classes, (String)" ");
        if (this.contains(cssclass)) {
            this.classes = DefaultGroovyMethods.minus(this.classes, (Object)cssclass);
            this.firePropertyChange(KEY_VALUE, oldValue, DefaultGroovyMethods.join(this.classes, (String)" "));
        } else {
            this.classes.add(cssclass);
            this.firePropertyChange(KEY_VALUE, oldValue, DefaultGroovyMethods.join(this.classes, (String)" "));
        }
        return DefaultGroovyMethods.join(this.classes, (String)" ");
    }

    public String addAll(String ... cssclasses) {
        String oldValue = DefaultGroovyMethods.join(this.classes, (String)" ");
        boolean added = false;
        for (String cssclass : cssclasses) {
            if (this.contains(cssclass)) continue;
            added = true;
            this.classes.add(cssclass);
        }
        if (added) {
            this.firePropertyChange(KEY_VALUE, oldValue, DefaultGroovyMethods.join(this.classes, (String)" "));
        }
        return DefaultGroovyMethods.join(this.classes, (String)" ");
    }

    public String removeAll(String ... cssclasses) {
        String oldValue = DefaultGroovyMethods.join(this.classes, (String)" ");
        boolean removed = false;
        for (String cssclass : cssclasses) {
            if (!this.contains(cssclass)) continue;
            removed = true;
            this.classes.remove(cssclass);
        }
        if (removed) {
            this.firePropertyChange(KEY_VALUE, oldValue, DefaultGroovyMethods.join(this.classes, (String)" "));
        }
        return DefaultGroovyMethods.join(this.classes, (String)" ");
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.pcs.getPropertyChangeListeners(propertyName);
    }

    protected void firePropertyChange(PropertyChangeEvent event) {
        this.pcs.firePropertyChange(event);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CssClass cssClass = (CssClass)o;
        return ((Object)this.classes).equals(cssClass.classes);
    }

    public int hashCode() {
        return ((Object)this.classes).hashCode();
    }

    public String toString() {
        return DefaultGroovyMethods.join(this.classes, (String)" ");
    }
}

