/*
 * Decompiled with CFR 0.152.
 */
package griffon.builder.css;

import com.feature50.clarity.css.CSSPropertyHandlers;
import com.feature50.util.ArrayUtils;
import com.feature50.util.SwingUtils;
import com.steadystate.css.parser.CSSOMParser;
import griffon.builder.css.CSSBindings;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.awt.Container;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSDecorator {
    private static final Logger logger = Logger.getLogger(CSSDecorator.class.getName());
    private static final GroovyShell shell = new GroovyShell((Binding)CSSBindings.getInstance());

    public static void applyStyle(String style, Container root) {
        try {
            CSSDecorator.applyStylesheet(new InputSource((Reader)new StringReader(style)), SwingUtils.getAllJComponents(root));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, String.format("Couldn't apply stylesheet '%1$s'", style), e);
        }
    }

    public static void applyStyle(String style, List<JComponent> allComponents) {
        try {
            CSSDecorator.applyStylesheet(new InputSource((Reader)new StringReader(style)), allComponents);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, String.format("Couldn't apply stylesheet '%1$s'", style), e);
        }
    }

    public static void decorate(String cssName, Container root) {
        CSSDecorator.decorate(new String[]{cssName}, SwingUtils.getAllJComponents(root), null);
    }

    public static void decorate(String cssName, Container root, ClassLoader classLoader) {
        CSSDecorator.decorate(new String[]{cssName}, SwingUtils.getAllJComponents(root), classLoader);
    }

    public static void decorate(String cssName, List<JComponent> allComponents) {
        CSSDecorator.decorate(new String[]{cssName}, allComponents, null);
    }

    public static void decorate(String cssName, List<JComponent> allComponents, ClassLoader classLoader) {
        CSSDecorator.decorate(new String[]{cssName}, allComponents, classLoader);
    }

    public static void decorate(List<String> cssNames, Container root) {
        CSSDecorator.decorate(cssNames.toArray(new String[cssNames.size()]), SwingUtils.getAllJComponents(root), null);
    }

    public static void decorate(List<String> cssNames, Container root, ClassLoader classLoader) {
        CSSDecorator.decorate(cssNames.toArray(new String[cssNames.size()]), SwingUtils.getAllJComponents(root), classLoader);
    }

    public static void decorate(List<String> cssNames, List<JComponent> allComponents) {
        CSSDecorator.decorate(cssNames.toArray(new String[cssNames.size()]), allComponents, null);
    }

    public static void decorate(List<String> cssNames, List<JComponent> allComponents, ClassLoader classLoader) {
        CSSDecorator.decorate(cssNames.toArray(new String[cssNames.size()]), allComponents, classLoader);
    }

    public static void decorate(String[] cssNames, Container root) {
        CSSDecorator.decorate(cssNames, SwingUtils.getAllJComponents(root), null);
    }

    public static void decorate(String[] cssNames, Container root, ClassLoader classLoader) {
        CSSDecorator.decorate(cssNames, SwingUtils.getAllJComponents(root), classLoader);
    }

    public static void decorate(String[] cssNames, List<JComponent> allComponents) {
        CSSDecorator.decorate(cssNames, allComponents, null);
    }

    public static void decorate(String[] cssNames, List<JComponent> allComponents, ClassLoader classLoader) {
        if (ArrayUtils.isNullOrEmpty(cssNames)) {
            return;
        }
        if (classLoader == null) {
            classLoader = CSSDecorator.class.getClassLoader();
        }
        for (String cssName : cssNames) {
            InputStream in;
            if (!cssName.endsWith(".css")) {
                cssName = cssName + ".css";
            }
            if ((in = classLoader.getResourceAsStream(cssName)) == null) {
                logger.warning(String.format("Stylesheet '%1$s' not found", cssName));
                continue;
            }
            try {
                CSSDecorator.applyStylesheet(new InputSource((Reader)new InputStreamReader(in)), allComponents);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, String.format("Couldn't load stylesheet '%1$s'", cssName), e);
            }
        }
    }

    private static void applyStylesheet(InputSource is, List<JComponent> allComponents) throws IOException {
        CSSOMParser parser = new CSSOMParser();
        CSSStyleSheet stylesheet = parser.parseStyleSheet(is, null, null);
        CSSRuleList list = stylesheet.getCssRules();
        for (int k = 0; k < list.getLength(); ++k) {
            CSSStyleRule rule = (CSSStyleRule)list.item(k);
            String selector = rule.getSelectorText();
            JComponent[] components = SwingUtils.parseSelector(selector, allComponents);
            CSSStyleDeclaration style = rule.getStyle();
            for (int j = 0; j < style.getLength(); ++j) {
                boolean result;
                String value = style.getPropertyValue(style.item(j));
                if (value != null && value.contains("$")) {
                    Object output = shell.evaluate(value);
                    if (output != null) {
                        value = String.valueOf(output);
                    }
                    if (value.startsWith("\"")) {
                        value = value.substring(1);
                    }
                    if (value.endsWith("\"")) {
                        value = value.substring(0, value.length() - 2);
                    }
                }
                if (result = CSSPropertyHandlers.getInstance().handle(components, style.item(j), value)) continue;
                logger.warning(String.format("CSS property '%1$s' in selector '%2$s' not supported", style.item(j), selector));
            }
        }
    }
}

