/*
 * Decompiled with CFR 0.152.
 */
package com.feature50.util;

import com.feature50.util.StringUtils;
import griffon.builder.css.CssClass;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingUtils {
    private static final Logger logger = Logger.getLogger(SwingUtils.class.getName());

    public static List<JComponent> removeUnnamedComponents(Collection components) {
        ArrayList<JComponent> c = new ArrayList<JComponent>();
        for (JComponent component : components) {
            if (!StringUtils.notNullOrEmpty(component.getName())) continue;
            c.add(component);
        }
        return c;
    }

    public static List<JComponent> getAllJComponents(Container container) {
        ArrayList<JComponent> components = new ArrayList<JComponent>();
        SwingUtils.getAllJComponents(container, components);
        return components;
    }

    private static void getAllJComponents(Container container, Collection<JComponent> collection) {
        Component[] children;
        if (container instanceof JComponent) {
            JComponent c = (JComponent)container;
            collection.add(c);
        }
        if ((children = container.getComponents()) != null) {
            for (int i = 0; i < children.length; ++i) {
                Component c = children[i];
                if (!(c instanceof Container)) continue;
                SwingUtils.getAllJComponents((Container)c, collection);
            }
        }
    }

    public static JComponent getComponentByName(Container parent, String name) {
        List<JComponent> components = SwingUtils.getAllJComponents(parent);
        for (JComponent component : components) {
            if (!name.equals(component.getName())) continue;
            return component;
        }
        return null;
    }

    public static JComponent[] getComponentsByPattern(Container parent, Pattern pattern) {
        ArrayList<JComponent> results = new ArrayList<JComponent>();
        List<JComponent> components = SwingUtils.getAllJComponents(parent);
        for (JComponent component : components) {
            String name = component.getName();
            if (StringUtils.isNullOrEmpty(name) || !pattern.matcher(name).matches()) continue;
            results.add(component);
        }
        return results.toArray(new JComponent[0]);
    }

    public static JComponent[] parseSelector(String selector, List<JComponent> allComponents) {
        ArrayList comps = new ArrayList();
        String[] group = selector.split(",");
        for (int i = 0; i < group.length; ++i) {
            JComponent component;
            int j;
            String s = group[i].trim();
            String normalizedSelector = SwingUtils.normalizeSelector(s);
            ArrayList<SelectorElement> elements = new ArrayList<SelectorElement>();
            StringBuffer element = new StringBuffer();
            boolean add = false;
            boolean child = false;
            boolean sibling = false;
            for (int z = normalizedSelector.length() - 1; z >= -1; --z) {
                String[] temp;
                char c = z == -1 ? (char)' ' : (char)normalizedSelector.charAt(z);
                if (c == ' ') {
                    add = true;
                } else if (c == '+') {
                    add = true;
                    sibling = true;
                } else if (c == '>') {
                    add = true;
                    child = true;
                } else {
                    element.insert(0, c);
                }
                if (!add) continue;
                String e = element.toString();
                String pseudoClass = null;
                String type = null;
                String id = null;
                String clazz = null;
                if (e != null && e.indexOf(":") != -1) {
                    logger.warning(String.format("Pseudo classes not supported ('%1$s' uses one)", element));
                    temp = e.split(":");
                    e = temp[0];
                    pseudoClass = temp[1];
                }
                if (e != null && e.indexOf("[") != -1) {
                    logger.warning(String.format("Attribute selectors not supported ('%1$s' uses one)", element));
                    e = e.replaceAll("\\[.*\\]", "");
                }
                if (e != null && e.indexOf("#") != -1) {
                    temp = e.split("#");
                    e = StringUtils.notNullOrEmpty(temp[0]) ? temp[0] : null;
                    id = temp[1];
                }
                if (e != null && e.indexOf(".") != -1) {
                    temp = e.split("\\.");
                    e = StringUtils.notNullOrEmpty(temp[0]) ? temp[0] : null;
                    clazz = temp[1];
                }
                type = e;
                elements.add(new SelectorElement(child, sibling, false, id, clazz, type));
                element = new StringBuffer();
                sibling = false;
                child = false;
                add = false;
            }
            ArrayList<JComponent> selected = new ArrayList<JComponent>();
            for (j = 0; j < allComponents.size(); ++j) {
                component = allComponents.get(j);
                if (!SwingUtils.matches(component, (SelectorElement)elements.get(0))) continue;
                selected.add(component);
            }
            if (elements.size() > 1) {
                j = 0;
                while (j < selected.size()) {
                    component = (JComponent)selected.get(j);
                    boolean matched = false;
                    JComponent leftOff = component;
                    for (int q = 1; q < elements.size(); ++q) {
                        Container parent;
                        SelectorElement se = (SelectorElement)elements.get(q);
                        matched = false;
                        if (((SelectorElement)elements.get(q - 1)).sibling) {
                            if (leftOff.getParent() == null) break;
                            Component[] siblings = leftOff.getParent().getComponents();
                            boolean foundSibling = false;
                            for (int k = 0; k < siblings.length; ++k) {
                                if (!(siblings[k] instanceof JComponent) || !SwingUtils.matches((JComponent)siblings[k], se)) continue;
                                leftOff = (JComponent)siblings[k];
                                foundSibling = true;
                                break;
                            }
                            if (!foundSibling) {
                                break;
                            }
                        } else if (((SelectorElement)elements.get(q - 1)).child) {
                            if (leftOff.getParent() == null || !((parent = leftOff.getParent()) instanceof JComponent) || !SwingUtils.matches((JComponent)parent, se)) break;
                            leftOff = (JComponent)parent;
                        } else {
                            parent = leftOff.getParent();
                            boolean foundAncestor = false;
                            while (parent != null && parent instanceof JComponent) {
                                JComponent c = (JComponent)parent;
                                if (SwingUtils.matches(c, se)) {
                                    foundAncestor = true;
                                    leftOff = c;
                                    break;
                                }
                                parent = c.getParent();
                            }
                            if (!foundAncestor) break;
                        }
                        matched = true;
                    }
                    if (matched) {
                        ++j;
                        continue;
                    }
                    selected.remove(j);
                }
            }
            comps.addAll(selected);
        }
        return comps.toArray(new JComponent[0]);
    }

    private static boolean matches(JComponent component, SelectorElement element) {
        CssClass cssClass;
        if (element.id != null && !element.id.equals(component.getName())) {
            return false;
        }
        if (!(element.clazz == null || (cssClass = (CssClass)component.getClientProperty("clarity.class")) != null && cssClass.contains(element.clazz))) {
            return false;
        }
        if (element.type != null && !element.type.equals("*")) {
            boolean found = false;
            for (Class<?> c = component.getClass(); c != null; c = c.getSuperclass()) {
                if (!c.getSimpleName().equalsIgnoreCase(element.type)) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        }
        return true;
    }

    private static String normalizeSelector(String selector) {
        while (selector.indexOf("  ") != -1) {
            selector = selector.replaceAll("  ", " ");
        }
        selector = selector.replaceAll(" \\+ ", "\\+");
        selector = selector.replaceAll(" \\> ", "\\>");
        return selector;
    }

    private static class SelectorElement {
        private boolean child;
        private boolean sibling;
        private boolean exactType;
        private String id;
        private String clazz;
        private String type;

        public SelectorElement(boolean child, boolean sibling, boolean exactType, String id, String clazz, String type) {
            this.child = child;
            this.sibling = sibling;
            this.exactType = exactType;
            this.id = id;
            this.clazz = clazz;
            this.type = type;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("SelectorElement");
            sb.append("{child=").append(this.child);
            sb.append(", sibling=").append(this.sibling);
            sb.append(", exactType=").append(this.exactType);
            sb.append(", id='").append(this.id).append('\'');
            sb.append(", clazz='").append(this.clazz).append('\'');
            sb.append(", type='").append(this.type).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }
}

