/*
 * Decompiled with CFR 0.152.
 */
package com.feature50.util;

import com.feature50.util.ArrayUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class ReflectionUtils {
    private static final String[] PREFIXES_GETTER = new String[]{"get", "is", "has"};
    private static final String[] PREFIXES_SETTER = new String[]{"set"};

    public static boolean hasMethod(String methodName, Class[] args, Class baseClass, Class subClass) {
        Class currentClass = subClass;
        while (!currentClass.equals(baseClass)) {
            try {
                Method method = currentClass.getDeclaredMethod(methodName, args);
                if (method == null) continue;
                return true;
            }
            catch (NoSuchMethodException e) {
                currentClass = currentClass.getSuperclass();
            }
        }
        return false;
    }

    public static boolean hasMethod(String methodName, Class baseClass, Class subClass) {
        Class currentClass = subClass;
        while (!currentClass.equals(baseClass)) {
            Method[] methods = currentClass.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                String name = method.getName();
                if (!name.equals(methodName)) continue;
                return true;
            }
            currentClass = currentClass.getSuperclass();
        }
        return false;
    }

    public static Object invokeGetter(Object object, String field) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = ReflectionUtils.getGetterMethod(object.getClass(), field);
        return method.invoke(object, new Object[0]);
    }

    public static void invokeSetter(Object object, String field, Object value) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        block6: {
            method = null;
            if (value != null) {
                try {
                    method = ReflectionUtils.getSetterMethod(object.getClass(), field, value.getClass());
                }
                catch (NoSuchMethodException e) {
                    Class primitiveClass = ReflectionUtils.getPrimitiveType(value.getClass());
                    if (primitiveClass == null) break block6;
                    try {
                        method = ReflectionUtils.getSetterMethod(object.getClass(), field, primitiveClass);
                    }
                    catch (NoSuchMethodException e1) {
                        // empty catch block
                    }
                }
            }
        }
        if (method == null) {
            method = ReflectionUtils.getSetterMethod(object.getClass(), field);
        }
        method.invoke(object, value);
    }

    public static Method getGetterMethod(Class type, String property) throws NoSuchMethodException {
        String getName = ReflectionUtils.getEtterMethodName(property, "get");
        try {
            return type.getMethod(getName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                getName = ReflectionUtils.getEtterMethodName(property, "is");
                return type.getMethod(getName, new Class[0]);
            }
            catch (Exception e1) {
                throw new NoSuchMethodException("No getter found for property '" + property + "' using 'is', 'has', and 'get' prefixes");
            }
        }
    }

    public static String getEtterMethodName(String property, String type) {
        return type + property.substring(0, 1).toUpperCase() + property.substring(1);
    }

    public static Method getSetterMethod(Class type, String property) throws NoSuchMethodException {
        String setterName = ReflectionUtils.getEtterMethodName(property, "set");
        Method setterMethod = null;
        Method[] methods = type.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equals(setterName)) continue;
            if (setterMethod != null) {
                throw new IllegalStateException(String.format("Type '%1$s' has more than one method named '%2$s'; use getSetterMethod(Class, String, Class) to obtain the right one", type, setterName));
            }
            setterMethod = method;
        }
        if (setterMethod == null) {
            throw new NoSuchMethodException(String.format("No setter method for property '%1$s'", property));
        }
        return setterMethod;
    }

    public static Method getSetterMethod(Class type, String property, Class ... parameters) throws NoSuchMethodException {
        String setterName = ReflectionUtils.getEtterMethodName(property, "set");
        return type.getMethod(setterName, parameters);
    }

    public static Class getPrimitiveType(Class wrapperType) {
        if (Boolean.class.equals((Object)wrapperType)) {
            return Boolean.TYPE;
        }
        if (Float.class.equals((Object)wrapperType)) {
            return Float.TYPE;
        }
        if (Double.class.equals((Object)wrapperType)) {
            return Double.TYPE;
        }
        if (Integer.class.equals((Object)wrapperType)) {
            return Integer.TYPE;
        }
        if (Long.class.equals((Object)wrapperType)) {
            return Long.TYPE;
        }
        if (Short.class.equals((Object)wrapperType)) {
            return Short.TYPE;
        }
        if (Byte.class.equals((Object)wrapperType)) {
            return Byte.TYPE;
        }
        if (Character.class.equals((Object)wrapperType)) {
            return Character.TYPE;
        }
        return null;
    }

    public static String getFormattedNameForField(String field) {
        StringBuffer sb = new StringBuffer();
        sb.append(Character.toUpperCase(field.charAt(0)));
        for (int i = 1; i < field.length(); ++i) {
            char c = field.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append(" ");
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static Method[] getGetterMethods(Class type) {
        Method[] methods = ReflectionUtils.getEtterMethods(type, "get");
        ArrayList<Method> list = new ArrayList<Method>();
        for (int i = 0; i < methods.length; ++i) {
            if (!ArrayUtils.isNullOrEmpty(methods[i].getParameterTypes())) continue;
            list.add(methods[i]);
        }
        return list.toArray(new Method[0]);
    }

    private static Method[] getEtterMethods(Class type, String prefix) {
        Method[] methods = type.getMethods();
        ArrayList<Method> etters = new ArrayList<Method>();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String name = method.getName();
            if (!name.startsWith(prefix) || name.length() <= 3 || !Character.isUpperCase(name.charAt(3)) || !ReflectionUtils.hasMethod(method.getName(), method.getParameterTypes(), type instanceof Object ? Object.class : type.getSuperclass(), type)) continue;
            etters.add(method);
        }
        return etters.toArray(new Method[0]);
    }

    public static String getPropertyFromEtter(Method method) {
        return ReflectionUtils.getPropertyFromEtter(method.getName());
    }

    public static String getPropertyFromEtter(String name) {
        int i;
        for (i = 0; i < PREFIXES_GETTER.length; ++i) {
            if (!name.startsWith(PREFIXES_GETTER[i])) continue;
            return Character.toLowerCase(name.charAt(PREFIXES_GETTER[i].length())) + name.substring(PREFIXES_GETTER[i].length() + 1);
        }
        for (i = 0; i < PREFIXES_SETTER.length; ++i) {
            if (!name.startsWith(PREFIXES_SETTER[i])) continue;
            return Character.toLowerCase(name.charAt(PREFIXES_SETTER[i].length())) + name.substring(PREFIXES_SETTER[i].length() + 1);
        }
        return null;
    }
}

