/*
 * Decompiled with CFR 0.152.
 */
package com.feature50.clarity.css;

import com.feature50.clarity.css.CSSPropertyHandler;
import com.feature50.clarity.css.CSSUtils;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;

public class DefaultCSSPropertyHandler
implements CSSPropertyHandler {
    private static final Logger logger = Logger.getLogger(DefaultCSSPropertyHandler.class.getName());

    public void processStyles(JComponent[] selected, String propertyName, String propertyValue) {
        block4: for (int i = 0; i < selected.length; ++i) {
            Color c;
            int j;
            JComponent component = selected[i];
            if (propertyName.equalsIgnoreCase("font-family")) {
                String[] fonts = propertyValue.split(",");
                for (j = 0; j < fonts.length; ++j) {
                    String font = fonts[j].trim();
                    String[] strings = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
                    boolean found = false;
                    for (int k = 0; k < strings.length; ++k) {
                        if (!strings[k].equalsIgnoreCase(font)) continue;
                        Font f = component.getFont();
                        component.setFont(new Font(strings[k], f.getStyle(), f.getSize()));
                        found = true;
                        break;
                    }
                    if (found) continue block4;
                }
                continue;
            }
            if (propertyName.equalsIgnoreCase("font-size")) {
                int size = -1;
                for (j = 0; j < CSSUtils.FONT_ABSOLUTE_SIZE_NAMES.length; ++j) {
                    if (!CSSUtils.FONT_ABSOLUTE_SIZE_NAMES[j].equalsIgnoreCase(propertyValue)) continue;
                    size = CSSUtils.FONT_ABSOLUTE_SIZE_VALUES[j];
                    break;
                }
                if (size == -1) {
                    if (propertyValue.equals("smaller")) {
                        Container c2 = component.getParent();
                        int ps = c2.getFont().getSize();
                        size = ps--;
                    } else if (propertyValue.equals("larger")) {
                        Container c3 = component.getParent();
                        int ps = c3.getFont().getSize();
                        size = ps++;
                    }
                }
                if (size == -1 && propertyValue.endsWith("%")) {
                    Container c4 = component.getParent();
                    int ps = c4.getFont().getSize();
                    String perc = propertyValue.substring(0, propertyValue.length() - 1);
                    int p = 100;
                    try {
                        p = Double.valueOf(perc).intValue();
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, String.format("font-size value ('%1$s') was an invalid percentage", propertyValue), e);
                    }
                    float factor = (float)p / 100.0f;
                    size = Math.round((float)ps * factor);
                }
                if (size == -1) {
                    String s = propertyValue;
                    if (propertyValue.endsWith("pt")) {
                        s = propertyValue.substring(0, propertyValue.length() - 2);
                    }
                    try {
                        size = Double.valueOf(s).intValue();
                    }
                    catch (NumberFormatException e) {
                        logger.log(Level.WARNING, String.format("font-size value ('%1$s') not supported; 'pt' is the only supported length and is implicit", propertyValue), e);
                    }
                }
                Font f = component.getFont();
                component.setFont(f.deriveFont((float)size));
                continue;
            }
            if (propertyName.equalsIgnoreCase("font-weight")) {
                int style;
                if (propertyValue.equalsIgnoreCase("normal")) {
                    style = 0;
                } else if (propertyValue.equalsIgnoreCase("bold")) {
                    style = 1;
                } else {
                    logger.warning(String.format("font-weight value ('%1$s') unsupported", propertyValue));
                    continue;
                }
                Font f = component.getFont();
                if (f.getStyle() == 2) {
                    if (style != true) continue;
                    style = 3;
                }
                if (f.getStyle() == 2 && style == 0) continue;
                component.setFont(f.deriveFont(style));
                continue;
            }
            if (propertyName.equalsIgnoreCase("font-style")) {
                int style;
                if (propertyValue.equalsIgnoreCase("normal")) {
                    style = 0;
                } else if (propertyValue.equalsIgnoreCase("italic")) {
                    style = 2;
                } else {
                    logger.warning(String.format("font-weight value ('%1$s') unsupported", propertyValue));
                    continue;
                }
                Font f = component.getFont();
                if (f.getStyle() == 1) {
                    if (style != 2) continue;
                    style = 3;
                }
                component.setFont(f.deriveFont(style));
                continue;
            }
            if (propertyName.equalsIgnoreCase("color")) {
                c = CSSUtils.getColor("color", propertyValue);
                component.setForeground(c);
                continue;
            }
            if (!propertyName.equalsIgnoreCase("background-color")) continue;
            c = CSSUtils.getColor("background-color", propertyValue);
            component.setBackground(c);
        }
    }

    public String[] getPropertyNames() {
        return new String[]{"font-family", "font-size", "font-weight", "font-style", "color", "background-color"};
    }
}

