/*
 * Decompiled with CFR 0.152.
 */
package com.feature50.clarity.css;

import com.feature50.clarity.css.CSSPropertyHandler;
import com.feature50.clarity.css.DefaultCSSPropertyHandler;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class CSSPropertyHandlers {
    private static CSSPropertyHandlers instance;
    private List<CSSPropertyHandler> handlers = new ArrayList<CSSPropertyHandler>();

    private CSSPropertyHandlers() {
        this.addHandler(new DefaultCSSPropertyHandler());
    }

    public boolean handle(JComponent[] components, String property, String value) {
        boolean processed = false;
        for (int i = 0; i < this.handlers.size(); ++i) {
            CSSPropertyHandler h = this.handlers.get(i);
            for (int j = 0; j < h.getPropertyNames().length; ++j) {
                String name = h.getPropertyNames()[j];
                if (!property.equals(name)) continue;
                processed = true;
                h.processStyles(components, property, value);
            }
        }
        return processed;
    }

    public void addHandler(CSSPropertyHandler handler) {
        this.handlers.add(handler);
    }

    public void removeHandler(CSSPropertyHandler handler) {
        this.handlers.remove(handler);
    }

    public static synchronized CSSPropertyHandlers getInstance() {
        if (instance == null) {
            instance = new CSSPropertyHandlers();
        }
        return instance;
    }
}

