/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmavenplus.mojo;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.codehaus.gmavenplus.mojo.AbstractGroovyMojo;

public abstract class AbstractGroovySourcesMojo
extends AbstractGroovyMojo {
    protected static final String MAIN = "main";
    protected static final String TEST = "test";
    @Parameter
    protected FileSet[] sources;
    @Parameter
    protected FileSet[] testSources;
    @Parameter(property="maven.test.skip", defaultValue="false")
    protected boolean skipTests;
    @Parameter(defaultValue="false")
    protected boolean useSharedClassLoader;

    protected FileSet[] getSourceRoots(boolean includeJavaSources) {
        return this.getFilesets(this.sources, MAIN, includeJavaSources);
    }

    protected FileSet[] getSourceRoots() {
        return this.getFilesets(this.sources, MAIN, false);
    }

    protected Set<File> getSources(boolean includeJavaSources) {
        return this.getFiles(this.sources, MAIN, includeJavaSources);
    }

    protected Set<File> getSources() {
        return this.getFiles(this.sources, MAIN, false);
    }

    protected FileSet[] getTestSourceRoots(boolean includeJavaSources) {
        return this.getFilesets(this.testSources, TEST, includeJavaSources);
    }

    protected FileSet[] getTestSourceRoots() {
        return this.getFilesets(this.testSources, TEST, false);
    }

    protected Set<File> getTestSources(boolean includeJavaSources) {
        return this.getFiles(this.testSources, TEST, includeJavaSources);
    }

    protected Set<File> getTestSources() {
        return this.getFiles(this.testSources, TEST, false);
    }

    protected Set<File> getFiles(FileSet[] fromSources, String defaultSourceDirectory, boolean includeJavaSources) {
        HashSet<File> files = new HashSet<File>();
        FileSetManager fileSetManager = new FileSetManager(this.getLog());
        for (FileSet fileSet : this.getFilesets(fromSources, defaultSourceDirectory, includeJavaSources)) {
            for (String include : fileSetManager.getIncludedFiles(fileSet)) {
                files.add(new File(fileSet.getDirectory(), include));
            }
        }
        return files;
    }

    protected FileSet[] getFilesets(FileSet[] fromSources, String defaultSubDirectory, boolean includeJavaSources) {
        FileSet[] result;
        FileSet[] groovyFileSets;
        if (fromSources != null) {
            groovyFileSets = fromSources;
        } else {
            FileSet groovyFileSet = new FileSet();
            String groovyDirectory = "src" + File.separator + defaultSubDirectory + File.separator + "groovy";
            groovyFileSet.setDirectory(this.project.getBasedir() + File.separator + (String)groovyDirectory);
            groovyFileSet.setIncludes(Collections.singletonList(GROOVY_SOURCES_PATTERN));
            groovyFileSets = new FileSet[]{groovyFileSet};
        }
        if (includeJavaSources) {
            ArrayList<FileSet> javaFileSets = new ArrayList<FileSet>();
            if (TEST.equals(defaultSubDirectory)) {
                for (Object sourceRoot : this.project.getTestCompileSourceRoots()) {
                    FileSet javaFileSet = new FileSet();
                    javaFileSet.setDirectory((String)sourceRoot);
                    javaFileSet.setIncludes(Collections.singletonList(JAVA_SOURCES_PATTERN));
                    javaFileSets.add(javaFileSet);
                }
            } else {
                for (Object sourceRoot : this.project.getCompileSourceRoots()) {
                    FileSet javaFileSet = new FileSet();
                    javaFileSet.setDirectory((String)sourceRoot);
                    javaFileSet.setIncludes(Collections.singletonList(JAVA_SOURCES_PATTERN));
                    javaFileSets.add(javaFileSet);
                }
            }
            FileSet[] javaFileSetsArr = javaFileSets.toArray(new FileSet[0]);
            result = Arrays.copyOf(groovyFileSets, groovyFileSets.length + javaFileSetsArr.length);
            System.arraycopy(javaFileSetsArr, 0, result, groovyFileSets.length, javaFileSetsArr.length);
        } else {
            result = groovyFileSets;
        }
        return result;
    }
}

