/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmavenplus.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.gmavenplus.model.Version;

public class ClassWrangler {
    protected String groovyVersion = null;
    protected ClassLoader classLoader;
    protected Log log;

    public ClassWrangler(ClassLoader classLoaderForLoading, Log pluginLog) {
        this.log = pluginLog;
        this.classLoader = classLoaderForLoading;
    }

    public ClassWrangler(List classpath, Log pluginLog) throws MalformedURLException {
        this.log = pluginLog;
        this.classLoader = this.createNewClassLoader(classpath);
        Thread.currentThread().setContextClassLoader(this.classLoader);
    }

    public String getGroovyVersionString() {
        if (this.groovyVersion == null) {
            String jar = this.getGroovyJar();
            int idx = Integer.MAX_VALUE;
            for (int i = 0; i < 9; ++i) {
                int newIdx = jar.indexOf("-" + i);
                if (newIdx < 0 || newIdx >= idx) continue;
                idx = newIdx;
            }
            if (idx < Integer.MAX_VALUE) {
                this.groovyVersion = jar.substring(idx + 1, jar.length() - 4);
            }
        }
        return this.groovyVersion;
    }

    public Version getGroovyVersion() {
        try {
            return Version.parseFromString(this.getGroovyVersionString().replace("-indy", ""));
        }
        catch (Exception e) {
            this.log.error((CharSequence)"Unable to determine Groovy version.  Is Groovy declared as a dependency?");
            return null;
        }
    }

    public boolean isGroovyIndy() {
        return this.getGroovyVersionString().contains("-indy");
    }

    public String getGroovyJar() {
        try {
            String groovyObjectClassPath = this.getJarPath();
            String groovyJar = null;
            if (groovyObjectClassPath != null) {
                groovyJar = groovyObjectClassPath.replaceAll("!.+", "");
                groovyJar = groovyJar.substring(groovyJar.lastIndexOf("/") + 1, groovyJar.length());
            }
            return groovyJar;
        }
        catch (ClassNotFoundException e) {
            this.log.error((CharSequence)"Unable to determine Groovy version.  Is Groovy declared as a dependency?");
            return null;
        }
    }

    protected String getJarPath() throws ClassNotFoundException {
        CodeSource codeSource;
        Class<?> groovyObjectClass = Class.forName("groovy.lang.GroovyObject", true, this.classLoader);
        String groovyObjectClassPath = String.valueOf(groovyObjectClass.getResource("/" + groovyObjectClass.getName().replace('.', '/') + ".class"));
        if (groovyObjectClassPath == null && (codeSource = groovyObjectClass.getProtectionDomain().getCodeSource()) != null) {
            groovyObjectClassPath = String.valueOf(codeSource.getLocation());
        }
        return groovyObjectClassPath;
    }

    public void logGroovyVersion(String goal) {
        if (this.log.isInfoEnabled()) {
            this.log.info((CharSequence)("Using Groovy " + this.getGroovyVersionString() + " to perform " + goal + "."));
        }
    }

    public ClassLoader createNewClassLoader(List classpath) throws MalformedURLException {
        ArrayList<URL> urlsList = new ArrayList<URL>();
        for (Object classPathObject : classpath) {
            String path = (String)classPathObject;
            urlsList.add(new File(path).toURI().toURL());
        }
        URL[] urlsArray = urlsList.toArray(new URL[urlsList.size()]);
        return new URLClassLoader(urlsArray, ClassLoader.getSystemClassLoader());
    }

    public Class getClass(String className) throws ClassNotFoundException {
        return Class.forName(className, true, this.classLoader);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

