/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven2;

import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.maven2.AbstractCargoMojo;

public class ContainerStartMojo
extends AbstractCargoMojo {
    protected LocalContainer localContainer;

    @Override
    public void doExecute() throws MojoExecutionException {
        Container container = this.createContainer();
        if (!container.getType().isLocal()) {
            throw new MojoExecutionException("Only local containers can be started");
        }
        this.localContainer = (LocalContainer)container;
        this.addAutoDeployDeployable(this.localContainer);
        try {
            this.executeLocalContainerAction();
            this.waitDeployableMonitor((Container)this.localContainer, true);
        }
        catch (Throwable t1) {
            this.getLog().error((CharSequence)("Starting container [" + this.localContainer + "] failed, now stopping container"));
            try {
                this.localContainer.stop();
            }
            catch (Throwable t2) {
                this.getLog().debug((CharSequence)("Stopping container [" + this.localContainer + "] failed"), t2);
            }
            throw new MojoExecutionException("Cannot start container [" + this.localContainer + "]", t1);
        }
    }

    protected void executeLocalContainerAction() {
        this.localContainer.start();
    }

    protected void addAutoDeployDeployable(LocalContainer container) throws MojoExecutionException {
        if (this.getDeployerElement() == null && this.getCargoProject().getPackaging() != null && this.getCargoProject().isJ2EEPackaging() && (this.getDeployablesElement() == null || !this.containsAutoDeployable(this.getDeployablesElement()))) {
            LocalConfiguration configuration = container.getConfiguration();
            configuration.addDeployable(this.createAutoDeployDeployable((Container)container));
        }
    }
}

