/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven2.configuration;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Properties;

public class Proxy {
    private String host;
    private int port = 80;
    private String user;
    private String password;
    private String excludeHosts = "";

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setExcludeHosts(String proxyExcludeHosts) {
        this.excludeHosts = proxyExcludeHosts;
    }

    public String getExcludeHosts() {
        return this.excludeHosts;
    }

    public void configure() {
        if (this.getHost() != null && this.getHost().trim().length() > 0) {
            Properties sysprops = System.getProperties();
            String portString = Integer.toString(this.getPort());
            sysprops.put("http.proxyHost", this.getHost());
            sysprops.put("http.proxyPort", portString);
            sysprops.put("https.proxyHost", this.getHost());
            sysprops.put("https.proxyPort", portString);
            sysprops.put("ftp.proxyHost", this.getHost());
            sysprops.put("ftp.proxyPort", portString);
            if (this.getExcludeHosts() != null) {
                sysprops.put("http.nonProxyHosts", this.getExcludeHosts());
                sysprops.put("https.nonProxyHosts", this.getExcludeHosts());
                sysprops.put("ftp.nonProxyHosts", this.getExcludeHosts());
            }
            if (this.getUser() != null) {
                sysprops.put("http.proxyUser", this.getUser());
                sysprops.put("http.proxyPassword", this.getPassword());
                Authenticator.setDefault(new ProxyAuthenticator(this.getUser(), this.getPassword()));
            }
        }
    }

    public void clear() {
        Properties sysprops = System.getProperties();
        sysprops.remove("http.proxyHost");
        sysprops.remove("http.proxyPort");
        sysprops.remove("http.proxyUser");
        sysprops.remove("http.proxyPassword");
        sysprops.remove("https.proxyHost");
        sysprops.remove("https.proxyPort");
        sysprops.remove("ftp.proxyHost");
        sysprops.remove("ftp.proxyPort");
        Authenticator.setDefault(new ProxyAuthenticator("", ""));
    }

    private static final class ProxyAuthenticator
    extends Authenticator {
        private PasswordAuthentication authentication;

        private ProxyAuthenticator(String user, String pass) {
            this.authentication = new PasswordAuthentication(user, pass.toCharArray());
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return this.authentication;
        }
    }
}

