/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven2;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.maven2.AbstractCargoMojo;
import org.codehaus.cargo.maven2.configuration.Deployable;
import org.codehaus.cargo.tools.daemon.DaemonClient;

public abstract class AbstractDaemonMojo
extends AbstractCargoMojo {
    protected DaemonClient daemonClient = null;
    protected String daemonHandleId = null;
    protected final List<org.codehaus.cargo.container.deployable.Deployable> daemonDeployables = new ArrayList<org.codehaus.cargo.container.deployable.Deployable>();
    protected InstalledLocalContainer daemonContainer;

    public void doExecute() throws MojoExecutionException {
        this.getCargoProject().setDaemonRun(true);
        if (!(this.getCargoProject().getPackaging() != null && this.getCargoProject().isJ2EEPackaging() || this.getDeployablesElement() != null && this.getDeployablesElement().length != 0)) {
            this.getLog().info((CharSequence)"There's nothing to deploy or undeploy");
            return;
        }
        Container container = this.createContainer();
        if (!(container instanceof InstalledLocalContainer)) {
            throw new MojoExecutionException("Container must be of INSTALLED type.");
        }
        String daemonURL = this.getDaemonProperty("cargo.daemon.url");
        String daemonHandleId = this.getDaemonProperty("cargo.daemon.handleid");
        if (daemonURL == null || daemonURL.length() == 0) {
            throw new MojoExecutionException("Missing daemon URL property.");
        }
        if (daemonHandleId == null || daemonHandleId.length() == 0) {
            throw new MojoExecutionException("Missing daemon handle id property.");
        }
        try {
            this.daemonClient = new DaemonClient(new URL(daemonURL));
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Malformed daemon URL: " + e);
        }
        this.daemonHandleId = daemonHandleId;
        this.daemonContainer = (InstalledLocalContainer)container;
        this.createDeployables(container);
        this.performAction();
    }

    protected abstract void performAction() throws MojoExecutionException;

    private void createDeployables(Container container) throws MojoExecutionException {
        ArrayList<Deployable> deployableElements = new ArrayList<Deployable>();
        if (this.getDeployablesElement() != null) {
            for (Deployable deployableElement : this.getDeployablesElement()) {
                if (deployableElements.contains(deployableElement)) continue;
                deployableElements.add(deployableElement);
            }
        }
        for (Deployable deployableElement : deployableElements) {
            org.codehaus.cargo.container.deployable.Deployable deployable = deployableElement.createDeployable(container.getId(), this.getCargoProject());
            URL pingURL = deployableElement.getPingURL();
            Long pingTimeout = deployableElement.getPingTimeout();
            this.addDeployable(deployable, pingURL, pingTimeout);
        }
        if (this.getCargoProject().getPackaging() != null && this.getCargoProject().isJ2EEPackaging()) {
            Deployable[] deployableElementsArray = new Deployable[deployableElements.size()];
            deployableElements.toArray(deployableElementsArray);
            if (!this.containsAutoDeployable(deployableElementsArray)) {
                this.addDeployable(this.createAutoDeployDeployable(container), null, null);
            }
        }
    }

    private void addDeployable(org.codehaus.cargo.container.deployable.Deployable deployable, URL pingURL, Long pingTimeout) {
        this.daemonDeployables.add(deployable);
    }
}

