/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven2.util;

import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CargoProject {
    private Log log;
    private String packaging;
    private String groupId;
    private String artifactId;
    private String buildDirectory;
    private String finalName;
    private Set<Artifact> artifacts;
    private ClassLoader embeddedClassLoader;

    public CargoProject(String packaging, String groupId, String artifactId, String buildDirectory, String finalName, Set<Artifact> artifacts, Log log) {
        this.log = log;
        this.packaging = packaging;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.buildDirectory = buildDirectory;
        this.finalName = finalName;
        this.artifacts = artifacts;
    }

    public CargoProject(MavenProject project, Log log) {
        this(project.getPackaging(), project.getGroupId(), project.getArtifactId(), project.getBuild().getDirectory(), project.getBuild().getFinalName(), project.getArtifacts(), log);
    }

    public String getPackaging() {
        return this.packaging;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getBuildDirectory() {
        return this.buildDirectory;
    }

    public String getFinalName() {
        return this.finalName;
    }

    public Set<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public Log getLog() {
        return this.log;
    }

    public boolean isJ2EEPackaging() {
        boolean result = false;
        if (this.getPackaging().equalsIgnoreCase("war")) {
            result = true;
        } else if (this.getPackaging().equalsIgnoreCase("ear")) {
            result = true;
        } else if (this.getPackaging().equalsIgnoreCase("ejb")) {
            result = true;
        } else if (this.getPackaging().equalsIgnoreCase("uberwar")) {
            result = true;
        } else if (this.getPackaging().equalsIgnoreCase("rar")) {
            result = true;
        } else if (this.getPackaging().equalsIgnoreCase("bundle")) {
            result = true;
        }
        return result;
    }

    public void setEmbeddedClassLoader(ClassLoader classLoader) {
        this.embeddedClassLoader = classLoader;
    }

    public ClassLoader getEmbeddedClassLoader() {
        return this.embeddedClassLoader;
    }
}

