/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.maven.jacoco;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codefilarete.maven.jacoco.AbstractReportMojo;
import org.codefilarete.maven.jacoco.FileFilter;
import org.codefilarete.maven.jacoco.ReportSupport;
import org.jacoco.report.IReportGroupVisitor;

@Mojo(name="report-aggregate", threadSafe=true)
public class ReportAggregateMojo
extends AbstractReportMojo {
    @Parameter
    List<String> dataFileIncludes;
    @Parameter
    List<String> dataFileExcludes;
    @Parameter(defaultValue="${project.reporting.outputDirectory}/jacoco-aggregate")
    private File outputDirectory;
    @Parameter(property="reactorProjects", readonly=true)
    private List<MavenProject> reactorProjects;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;

    @Override
    public boolean canGenerateReport() {
        boolean canGenerateReport = super.canGenerateReport();
        if (canGenerateReport) {
            if (this.shouldDelayExecution()) {
                this.getLog().info((CharSequence)"Delaying Report Generation to the end of multi-module project");
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean shouldDelayExecution() {
        return !this.session.getCurrentProject().isExecutionRoot();
    }

    @Override
    void loadExecutionData(ReportSupport support) throws IOException {
        if (this.dataFileIncludes == null) {
            this.dataFileIncludes = Arrays.asList("target/*.exec");
        }
        FileFilter filter = new FileFilter(this.dataFileIncludes, this.dataFileExcludes);
        this.loadExecutionData(support, filter, this.project.getBasedir());
        for (MavenProject dependency : this.findProjectToInclude()) {
            this.loadExecutionData(support, filter, dependency.getBasedir());
        }
    }

    private void loadExecutionData(ReportSupport support, FileFilter filter, File basedir) throws IOException {
        this.getLog().info((CharSequence)("found execution data files in " + basedir + ": " + filter.getFiles(basedir)));
        for (File execFile : filter.getFiles(basedir)) {
            support.loadExecutionData(execFile);
        }
    }

    @Override
    File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    void createReport(IReportGroupVisitor visitor, ReportSupport support) throws IOException {
        IReportGroupVisitor group = visitor.visitGroup(this.title);
        for (MavenProject dependency : this.findProjectToInclude()) {
            this.processProject(support, group, dependency);
        }
    }

    private void processProject(ReportSupport support, IReportGroupVisitor group, MavenProject project) throws IOException {
        support.processProject(group, project.getArtifactId(), project, this.getIncludes(), this.getExcludes(), this.sourceEncoding);
    }

    public File getReportOutputDirectory() {
        return this.outputDirectory;
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.outputDirectory = reportOutputDirectory != null && !reportOutputDirectory.getAbsolutePath().endsWith("jacoco-aggregate") ? new File(reportOutputDirectory, "jacoco-aggregate") : reportOutputDirectory;
    }

    public String getOutputName() {
        return "jacoco-aggregate/index";
    }

    public String getName(Locale locale) {
        return "Codefilarete JaCoCo Aggregate";
    }

    private List<MavenProject> findProjectToInclude() {
        ArrayList<MavenProject> result = new ArrayList<MavenProject>(this.reactorProjects);
        this.getLog().info((CharSequence)("Projects to be added to report " + ReportAggregateMojo.buildProjectReferenceId(this.reactorProjects)));
        return result;
    }

    private static String buildProjectReferenceId(List<MavenProject> projects) {
        StringBuilder buffer = new StringBuilder(128);
        for (MavenProject project : projects) {
            buffer.append(ReportAggregateMojo.buildProjectReferenceId(project)).append(", ");
        }
        return buffer.toString();
    }

    private static String buildProjectReferenceId(MavenProject project) {
        return project.getGroupId() + ':' + project.getArtifactId() + ':' + project.getVersion();
    }
}

