/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.rdb.graph;

import com.google.common.util.concurrent.Uninterruptibles;
import commonj.sdo.Property;
import commonj.sdo.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudgraph.common.concurrent.SubgraphTask;
import org.cloudgraph.common.concurrent.Traversal;
import org.cloudgraph.rdb.graph.ParallelGraphAssembler;
import org.cloudgraph.store.lang.AssemblerSupport;
import org.cloudgraph.store.lang.DefaultAssembler;
import org.cloudgraph.store.lang.StatementExecutor;
import org.cloudgraph.store.lang.StatementFactory;
import org.plasma.query.collector.SelectionCollector;
import org.plasma.sdo.PlasmaDataObject;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.access.provider.common.PropertyPair;

public class ParallelSubgraphTask
extends AssemblerSupport
implements SubgraphTask {
    private static Log log = LogFactory.getLog(ParallelSubgraphTask.class);
    protected PlasmaType subrootType;
    protected PlasmaDataObject source;
    protected PlasmaProperty sourceProperty;
    protected List<PropertyPair> subrootChildKeyPairs;
    protected int level;
    protected int sequence;
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);
    private ParallelGraphAssembler sharedAssembler;

    public ParallelSubgraphTask(PlasmaType subrootType, PlasmaDataObject source, SelectionCollector selection, StatementFactory statementFactory, StatementExecutor statementExecutor, PlasmaProperty sourceProperty, List<PropertyPair> childKeyPairs, int level, int sequence, ParallelGraphAssembler assembler) {
        super(selection, statementFactory, statementExecutor);
        this.subrootType = subrootType;
        this.source = source;
        this.sourceProperty = sourceProperty;
        this.subrootChildKeyPairs = childKeyPairs;
        this.level = level;
        this.sequence = sequence;
        this.sharedAssembler = assembler;
        if (log.isDebugEnabled()) {
            log.debug((Object)(String.valueOf(level) + ":process: " + source.getType().getName() + "." + sourceProperty.getName() + "->" + subrootType.getName() + ": " + childKeyPairs));
        }
    }

    public void start() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("start-" + this.level + "." + this.sequence));
        }
        try {
            this.sharedAssembler.getExecutorService().execute(new Runnable(){

                @Override
                public void run() {
                    ParallelSubgraphTask.this.assemble();
                    ParallelSubgraphTask.this.shutdown();
                }
            });
        }
        catch (RejectedExecutionException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void shutdown() {
        this.shutdownLatch.countDown();
    }

    public void join() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("join-" + this.level + "." + this.sequence));
        }
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.shutdownLatch);
    }

    public void assemble() {
        this.assemble(this.subrootType, this.source, this.sourceProperty, this.subrootChildKeyPairs, this.level);
    }

    private void assemble(PlasmaType targetType, PlasmaDataObject source, PlasmaProperty sourceProperty, List<PropertyPair> childKeyPairs, int level) {
        Set props = this.collector.getProperties((Type)targetType, level);
        if (props == null) {
            props = DefaultAssembler.EMPTY_PROPERTY_SET;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(String.valueOf(level) + ":assemble: " + source.getType().getName() + "." + sourceProperty.getName() + "->" + targetType.getName() + ": " + props));
        }
        List result = this.getPredicateResult(targetType, sourceProperty, props, childKeyPairs);
        if (log.isDebugEnabled()) {
            log.debug((Object)(String.valueOf(level) + ":results: " + result.size()));
        }
        Map resultMap = this.sharedAssembler.collectResults(targetType, source, sourceProperty, result);
        for (PlasmaDataObject target : resultMap.keySet()) {
            List row = (List)resultMap.get(target);
            ArrayList<Traversal> traversals = new ArrayList<Traversal>();
            for (PropertyPair pair : row) {
                if (pair.getProp().isMany() || pair.getProp().getType().isDataType() || !pair.isQueryProperty()) continue;
                List nextKeyPairs = this.getNextKeyPairs(target, pair, level);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(String.valueOf(level) + ":traverse: (" + pair.getProp().isMany() + ") " + pair.getProp().toString() + ":" + String.valueOf(pair.getValue())));
                }
                Traversal traversal = new Traversal((PlasmaType)pair.getProp().getType(), target, pair.getProp(), nextKeyPairs, level + 1);
                traversals.add(traversal);
            }
            for (Property p : props) {
                PlasmaProperty prop = (PlasmaProperty)p;
                if (!prop.isMany() || prop.getType().isDataType()) continue;
                List list = this.getChildKeyProps(target, targetType, prop);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(String.valueOf(level) + ":traverse: (" + prop.isMany() + ") " + prop.toString() + " - " + list.toArray().toString()));
                }
                Traversal trav2 = new Traversal((PlasmaType)prop.getType(), target, prop, list, level + 1);
                traversals.add(trav2);
            }
            this.sharedAssembler.logPoolStatistics();
            int available = 0;
            if (level <= this.sharedAssembler.getConfig().getMaxThreadDepth() && (available = this.sharedAssembler.numThreadsAvailable()) > traversals.size()) {
                available = traversals.size();
            }
            ArrayList<ParallelSubgraphTask> concurrentTasks = null;
            for (int i = 0; i < available; ++i) {
                if (concurrentTasks == null) {
                    concurrentTasks = new ArrayList<ParallelSubgraphTask>();
                }
                Traversal traversal = (Traversal)traversals.get(i);
                ParallelSubgraphTask task = new ParallelSubgraphTask(traversal.getSubrootType(), traversal.getSource(), this.collector, this.getStatementFactory(), this.getStatementExecutor(), traversal.getSourceProperty(), traversal.getChildKeyPairs(), traversal.getLevel(), i, this.sharedAssembler);
                concurrentTasks.add(task);
            }
            if (concurrentTasks != null) {
                for (SubgraphTask subgraphTask : concurrentTasks) {
                    subgraphTask.start();
                }
                for (SubgraphTask subgraphTask : concurrentTasks) {
                    subgraphTask.join();
                }
            }
            for (int i = available; i < traversals.size(); ++i) {
                Traversal traversal = (Traversal)traversals.get(i);
                this.assemble(traversal.getSubrootType(), traversal.getSource(), traversal.getSourceProperty(), traversal.getChildKeyPairs(), traversal.getLevel());
            }
        }
    }
}

