/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.rdb.filter;

import commonj.sdo.Property;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudgraph.rdb.service.RDBDataConverter;
import org.cloudgraph.store.lang.StatementExecutor;
import org.cloudgraph.store.lang.StatementUtil;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.access.DataAccessException;
import org.plasma.sdo.access.provider.common.PropertyPair;
import org.plasma.sdo.profile.KeyType;

public class RDBStatementExecutor
implements StatementExecutor {
    private static Log log = LogFactory.getFactory().getInstance(RDBStatementExecutor.class);
    protected RDBDataConverter converter = RDBDataConverter.INSTANCE;
    private Connection con;
    private StatementUtil statementUtil;

    private RDBStatementExecutor() {
    }

    public RDBStatementExecutor(Connection con) {
        this.con = con;
        this.statementUtil = new StatementUtil();
    }

    public List<List<PropertyPair>> fetch(PlasmaType type, StringBuilder sql) {
        return this.fetch(type, sql, new HashSet<Property>(), new Object[0]);
    }

    public List<List<PropertyPair>> fetch(PlasmaType type, StringBuilder sql, Set<Property> props) {
        return this.fetch(type, sql, props, new Object[0]);
    }

    public List<List<PropertyPair>> fetch(PlasmaType type, StringBuilder sql, Set<Property> props, Object[] params) {
        ArrayList<List<PropertyPair>> result = new ArrayList<List<PropertyPair>>();
        Statement statement = null;
        ResultSet rs = null;
        try {
            if (log.isDebugEnabled()) {
                if (params == null || params.length == 0) {
                    log.debug((Object)("fetch: " + sql.toString()));
                } else {
                    StringBuilder paramBuf = new StringBuilder();
                    paramBuf.append(" [");
                    for (int p = 0; p < params.length; ++p) {
                        if (p > 0) {
                            paramBuf.append(", ");
                        }
                        paramBuf.append(String.valueOf(params[p]));
                    }
                    paramBuf.append("]");
                    log.debug((Object)("fetch: " + sql.toString() + " " + paramBuf.toString()));
                }
            }
            statement = this.con.prepareStatement(sql.toString(), 1003, 1007);
            for (int i = 0; i < params.length; ++i) {
                statement.setString(i + 1, String.valueOf(params[i]));
            }
            statement.execute();
            rs = statement.getResultSet();
            ResultSetMetaData rsMeta = rs.getMetaData();
            int numcols = rsMeta.getColumnCount();
            int count = 0;
            while (rs.next()) {
                ArrayList<PropertyPair> row = new ArrayList<PropertyPair>(numcols);
                result.add(row);
                for (int i = 1; i <= numcols; ++i) {
                    PlasmaProperty prop;
                    String columnName = rsMeta.getColumnName(i);
                    int columnType = rsMeta.getColumnType(i);
                    PlasmaProperty valueProp = prop = (PlasmaProperty)type.getProperty(columnName);
                    while (!valueProp.getType().isDataType()) {
                        valueProp = this.statementUtil.getOppositePriKeyProperty((Property)valueProp);
                    }
                    Object value = this.converter.fromJDBCDataType(rs, i, columnType, valueProp);
                    if (value == null) continue;
                    PropertyPair pair = new PropertyPair(prop, value);
                    if (!valueProp.equals(prop)) {
                        pair.setValueProp(valueProp);
                    }
                    if (!props.contains(prop)) {
                        pair.setQueryProperty(false);
                    }
                    row.add(pair);
                }
                ++count;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("returned " + count + " results"));
            }
        }
        catch (Throwable t) {
            throw new DataAccessException(t);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public Map<String, PropertyPair> fetchRowMap(PlasmaType type, StringBuilder sql) {
        HashMap<String, PropertyPair> result = new HashMap<String, PropertyPair>();
        Statement statement = null;
        ResultSet rs = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("fetch: " + sql.toString()));
            }
            statement = this.con.prepareStatement(sql.toString(), 1003, 1007);
            statement.execute();
            rs = statement.getResultSet();
            ResultSetMetaData rsMeta = rs.getMetaData();
            int numcols = rsMeta.getColumnCount();
            int count = 0;
            while (rs.next()) {
                for (int i = 1; i <= numcols; ++i) {
                    PlasmaProperty prop;
                    String columnName = rsMeta.getColumnName(i);
                    int columnType = rsMeta.getColumnType(i);
                    PlasmaProperty valueProp = prop = (PlasmaProperty)type.getProperty(columnName);
                    while (!valueProp.getType().isDataType()) {
                        valueProp = this.statementUtil.getOppositePriKeyProperty((Property)valueProp);
                    }
                    Object value = this.converter.fromJDBCDataType(rs, i, columnType, valueProp);
                    if (value == null) continue;
                    PropertyPair pair = new PropertyPair(prop, value);
                    if (!valueProp.equals(prop)) {
                        pair.setValueProp(valueProp);
                    }
                    result.put(prop.getName(), pair);
                }
                ++count;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("returned " + count + " results"));
            }
        }
        catch (Throwable t) {
            throw new DataAccessException(t);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public List<PropertyPair> fetchRow(PlasmaType type, StringBuilder sql) {
        ArrayList<PropertyPair> result = new ArrayList<PropertyPair>();
        Statement statement = null;
        ResultSet rs = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("fetch: " + sql.toString()));
            }
            statement = this.con.prepareStatement(sql.toString(), 1003, 1007);
            statement.execute();
            rs = statement.getResultSet();
            ResultSetMetaData rsMeta = rs.getMetaData();
            int numcols = rsMeta.getColumnCount();
            int count = 0;
            while (rs.next()) {
                for (int i = 1; i <= numcols; ++i) {
                    PlasmaProperty prop;
                    String columnName = rsMeta.getColumnName(i);
                    int columnType = rsMeta.getColumnType(i);
                    PlasmaProperty valueProp = prop = (PlasmaProperty)type.getProperty(columnName);
                    while (!valueProp.getType().isDataType()) {
                        valueProp = this.statementUtil.getOppositePriKeyProperty((Property)valueProp);
                    }
                    Object value = this.converter.fromJDBCDataType(rs, i, columnType, valueProp);
                    if (value == null) continue;
                    PropertyPair pair = new PropertyPair(prop, value);
                    if (!valueProp.equals(prop)) {
                        pair.setValueProp(valueProp);
                    }
                    result.add(pair);
                }
                ++count;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("returned " + count + " results"));
            }
        }
        catch (Throwable t) {
            throw new DataAccessException(t);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public void execute(PlasmaType type, StringBuilder sql, Map<String, PropertyPair> values) {
        Statement statement = null;
        ArrayList<ByteArrayInputStream> streams = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("execute: " + sql.toString()));
                StringBuilder paramBuf = this.createParamDebug(values);
                log.debug((Object)("params: " + paramBuf.toString()));
            }
            statement = this.con.prepareStatement(sql.toString());
            for (PropertyPair propertyPair : values.values()) {
                PlasmaProperty valueProp = propertyPair.getProp();
                if (propertyPair.getValueProp() != null) {
                    valueProp = propertyPair.getValueProp();
                }
                int jdbcType = this.converter.toJDBCDataType(valueProp, propertyPair.getValue());
                Object jdbcValue = this.converter.toJDBCDataValue(valueProp, propertyPair.getValue());
                if (jdbcType != 2004 && jdbcType != -3) {
                    statement.setObject(propertyPair.getColumn(), jdbcValue, jdbcType);
                } else {
                    byte[] bytes = (byte[])jdbcValue;
                    long len = bytes.length;
                    ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                    statement.setBinaryStream(propertyPair.getColumn(), is, len);
                    if (streams == null) {
                        streams = new ArrayList<ByteArrayInputStream>();
                    }
                    streams.add(is);
                }
                if (propertyPair.getOldValue() == null) continue;
                Object jdbcOldValue = this.converter.toJDBCDataValue(valueProp, propertyPair.getOldValue());
                if (jdbcType != 2004 && jdbcType != -3) {
                    statement.setObject(propertyPair.getOldValueColumn(), jdbcOldValue, jdbcType);
                    continue;
                }
                byte[] bytes = (byte[])jdbcOldValue;
                long len = bytes.length;
                ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                statement.setBinaryStream(propertyPair.getOldValueColumn(), is, len);
                if (streams == null) {
                    streams = new ArrayList();
                }
                streams.add(is);
            }
            statement.executeUpdate();
        }
        catch (Throwable t) {
            throw new DataAccessException(t);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            if (streams != null) {
                try {
                    for (InputStream inputStream : streams) {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void executeInsert(PlasmaType type, StringBuilder sql, Map<String, PropertyPair> values) {
        Statement statement = null;
        ArrayList<ByteArrayInputStream> streams = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("execute: " + sql.toString()));
                StringBuilder paramBuf = this.createParamDebug(values);
                log.debug((Object)("params: " + paramBuf.toString()));
            }
            statement = this.con.prepareStatement(sql.toString());
            for (PropertyPair propertyPair : values.values()) {
                PlasmaProperty valueProp = propertyPair.getProp();
                if (propertyPair.getValueProp() != null) {
                    valueProp = propertyPair.getValueProp();
                }
                int jdbcType = this.converter.toJDBCDataType(valueProp, propertyPair.getValue());
                Object jdbcValue = this.converter.toJDBCDataValue(valueProp, propertyPair.getValue());
                if (jdbcType != 2004 && jdbcType != -3) {
                    statement.setObject(propertyPair.getColumn(), jdbcValue, jdbcType);
                    continue;
                }
                byte[] bytes = (byte[])jdbcValue;
                long len = bytes.length;
                ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                statement.setBinaryStream(propertyPair.getColumn(), is, len);
                if (streams == null) {
                    streams = new ArrayList<ByteArrayInputStream>();
                }
                streams.add(is);
            }
            statement.execute();
        }
        catch (Throwable t) {
            throw new DataAccessException(t);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            if (streams != null) {
                try {
                    for (InputStream inputStream : streams) {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private StringBuilder createParamDebug(Map<String, PropertyPair> values) throws SQLException {
        StringBuilder paramBuf = new StringBuilder();
        paramBuf.append("[");
        paramBuf.append("[");
        int i = 1;
        for (PropertyPair pair : values.values()) {
            PlasmaProperty valueProp = pair.getProp();
            if (pair.getValueProp() != null) {
                valueProp = pair.getValueProp();
            }
            int jdbcType = this.converter.toJDBCDataType(valueProp, pair.getValue());
            Object jdbcValue = this.converter.toJDBCDataValue(valueProp, pair.getValue());
            Object jdbcOldValue = null;
            if (pair.getOldValue() != null) {
                jdbcOldValue = this.converter.toJDBCDataValue(valueProp, pair.getOldValue());
            }
            if (i > 1) {
                paramBuf.append(", ");
            }
            paramBuf.append("(");
            paramBuf.append(jdbcValue.getClass().getSimpleName());
            paramBuf.append("/");
            paramBuf.append(this.converter.getJdbcTypeName(jdbcType));
            paramBuf.append(")");
            paramBuf.append(String.valueOf(jdbcValue));
            if (jdbcOldValue != null) {
                paramBuf.append("(");
                paramBuf.append(String.valueOf(jdbcOldValue));
                paramBuf.append(")");
            }
            ++i;
        }
        paramBuf.append("]");
        return paramBuf;
    }

    public List<PropertyPair> executeInsertWithGeneratedKeys(PlasmaType type, StringBuilder sql, Map<String, PropertyPair> values) {
        ArrayList<PropertyPair> resultKeys = new ArrayList<PropertyPair>();
        Statement statement = null;
        ArrayList<ByteArrayInputStream> streams = null;
        ResultSet generatedKeys = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("execute: " + sql.toString()));
                StringBuilder paramBuf = this.createParamDebug(values);
                log.debug((Object)("params: " + paramBuf.toString()));
            }
            statement = this.con.prepareStatement(sql.toString(), 1);
            for (PropertyPair propertyPair : values.values()) {
                PlasmaProperty valueProp = propertyPair.getProp();
                if (propertyPair.getValueProp() != null) {
                    valueProp = propertyPair.getValueProp();
                }
                int jdbcType = this.converter.toJDBCDataType(valueProp, propertyPair.getValue());
                Object jdbcValue = this.converter.toJDBCDataValue(valueProp, propertyPair.getValue());
                if (jdbcType != 2004 && jdbcType != -3) {
                    statement.setObject(propertyPair.getColumn(), jdbcValue, jdbcType);
                    continue;
                }
                byte[] bytes = (byte[])jdbcValue;
                long len = bytes.length;
                ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                statement.setBinaryStream(propertyPair.getColumn(), is, len);
                if (streams == null) {
                    streams = new ArrayList<ByteArrayInputStream>();
                }
                streams.add(is);
            }
            statement.execute();
            generatedKeys = statement.getGeneratedKeys();
            ResultSetMetaData rsMeta = generatedKeys.getMetaData();
            int n = rsMeta.getColumnCount();
            if (log.isDebugEnabled()) {
                log.debug((Object)("returned " + n + " keys"));
            }
            if (generatedKeys.next()) {
                List pkPropList = type.findProperties(KeyType.primary);
                if (pkPropList == null || pkPropList.size() == 0) {
                    throw new DataAccessException("no pri-key properties found for type '" + type.getName() + "'");
                }
                if (pkPropList.size() > 1) {
                    throw new DataAccessException("multiple pri-key properties found for type '" + type.getName() + "' - cannot map to generated keys");
                }
                PlasmaProperty prop = (PlasmaProperty)pkPropList.get(0);
                for (int i = 1; i <= n; ++i) {
                    String columnName = rsMeta.getColumnName(i);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("returned key column '" + columnName + "'"));
                    }
                    int columnType = rsMeta.getColumnType(i);
                    Object value = this.converter.fromJDBCDataType(generatedKeys, i, columnType, prop);
                    PropertyPair pair = new PropertyPair(prop, value);
                    resultKeys.add(pair);
                }
            }
        }
        catch (Throwable t) {
            throw new DataAccessException(t);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            if (streams != null) {
                try {
                    for (InputStream inputStream : streams) {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return resultKeys;
    }
}

