/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.rdb.connect;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudgraph.rdb.connect.DataSourceProvder;
import org.plasma.runtime.DataAccessProviderName;
import org.plasma.runtime.PlasmaRuntime;
import org.plasma.runtime.Property;
import org.plasma.sdo.access.DataAccessException;

public class JNDIDataSourceProvider
implements DataSourceProvder {
    private static final Log log = LogFactory.getLog(JNDIDataSourceProvider.class);
    protected DataSource datasource;

    public JNDIDataSourceProvider() {
        Properties props = new Properties();
        for (Property property : PlasmaRuntime.getInstance().getDataAccessProvider(DataAccessProviderName.JDBC).getProperties()) {
            props.put(property.getName(), property.getValue());
        }
        String datasourceName = props.getProperty("org.plasma.sdo.access.provider.jdbc.ConnectionDataSourceName");
        if (datasourceName == null) {
            throw new DataAccessException("cannot lookup datasource - datasource name property 'org.plasma.sdo.access.provider.jdbc.ConnectionDataSourceName' not found in configuration for data access provider '" + DataAccessProviderName.JDBC.name() + "' - a fully qualified JNDI name is required");
        }
        try {
            InitialContext initialContext = new InitialContext();
            this.datasource = (DataSource)initialContext.lookup(datasourceName);
            if (this.datasource == null) {
                throw new DataAccessException("cannot lookup datasource '" + datasourceName + "'");
            }
        }
        catch (NamingException ex) {
            log.error((Object)("cannot lookup datasource '" + datasourceName + "'"), (Throwable)ex);
            throw new DataAccessException((Throwable)ex);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.datasource.getConnection();
    }
}

