/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.rdb.service;

import commonj.sdo.ChangeSummary;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudgraph.rdb.filter.RDBStatementExecutor;
import org.cloudgraph.rdb.filter.RDBStatementFactory;
import org.cloudgraph.rdb.service.RDBServiceException;
import org.cloudgraph.store.lang.StatementExecutor;
import org.cloudgraph.store.lang.StatementFactory;
import org.cloudgraph.store.service.CreatedCommitComparator;
import org.cloudgraph.store.service.DeletedCommitComparator;
import org.cloudgraph.store.service.GraphServiceException;
import org.plasma.config.DataAccessProvider;
import org.plasma.config.DataAccessProviderName;
import org.plasma.config.PlasmaConfig;
import org.plasma.sdo.DataFlavor;
import org.plasma.sdo.PlasmaChangeSummary;
import org.plasma.sdo.PlasmaDataGraph;
import org.plasma.sdo.PlasmaDataGraphVisitor;
import org.plasma.sdo.PlasmaDataObject;
import org.plasma.sdo.PlasmaNode;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.access.DataAccessException;
import org.plasma.sdo.access.DataGraphDispatcher;
import org.plasma.sdo.access.InvalidSnapshotException;
import org.plasma.sdo.access.LockedEntityException;
import org.plasma.sdo.access.RequiredPropertyException;
import org.plasma.sdo.access.SequenceGenerator;
import org.plasma.sdo.access.provider.common.ModifiedObjectCollector;
import org.plasma.sdo.access.provider.common.PropertyPair;
import org.plasma.sdo.core.CoreDataObject;
import org.plasma.sdo.core.CoreHelper;
import org.plasma.sdo.core.NullValue;
import org.plasma.sdo.core.SnapshotMap;
import org.plasma.sdo.profile.ConcurrencyType;
import org.plasma.sdo.profile.ConcurrentDataFlavor;
import org.plasma.sdo.profile.KeyType;
import sorts.InsertionSort;

public class GraphDispatcher
implements DataGraphDispatcher {
    private static Log log = LogFactory.getLog(GraphDispatcher.class);
    private SnapshotMap snapshotMap;
    private SequenceGenerator sequenceGenerator;
    private String username;
    private StatementFactory statementFactory;
    private StatementExecutor statementExecutor;

    private GraphDispatcher() {
    }

    public GraphDispatcher(SnapshotMap snapshotMap, String username, Connection con) {
        this.snapshotMap = snapshotMap;
        this.username = username;
        this.statementFactory = new RDBStatementFactory();
        this.statementExecutor = new RDBStatementExecutor(con);
    }

    public void close() {
        if (this.sequenceGenerator != null) {
            this.sequenceGenerator.close();
        }
    }

    public SnapshotMap commit(DataGraph[] dataGraphs) {
        DataGraph[] dataGraphArray = dataGraphs;
        int n = dataGraphs.length;
        int n2 = 0;
        while (n2 < n) {
            DataGraph dataGraph = dataGraphArray[n2];
            this.commit(dataGraph);
            ++n2;
        }
        return this.snapshotMap;
    }

    public SnapshotMap commit(DataGraph dataGraph) {
        int n;
        Object[] objectArray;
        DataObject dataObject;
        int i;
        if (this.username == null || this.username.length() == 0) {
            throw new IllegalArgumentException("expected username param not, '" + String.valueOf(this.username) + "'");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("current user is '" + this.username + "'"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)dataGraph.getChangeSummary().toString());
            log.debug((Object)((PlasmaDataGraph)dataGraph).dump());
        }
        PlasmaChangeSummary changeSummary = (PlasmaChangeSummary)dataGraph.getChangeSummary();
        List list = changeSummary.getChangedDataObjects();
        DataObject[] changed = new DataObject[list.size()];
        list.toArray(changed);
        if (log.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append('\n');
            i = 0;
            while (i < changed.length) {
                dataObject = changed[i];
                if (changeSummary.isCreated(dataObject)) {
                    buf.append("created: ");
                } else if (changeSummary.isModified(dataObject)) {
                    buf.append("modified: ");
                } else if (changeSummary.isDeleted(dataObject)) {
                    buf.append("deleted: ");
                }
                buf.append(String.valueOf(dataObject.getType().getName()) + " (" + dataObject.toString() + ")");
                buf.append(" depth: " + changeSummary.getPathDepth(dataObject));
                buf.append('\n');
                ++i;
            }
            log.debug((Object)("commit list: " + buf.toString()));
        }
        ArrayList<CoreDataObject> createdList = new ArrayList<CoreDataObject>();
        i = 0;
        while (i < changed.length) {
            dataObject = changed[i];
            if (changeSummary.isCreated(dataObject)) {
                createdList.add((CoreDataObject)dataObject);
            }
            ++i;
        }
        Object[] createdArray = new CoreDataObject[createdList.size()];
        createdList.toArray(createdArray);
        if (log.isDebugEnabled()) {
            int createdIndex = 0;
            Object[] objectArray2 = createdArray;
            int n2 = createdArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Object dataObject2 = objectArray2[n3];
                log.debug((Object)("created before sort " + createdIndex + ": " + dataObject2.toString()));
                ++createdIndex;
                ++n3;
            }
        }
        CreatedCommitComparator comparator = new CreatedCommitComparator();
        InsertionSort sort = new InsertionSort();
        sort.sort(createdArray, (Comparator)comparator);
        if (log.isDebugEnabled()) {
            int createdIndex = 0;
            Object[] objectArray3 = createdArray;
            int n4 = createdArray.length;
            int n5 = 0;
            while (n5 < n4) {
                Object dataObject3 = objectArray3[n5];
                log.debug((Object)("created after sort " + createdIndex + ": " + dataObject3.toString()));
                ++createdIndex;
                ++n5;
            }
        }
        ArrayList<CoreDataObject> deletedList = new ArrayList<CoreDataObject>();
        int i2 = 0;
        while (i2 < changed.length) {
            DataObject dataObject4 = changed[i2];
            if (changeSummary.isDeleted(dataObject4)) {
                deletedList.add((CoreDataObject)dataObject4);
            }
            ++i2;
        }
        Object[] deletedArray = new CoreDataObject[deletedList.size()];
        deletedList.toArray(deletedArray);
        if (log.isDebugEnabled()) {
            int deletedIndex = 0;
            objectArray = deletedArray;
            n = deletedArray.length;
            int n6 = 0;
            while (n6 < n) {
                Object dataObject5 = objectArray[n6];
                log.debug((Object)("deleted before sort " + deletedIndex + ": " + dataObject5.toString()));
                ++deletedIndex;
                ++n6;
            }
        }
        comparator = new DeletedCommitComparator();
        sort = new InsertionSort();
        sort.sort(deletedArray, (Comparator)comparator);
        if (log.isDebugEnabled()) {
            int deletedIndex = 0;
            int i3 = deletedArray.length - 1;
            while (i3 >= 0) {
                Object dataObject6 = deletedArray[i3];
                log.debug((Object)("deleted after sort " + deletedIndex + ": " + dataObject6.toString()));
                ++deletedIndex;
                --i3;
            }
        }
        ModifiedObjectCollector modified = new ModifiedObjectCollector(dataGraph);
        try {
            objectArray = createdArray;
            n = createdArray.length;
            int n7 = 0;
            while (n7 < n) {
                Object dataObject7 = objectArray[n7];
                this.create(dataGraph, (PlasmaDataObject)dataObject7);
                ++n7;
            }
            for (PlasmaDataObject dataObject8 : modified.getResult()) {
                this.update(dataGraph, dataObject8);
            }
            objectArray = deletedArray;
            n = deletedArray.length;
            int n8 = 0;
            while (n8 < n) {
                Object dataObject9 = objectArray[n8];
                this.delete(dataGraph, (DataObject)dataObject9);
                ++n8;
            }
            new UpdatePessimisticVisitor(dataGraph);
            return this.snapshotMap;
        }
        catch (IllegalAccessException e) {
            throw new RDBServiceException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RDBServiceException(e);
        }
        catch (InvocationTargetException e) {
            throw new RDBServiceException(e);
        }
        catch (SQLException e) {
            throw new RDBServiceException(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    private void create(DataGraph dataGraph, PlasmaDataObject dataObject) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        PlasmaType type = (PlasmaType)dataObject.getType();
        UUID uuid = ((CoreDataObject)dataObject).getUUID();
        if (uuid == null) {
            throw new DataAccessException("expected UUID for inserted entity '" + type.getName() + "'");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("creating " + type.getName() + " '" + dataObject.getUUIDAsString() + "'"));
        }
        HashMap<String, PropertyPair> entity = new HashMap<String, PropertyPair>();
        List pkList = type.findProperties(KeyType.primary);
        if (pkList == null || pkList.size() == 0) {
            throw new DataAccessException("no pri-key properties found for type '" + dataObject.getType().getName() + "'");
        }
        for (Property pkp : pkList) {
            Object pk;
            PlasmaProperty priKeyProperty;
            block34: {
                block32: {
                    block33: {
                        priKeyProperty = (PlasmaProperty)pkp;
                        pk = dataObject.get(priKeyProperty.getName());
                        if (!priKeyProperty.getType().isDataType()) break block32;
                        if (pk != null) break block33;
                        if (!this.hasSequenceGenerator()) break block34;
                        DataFlavor dataFlavor = priKeyProperty.getDataFlavor();
                        switch (dataFlavor) {
                            case integral: {
                                if (this.sequenceGenerator == null) {
                                    this.sequenceGenerator = this.newSequenceGenerator();
                                    this.sequenceGenerator.initialize();
                                }
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("getting seq-num for " + type.getName()));
                                }
                                pk = this.sequenceGenerator.get((DataObject)dataObject);
                                PropertyPair pair = new PropertyPair(priKeyProperty, pk);
                                entity.put(priKeyProperty.getName(), pair);
                                ((CoreDataObject)dataObject).setValue(priKeyProperty.getName(), pk);
                                break block34;
                            }
                            default: {
                                throw new DataAccessException("found null primary key property '" + priKeyProperty.getName() + "' for type, " + type.getURI() + "#" + type.getName());
                            }
                        }
                    }
                    PropertyPair pair = new PropertyPair(priKeyProperty, pk);
                    entity.put(priKeyProperty.getName(), pair);
                    break block34;
                }
                if (pk == null) {
                    throw new DataAccessException("found null primary key value for property '" + priKeyProperty.toString() + " on property supplier chain");
                }
                PlasmaProperty priKeyValueProperty = priKeyProperty;
                PlasmaDataObject priKeyDataObject = dataObject;
                while (!priKeyValueProperty.getType().isDataType()) {
                    priKeyDataObject = (DataObject)pk;
                    if ((pk = priKeyDataObject.get((priKeyValueProperty = this.statementFactory.getOppositePriKeyProperty((Property)priKeyValueProperty)).getName())) != null) continue;
                    throw new DataAccessException("found null primary key value for property '" + priKeyValueProperty.toString() + " on property supplier chain");
                }
                PropertyPair pair = new PropertyPair(priKeyProperty, pk);
                entity.put(priKeyProperty.getName(), pair);
                pair.setValueProp(priKeyValueProperty);
            }
            if (pk == null) continue;
            if (priKeyProperty.getType().isDataType()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("mapping UUID '" + uuid + "' to pk (" + String.valueOf(pk) + ")"));
                }
                PropertyPair pkPair = new PropertyPair(priKeyProperty, pk);
                this.snapshotMap.put(uuid, pkPair);
                continue;
            }
            log.warn((Object)("ignoring FK pk property, " + priKeyProperty.toString()));
        }
        Property originationUserProperty = type.findProperty(ConcurrencyType.origination, ConcurrentDataFlavor.user);
        if (originationUserProperty != null) {
            entity.put(originationUserProperty.getName(), new PropertyPair((PlasmaProperty)originationUserProperty, (Object)this.username));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("could not find origination (username) property for type, " + type.getURI() + "#" + type.getName()));
        }
        Property originationTimestampProperty = type.findProperty(ConcurrencyType.origination, ConcurrentDataFlavor.time);
        if (originationTimestampProperty != null) {
            entity.put(originationTimestampProperty.getName(), new PropertyPair((PlasmaProperty)originationTimestampProperty, (Object)this.snapshotMap.getSnapshotDate()));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("could not find origination date property for type, " + type + "#" + type.getName()));
        }
        Property concurrencyUserProperty = type.findProperty(ConcurrencyType.optimistic, ConcurrentDataFlavor.user);
        if (concurrencyUserProperty != null) {
            entity.put(concurrencyUserProperty.getName(), new PropertyPair((PlasmaProperty)concurrencyUserProperty, (Object)this.username));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("could not find optimistic concurrency (username) property for type, " + type.getURI() + "#" + dataObject.getType().getName()));
        }
        Property concurrencyVersionProperty = type.findProperty(ConcurrencyType.optimistic, ConcurrentDataFlavor.time);
        if (concurrencyVersionProperty != null) {
            entity.put(concurrencyVersionProperty.getName(), new PropertyPair((PlasmaProperty)concurrencyVersionProperty, (Object)this.snapshotMap.getSnapshotDate()));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("could not find optimistic concurrency version property for type, " + type.getURI() + "#" + type.getName()));
        }
        List properties = type.getProperties();
        for (Property p : properties) {
            Object value;
            PlasmaProperty property = (PlasmaProperty)p;
            if (property.isMany() || property.isKey(KeyType.primary) || property.getConcurrent() != null || (value = dataObject.get((Property)property)) == null) continue;
            PropertyPair pair = this.createValue(dataObject, value, (Property)property);
            entity.put(property.getName(), pair);
        }
        StringBuilder insert = this.statementFactory.createInsert(type, entity);
        if (log.isDebugEnabled()) {
            log.debug((Object)("inserting " + dataObject.getType().getName()));
        }
        if (!this.hasSequenceGenerator()) {
            List keys = this.statementExecutor.executeInsertWithGeneratedKeys(type, insert, entity);
            for (Property pkp : pkList) {
                PlasmaProperty targetPriKeyProperty = (PlasmaProperty)pkp;
                for (PropertyPair key : keys) {
                    if (!targetPriKeyProperty.getName().equals(key.getProp().getName())) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("mapping UUID '" + uuid + "' to pk (" + String.valueOf(key.getValue()) + ")"));
                    }
                    this.snapshotMap.put(uuid, key);
                }
            }
        } else {
            this.statementExecutor.executeInsert(type, insert, entity);
        }
    }

    private void update(DataGraph dataGraph, PlasmaDataObject dataObject) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SQLException {
        ArrayList params;
        StringBuilder select;
        Map entity;
        PlasmaProperty concurrencyTimestampProperty;
        PlasmaProperty concurrencyUserProperty;
        PlasmaProperty lockingTimestampProperty;
        PlasmaProperty lockingUserProperty;
        List pkList;
        PlasmaType type = (PlasmaType)dataObject.getType();
        if (log.isDebugEnabled()) {
            log.debug((Object)("updating " + type.getName() + " '" + dataObject.getUUIDAsString() + "'"));
        }
        if ((pkList = type.findProperties(KeyType.primary)) == null || pkList.size() == 0) {
            throw new DataAccessException("no pri-key properties found for type '" + dataObject.getType().getName() + "'");
        }
        ArrayList<PropertyPair> pkPairs = new ArrayList<PropertyPair>();
        for (Property pkp : pkList) {
            PlasmaProperty pkProperty = (PlasmaProperty)pkp;
            Object pk = dataObject.get((Property)pkProperty);
            if (pk == null) {
                throw new DataAccessException("found null primary key property '" + pkProperty.getName() + "' for type, " + type.getURI() + "#" + type.getName());
            }
            ChangeSummary.Setting setting = dataGraph.getChangeSummary().getOldValue((DataObject)dataObject, (Property)pkProperty);
            if (setting != null) {
                if (!pkProperty.isReadOnly()) {
                    Object oldPk = setting.getValue();
                    PropertyPair pair = this.createValue(dataObject, pk, oldPk, (Property)pkProperty);
                    pkPairs.add(pair);
                    continue;
                }
                throw new IllegalAccessException("attempt to modify read-only property, " + type.getURI() + "#" + type.getName() + "." + pkProperty.getName());
            }
            PropertyPair pair = this.createValue(dataObject, pk, (Property)pkProperty);
            pkPairs.add(pair);
        }
        Timestamp snapshotDate = (Timestamp)((CoreDataObject)dataObject).getValue("snapshotTimestamp");
        if (snapshotDate == null) {
            throw new RequiredPropertyException("instance property 'snapshotTimestamp' is required to update entity '" + type.getURI() + "#" + type.getName() + "'");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("snapshot date: " + String.valueOf(snapshotDate)));
        }
        if ((lockingUserProperty = (PlasmaProperty)type.findProperty(ConcurrencyType.pessimistic, ConcurrentDataFlavor.user)) == null && log.isDebugEnabled()) {
            log.debug((Object)("could not find locking user property for type, " + type.getURI() + "#" + type.getName()));
        }
        if ((lockingTimestampProperty = (PlasmaProperty)type.findProperty(ConcurrencyType.pessimistic, ConcurrentDataFlavor.time)) == null && log.isDebugEnabled()) {
            log.debug((Object)("could not find locking timestamp property for type, " + type.getURI() + "#" + type.getName()));
        }
        if ((concurrencyUserProperty = (PlasmaProperty)type.findProperty(ConcurrencyType.optimistic, ConcurrentDataFlavor.user)) == null && log.isDebugEnabled()) {
            log.debug((Object)("could not find optimistic concurrency (username) property for type, " + type.getURI() + "#" + type.getName()));
        }
        if ((concurrencyTimestampProperty = (PlasmaProperty)type.findProperty(ConcurrencyType.optimistic, ConcurrentDataFlavor.time)) == null && log.isDebugEnabled()) {
            log.debug((Object)("could not find optimistic concurrency timestamp property for type, " + type.getURI() + "#" + type.getName()));
        }
        if ((entity = this.statementExecutor.fetchRowMap(type, select = this.statementFactory.createSelectConcurrent(type, pkPairs, 5, params = new ArrayList()))).size() == 0) {
            throw new GraphServiceException("could not lock record of type, " + type.toString());
        }
        for (PropertyPair pair : pkPairs) {
            entity.put(pair.getProp().getName(), pair);
        }
        if (concurrencyTimestampProperty != null && concurrencyUserProperty != null) {
            this.checkAndRefreshConcurrencyFields((Type)type, entity, (Property)concurrencyTimestampProperty, (Property)concurrencyUserProperty, snapshotDate);
        }
        if (CoreHelper.isFlaggedLocked((DataObject)dataObject)) {
            this.lock(dataObject, entity, lockingTimestampProperty, lockingUserProperty, snapshotDate);
        } else if (CoreHelper.isFlaggedUnlocked((DataObject)dataObject)) {
            this.unlock(dataObject, entity, lockingTimestampProperty, lockingUserProperty, snapshotDate);
        }
        List properties = type.getProperties();
        for (Property p : properties) {
            ChangeSummary.Setting oldValue;
            PlasmaProperty property = (PlasmaProperty)p;
            if (property.isMany() || property.isKey(KeyType.primary) || property.getConcurrent() != null || (oldValue = dataGraph.getChangeSummary().getOldValue((DataObject)dataObject, (Property)property)) == null) continue;
            if (!property.isReadOnly()) {
                Object value = dataObject.get((Property)property);
                if (value == null) continue;
                PropertyPair pair = this.createValue(dataObject, value, (Property)property);
                entity.put(property.getName(), pair);
                continue;
            }
            throw new IllegalAccessException("attempt to modify read-only property, " + type.getURI() + "#" + type.getName() + "." + property.getName());
        }
        if (this.statementFactory.hasUpdatableProperties(entity)) {
            StringBuilder update = this.statementFactory.createUpdate(type, entity);
            if (log.isDebugEnabled()) {
                log.debug((Object)("updating " + dataObject.getType().getName()));
            }
            this.statementExecutor.execute(type, update, entity);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void delete(DataGraph dataGraph, DataObject dataObject) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, SQLException {
        type = (PlasmaType)dataObject.getType();
        if (GraphDispatcher.log.isDebugEnabled()) {
            GraphDispatcher.log.debug((Object)("deleting " + type.getName() + " '" + ((PlasmaDataObject)dataObject).getUUIDAsString() + "'"));
        }
        if ((pkList = type.findProperties(KeyType.primary)) == null || pkList.size() == 0) {
            throw new DataAccessException("no pri-key properties found for type '" + dataObject.getType().getName() + "'");
        }
        pkPairs = new ArrayList<PropertyPair>();
        for (Property pkp : pkList) {
            priKeyValueProperty = pkProperty = (PlasmaProperty)pkp;
            priKeyDataObject = dataObject;
            pk = priKeyDataObject.get(pkProperty.getName());
            if (pk != null) ** GOTO lbl24
            setting = dataGraph.getChangeSummary().getOldValue(dataObject, (Property)pkProperty);
            if (setting != null) {
                pk = setting.getValue();
            }
            if (pk != null) ** GOTO lbl24
            throw new DataAccessException("found null primary key property '" + pkProperty.toString());
lbl-1000:
            // 1 sources

            {
                priKeyDataObject = (DataObject)pk;
                if ((pk = priKeyDataObject.get((priKeyValueProperty = this.statementFactory.getOppositePriKeyProperty((Property)priKeyValueProperty)).getName())) != null) continue;
                setting = dataGraph.getChangeSummary().getOldValue(priKeyDataObject, (Property)priKeyValueProperty);
                if (setting != null) {
                    pk = setting.getValue();
                }
                if (pk != null) continue;
                throw new DataAccessException("found null primary key property '" + priKeyValueProperty.toString());
lbl24:
                // 4 sources

                ** while (!priKeyValueProperty.getType().isDataType())
            }
lbl25:
            // 1 sources

            pair = new PropertyPair(pkProperty, pk);
            if (!priKeyValueProperty.equals(pkProperty)) {
                pair.setValueProp(priKeyValueProperty);
            }
            pkPairs.add(pair);
        }
        snapshotDate = (Timestamp)((CoreDataObject)dataObject).getValue("snapshotTimestamp");
        if (snapshotDate == null) {
            throw new RequiredPropertyException("property 'snapshotTimestamp' is required to update entity '" + type.getName() + "'");
        }
        params = new ArrayList<E>();
        select = this.statementFactory.createSelectConcurrent(type, pkPairs, 5, params);
        entity = this.statementExecutor.fetchRowMap(type, select);
        lockingUserProperty = (PlasmaProperty)type.findProperty(ConcurrencyType.pessimistic, ConcurrentDataFlavor.user);
        if (lockingUserProperty == null && GraphDispatcher.log.isDebugEnabled()) {
            GraphDispatcher.log.debug((Object)("could not find locking user property for type, " + type.getURI() + "#" + type.getName()));
        }
        if ((lockingTimestampProperty = (PlasmaProperty)type.findProperty(ConcurrencyType.pessimistic, ConcurrentDataFlavor.time)) == null && GraphDispatcher.log.isDebugEnabled()) {
            GraphDispatcher.log.debug((Object)("could not find locking timestamp property for type, " + type.getURI() + "#" + type.getName()));
        }
        if ((concurrencyUserProperty = (PlasmaProperty)type.findProperty(ConcurrencyType.optimistic, ConcurrentDataFlavor.user)) == null && GraphDispatcher.log.isDebugEnabled()) {
            GraphDispatcher.log.debug((Object)("could not find optimistic concurrency (username) property for type, " + type.getURI() + "#" + type.getName()));
        }
        if ((concurrencyTimestampProperty = (PlasmaProperty)type.findProperty(ConcurrencyType.optimistic, ConcurrentDataFlavor.time)) == null && GraphDispatcher.log.isDebugEnabled()) {
            GraphDispatcher.log.debug((Object)("could not find optimistic concurrency timestamp property for type, " + dataObject.getType().getURI() + "#" + dataObject.getType().getName()));
        }
        if (concurrencyTimestampProperty != null && concurrencyUserProperty != null) {
            this.checkConcurrencyFields((Type)type, entity, (Property)concurrencyTimestampProperty, (Property)concurrencyUserProperty, snapshotDate);
        } else if (GraphDispatcher.log.isDebugEnabled()) {
            GraphDispatcher.log.debug((Object)("could not find concurrency version or user fields for " + dataObject.getType().getURI() + "#" + dataObject.getType().getName()));
        }
        entity.clear();
        for (PropertyPair pair : pkPairs) {
            entity.put(pair.getProp().getName(), pair);
        }
        delete = this.statementFactory.createDelete(type, entity);
        if (GraphDispatcher.log.isDebugEnabled()) {
            GraphDispatcher.log.debug((Object)("deleting " + dataObject.getType().getName()));
        }
        this.statementExecutor.execute(type, delete, entity);
    }

    private void checkConcurrencyFields(Type type, Map<String, PropertyPair> entity, Property lastUpdatedDateProperty, Property lastUpdatedByNameProperty, Timestamp snapshotDate) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        PropertyPair lastUpdatedDatePair = entity.get(lastUpdatedDateProperty.getName());
        PropertyPair lastUpdatedByPair = entity.get(lastUpdatedByNameProperty.getName());
        String entityName = type.getName();
        if (lastUpdatedDatePair != null) {
            Date lastUpdatedDate = (Date)lastUpdatedDatePair.getValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)("comparing " + lastUpdatedDate + "greater than snapshot: " + snapshotDate));
            }
            if (lastUpdatedDate.getTime() > snapshotDate.getTime()) {
                if (lastUpdatedByPair != null) {
                    String lastUpdatedBy = (String)lastUpdatedByPair.getValue();
                    throw new InvalidSnapshotException(entityName, this.username, snapshotDate, lastUpdatedBy, lastUpdatedDate);
                }
                throw new InvalidSnapshotException(entityName, this.username, snapshotDate, "unknown", lastUpdatedDate);
            }
        }
    }

    private void checkAndRefreshConcurrencyFields(Type type, Map<String, PropertyPair> entity, Property lastUpdatedDateProperty, Property lastUpdatedByNameProperty, Timestamp snapshotDate) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        PropertyPair lastUpdatedDatePair = entity.get(lastUpdatedDateProperty.getName());
        PropertyPair lastUpdatedByPair = entity.get(lastUpdatedByNameProperty.getName());
        String entityName = type.getName();
        if (lastUpdatedDatePair != null) {
            Date lastUpdatedDate = (Date)lastUpdatedDatePair.getValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)("comparing " + lastUpdatedDate + "greater than snapshot: " + snapshotDate));
            }
            if (lastUpdatedDate.getTime() > snapshotDate.getTime()) {
                if (lastUpdatedByPair != null) {
                    String lastUpdatedBy = (String)lastUpdatedByPair.getValue();
                    throw new InvalidSnapshotException(entityName, this.username, snapshotDate, lastUpdatedBy, lastUpdatedDate);
                }
                throw new InvalidSnapshotException(entityName, this.username, snapshotDate, "unknown", lastUpdatedDate);
            }
            PropertyPair updatedDatePair = new PropertyPair(lastUpdatedDatePair.getProp(), (Object)this.snapshotMap.getSnapshotDate());
            entity.put(lastUpdatedDatePair.getProp().getName(), updatedDatePair);
            if (lastUpdatedByPair != null) {
                PropertyPair updatedByPair = new PropertyPair(lastUpdatedByPair.getProp(), (Object)this.username);
                entity.put(updatedByPair.getProp().getName(), updatedByPair);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("reset updated-date " + entity.getClass().getSimpleName() + " (" + entityName + " - " + this.snapshotMap.getSnapshotDate() + "(" + String.valueOf(this.snapshotMap.getSnapshotDate().getTime()) + ")"));
        }
    }

    private void lock(PlasmaDataObject dataObject, Map<String, PropertyPair> entity, PlasmaProperty lockedDateProperty, PlasmaProperty lockedByNameProperty, Timestamp snapshotDate) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (lockedDateProperty != null && lockedByNameProperty != null) {
            PropertyPair lockedDatePair = entity.get(lockedDateProperty.getName());
            PropertyPair lockedByNamePair = entity.get(lockedByNameProperty.getName());
            String lockedByName = (String)lockedByNamePair.getValue();
            Date lockedDate = (Date)lockedDatePair.getValue();
            CoreHelper.unflagLocked((DataObject)dataObject);
            if (lockedByName == null || this.username.equals(lockedByName)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("locking " + entity.getClass().getSimpleName() + " (" + dataObject.getUUIDAsString() + ")"));
                }
                entity.put(lockedByNameProperty.getName(), new PropertyPair(lockedByNameProperty, (Object)this.username));
                entity.put(lockedDateProperty.getName(), new PropertyPair(lockedDateProperty, (Object)this.snapshotMap.getSnapshotDate()));
            } else {
                long timeout = 300000L;
                DataAccessProvider providerConf = PlasmaConfig.getInstance().getDataAccessProvider(DataAccessProviderName.JDBC);
                if (providerConf.getConcurrency() != null && providerConf.getConcurrency().getPessimisticLockTimeoutMillis() > 0L) {
                    timeout = providerConf.getConcurrency().getPessimisticLockTimeoutMillis();
                }
                if (snapshotDate.getTime() - lockedDate.getTime() > timeout) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("locking " + entity.getClass().getSimpleName() + " (" + dataObject.getUUIDAsString() + ") - existing lock by '" + lockedByName + "' expired"));
                    }
                    entity.put(lockedByNameProperty.getName(), new PropertyPair(lockedByNameProperty, (Object)this.username));
                    entity.put(lockedDateProperty.getName(), new PropertyPair(lockedDateProperty, (Object)this.snapshotMap.getSnapshotDate()));
                } else {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("could not issue lock for user '" + String.valueOf(this.username) + "' for snapshot date " + String.valueOf(snapshotDate)));
                    }
                    throw new LockedEntityException(entity.getClass().getSimpleName(), lockedByName, lockedDate);
                }
            }
        }
    }

    private void unlock(PlasmaDataObject dataObject, Map<String, PropertyPair> entity, PlasmaProperty lockedDateProperty, PlasmaProperty lockedByNameProperty, Timestamp snapshotDate) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (lockedDateProperty != null && lockedByNameProperty != null) {
            PropertyPair lockedDatePair = entity.get(lockedDateProperty.getName());
            PropertyPair lockedByNamePair = entity.get(lockedByNameProperty.getName());
            String lockedByName = (String)lockedByNamePair.getValue();
            Date lockedDate = (Date)lockedDatePair.getValue();
            if (this.username.equals(lockedByName)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("unlocking " + entity.getClass().getSimpleName() + " (" + dataObject.getUUIDAsString() + ")"));
                }
                entity.put(lockedByNameProperty.getName(), new PropertyPair(lockedByNameProperty, (Object)this.username));
                entity.put(lockedDateProperty.getName(), new PropertyPair(lockedDateProperty, (Object)this.snapshotMap.getSnapshotDate()));
            } else {
                log.warn((Object)("could not unlock entity " + entity.getClass().getSimpleName() + " (" + dataObject.getUUIDAsString() + ") - current user '" + this.username + "' has no existing or expired lock"));
            }
        }
    }

    protected PropertyPair createValue(PlasmaDataObject dataObject, Object value, Property property) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return this.createValue(dataObject, value, null, property);
    }

    protected PropertyPair createValue(PlasmaDataObject dataObject, Object value, Object oldValue, Property property) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setting " + dataObject.toString() + "." + property.getName()));
        }
        PropertyPair resultValue = this.findResultValue(dataObject, value, property);
        if (oldValue != null) {
            PropertyPair oldResultValue = this.findResultValue(dataObject, oldValue, property);
            resultValue.setOldValue(oldResultValue.getValue());
        }
        return resultValue;
    }

    protected PropertyPair findResultValue(PlasmaDataObject dataObject, Object value, Property property) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object resultValue = value;
        PlasmaProperty valueProperty = null;
        if (!property.getType().isDataType() && !(resultValue instanceof NullValue)) {
            if (!(resultValue instanceof DataObject)) {
                throw new DataAccessException("expected data object for singular reference property " + property.getType().getName() + "." + property.getName() + " but found " + resultValue.getClass().getName());
            }
            DataObject resultDataObject = (DataObject)resultValue;
            CoreDataObject resultCoreObject = (CoreDataObject)resultValue;
            PlasmaType resultType = (PlasmaType)resultDataObject.getType();
            List pkList = resultType.findProperties(KeyType.primary);
            if (pkList == null) {
                throw new DataAccessException("found no pri-key properties found for type '" + property.getType().getName() + "'");
            }
            if (pkList.size() > 1) {
                throw new DataAccessException("multiple pri-key properties found for type '" + property.getType().getName() + "' - not yet supported");
            }
            Object pk = null;
            valueProperty = (PlasmaProperty)pkList.get(0);
            while (!valueProperty.getType().isDataType()) {
                resultDataObject = (CoreDataObject)resultDataObject.get(valueProperty.getName());
                valueProperty = this.statementFactory.getOppositePriKeyProperty((Property)valueProperty);
            }
            pk = resultDataObject.get(valueProperty.getName());
            if (pk == null) {
                UUID uuid = resultCoreObject.getUUID();
                if (uuid == null) {
                    throw new DataAccessException("found no UUID value for entity '" + property.getType().getName() + "' when setting property " + dataObject.getType().toString() + "." + property.getName());
                }
                PropertyPair pkPair = this.snapshotMap.get(uuid, (Property)valueProperty);
                if (pkPair == null) {
                    throw new DataAccessException("found no pri-key value found in entity or mapped to UUID '" + uuid + "' for entity '" + property.getType().getName() + "' when setting property " + dataObject.getType().toString() + "." + property.getName());
                }
                pk = pkPair.getValue();
            }
            resultValue = pk;
            if (log.isDebugEnabled()) {
                log.debug((Object)("set " + dataObject.toString() + "." + property.getName() + " (" + String.valueOf(resultValue) + ")"));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("set " + dataObject.toString() + "." + property.getName() + " (" + String.valueOf(resultValue) + ")"));
        }
        PropertyPair result = null;
        if (!(value instanceof NullValue)) {
            result = new PropertyPair((PlasmaProperty)property, resultValue);
            if (valueProperty != null) {
                result.setValueProp(valueProperty);
            }
        } else {
            result = new PropertyPair((PlasmaProperty)property, null);
            if (valueProperty != null) {
                result.setValueProp(valueProperty);
            }
        }
        return result;
    }

    private Property findCachedProperty(PlasmaType type, Property instanceProp) {
        List result = type.search(instanceProp);
        if (result != null && result.size() > 0) {
            Object obj;
            if (result.size() > 1) {
                log.warn((Object)("expected single value for instance property '" + instanceProp.getName() + "' withing type '" + type.getURI() + "#" + type.getName() + "' and all its base types"));
            }
            if ((obj = result.get(0)) instanceof Property) {
                return (Property)obj;
            }
            log.warn((Object)("expected value for instance property '" + instanceProp.getName() + "' for type '" + type.getURI() + "#" + type.getName() + "' or one of its base types to be a instnace of class, " + Property.class.getName()));
        }
        return null;
    }

    private boolean hasSequenceGenerator() {
        DataAccessProvider provider = PlasmaConfig.getInstance().getDataAccessProvider(DataAccessProviderName.JDBC);
        return provider.getSequenceConfiguration() != null && provider.getSequenceConfiguration().getGeneratorClassName() != null;
    }

    private SequenceGenerator newSequenceGenerator() {
        try {
            DataAccessProvider provider = PlasmaConfig.getInstance().getDataAccessProvider(DataAccessProviderName.JDBC);
            String qualifiedName = provider.getSequenceConfiguration().getGeneratorClassName();
            Class<?> entityClass = Class.forName(qualifiedName);
            Class[] argClasses = new Class[]{};
            Object[] args = new Object[]{};
            Constructor<?> constructor = entityClass.getConstructor(argClasses);
            return (SequenceGenerator)constructor.newInstance(args);
        }
        catch (ClassNotFoundException e) {
            throw new DataAccessException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new DataAccessException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new DataAccessException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new DataAccessException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    protected String printDataObjectInfo(DataObject vo) {
        return vo.getType().getName();
    }

    class UpdatePessimisticVisitor
    implements PlasmaDataGraphVisitor {
        private DataGraph dataGraph;

        public UpdatePessimisticVisitor(DataGraph dataGraph) {
            this.dataGraph = dataGraph;
            ((PlasmaNode)this.dataGraph.getRootObject()).getDataObject().accept((PlasmaDataGraphVisitor)this);
        }

        public void visit(DataObject target, DataObject source, String sourceKey, int level) {
            block6: {
                try {
                    if (!CoreHelper.isFlaggedLocked((DataObject)target) && !CoreHelper.isFlaggedUnlocked((DataObject)target)) break block6;
                    try {
                        GraphDispatcher.this.update(this.dataGraph, (PlasmaDataObject)target);
                    }
                    catch (SQLException e) {
                        throw new RDBServiceException(e);
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new DataAccessException((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new DataAccessException((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new DataAccessException((Throwable)e);
                }
            }
        }
    }
}

