/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.rdb.filter;

import java.util.List;
import org.plasma.config.DataAccessProviderName;
import org.plasma.config.PlasmaConfig;
import org.plasma.config.RDBMSVendorName;
import org.plasma.query.model.Function;
import org.plasma.query.model.FunctionArg;
import org.plasma.sdo.DataFlavor;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.access.DataAccessException;

public class Functions {
    public static String wrap(PlasmaProperty endpointProp, List<Function> functions, String targetAlias) {
        DataFlavor flavor = endpointProp.getDataFlavor();
        RDBMSVendorName vendor = PlasmaConfig.getInstance().getRDBMSProviderVendor(DataAccessProviderName.JDBC);
        StringBuilder buf = new StringBuilder();
        String result = String.valueOf(targetAlias) + "." + endpointProp.getPhysicalName();
        for (Function func : functions) {
            Functions.validateFunction(func, endpointProp, flavor);
            switch (vendor) {
                case ORACLE: {
                    result = Functions.beginFunctionOracle(func, endpointProp, result);
                    break;
                }
                case MYSQL: {
                    result = Functions.beginFunctionMySql(func, endpointProp, result);
                }
            }
        }
        return result;
    }

    private static String beginFunctionOracle(Function func, PlasmaProperty endpointProp, String propertyArg) {
        StringBuilder buf = new StringBuilder();
        switch (func.getName()) {
            case MIN: 
            case MAX: 
            case AVG: 
            case SUM: {
                break;
            }
            case ABS: {
                buf.append("ABS(");
                buf.append(propertyArg);
                buf.append(")");
                break;
            }
            case CEILING: {
                buf.append("CEIL(");
                buf.append(propertyArg);
                buf.append(")");
                break;
            }
            case FLOOR: {
                buf.append("FLOOR(");
                buf.append(propertyArg);
                buf.append(")");
                break;
            }
            case ROUND: {
                buf.append("ROUND(");
                buf.append(propertyArg);
                buf.append(")");
                break;
            }
            case SUBSTRING_BEFORE: {
                String arg = ((FunctionArg)func.getFunctionArgs().get(0)).getValue();
                buf.append("SUBSTR(");
                buf.append(propertyArg);
                buf.append(",0, INSTR(");
                buf.append(propertyArg);
                buf.append(",'");
                buf.append(arg);
                buf.append("'))");
                break;
            }
            case SUBSTRING_AFTER: {
                String arg = ((FunctionArg)func.getFunctionArgs().get(0)).getValue();
                buf.append("SUBSTR(");
                buf.append(propertyArg);
                buf.append(",INSTR(");
                buf.append(propertyArg);
                buf.append(",'");
                buf.append(arg);
                buf.append("'))");
                break;
            }
            case NORMALIZE_SPACE: {
                buf.append("REGEXP_REPLACE(TRIM(");
                buf.append(propertyArg);
                buf.append("), '\\s+', ' ')");
                break;
            }
            case UPPER_CASE: {
                buf.append("UPPER(");
                buf.append(propertyArg);
                buf.append(")");
                break;
            }
            case LOWER_CASE: {
                buf.append("LOWER(");
                buf.append(propertyArg);
                buf.append(")");
            }
        }
        return buf.toString();
    }

    private static String beginFunctionMySql(Function func, PlasmaProperty endpointProp, String propertyArg) {
        StringBuilder buf = new StringBuilder();
        switch (func.getName()) {
            case MIN: 
            case MAX: 
            case AVG: 
            case SUM: {
                break;
            }
            case ABS: {
                buf.append("ABS(");
                buf.append(propertyArg);
                buf.append(")");
                break;
            }
            case CEILING: {
                buf.append("CEIL(");
                buf.append(propertyArg);
                buf.append(")");
                break;
            }
            case FLOOR: {
                buf.append("FLOOR(");
                buf.append(propertyArg);
                buf.append(")");
                break;
            }
            case ROUND: {
                buf.append("ROUND(");
                buf.append(propertyArg);
                buf.append(")");
                break;
            }
            case SUBSTRING_BEFORE: {
                String arg = ((FunctionArg)func.getFunctionArgs().get(0)).getValue();
                buf.append("SUBSTRING_INDEX(");
                buf.append(propertyArg);
                buf.append(",'");
                buf.append(arg);
                buf.append("', 1)");
                break;
            }
            case SUBSTRING_AFTER: {
                String arg = ((FunctionArg)func.getFunctionArgs().get(0)).getValue();
                buf.append("SUBSTR(");
                buf.append(propertyArg);
                buf.append(",LOCATE(");
                buf.append("'");
                buf.append(arg);
                buf.append("'");
                buf.append(",");
                buf.append(propertyArg);
                buf.append("))");
                break;
            }
            case NORMALIZE_SPACE: {
                buf.append("TRIM(BOTH ' ' FROM ");
                buf.append(propertyArg);
                buf.append(")");
                break;
            }
            case UPPER_CASE: {
                buf.append("UPPER(");
                buf.append(propertyArg);
                buf.append(")");
                break;
            }
            case LOWER_CASE: {
                buf.append("LOWER(");
                buf.append(propertyArg);
                buf.append(")");
            }
        }
        return buf.toString();
    }

    private static void validateFunction(Function func, PlasmaProperty endpointProp, DataFlavor flavor) {
        switch (func.getName()) {
            case MIN: 
            case MAX: 
            case AVG: 
            case SUM: {
                throw new DataAccessException("aggregate function '" + func.getName() + "' not applicable in query Where clause");
            }
            case ABS: 
            case CEILING: 
            case FLOOR: 
            case ROUND: {
                if (Functions.isNumber(flavor)) break;
                throw new DataAccessException("function '" + func.getName() + "' not applicable for non numeric property, " + endpointProp.toString());
            }
            case SUBSTRING_BEFORE: 
            case SUBSTRING_AFTER: {
                if (func.getFunctionArgs().size() == 1) break;
                throw new DataAccessException("function '" + func.getName() + "' requires a single string argument - " + func.getFunctionArgs().size() + " argument(s) found");
            }
            case NORMALIZE_SPACE: 
            case UPPER_CASE: 
            case LOWER_CASE: {
                if (Functions.isString(flavor)) break;
                throw new DataAccessException("function '" + func.getName() + "' not applicable for non-string property, " + endpointProp.toString());
            }
            case YEAR_FROM_DATE: 
            case MONTH_FROM_DATE: 
            case DAY_FROM_DATE: {
                if (Functions.isString(flavor)) break;
                throw new DataAccessException("function '" + func.getName() + "' not applicable for non-temporal property, " + endpointProp.toString());
            }
        }
    }

    private static boolean isNumber(DataFlavor flavor) {
        switch (flavor) {
            case integral: 
            case real: {
                return true;
            }
        }
        return false;
    }

    private static boolean isString(DataFlavor flavor) {
        switch (flavor) {
            case string: {
                return true;
            }
        }
        return false;
    }
}

