/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.rdb.graph;

import commonj.sdo.DataGraph;
import commonj.sdo.Property;
import commonj.sdo.Type;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudgraph.common.concurrent.GraphMetricVisitor;
import org.cloudgraph.rdb.filter.RDBStatementExecutor;
import org.cloudgraph.rdb.filter.RDBStatementFactory;
import org.cloudgraph.store.lang.DefaultAssembler;
import org.cloudgraph.store.lang.LangStoreGraphAssembler;
import org.cloudgraph.store.lang.StatementExecutor;
import org.cloudgraph.store.lang.StatementFactory;
import org.plasma.query.collector.SelectionCollector;
import org.plasma.sdo.PlasmaDataGraphVisitor;
import org.plasma.sdo.PlasmaDataObject;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.access.provider.common.PropertyPair;
import org.plasma.sdo.core.CoreNode;

public class GraphAssembler
extends DefaultAssembler
implements LangStoreGraphAssembler {
    private static Log log = LogFactory.getLog(GraphAssembler.class);

    public GraphAssembler(PlasmaType rootType, SelectionCollector collector, Timestamp snapshotDate, Connection con) {
        super(rootType, collector, (StatementFactory)new RDBStatementFactory(), (StatementExecutor)new RDBStatementExecutor(con), new HashMap(), snapshotDate);
    }

    public void assemble(List<PropertyPair> results) {
        long before = System.currentTimeMillis();
        DataGraph dataGraph = this.initRoot(results);
        CoreNode rootNode = (CoreNode)dataGraph.getRootObject();
        for (PropertyPair pair : results) {
            if (pair.getProp().isMany() || pair.getProp().getType().isDataType()) continue;
            List childKeyProps = this.getChildKeyPairs(pair);
            this.assemble((PlasmaType)pair.getProp().getType(), this.root, pair.getProp(), childKeyProps, 1);
        }
        Set props = this.collector.getProperties((Type)this.rootType);
        for (Property p : props) {
            PlasmaProperty prop = (PlasmaProperty)p;
            if (!prop.isMany() || prop.getType().isDataType()) continue;
            List childKeyProps = this.getChildKeyPairs(this.root, prop);
            this.assemble((PlasmaType)prop.getType(), this.root, prop, childKeyProps, 1);
        }
        long after = System.currentTimeMillis();
        rootNode.getValueObject().put("GraphAssemblyTime", (Object)(after - before));
        GraphMetricVisitor visitor = new GraphMetricVisitor();
        this.root.accept((PlasmaDataGraphVisitor)visitor);
        rootNode.getValueObject().put("GraphNodeCount", (Object)visitor.getCount());
        rootNode.getValueObject().put("GraphDepth", (Object)visitor.getDepth());
        rootNode.getValueObject().put("GraphThreadCount", (Object)visitor.getThreadCount());
    }

    protected void assemble(PlasmaType targetType, PlasmaDataObject source, PlasmaProperty sourceProperty, List<PropertyPair> childKeyPairs, int level) {
        Set props = this.collector.getProperties((Type)targetType, level);
        if (props == null) {
            props = EMPTY_PROPERTY_SET;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(String.valueOf(level) + ":assemble: " + source.getType().getName() + "." + sourceProperty.getName() + "->" + targetType.getName() + ": " + props));
        }
        List result = this.getPredicateResult(targetType, sourceProperty, props, childKeyPairs);
        if (log.isDebugEnabled()) {
            log.debug((Object)(String.valueOf(level) + ":results: " + result.size()));
        }
        Map resultMap = this.collectResults(targetType, source, sourceProperty, result);
        for (PlasmaDataObject target : resultMap.keySet()) {
            List row = (List)resultMap.get(target);
            for (PropertyPair pair : row) {
                if (pair.getProp().isMany() || pair.getProp().getType().isDataType() || !pair.isQueryProperty()) continue;
                List nextKeyPairs = this.getNextKeyPairs(target, pair, level);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(String.valueOf(level) + ":traverse: (" + pair.getProp().isMany() + ") " + pair.getProp().toString() + ":" + String.valueOf(pair.getValue())));
                }
                this.assemble((PlasmaType)pair.getProp().getType(), target, pair.getProp(), nextKeyPairs, level + 1);
            }
            for (Property p : props) {
                PlasmaProperty prop = (PlasmaProperty)p;
                if (!prop.isMany() || prop.getType().isDataType()) continue;
                List childKeyProps = this.getChildKeyProps(target, targetType, prop);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(String.valueOf(level) + ":traverse: (" + prop.isMany() + ") " + prop.toString() + " - " + childKeyProps.toArray().toString()));
                }
                this.assemble((PlasmaType)prop.getType(), target, prop, childKeyProps, level + 1);
            }
        }
    }
}

