/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.rdb.service;

import commonj.sdo.Property;
import commonj.sdo.Type;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudgraph.rdb.service.RDBServiceException;
import org.plasma.sdo.DataFlavor;
import org.plasma.sdo.DataType;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.helper.DataConverter;

public class RDBDataConverter {
    private static Log log = LogFactory.getFactory().getInstance(RDBDataConverter.class);
    public static RDBDataConverter INSTANCE = RDBDataConverter.initializeInstance();
    private Map<Integer, String> sqlTypeMap = new HashMap<Integer, String>();

    private RDBDataConverter() {
        Field[] fields = Types.class.getFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                String name = fields[i].getName();
                Integer value = (Integer)fields[i].get(null);
                this.sqlTypeMap.put(value, name);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private static synchronized RDBDataConverter initializeInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RDBDataConverter();
        }
        return INSTANCE;
    }

    public Object fromJDBCDataType(ResultSet rs, int columnIndex, int sourceType, PlasmaProperty targetProperty) throws SQLException {
        Object result = this.convertFrom(rs, columnIndex, sourceType, (Property)targetProperty);
        return result;
    }

    public int toJDBCDataType(PlasmaProperty sourceProperty, Object value) throws SQLException {
        int result = this.convertToSqlType((Property)sourceProperty, value);
        return result;
    }

    public Object toJDBCDataValue(PlasmaProperty sourceProperty, Object value) throws SQLException {
        Object result = this.convertToSqlValue((Property)sourceProperty, value);
        return result;
    }

    public DataFlavor toJDBCDataFlavor(PlasmaProperty sourceProperty) {
        if (!sourceProperty.getType().isDataType()) {
            throw new IllegalArgumentException("expected data type property, not " + sourceProperty.toString());
        }
        PlasmaProperty dataProperty = sourceProperty;
        return dataProperty.getDataFlavor();
    }

    private Object convertToSqlValue(Property property, Object value) throws SQLException {
        Object result;
        if (!property.getType().isDataType()) {
            throw new IllegalArgumentException("expected data type property, not " + property.toString());
        }
        DataType dataType = DataType.valueOf((String)property.getType().getName());
        switch (dataType) {
            case String: 
            case URI: 
            case Month: 
            case MonthDay: 
            case Day: 
            case Time: 
            case Year: 
            case YearMonth: 
            case YearMonthDay: 
            case Duration: {
                result = DataConverter.INSTANCE.toString(property.getType(), value);
                break;
            }
            case Date: {
                Date date = DataConverter.INSTANCE.toDate(property.getType(), value);
                result = new Timestamp(date.getTime());
                break;
            }
            case DateTime: {
                Date date = DataConverter.INSTANCE.toDate(property.getType(), value);
                result = new Timestamp(date.getTime());
                break;
            }
            case Decimal: {
                result = DataConverter.INSTANCE.toDecimal(property.getType(), value);
                break;
            }
            case Bytes: {
                result = DataConverter.INSTANCE.toBytes(property.getType(), value);
                break;
            }
            case Byte: {
                result = DataConverter.INSTANCE.toByte(property.getType(), value);
                break;
            }
            case Boolean: {
                result = DataConverter.INSTANCE.toBoolean(property.getType(), value);
                break;
            }
            case Character: {
                result = DataConverter.INSTANCE.toString(property.getType(), value);
                break;
            }
            case Double: {
                result = DataConverter.INSTANCE.toDouble(property.getType(), value);
                break;
            }
            case Float: {
                result = DataConverter.INSTANCE.toDouble(property.getType(), value);
                break;
            }
            case Int: {
                result = DataConverter.INSTANCE.toInt(property.getType(), value);
                break;
            }
            case Integer: {
                result = DataConverter.INSTANCE.toInteger(property.getType(), value);
                break;
            }
            case Long: {
                result = DataConverter.INSTANCE.toLong(property.getType(), value);
                break;
            }
            case Short: {
                result = DataConverter.INSTANCE.toShort(property.getType(), value);
                break;
            }
            case Strings: {
                result = DataConverter.INSTANCE.toString(property.getType(), value);
                break;
            }
            default: {
                result = DataConverter.INSTANCE.toString(property.getType(), value);
            }
        }
        return result;
    }

    private int convertToSqlType(Property property, Object value) {
        int result;
        if (!property.getType().isDataType()) {
            throw new IllegalArgumentException("expected data type property, not " + property.toString());
        }
        DataType dataType = DataType.valueOf((String)property.getType().getName());
        switch (dataType) {
            case String: 
            case URI: 
            case Month: 
            case MonthDay: 
            case Day: 
            case Time: 
            case Year: 
            case YearMonth: 
            case YearMonthDay: 
            case Duration: 
            case Strings: {
                result = 12;
                break;
            }
            case Date: {
                result = 93;
                break;
            }
            case DateTime: {
                result = 93;
                break;
            }
            case Decimal: {
                result = 3;
                break;
            }
            case Bytes: {
                result = -3;
                break;
            }
            case Byte: {
                result = -3;
                break;
            }
            case Boolean: {
                result = 16;
                break;
            }
            case Character: {
                result = 1;
                break;
            }
            case Double: {
                result = 8;
                break;
            }
            case Float: {
                result = 6;
                break;
            }
            case Int: {
                result = 4;
                break;
            }
            case Integer: {
                result = -5;
                break;
            }
            case Long: {
                result = 4;
                break;
            }
            case Short: {
                result = 5;
                break;
            }
            default: {
                result = 12;
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object convertFrom(ResultSet rs, int columnIndex, int sourceType, Property property) throws SQLException {
        Object result = null;
        if (!property.getType().isDataType()) {
            throw new IllegalArgumentException("expected data type property, not " + property.toString());
        }
        DataType targetDataType = DataType.valueOf((String)property.getType().getName());
        switch (targetDataType) {
            case String: 
            case URI: 
            case Month: 
            case MonthDay: 
            case Day: 
            case Time: 
            case Year: 
            case YearMonth: 
            case YearMonthDay: 
            case Duration: {
                return rs.getString(columnIndex);
            }
            case Date: {
                Timestamp ts = rs.getTimestamp(columnIndex);
                if (ts == null) return result;
                return new Date(ts.getTime());
            }
            case DateTime: {
                Timestamp ts = rs.getTimestamp(columnIndex);
                if (ts == null) return result;
                return new Date(ts.getTime());
            }
            case Decimal: {
                return rs.getBigDecimal(columnIndex);
            }
            case Bytes: {
                if (sourceType != 2004) {
                    return rs.getBytes(columnIndex);
                }
                if (sourceType != 2004) return result;
                Blob blob = rs.getBlob(columnIndex);
                if (blob == null) return result;
                long blobLen = blob.length();
                InputStream is = blob.getBinaryStream();
                try {
                    byte[] bytes = IOUtils.toByteArray((InputStream)is);
                    long len = bytes.length;
                    result = bytes;
                }
                catch (IOException e) {
                    try {
                        throw new RDBServiceException(e);
                    }
                    catch (Throwable throwable) {
                        try {
                            is.close();
                            throw throwable;
                        }
                        catch (IOException e2) {
                            log.error((Object)e2.getMessage(), (Throwable)e2);
                        }
                        throw throwable;
                    }
                }
                try {
                    is.close();
                    return result;
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    return result;
                }
            }
            case Byte: {
                return rs.getByte(columnIndex);
            }
            case Boolean: {
                return rs.getBoolean(columnIndex);
            }
            case Character: {
                return rs.getInt(columnIndex);
            }
            case Double: {
                return rs.getDouble(columnIndex);
            }
            case Float: {
                return Float.valueOf(rs.getFloat(columnIndex));
            }
            case Int: {
                return rs.getInt(columnIndex);
            }
            case Integer: {
                return new BigInteger(rs.getString(columnIndex));
            }
            case Long: {
                return rs.getLong(columnIndex);
            }
            case Short: {
                return rs.getShort(columnIndex);
            }
            case Strings: {
                String value = rs.getString(columnIndex);
                if (value == null) return result;
                String[] values = value.split("\\s");
                ArrayList<String> list = new ArrayList<String>(values.length);
                int i = 0;
                while (i < values.length) {
                    list.add(values[i]);
                    ++i;
                }
                return list;
            }
        }
        return rs.getObject(columnIndex);
    }

    public String toJDBCString(Type sourceType, PlasmaProperty sourceProperty, Object value) {
        String result = null;
        DataFlavor flavor = sourceProperty.getDataFlavor();
        switch (flavor) {
            case integral: 
            case real: {
                result = value.toString();
                break;
            }
            case string: {
                result = "'" + value.toString() + "'";
                break;
            }
            default: {
                result = value.toString();
            }
        }
        return result;
    }

    public String getJdbcTypeName(int jdbcType) {
        return this.sqlTypeMap.get(jdbcType);
    }
}

