/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.rdb.service;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.sdo.DataFlavor;
import org.plasma.sdo.DataType;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.access.DataAccessException;
import org.plasma.sdo.helper.DataConverter;
import org.plasma.sdo.profile.KeyType;

public class RDBDataConverter {
    private static Log log = LogFactory.getFactory().getInstance(RDBDataConverter.class);
    public static RDBDataConverter INSTANCE = RDBDataConverter.initializeInstance();
    private Map<Integer, String> sqlTypeMap = new HashMap<Integer, String>();

    private RDBDataConverter() {
        Field[] fields = Types.class.getFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                String name = fields[i].getName();
                Integer value = (Integer)fields[i].get(null);
                this.sqlTypeMap.put(value, name);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private static synchronized RDBDataConverter initializeInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RDBDataConverter();
        }
        return INSTANCE;
    }

    public Object fromJDBCDataType(ResultSet rs, int columnIndex, int sourceType, PlasmaProperty targetProperty) throws SQLException {
        Object result = null;
        if (targetProperty.getType().isDataType()) {
            result = this.convertFrom(rs, columnIndex, sourceType, (Property)targetProperty);
        } else {
            Property pkProp = this.getOppositePriKeyProperty((Property)targetProperty);
            result = this.convertFrom(rs, columnIndex, sourceType, pkProp);
        }
        return result;
    }

    public int toJDBCDataType(PlasmaProperty sourceProperty, Object value) throws SQLException {
        int result;
        if (sourceProperty.getType().isDataType()) {
            result = this.convertToSqlType((Property)sourceProperty, value);
        } else {
            Property pkProp = this.getOppositePriKeyProperty((Property)sourceProperty);
            result = this.convertToSqlType(pkProp, value);
        }
        return result;
    }

    public Object toJDBCDataValue(PlasmaProperty sourceProperty, Object value) throws SQLException {
        Object result;
        if (sourceProperty.getType().isDataType()) {
            result = this.convertToSqlValue((Property)sourceProperty, value);
        } else {
            Property pkProp = this.getOppositePriKeyProperty((Property)sourceProperty);
            if (value instanceof DataObject) {
                DataObject dataObject = (DataObject)value;
                Object pk = dataObject.get(pkProp);
                result = this.convertToSqlValue(pkProp, pk);
            } else {
                result = this.convertToSqlValue(pkProp, value);
            }
        }
        return result;
    }

    public DataFlavor toJDBCDataFlavor(PlasmaProperty sourceProperty) {
        PlasmaProperty dataProperty = sourceProperty;
        if (!sourceProperty.getType().isDataType()) {
            dataProperty = (PlasmaProperty)this.getOppositePriKeyProperty((Property)sourceProperty);
        }
        return dataProperty.getDataFlavor();
    }

    private Object convertToSqlValue(Property property, Object value) throws SQLException {
        Object result;
        if (!property.getType().isDataType()) {
            throw new IllegalArgumentException("expected data type property, not " + property.toString());
        }
        DataType dataType = DataType.valueOf((String)property.getType().getName());
        switch (dataType) {
            case String: 
            case URI: 
            case Month: 
            case MonthDay: 
            case Day: 
            case Time: 
            case Year: 
            case YearMonth: 
            case YearMonthDay: 
            case Duration: {
                result = DataConverter.INSTANCE.toString(property.getType(), value);
                break;
            }
            case Date: {
                Date date = DataConverter.INSTANCE.toDate(property.getType(), value);
                result = new Timestamp(date.getTime());
                break;
            }
            case DateTime: {
                Date date = DataConverter.INSTANCE.toDate(property.getType(), value);
                result = new Timestamp(date.getTime());
                break;
            }
            case Decimal: {
                result = DataConverter.INSTANCE.toDecimal(property.getType(), value);
                break;
            }
            case Bytes: {
                result = DataConverter.INSTANCE.toBytes(property.getType(), value);
                break;
            }
            case Byte: {
                result = DataConverter.INSTANCE.toByte(property.getType(), value);
                break;
            }
            case Boolean: {
                result = DataConverter.INSTANCE.toBoolean(property.getType(), value);
                break;
            }
            case Character: {
                result = DataConverter.INSTANCE.toString(property.getType(), value);
                break;
            }
            case Double: {
                result = DataConverter.INSTANCE.toDouble(property.getType(), value);
                break;
            }
            case Float: {
                result = DataConverter.INSTANCE.toDouble(property.getType(), value);
                break;
            }
            case Int: {
                result = DataConverter.INSTANCE.toInt(property.getType(), value);
                break;
            }
            case Integer: {
                result = DataConverter.INSTANCE.toInteger(property.getType(), value);
                break;
            }
            case Long: {
                result = DataConverter.INSTANCE.toLong(property.getType(), value);
                break;
            }
            case Short: {
                result = DataConverter.INSTANCE.toShort(property.getType(), value);
                break;
            }
            case Strings: {
                result = DataConverter.INSTANCE.toString(property.getType(), value);
                break;
            }
            default: {
                result = DataConverter.INSTANCE.toString(property.getType(), value);
            }
        }
        return result;
    }

    private int convertToSqlType(Property property, Object value) {
        int result;
        if (!property.getType().isDataType()) {
            throw new IllegalArgumentException("expected data type property, not " + property.toString());
        }
        DataType dataType = DataType.valueOf((String)property.getType().getName());
        switch (dataType) {
            case String: 
            case URI: 
            case Month: 
            case MonthDay: 
            case Day: 
            case Time: 
            case Year: 
            case YearMonth: 
            case YearMonthDay: 
            case Duration: 
            case Strings: {
                result = 12;
                break;
            }
            case Date: {
                result = 93;
                break;
            }
            case DateTime: {
                result = 93;
                break;
            }
            case Decimal: {
                result = 3;
                break;
            }
            case Bytes: {
                result = -3;
                break;
            }
            case Byte: {
                result = -3;
                break;
            }
            case Boolean: {
                result = 16;
                break;
            }
            case Character: {
                result = 1;
                break;
            }
            case Double: {
                result = 8;
                break;
            }
            case Float: {
                result = 6;
                break;
            }
            case Int: {
                result = 4;
                break;
            }
            case Integer: {
                result = -5;
                break;
            }
            case Long: {
                result = 4;
                break;
            }
            case Short: {
                result = 5;
                break;
            }
            default: {
                result = 12;
            }
        }
        return result;
    }

    private Property getOppositePriKeyProperty(Property targetProperty) {
        PlasmaProperty opposite = (PlasmaProperty)targetProperty.getOpposite();
        if (opposite == null) {
            throw new DataAccessException("no opposite property found - cannot map from reference property, " + targetProperty.getType() + "." + targetProperty.getName());
        }
        List pkeyProps = ((PlasmaType)opposite.getContainingType()).findProperties(KeyType.primary);
        if (pkeyProps.size() == 0) {
            throw new DataAccessException("no opposite pri-key properties found - cannot map from reference property, " + targetProperty.getType() + "." + targetProperty.getName());
        }
        if (pkeyProps.size() > 1) {
            throw new DataAccessException("multiple opposite pri-key properties found - cannot map from reference property, " + targetProperty.getType() + "." + targetProperty.getName());
        }
        Property pkProp = (Property)pkeyProps.get(0);
        return pkProp;
    }

    private Object convertFrom(ResultSet rs, int columnIndex, int sourceType, Property property) throws SQLException {
        ArrayList<String> result = null;
        if (!property.getType().isDataType()) {
            throw new IllegalArgumentException("expected data type property, not " + property.toString());
        }
        DataType targetDataType = DataType.valueOf((String)property.getType().getName());
        switch (targetDataType) {
            case String: 
            case URI: 
            case Month: 
            case MonthDay: 
            case Day: 
            case Time: 
            case Year: 
            case YearMonth: 
            case YearMonthDay: 
            case Duration: {
                result = rs.getString(columnIndex);
                break;
            }
            case Date: {
                Timestamp ts = rs.getTimestamp(columnIndex);
                if (ts == null) break;
                result = new Date(ts.getTime());
                break;
            }
            case DateTime: {
                Timestamp ts = rs.getTimestamp(columnIndex);
                if (ts == null) break;
                result = new Date(ts.getTime());
                break;
            }
            case Decimal: {
                result = rs.getBigDecimal(columnIndex);
                break;
            }
            case Bytes: {
                result = (ArrayList<String>)rs.getBytes(columnIndex);
                break;
            }
            case Byte: {
                result = rs.getByte(columnIndex);
                break;
            }
            case Boolean: {
                result = rs.getBoolean(columnIndex);
                break;
            }
            case Character: {
                result = rs.getInt(columnIndex);
                break;
            }
            case Double: {
                result = rs.getDouble(columnIndex);
                break;
            }
            case Float: {
                result = Float.valueOf(rs.getFloat(columnIndex));
                break;
            }
            case Int: {
                result = rs.getInt(columnIndex);
                break;
            }
            case Integer: {
                result = new BigInteger(rs.getString(columnIndex));
                break;
            }
            case Long: {
                result = rs.getLong(columnIndex);
                break;
            }
            case Short: {
                result = rs.getShort(columnIndex);
                break;
            }
            case Strings: {
                String value = rs.getString(columnIndex);
                String[] values = value.split("\\s");
                ArrayList<String> list = new ArrayList<String>(values.length);
                for (int i = 0; i < values.length; ++i) {
                    list.add(values[i]);
                }
                result = list;
                break;
            }
            default: {
                result = rs.getObject(columnIndex);
            }
        }
        return result;
    }

    public String toJDBCString(Type sourceType, PlasmaProperty sourceProperty, Object value) {
        String result = null;
        DataFlavor flavor = sourceProperty.getDataFlavor();
        switch (flavor) {
            case integral: 
            case real: {
                result = value.toString();
                break;
            }
            case string: {
                result = "'" + value.toString() + "'";
                break;
            }
            default: {
                result = value.toString();
            }
        }
        return result;
    }

    public String getJdbcTypeName(int jdbcType) {
        return this.sqlTypeMap.get(jdbcType);
    }
}

