/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.rdb.service;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudgraph.rdb.filter.FilterAssembler;
import org.cloudgraph.rdb.service.AliasMap;
import org.cloudgraph.rdb.service.JDBCSupport;
import org.cloudgraph.rdb.service.RDBDataConverter;
import org.plasma.query.collector.PropertySelectionCollector;
import org.plasma.query.model.Where;
import org.plasma.sdo.PlasmaDataGraph;
import org.plasma.sdo.PlasmaDataObject;
import org.plasma.sdo.PlasmaNode;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.access.DataAccessException;
import org.plasma.sdo.access.DataGraphAssembler;
import org.plasma.sdo.access.provider.common.PropertyPair;
import org.plasma.sdo.core.CoreNode;
import org.plasma.sdo.helper.PlasmaDataFactory;
import org.plasma.sdo.profile.KeyType;

public class GraphAssembler
extends JDBCSupport
implements DataGraphAssembler {
    private static Log log = LogFactory.getLog(GraphAssembler.class);
    private PlasmaType rootType;
    private PlasmaDataObject root;
    private Map<Type, List<String>> propertyMap;
    private Map<Property, Where> predicateMap;
    private Timestamp snapshotDate;
    private Connection con;
    private RDBDataConverter converter;
    private Map<Integer, PlasmaDataObject> dataObjectMap = new HashMap<Integer, PlasmaDataObject>();
    private Comparator<PropertyPair> nameComparator;

    private GraphAssembler() {
    }

    public GraphAssembler(PlasmaType rootType, PropertySelectionCollector collector, Timestamp snapshotDate, Connection con) {
        this.rootType = rootType;
        this.propertyMap = collector.getResult();
        this.predicateMap = collector.getPredicateMap();
        this.snapshotDate = snapshotDate;
        this.con = con;
        this.converter = RDBDataConverter.INSTANCE;
        this.nameComparator = new Comparator<PropertyPair>(){

            @Override
            public int compare(PropertyPair o1, PropertyPair o2) {
                return o1.getProp().getName().compareTo(o2.getProp().getName());
            }
        };
    }

    public void assemble(List<PropertyPair> results) throws SQLException {
        PlasmaDataGraph dataGraph = PlasmaDataFactory.INSTANCE.createDataGraph();
        this.root = (PlasmaDataObject)dataGraph.createRootObject((Type)this.rootType);
        if (log.isDebugEnabled()) {
            log.debug((Object)("assembling root: " + this.root.getType().getName()));
        }
        CoreNode rootNode = (CoreNode)this.root;
        if (this.snapshotDate != null) {
            rootNode.setValue("snapshotTimestamp", (Object)this.snapshotDate);
        }
        for (PropertyPair pair : results) {
            if (!pair.getProp().getType().isDataType()) continue;
            rootNode.setValue(pair.getProp().getName(), pair.getValue());
        }
        for (PropertyPair pair : results) {
            if (pair.getProp().isMany() || pair.getProp().getType().isDataType()) continue;
            ArrayList<PropertyPair> childKeyProps = new ArrayList<PropertyPair>();
            List childPkProps = ((PlasmaType)pair.getProp().getType()).findProperties(KeyType.primary);
            if (childPkProps.size() == 1) {
                childKeyProps.add(new PropertyPair((PlasmaProperty)childPkProps.get(0), pair.getValue()));
            } else {
                this.throwPriKeyError(childPkProps, pair.getProp().getType(), (Property)pair.getProp());
            }
            this.assemble((PlasmaType)pair.getProp().getType(), this.root, pair.getProp(), childKeyProps);
        }
        List<String> names = this.propertyMap.get(this.rootType);
        for (String name : names) {
            PlasmaProperty prop = (PlasmaProperty)this.rootType.getProperty(name);
            if (!prop.isMany() || prop.getType().isDataType()) continue;
            PlasmaProperty opposite = (PlasmaProperty)prop.getOpposite();
            if (opposite == null) {
                throw new DataAccessException("no opposite property found - cannot map from many property, " + prop.getType() + "." + prop.getName());
            }
            ArrayList<PropertyPair> childKeyProps = new ArrayList<PropertyPair>();
            List rootPkProps = ((PlasmaType)this.root.getType()).findProperties(KeyType.primary);
            if (rootPkProps.size() == 1) {
                childKeyProps.add(new PropertyPair(opposite, this.root.get((Property)rootPkProps.get(0))));
            } else {
                this.throwPriKeyError(rootPkProps, this.root.getType(), (Property)prop);
            }
            this.assemble((PlasmaType)prop.getType(), this.root, prop, childKeyProps);
        }
    }

    private void assemble(PlasmaType targetType, PlasmaDataObject source, PlasmaProperty sourceProperty, List<PropertyPair> childKeyPairs) throws SQLException {
        List<String> names = this.propertyMap.get(targetType);
        if (log.isDebugEnabled()) {
            log.debug((Object)("assemble: " + source.getType().getName() + "." + sourceProperty.getName() + ": " + names));
        }
        List<List<PropertyPair>> result = null;
        Where where = this.predicateMap.get(sourceProperty);
        if (where == null) {
            StringBuilder query = this.createSelect(targetType, names, childKeyPairs);
            result = this.fetch(targetType, query, this.con);
        } else {
            AliasMap aliasMap = new AliasMap(targetType);
            FilterAssembler filterAssembler = new FilterAssembler(where, (Type)targetType, aliasMap);
            StringBuilder query = this.createSelect(targetType, names, childKeyPairs, filterAssembler, aliasMap);
            result = this.fetch(targetType, query, filterAssembler.getParams(), this.con);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("results: " + result.size()));
        }
        HashMap<PlasmaDataObject, List<PropertyPair>> resultMap = new HashMap<PlasmaDataObject, List<PropertyPair>>();
        for (List<PropertyPair> row : result) {
            PlasmaDataObject target = this.findDataObject(targetType, row);
            if (target == null) {
                target = this.createDataObject(row, source, sourceProperty);
                resultMap.put(target, row);
                continue;
            }
            this.link(target, source, sourceProperty);
        }
        for (PlasmaDataObject target : resultMap.keySet()) {
            List row = (List)resultMap.get(target);
            for (PropertyPair pair : row) {
                if (pair.getProp().isMany() || pair.getProp().getType().isDataType()) continue;
                ArrayList<PropertyPair> nextKeyPairs = new ArrayList<PropertyPair>();
                List nextKeyProps = ((PlasmaType)pair.getProp().getType()).findProperties(KeyType.primary);
                if (nextKeyProps.size() == 1) {
                    nextKeyPairs.add(new PropertyPair((PlasmaProperty)nextKeyProps.get(0), pair.getValue()));
                } else {
                    this.throwPriKeyError(nextKeyProps, pair.getProp().getType(), (Property)pair.getProp());
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("traverse: (" + pair.getProp().isMany() + ") " + pair.getProp().getType().getName() + "." + pair.getProp().getName()));
                }
                this.assemble((PlasmaType)pair.getProp().getType(), target, pair.getProp(), nextKeyPairs);
            }
            for (String name : names) {
                PlasmaProperty prop = (PlasmaProperty)targetType.getProperty(name);
                if (!prop.isMany() || prop.getType().isDataType()) continue;
                PlasmaProperty opposite = (PlasmaProperty)prop.getOpposite();
                if (opposite == null) {
                    throw new DataAccessException("no opposite property found - cannot map from many property, " + prop.getType() + "." + prop.getName());
                }
                ArrayList<PropertyPair> childKeyProps = new ArrayList<PropertyPair>();
                List nextKeyProps = targetType.findProperties(KeyType.primary);
                if (nextKeyProps.size() == 1) {
                    childKeyProps.add(new PropertyPair(opposite, target.get((Property)nextKeyProps.get(0))));
                } else {
                    this.throwPriKeyError(nextKeyProps, (Type)targetType, (Property)prop);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("traverse: (" + prop.isMany() + ") " + target.getType().getName() + "." + prop.getName()));
                }
                this.assemble((PlasmaType)prop.getType(), target, prop, childKeyProps);
            }
        }
    }

    private PlasmaDataObject createDataObject(List<PropertyPair> row, PlasmaDataObject source, PlasmaProperty sourceProperty) {
        PlasmaDataObject target = (PlasmaDataObject)source.createDataObject((Property)sourceProperty);
        if (log.isDebugEnabled()) {
            log.debug((Object)("create: " + source.getType().getName() + "." + sourceProperty.getName() + "->" + target.getType().getName()));
        }
        CoreNode node = (CoreNode)target;
        if (this.snapshotDate != null) {
            node.setValue("snapshotTimestamp", (Object)this.snapshotDate);
        }
        for (PropertyPair pair : row) {
            if (!pair.getProp().getType().isDataType()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("set: (" + pair.getValue() + ") " + pair.getProp().getContainingType().getName() + "." + pair.getProp().getName()));
            }
            node.setValue(pair.getProp().getName(), pair.getValue());
        }
        int key = this.createHashKey((PlasmaType)target.getType(), row);
        if (log.isDebugEnabled()) {
            log.debug((Object)("mapping " + key + "->" + target));
        }
        this.dataObjectMap.put(key, target);
        return target;
    }

    private PlasmaDataObject findDataObject(PlasmaType type, List<PropertyPair> row) {
        int key = this.createHashKey(type, row);
        PlasmaDataObject result = this.dataObjectMap.get(key);
        if (log.isDebugEnabled()) {
            if (result != null) {
                log.debug((Object)("found existing mapping " + key + "->" + result));
            } else {
                log.debug((Object)("found no existing mapping for key: " + key));
            }
        }
        return result;
    }

    private int createHashKey(PlasmaType type, List<PropertyPair> row) {
        PropertyPair[] pairs = new PropertyPair[row.size()];
        row.toArray(pairs);
        Arrays.sort(pairs, this.nameComparator);
        int result = type.getQualifiedName().hashCode();
        int pks = 0;
        for (int i = 0; i < pairs.length; ++i) {
            if (!pairs[i].getProp().isKey(KeyType.primary)) continue;
            Object value = pairs[i].getValue();
            result ^= value.hashCode();
            ++pks;
        }
        if (pks == 0) {
            throw new IllegalStateException("cannot create hash key - no primary keys found for type, " + type.toString());
        }
        return result;
    }

    private void link(PlasmaDataObject target, PlasmaDataObject source, PlasmaProperty sourceProperty) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("linking source (" + source.getUUIDAsString() + ") " + source.getType().getURI() + "#" + source.getType().getName() + "." + sourceProperty.getName() + "->(" + target.getUUIDAsString() + ") " + target.getType().getURI() + "#" + target.getType().getName()));
        }
        if (sourceProperty.isMany()) {
            PlasmaDataObject existingOpposite;
            PlasmaProperty opposite = (PlasmaProperty)sourceProperty.getOpposite();
            if (opposite != null && !opposite.isMany() && target.isSet((Property)opposite) && (existingOpposite = (PlasmaDataObject)target.get((Property)opposite)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("encountered existing opposite (" + existingOpposite.getType().getName() + ") value found while creating link (" + source.getUUIDAsString() + ") " + source.getType().getURI() + "#" + source.getType().getName() + "." + sourceProperty.getName() + "->(" + target.getUUIDAsString() + ") " + target.getType().getURI() + "#" + target.getType().getName() + " - no link created"));
                }
                return;
            }
            ArrayList<PlasmaDataObject> list = source.getList((Property)sourceProperty);
            if (list == null) {
                list = new ArrayList<PlasmaDataObject>();
            }
            if (log.isDebugEnabled()) {
                for (DataObject dataObject : list) {
                    log.debug((Object)("existing: (" + ((PlasmaNode)dataObject).getUUIDAsString() + ") " + dataObject.getType().getURI() + "#" + dataObject.getType().getName()));
                }
            }
            if (!list.contains(target)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("adding target  (" + source.getUUIDAsString() + ") " + source.getType().getURI() + "#" + source.getType().getName() + "." + sourceProperty.getName() + "->(" + target.getUUIDAsString() + ") " + target.getType().getURI() + "#" + target.getType().getName()));
                }
                if (target.getContainer() == null) {
                    target.setContainer((DataObject)source);
                    target.setContainmentProperty((Property)sourceProperty);
                }
                list.add(target);
                source.setList((Property)sourceProperty, list);
            }
        } else {
            PlasmaDataObject existing = (PlasmaDataObject)source.get((Property)sourceProperty);
            if (existing == null) {
                source.set((Property)sourceProperty, (Object)target);
                if (target.getContainer() == null) {
                    target.setContainer((DataObject)source);
                    target.setContainmentProperty((Property)sourceProperty);
                }
            } else if (!existing.getUUIDAsString().equals(target.getUUIDAsString()) && log.isDebugEnabled()) {
                log.debug((Object)("encountered existing (" + existing.getType().getName() + ") value found while creating link (" + source.getUUIDAsString() + ") " + source.getType().getURI() + "#" + source.getType().getName() + "." + sourceProperty.getName() + "->(" + target.getUUIDAsString() + ") " + target.getType().getURI() + "#" + target.getType().getName()));
            }
        }
    }

    private void throwPriKeyError(List<Property> rootPkProps, Type type, Property prop) {
        if (prop.isMany()) {
            if (rootPkProps.size() == 0) {
                throw new DataAccessException("no pri-keys found for " + type.getURI() + "#" + type.getName() + " - cannot map from many property, " + prop.getType() + "." + prop.getName());
            }
            throw new DataAccessException("multiple pri-keys found for " + type.getURI() + "#" + type.getName() + " - cannot map from many property, " + prop.getType() + "." + prop.getName());
        }
        if (rootPkProps.size() == 0) {
            throw new DataAccessException("no pri-keys found for " + type.getURI() + "#" + type.getName() + " - cannot map from singular property, " + prop.getType() + "." + prop.getName());
        }
        throw new DataAccessException("multiple pri-keys found for " + type.getURI() + "#" + type.getName() + " - cannot map from singular property, " + prop.getType() + "." + prop.getName());
    }

    public PlasmaDataGraph getDataGraph() {
        return (PlasmaDataGraph)this.root.getDataGraph();
    }

    public void clear() {
        this.root = null;
        this.dataObjectMap.clear();
    }
}

