/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.rdb.service;

import commonj.sdo.ChangeSummary;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudgraph.rdb.service.CreatedCommitComparator;
import org.cloudgraph.rdb.service.JDBCSupport;
import org.plasma.config.DataAccessProvider;
import org.plasma.config.DataAccessProviderName;
import org.plasma.config.PlasmaConfig;
import org.plasma.sdo.DataFlavor;
import org.plasma.sdo.PlasmaChangeSummary;
import org.plasma.sdo.PlasmaDataGraph;
import org.plasma.sdo.PlasmaDataGraphVisitor;
import org.plasma.sdo.PlasmaDataObject;
import org.plasma.sdo.PlasmaNode;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.access.DataAccessException;
import org.plasma.sdo.access.DataGraphDispatcher;
import org.plasma.sdo.access.InvalidSnapshotException;
import org.plasma.sdo.access.LockedEntityException;
import org.plasma.sdo.access.RequiredPropertyException;
import org.plasma.sdo.access.SequenceGenerator;
import org.plasma.sdo.access.provider.common.DeletedObjectCollector;
import org.plasma.sdo.access.provider.common.ModifiedObjectCollector;
import org.plasma.sdo.access.provider.common.PropertyPair;
import org.plasma.sdo.access.provider.jdbc.JDBCDataConverter;
import org.plasma.sdo.core.CoreDataObject;
import org.plasma.sdo.core.CoreHelper;
import org.plasma.sdo.core.NullValue;
import org.plasma.sdo.core.SnapshotMap;
import org.plasma.sdo.profile.ConcurrencyType;
import org.plasma.sdo.profile.ConcurrentDataFlavor;
import org.plasma.sdo.profile.KeyType;
import sorts.InsertionSort;

public class GraphDispatcher
extends JDBCSupport
implements DataGraphDispatcher {
    private static Log log = LogFactory.getLog(GraphDispatcher.class);
    private Connection con;
    private SnapshotMap snapshotMap;
    private SequenceGenerator sequenceGenerator;
    private String username;
    private JDBCDataConverter converter = JDBCDataConverter.INSTANCE;

    private GraphDispatcher() {
    }

    public GraphDispatcher(SnapshotMap snapshotMap, String username, Connection con) {
        this.snapshotMap = snapshotMap;
        this.username = username;
        this.con = con;
    }

    public void close() {
        if (this.sequenceGenerator != null) {
            this.sequenceGenerator.close();
        }
    }

    public SnapshotMap commit(DataGraph dataGraph) {
        DataObject dataObject;
        int i;
        if (this.username == null || this.username.length() == 0) {
            throw new IllegalArgumentException("expected username param not, '" + String.valueOf(this.username) + "'");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("current user is '" + this.username + "'"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)dataGraph.getChangeSummary().toString());
            log.debug((Object)((PlasmaDataGraph)dataGraph).dump());
        }
        PlasmaChangeSummary changeSummary = (PlasmaChangeSummary)dataGraph.getChangeSummary();
        List list = changeSummary.getChangedDataObjects();
        DataObject[] changed = new DataObject[list.size()];
        list.toArray(changed);
        if (log.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append('\n');
            for (i = 0; i < changed.length; ++i) {
                dataObject = changed[i];
                if (changeSummary.isCreated(dataObject)) {
                    buf.append("created: ");
                } else if (changeSummary.isModified(dataObject)) {
                    buf.append("modified: ");
                } else if (changeSummary.isDeleted(dataObject)) {
                    buf.append("deleted: ");
                }
                buf.append(dataObject.getType().getName() + " (" + dataObject.toString() + ")");
                buf.append(" depth: " + changeSummary.getPathDepth(dataObject));
                buf.append('\n');
            }
            log.debug((Object)("commit list: " + buf.toString()));
        }
        ArrayList<CoreDataObject> createdList = new ArrayList<CoreDataObject>();
        for (i = 0; i < changed.length; ++i) {
            dataObject = changed[i];
            if (!changeSummary.isCreated(dataObject)) continue;
            createdList.add((CoreDataObject)dataObject);
        }
        Object[] createdArray = new CoreDataObject[createdList.size()];
        createdList.toArray(createdArray);
        if (log.isDebugEnabled()) {
            int createdIndex = 0;
            for (CoreDataObject coreDataObject : createdArray) {
                log.debug((Object)("created before sort " + createdIndex + ": " + coreDataObject.toString()));
                ++createdIndex;
            }
        }
        CreatedCommitComparator comparator = new CreatedCommitComparator();
        Collections.sort(createdList, comparator);
        InsertionSort sort = new InsertionSort();
        sort.sort(createdArray, (Comparator)comparator);
        if (log.isDebugEnabled()) {
            int createdIndex = 0;
            for (Object dataObject3 : createdArray) {
                log.debug((Object)("created after sort " + createdIndex + ": " + dataObject3.toString()));
                ++createdIndex;
            }
        }
        ModifiedObjectCollector modified = new ModifiedObjectCollector(dataGraph);
        DeletedObjectCollector deleted = new DeletedObjectCollector(dataGraph);
        try {
            for (Object dataObject4 : createdArray) {
                this.create(dataGraph, (PlasmaDataObject)dataObject4);
            }
            for (PlasmaDataObject dataObject5 : modified.getResult()) {
                this.update(dataGraph, dataObject5);
            }
            for (PlasmaDataObject dataObject6 : deleted.getResult()) {
                this.delete(dataGraph, (DataObject)dataObject6);
            }
            new UpdatePessimisticVisitor(dataGraph);
            return this.snapshotMap;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new DataAccessException((Throwable)illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DataAccessException((Throwable)illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new DataAccessException((Throwable)invocationTargetException);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
    }

    private void create(DataGraph dataGraph, PlasmaDataObject dataObject) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        PlasmaType type = (PlasmaType)dataObject.getType();
        String uuid = ((CoreDataObject)dataObject).getUUIDAsString();
        if (uuid == null) {
            throw new DataAccessException("expected UUID for inserted entity '" + type.getName() + "'");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("creating " + type.getName() + " '" + dataObject.getUUIDAsString() + "'"));
        }
        HashMap<String, PropertyPair> entity = new HashMap<String, PropertyPair>();
        List pkList = type.findProperties(KeyType.primary);
        if (pkList == null || pkList.size() == 0) {
            throw new DataAccessException("no pri-key properties found for type '" + dataObject.getType().getName() + "'");
        }
        for (Property pkp : pkList) {
            PlasmaProperty targetPriKeyProperty = (PlasmaProperty)pkp;
            Object pk = dataObject.get((Property)targetPriKeyProperty);
            if (pk == null) {
                if (this.hasSequenceGenerator()) {
                    DataFlavor dataFlavor = targetPriKeyProperty.getDataFlavor();
                    switch (dataFlavor) {
                        case integral: {
                            if (this.sequenceGenerator == null) {
                                this.sequenceGenerator = this.newSequenceGenerator();
                                this.sequenceGenerator.initialize();
                            }
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("getting seq-num for " + type.getName()));
                            }
                            pk = this.sequenceGenerator.get((DataObject)dataObject);
                            entity.put(targetPriKeyProperty.getName(), new PropertyPair(targetPriKeyProperty, pk));
                            ((CoreDataObject)dataObject).setValue(targetPriKeyProperty.getName(), pk);
                            break;
                        }
                        default: {
                            throw new DataAccessException("found null primary key property '" + targetPriKeyProperty.getName() + "' for type, " + type.getURI() + "#" + type.getName());
                        }
                    }
                }
            } else {
                entity.put(targetPriKeyProperty.getName(), new PropertyPair(targetPriKeyProperty, pk));
            }
            if (pk == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("mapping UUID '" + uuid + "' to pk (" + String.valueOf(pk) + ")"));
            }
            this.snapshotMap.put(uuid, pk);
        }
        Property originationUserProperty = type.findProperty(ConcurrencyType.origination, ConcurrentDataFlavor.user);
        if (originationUserProperty != null) {
            entity.put(originationUserProperty.getName(), new PropertyPair((PlasmaProperty)originationUserProperty, (Object)this.username));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("could not find origination (username) property for type, " + type.getURI() + "#" + type.getName()));
        }
        Property originationTimestampProperty = type.findProperty(ConcurrencyType.origination, ConcurrentDataFlavor.time);
        if (originationTimestampProperty != null) {
            entity.put(originationTimestampProperty.getName(), new PropertyPair((PlasmaProperty)originationTimestampProperty, (Object)this.snapshotMap.getSnapshotDate()));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("could not find origination date property for type, " + type + "#" + type.getName()));
        }
        Property concurrencyUserProperty = type.findProperty(ConcurrencyType.optimistic, ConcurrentDataFlavor.user);
        if (concurrencyUserProperty != null) {
            entity.put(concurrencyUserProperty.getName(), new PropertyPair((PlasmaProperty)concurrencyUserProperty, (Object)this.username));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("could not find optimistic concurrency (username) property for type, " + type.getURI() + "#" + dataObject.getType().getName()));
        }
        Property concurrencyVersionProperty = type.findProperty(ConcurrencyType.optimistic, ConcurrentDataFlavor.time);
        if (concurrencyVersionProperty != null) {
            entity.put(concurrencyVersionProperty.getName(), new PropertyPair((PlasmaProperty)concurrencyVersionProperty, (Object)this.snapshotMap.getSnapshotDate()));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("could not find optimistic concurrency version property for type, " + type.getURI() + "#" + type.getName()));
        }
        List properties = type.getProperties();
        for (Property p : properties) {
            Object value;
            PlasmaProperty property = (PlasmaProperty)p;
            if (property.isMany() || property.isKey(KeyType.primary) || property.getConcurrent() != null || (value = dataObject.get((Property)property)) == null) continue;
            PropertyPair pair = this.createValue(dataObject, value, (Property)property);
            entity.put(property.getName(), pair);
        }
        StringBuilder insert = this.createInsert(type, entity);
        if (log.isDebugEnabled()) {
            log.debug((Object)("inserting " + dataObject.getType().getName()));
        }
        List<PropertyPair> keys = this.executeInsert(type, insert, entity, this.con);
        for (Property pkp : pkList) {
            PlasmaProperty targetPriKeyProperty = (PlasmaProperty)pkp;
            for (PropertyPair key : keys) {
                if (!targetPriKeyProperty.getName().equals(key.getProp().getName())) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("mapping UUID '" + uuid + "' to pk (" + String.valueOf(key.getValue()) + ")"));
                }
                this.snapshotMap.put(uuid, key.getValue());
            }
        }
    }

    private void update(DataGraph dataGraph, PlasmaDataObject dataObject) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        PlasmaProperty concurrencyTimestampProperty;
        PlasmaProperty concurrencyUserProperty;
        PlasmaProperty lockingTimestampProperty;
        PlasmaProperty lockingUserProperty;
        List pkList;
        PlasmaType type = (PlasmaType)dataObject.getType();
        if (log.isDebugEnabled()) {
            log.debug((Object)("updating " + type.getName() + " '" + dataObject.getUUIDAsString() + "'"));
        }
        if ((pkList = type.findProperties(KeyType.primary)) == null || pkList.size() == 0) {
            throw new DataAccessException("no pri-key properties found for type '" + dataObject.getType().getName() + "'");
        }
        ArrayList<PropertyPair> pkPairs = new ArrayList<PropertyPair>();
        for (Property pkp : pkList) {
            PlasmaProperty pkProperty = (PlasmaProperty)pkp;
            Object pk = dataObject.get((Property)pkProperty);
            if (pk == null) {
                throw new DataAccessException("found null primary key property '" + pkProperty.getName() + "' for type, " + type.getURI() + "#" + type.getName());
            }
            pkPairs.add(new PropertyPair(pkProperty, pk));
        }
        Timestamp snapshotDate = (Timestamp)((CoreDataObject)dataObject).getValue("snapshotTimestamp");
        if (snapshotDate == null) {
            throw new RequiredPropertyException("instance property 'snapshotTimestamp' is required to update entity '" + type.getURI() + "#" + type.getName() + "'");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("snapshot date: " + String.valueOf(snapshotDate)));
        }
        if ((lockingUserProperty = (PlasmaProperty)type.findProperty(ConcurrencyType.pessimistic, ConcurrentDataFlavor.user)) == null && log.isDebugEnabled()) {
            log.debug((Object)("could not find locking user property for type, " + type.getURI() + "#" + type.getName()));
        }
        if ((lockingTimestampProperty = (PlasmaProperty)type.findProperty(ConcurrencyType.pessimistic, ConcurrentDataFlavor.time)) == null && log.isDebugEnabled()) {
            log.debug((Object)("could not find locking timestamp property for type, " + type.getURI() + "#" + type.getName()));
        }
        if ((concurrencyUserProperty = (PlasmaProperty)type.findProperty(ConcurrencyType.optimistic, ConcurrentDataFlavor.user)) == null && log.isDebugEnabled()) {
            log.debug((Object)("could not find optimistic concurrency (username) property for type, " + type.getURI() + "#" + type.getName()));
        }
        if ((concurrencyTimestampProperty = (PlasmaProperty)type.findProperty(ConcurrencyType.optimistic, ConcurrentDataFlavor.time)) == null && log.isDebugEnabled()) {
            log.debug((Object)("could not find optimistic concurrency timestamp property for type, " + type.getURI() + "#" + type.getName()));
        }
        StringBuilder select = this.createSelectForUpdate(type, pkPairs, 5);
        Map<String, PropertyPair> entity = this.fetchRowMap(type, select, this.con);
        if (concurrencyTimestampProperty != null && concurrencyUserProperty != null) {
            this.checkAndRefreshConcurrencyFields((Type)type, entity, (Property)concurrencyTimestampProperty, (Property)concurrencyUserProperty, snapshotDate);
        }
        if (CoreHelper.isFlaggedLocked((DataObject)dataObject)) {
            this.lock(dataObject, entity, lockingTimestampProperty, lockingUserProperty, snapshotDate);
        } else if (CoreHelper.isFlaggedUnlocked((DataObject)dataObject)) {
            this.unlock(dataObject, entity, lockingTimestampProperty, lockingUserProperty, snapshotDate);
        }
        List properties = type.getProperties();
        for (Property p : properties) {
            ChangeSummary.Setting oldValue;
            PlasmaProperty property = (PlasmaProperty)p;
            if (property.isMany() || property.isKey(KeyType.primary) || property.getConcurrent() != null || (oldValue = dataGraph.getChangeSummary().getOldValue((DataObject)dataObject, (Property)property)) == null) continue;
            if (!property.isReadOnly()) {
                Object value = dataObject.get((Property)property);
                if (value == null) continue;
                PropertyPair pair = this.createValue(dataObject, value, (Property)property);
                entity.put(property.getName(), pair);
                continue;
            }
            throw new IllegalAccessException("attempt to modify read-only property, " + type.getURI() + "#" + type.getName() + "." + property.getName());
        }
        if (this.hasUpdatableProperties(entity)) {
            StringBuilder update = this.createUpdate(type, entity);
            if (log.isDebugEnabled()) {
                log.debug((Object)("updating " + dataObject.getType().getName()));
            }
            this.execute(type, update, entity, this.con);
        }
    }

    private void delete(DataGraph dataGraph, DataObject dataObject) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        PlasmaProperty concurrencyTimestampProperty;
        PlasmaProperty concurrencyUserProperty;
        PlasmaProperty lockingTimestampProperty;
        List pkList;
        PlasmaType type = (PlasmaType)dataObject.getType();
        if (log.isDebugEnabled()) {
            log.debug((Object)("deleting " + type.getName() + " '" + ((PlasmaDataObject)dataObject).getUUIDAsString() + "'"));
        }
        if ((pkList = type.findProperties(KeyType.primary)) == null || pkList.size() == 0) {
            throw new DataAccessException("no pri-key properties found for type '" + dataObject.getType().getName() + "'");
        }
        ArrayList<PropertyPair> pkPairs = new ArrayList<PropertyPair>();
        for (Property pkp : pkList) {
            PlasmaProperty pkProperty = (PlasmaProperty)pkp;
            Object pk = dataObject.get((Property)pkProperty);
            if (pk == null) {
                throw new DataAccessException("found null primary key property '" + pkProperty.getName() + "' for type, " + type.getURI() + "#" + type.getName());
            }
            pkPairs.add(new PropertyPair(pkProperty, pk));
        }
        Timestamp snapshotDate = (Timestamp)((CoreDataObject)dataObject).getValue("snapshotTimestamp");
        if (snapshotDate == null) {
            throw new RequiredPropertyException("property 'snapshotTimestamp' is required to update entity '" + type.getName() + "'");
        }
        StringBuilder select = this.createSelectForUpdate(type, pkPairs, 5);
        Map<String, PropertyPair> entity = this.fetchRowMap(type, select, this.con);
        PlasmaProperty lockingUserProperty = (PlasmaProperty)type.findProperty(ConcurrencyType.pessimistic, ConcurrentDataFlavor.user);
        if (lockingUserProperty == null && log.isDebugEnabled()) {
            log.debug((Object)("could not find locking user property for type, " + type.getURI() + "#" + type.getName()));
        }
        if ((lockingTimestampProperty = (PlasmaProperty)type.findProperty(ConcurrencyType.pessimistic, ConcurrentDataFlavor.time)) == null && log.isDebugEnabled()) {
            log.debug((Object)("could not find locking timestamp property for type, " + type.getURI() + "#" + type.getName()));
        }
        if ((concurrencyUserProperty = (PlasmaProperty)type.findProperty(ConcurrencyType.optimistic, ConcurrentDataFlavor.user)) == null && log.isDebugEnabled()) {
            log.debug((Object)("could not find optimistic concurrency (username) property for type, " + type.getURI() + "#" + type.getName()));
        }
        if ((concurrencyTimestampProperty = (PlasmaProperty)type.findProperty(ConcurrencyType.optimistic, ConcurrentDataFlavor.time)) == null && log.isDebugEnabled()) {
            log.debug((Object)("could not find optimistic concurrency timestamp property for type, " + dataObject.getType().getURI() + "#" + dataObject.getType().getName()));
        }
        if (concurrencyTimestampProperty != null && concurrencyUserProperty != null) {
            this.checkConcurrencyFields((Type)type, entity, (Property)concurrencyTimestampProperty, (Property)concurrencyUserProperty, snapshotDate);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("could not find concurrency version or user fields for " + dataObject.getType().getURI() + "#" + dataObject.getType().getName()));
        }
        entity.clear();
        for (PropertyPair pair : pkPairs) {
            entity.put(pair.getProp().getName(), pair);
        }
        StringBuilder delete = this.createDelete(type, entity);
        if (log.isDebugEnabled()) {
            log.debug((Object)("deleting " + dataObject.getType().getName()));
        }
        this.execute(type, delete, entity, this.con);
    }

    private void checkConcurrencyFields(Type type, Map<String, PropertyPair> entity, Property lastUpdatedDateProperty, Property lastUpdatedByNameProperty, Timestamp snapshotDate) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        PropertyPair lastUpdatedDatePair = entity.get(lastUpdatedDateProperty.getName());
        PropertyPair lastUpdatedByPair = entity.get(lastUpdatedByNameProperty.getName());
        String entityName = type.getName();
        if (lastUpdatedDatePair != null) {
            Date lastUpdatedDate = (Date)lastUpdatedDatePair.getValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)("comparing " + lastUpdatedDate + "greater than snapshot: " + snapshotDate));
            }
            if (lastUpdatedDate.getTime() > snapshotDate.getTime()) {
                if (lastUpdatedByPair != null) {
                    String lastUpdatedBy = (String)lastUpdatedByPair.getValue();
                    throw new InvalidSnapshotException(entityName, this.username, snapshotDate, lastUpdatedBy, lastUpdatedDate);
                }
                throw new InvalidSnapshotException(entityName, this.username, snapshotDate, "unknown", lastUpdatedDate);
            }
        }
    }

    private void checkAndRefreshConcurrencyFields(Type type, Map<String, PropertyPair> entity, Property lastUpdatedDateProperty, Property lastUpdatedByNameProperty, Timestamp snapshotDate) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        PropertyPair lastUpdatedDatePair = entity.get(lastUpdatedDateProperty.getName());
        PropertyPair lastUpdatedByPair = entity.get(lastUpdatedByNameProperty.getName());
        String entityName = type.getName();
        if (lastUpdatedDatePair != null) {
            Date lastUpdatedDate = (Date)lastUpdatedDatePair.getValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)("comparing " + lastUpdatedDate + "greater than snapshot: " + snapshotDate));
            }
            if (lastUpdatedDate.getTime() > snapshotDate.getTime()) {
                if (lastUpdatedByPair != null) {
                    String lastUpdatedBy = (String)lastUpdatedByPair.getValue();
                    throw new InvalidSnapshotException(entityName, this.username, snapshotDate, lastUpdatedBy, lastUpdatedDate);
                }
                throw new InvalidSnapshotException(entityName, this.username, snapshotDate, "unknown", lastUpdatedDate);
            }
            PropertyPair updatedDatePair = new PropertyPair(lastUpdatedDatePair.getProp(), (Object)this.snapshotMap.getSnapshotDate());
            entity.put(lastUpdatedDatePair.getProp().getName(), updatedDatePair);
            if (lastUpdatedByPair != null) {
                PropertyPair updatedByPair = new PropertyPair(lastUpdatedByPair.getProp(), (Object)this.username);
                entity.put(updatedByPair.getProp().getName(), updatedByPair);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("reset updated-date " + entity.getClass().getSimpleName() + " (" + entityName + " - " + this.snapshotMap.getSnapshotDate() + "(" + String.valueOf(this.snapshotMap.getSnapshotDate().getTime()) + ")"));
        }
    }

    private void lock(PlasmaDataObject dataObject, Map<String, PropertyPair> entity, PlasmaProperty lockedDateProperty, PlasmaProperty lockedByNameProperty, Timestamp snapshotDate) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (lockedDateProperty != null && lockedByNameProperty != null) {
            PropertyPair lockedDatePair = entity.get(lockedDateProperty.getName());
            PropertyPair lockedByNamePair = entity.get(lockedByNameProperty.getName());
            String lockedByName = (String)lockedByNamePair.getValue();
            Date lockedDate = (Date)lockedDatePair.getValue();
            CoreHelper.unflagLocked((DataObject)dataObject);
            if (lockedByName == null || this.username.equals(lockedByName)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("locking " + entity.getClass().getSimpleName() + " (" + dataObject.getUUIDAsString() + ")"));
                }
                entity.put(lockedByNameProperty.getName(), new PropertyPair(lockedByNameProperty, (Object)this.username));
                entity.put(lockedDateProperty.getName(), new PropertyPair(lockedDateProperty, (Object)this.snapshotMap.getSnapshotDate()));
            } else {
                long timeout = 300000L;
                DataAccessProvider providerConf = PlasmaConfig.getInstance().getDataAccessProvider(DataAccessProviderName.JDBC);
                if (providerConf.getConcurrency() != null && providerConf.getConcurrency().getPessimisticLockTimeoutMillis() > 0L) {
                    timeout = providerConf.getConcurrency().getPessimisticLockTimeoutMillis();
                }
                if (snapshotDate.getTime() - lockedDate.getTime() > timeout) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("locking " + entity.getClass().getSimpleName() + " (" + dataObject.getUUIDAsString() + ") - existing lock by '" + lockedByName + "' expired"));
                    }
                    entity.put(lockedByNameProperty.getName(), new PropertyPair(lockedByNameProperty, (Object)this.username));
                    entity.put(lockedDateProperty.getName(), new PropertyPair(lockedDateProperty, (Object)this.snapshotMap.getSnapshotDate()));
                } else {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("could not issue lock for user '" + String.valueOf(this.username) + "' for snapshot date " + String.valueOf(snapshotDate)));
                    }
                    throw new LockedEntityException(entity.getClass().getSimpleName(), lockedByName, lockedDate);
                }
            }
        }
    }

    private void unlock(PlasmaDataObject dataObject, Map<String, PropertyPair> entity, PlasmaProperty lockedDateProperty, PlasmaProperty lockedByNameProperty, Timestamp snapshotDate) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (lockedDateProperty != null && lockedByNameProperty != null) {
            PropertyPair lockedDatePair = entity.get(lockedDateProperty.getName());
            PropertyPair lockedByNamePair = entity.get(lockedByNameProperty.getName());
            String lockedByName = (String)lockedByNamePair.getValue();
            Date lockedDate = (Date)lockedDatePair.getValue();
            if (this.username.equals(lockedByName)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("unlocking " + entity.getClass().getSimpleName() + " (" + dataObject.getUUIDAsString() + ")"));
                }
                entity.put(lockedByNameProperty.getName(), new PropertyPair(lockedByNameProperty, (Object)this.username));
                entity.put(lockedDateProperty.getName(), new PropertyPair(lockedDateProperty, (Object)this.snapshotMap.getSnapshotDate()));
            } else {
                log.warn((Object)("could not unlock entity " + entity.getClass().getSimpleName() + " (" + dataObject.getUUIDAsString() + ") - current user '" + this.username + "' has no existing or expired lock"));
            }
        }
    }

    protected PropertyPair createValue(PlasmaDataObject dataObject, Object value, Property property) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object resultValue = value;
        if (log.isDebugEnabled()) {
            log.debug((Object)("setting " + dataObject.toString() + "." + property.getName()));
        }
        if (!property.getType().isDataType() && !(resultValue instanceof NullValue)) {
            if (!(resultValue instanceof DataObject)) {
                throw new DataAccessException("expected data object for singular reference property " + property.getType().getName() + "." + property.getName() + " but found " + resultValue.getClass().getName());
            }
            DataObject resultDataObject = (DataObject)resultValue;
            CoreDataObject resultCoreObject = (CoreDataObject)resultValue;
            PlasmaType resultType = (PlasmaType)resultDataObject.getType();
            List pkList = resultType.findProperties(KeyType.primary);
            if (pkList == null) {
                throw new DataAccessException("found no pri-key properties found for type '" + property.getType().getName() + "'");
            }
            if (pkList.size() > 1) {
                throw new DataAccessException("multiple pri-key properties found for type '" + property.getType().getName() + "' - not yet supported");
            }
            Property targetPriKeyProperty = (Property)pkList.get(0);
            Object pk = resultDataObject.get(targetPriKeyProperty.getName());
            if (pk == null) {
                String uuid = resultCoreObject.getUUIDAsString();
                if (uuid == null) {
                    throw new DataAccessException("found no UUID value for entity '" + property.getType().getName() + "' when setting property " + dataObject.getType().toString() + "." + property.getName());
                }
                pk = this.snapshotMap.get(uuid);
                if (pk == null) {
                    throw new DataAccessException("found no pri-key value for UUID '" + uuid + "' in id-map for entity '" + property.getType().getName() + "' when setting property " + dataObject.getType().toString() + "." + property.getName());
                }
            }
            resultValue = pk;
            if (log.isDebugEnabled()) {
                log.debug((Object)("set " + dataObject.toString() + "." + property.getName() + " (" + String.valueOf(resultValue) + ")"));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("set " + dataObject.toString() + "." + property.getName() + " (" + String.valueOf(resultValue) + ")"));
        }
        PropertyPair result = null;
        result = !(value instanceof NullValue) ? new PropertyPair((PlasmaProperty)property, resultValue) : new PropertyPair((PlasmaProperty)property, null);
        return result;
    }

    private Property findCachedProperty(PlasmaType type, Property instanceProp) {
        List result = type.search(instanceProp);
        if (result != null && result.size() > 0) {
            Object obj;
            if (result.size() > 1) {
                log.warn((Object)("expected single value for instance property '" + instanceProp.getName() + "' withing type '" + type.getURI() + "#" + type.getName() + "' and all its base types"));
            }
            if ((obj = result.get(0)) instanceof Property) {
                return (Property)obj;
            }
            log.warn((Object)("expected value for instance property '" + instanceProp.getName() + "' for type '" + type.getURI() + "#" + type.getName() + "' or one of its base types to be a instnace of class, " + Property.class.getName()));
        }
        return null;
    }

    private boolean hasSequenceGenerator() {
        DataAccessProvider provider = PlasmaConfig.getInstance().getDataAccessProvider(DataAccessProviderName.JDBC);
        return provider.getSequenceConfiguration() != null && provider.getSequenceConfiguration().getGeneratorClassName() != null;
    }

    private SequenceGenerator newSequenceGenerator() {
        try {
            DataAccessProvider provider = PlasmaConfig.getInstance().getDataAccessProvider(DataAccessProviderName.JDBC);
            String qualifiedName = provider.getSequenceConfiguration().getGeneratorClassName();
            Class<?> entityClass = Class.forName(qualifiedName);
            Class[] argClasses = new Class[]{};
            Object[] args = new Object[]{};
            Constructor<?> constructor = entityClass.getConstructor(argClasses);
            return (SequenceGenerator)constructor.newInstance(args);
        }
        catch (ClassNotFoundException e) {
            throw new DataAccessException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new DataAccessException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new DataAccessException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new DataAccessException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    protected String printDataObjectInfo(DataObject vo) {
        return vo.getType().getName();
    }

    class UpdatePessimisticVisitor
    implements PlasmaDataGraphVisitor {
        private DataGraph dataGraph;

        public UpdatePessimisticVisitor(DataGraph dataGraph) {
            this.dataGraph = dataGraph;
            ((PlasmaNode)this.dataGraph.getRootObject()).getDataObject().accept((PlasmaDataGraphVisitor)this);
        }

        public void visit(DataObject target, DataObject source, String sourceKey, int level) {
            try {
                if (CoreHelper.isFlaggedLocked((DataObject)target) || CoreHelper.isFlaggedUnlocked((DataObject)target)) {
                    GraphDispatcher.this.update(this.dataGraph, (PlasmaDataObject)target);
                }
            }
            catch (IllegalArgumentException e) {
                throw new DataAccessException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new DataAccessException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new DataAccessException((Throwable)e);
            }
        }
    }
}

