/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.web;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.web.servlet.DispatcherServlet;

public class RecognizeFailureDispatcherServlet
extends GenericServlet {
    private static Log logger = LogFactory.getLog(RecognizeFailureDispatcherServlet.class);
    protected static final String HEADER = "X-Cf-Uaa-Error";
    protected static final String HEADER_MSG = "Server failed to start. Possible configuration error.";
    private volatile boolean failed = false;
    private DispatcherServlet delegate = new DispatcherServlet();

    public void setDelegate(DispatcherServlet delegate) {
        this.delegate = delegate;
    }

    public void init(ServletConfig config) throws ServletException {
        try {
            this.delegate.init(config);
        }
        catch (Exception e) {
            logger.fatal((Object)"Unable to start UAA application.", (Throwable)e);
            this.failed = true;
        }
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        if (this.failed) {
            String msg = "FAILURE";
            HttpServletResponse response = (HttpServletResponse)res;
            response.addHeader(HEADER, HEADER_MSG);
            response.setContentType("text/plain");
            response.setStatus(503);
            response.getWriter().write(msg);
            response.getWriter().flush();
        } else {
            this.delegate.service(req, res);
        }
    }

    public void destroy() {
        this.delegate.destroy();
    }

    public void setEnvironment(Environment environment) {
        this.delegate.setEnvironment(environment);
    }

    public ConfigurableEnvironment getEnvironment() {
        return this.delegate.getEnvironment();
    }

    public String getInitParameter(String name) {
        return this.delegate.getInitParameter(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return this.delegate.getInitParameterNames();
    }

    public ServletConfig getServletConfig() {
        return this.delegate.getServletConfig();
    }

    public ServletContext getServletContext() {
        return this.delegate.getServletContext();
    }

    public String getServletInfo() {
        return this.delegate.getServletInfo();
    }

    public void init() throws ServletException {
        this.delegate.init();
    }

    public void log(String msg) {
        this.delegate.log(msg);
    }

    public void log(String message, Throwable t) {
        this.delegate.log(message, t);
    }

    public String getServletName() {
        return this.delegate.getServletName();
    }
}

