/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.cloudfoundry.identity.uaa.util.TimeService;
import org.cloudfoundry.identity.uaa.util.TimedKeyValue;

public class TimeBasedExpiringValueMap<K, V> {
    public static final long DEFALT_TIMEOUT = 120000L;
    private final TimeService timeService;
    private final Map<K, TimedKeyValue> map;
    private final long timeout;
    private final AtomicLong lastCheck = new AtomicLong(0L);

    public TimeBasedExpiringValueMap(TimeService timeService) {
        this(timeService, 120000L);
    }

    public TimeBasedExpiringValueMap(TimeService timeService, long timeoutMilliseconds) {
        this.timeService = timeService;
        this.map = new ConcurrentHashMap<K, TimedKeyValue>();
        this.timeout = timeoutMilliseconds;
    }

    public void put(K key, V value) {
        TimedKeyValue<K, V> v = new TimedKeyValue<K, V>(this.timeService.getCurrentTimeMillis(), key, value);
        this.map.put(key, v);
        this.expireCheck();
    }

    public V get(K key) {
        TimedKeyValue v = this.map.get(key);
        if (v != null) {
            this.removeExpired(v);
            return v.getValue();
        }
        this.expireCheck();
        return null;
    }

    public V remove(K key) {
        TimedKeyValue v = this.map.remove(key);
        if (v != null) {
            return v.getValue();
        }
        return null;
    }

    public int size() {
        return this.map.size();
    }

    public void clear() {
        this.map.clear();
    }

    protected void expireCheck() {
        long l;
        long now = this.timeService.getCurrentTimeMillis();
        if (now - (l = this.lastCheck.get()) > this.timeout && this.lastCheck.compareAndSet(l, now)) {
            Map.Entry[] entries;
            for (Map.Entry entry : entries = this.map.entrySet().toArray(new Map.Entry[0])) {
                this.removeExpired((TimedKeyValue)entry.getValue());
            }
        }
    }

    protected boolean hasExpired(long time) {
        long now = this.timeService.getCurrentTimeMillis();
        return now - time > this.timeout;
    }

    protected boolean removeExpired(TimedKeyValue<K, V> timedKeyValue) {
        if (timedKeyValue != null && this.hasExpired(timedKeyValue.getTime())) {
            TimedKeyValue remove = this.map.remove(timedKeyValue.getKey());
            if (remove != null && this.hasExpired(remove.getTime())) {
                return true;
            }
            this.map.putIfAbsent(timedKeyValue.getKey(), timedKeyValue);
        }
        return false;
    }
}

