/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.event;

import java.security.Principal;
import org.cloudfoundry.identity.uaa.audit.AuditEvent;
import org.cloudfoundry.identity.uaa.audit.AuditEventType;
import org.cloudfoundry.identity.uaa.audit.event.AbstractUaaEvent;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.springframework.security.core.Authentication;

public class UserModifiedEvent
extends AbstractUaaEvent {
    private static final long serialVersionUID = 8139998613071093676L;
    private String userId;
    private String username;
    private String email;
    private AuditEventType eventType;

    protected UserModifiedEvent(String userId, String username, AuditEventType type, Authentication authentication) {
        super(authentication);
        this.userId = userId;
        this.username = username;
        this.eventType = type;
    }

    protected UserModifiedEvent(String userId, String username, String email, AuditEventType type, Authentication authentication) {
        super(authentication);
        this.userId = userId;
        this.username = username;
        this.eventType = type;
        this.email = email;
    }

    public static UserModifiedEvent userCreated(String userId, String username) {
        return new UserModifiedEvent(userId, username, AuditEventType.UserCreatedEvent, UserModifiedEvent.getContextAuthentication());
    }

    public static UserModifiedEvent userModified(String userId, String username) {
        return new UserModifiedEvent(userId, username, AuditEventType.UserModifiedEvent, UserModifiedEvent.getContextAuthentication());
    }

    public static UserModifiedEvent userDeleted(String userId, String username) {
        return new UserModifiedEvent(userId, username, AuditEventType.UserDeletedEvent, UserModifiedEvent.getContextAuthentication());
    }

    public static UserModifiedEvent userVerified(String userId, String username) {
        return new UserModifiedEvent(userId, username, AuditEventType.UserVerifiedEvent, UserModifiedEvent.getContextAuthentication());
    }

    public static UserModifiedEvent emailChanged(String userId, String username, String email) {
        return new UserModifiedEvent(userId, username, email, AuditEventType.EmailChangedEvent, UserModifiedEvent.getContextAuthentication());
    }

    @Override
    public AuditEvent getAuditEvent() {
        String[] details = new String[]{"user_id=" + this.userId, "username=" + this.username};
        String data = JsonUtils.writeValueAsString((Object)details);
        return this.createAuditRecord(this.userId, this.eventType, this.getOrigin((Principal)this.getAuthentication()), data);
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUsername() {
        return this.username;
    }

    public String getEmail() {
        return this.email;
    }
}

