/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import org.cloudfoundry.identity.uaa.provider.saml.ComparableProvider;
import org.opensaml.saml2.metadata.provider.AbstractMetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.UnmarshallingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigMetadataProvider
extends AbstractMetadataProvider
implements ComparableProvider {
    private final Logger log = LoggerFactory.getLogger(ConfigMetadataProvider.class);
    private final String metadata;
    private final String zoneId;
    private final String alias;

    public ConfigMetadataProvider(String zoneId, String alias, String metadata) {
        this.metadata = metadata;
        this.alias = alias;
        this.zoneId = zoneId;
    }

    @Override
    public byte[] fetchMetadata() throws MetadataProviderException {
        return this.metadata.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public XMLObject doGetMetadata() throws MetadataProviderException {
        ByteArrayInputStream stream = new ByteArrayInputStream(this.metadata.getBytes(StandardCharsets.UTF_8));
        try {
            return this.unmarshallMetadata(stream);
        }
        catch (UnmarshallingException e) {
            this.log.error("Unable to unmarshall metadata", (Throwable)e);
            throw new MetadataProviderException((Exception)((Object)e));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ComparableProvider)) {
            return false;
        }
        return this.compareTo((ComparableProvider)o) == 0;
    }

    public int hashCode() {
        return this.getHashCode();
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public String getZoneId() {
        return this.zoneId;
    }
}

