/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.ldap;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.apache.directory.api.util.DummySSLSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.cloudfoundry.identity.uaa.provider.ldap.extension.DefaultTlsDirContextAuthenticationStrategy;
import org.cloudfoundry.identity.uaa.provider.ldap.extension.ExternalTlsDirContextAuthenticationStrategy;
import org.cloudfoundry.identity.uaa.security.LdapSocketFactory;
import org.springframework.ldap.core.support.DirContextAuthenticationStrategy;
import org.springframework.ldap.core.support.SimpleDirContextAuthenticationStrategy;
import org.springframework.util.StringUtils;

public class ProcessLdapProperties {
    public static final String LDAP_SOCKET_FACTORY = "java.naming.ldap.factory.socket";
    public static final String LDAP_SSL_SOCKET_FACTORY = "org.cloudfoundry.identity.ldap.ssl.factory.socket";
    public static final String SKIP_SSL_VERIFICATION_SOCKET_FACTORY = DummySSLSocketFactory.class.getName();
    public static final String EXPIRY_CHECKING_SOCKET_FACTORY = LdapSocketFactory.class.getName();
    public static final String NONE = "none";
    public static final String SIMPLE = "simple";
    public static final String EXTERNAL = "external";
    private boolean disableSslVerification;
    private String baseUrl;
    private String tlsConfig = "none";

    public ProcessLdapProperties(String baseUrl, boolean disableSslVerification, String tlsConfig) {
        this.baseUrl = baseUrl;
        this.disableSslVerification = disableSslVerification;
        this.tlsConfig = tlsConfig;
    }

    public Map process(Map map) throws KeyManagementException, NoSuchAlgorithmException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(map);
        if (this.isDisableSslVerification()) {
            result.put(LDAP_SSL_SOCKET_FACTORY, SKIP_SSL_VERIFICATION_SOCKET_FACTORY);
        } else {
            result.put(LDAP_SSL_SOCKET_FACTORY, EXPIRY_CHECKING_SOCKET_FACTORY);
        }
        if (this.isLdapsUrl()) {
            result.put(LDAP_SOCKET_FACTORY, (String)result.get(LDAP_SSL_SOCKET_FACTORY));
        }
        return result;
    }

    public boolean isLdapsUrl() {
        return this.baseUrl != null && this.baseUrl.startsWith("ldaps");
    }

    public boolean isDisableSslVerification() {
        return this.disableSslVerification;
    }

    public SSLSocketFactory getSSLSocketFactory() throws NoSuchAlgorithmException, KeyManagementException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        Class<?> clazz = Class.forName((String)this.process(new HashMap()).get(LDAP_SSL_SOCKET_FACTORY), true, ProcessLdapProperties.class.getClassLoader());
        return (SSLSocketFactory)clazz.newInstance();
    }

    public void setDisableSslVerification(boolean disableSslVerification) {
        this.disableSslVerification = disableSslVerification;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public DirContextAuthenticationStrategy getAuthenticationStrategy() throws ClassNotFoundException, NoSuchAlgorithmException, IllegalAccessException, InstantiationException, KeyManagementException {
        Object tlsStrategy;
        if (!StringUtils.hasText((String)this.tlsConfig)) {
            this.tlsConfig = NONE;
        }
        switch (this.tlsConfig) {
            case "none": {
                return new SimpleDirContextAuthenticationStrategy();
            }
            case "simple": {
                tlsStrategy = new DefaultTlsDirContextAuthenticationStrategy();
                break;
            }
            case "external": {
                tlsStrategy = new ExternalTlsDirContextAuthenticationStrategy();
                break;
            }
            default: {
                throw new IllegalArgumentException(this.tlsConfig);
            }
        }
        tlsStrategy.setHostnameVerifier((HostnameVerifier)new AllowAllHostnameVerifier());
        tlsStrategy.setSslSocketFactory(this.getSSLSocketFactory());
        return tlsStrategy;
    }
}

