/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.audit.event.EntityDeletedEvent;
import org.cloudfoundry.identity.uaa.authentication.manager.DynamicLdapAuthenticationManager;
import org.cloudfoundry.identity.uaa.authentication.manager.LdapLoginAuthenticationManager;
import org.cloudfoundry.identity.uaa.provider.AbstractIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.AbstractXOAuthIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.IdentityProvider;
import org.cloudfoundry.identity.uaa.provider.IdentityProviderConfigValidator;
import org.cloudfoundry.identity.uaa.provider.IdentityProviderProvisioning;
import org.cloudfoundry.identity.uaa.provider.IdentityProviderStatus;
import org.cloudfoundry.identity.uaa.provider.IdentityProviderValidationRequest;
import org.cloudfoundry.identity.uaa.provider.IdpAlreadyExistsException;
import org.cloudfoundry.identity.uaa.provider.LdapIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.SamlIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.UaaIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.saml.SamlIdentityProviderConfigurator;
import org.cloudfoundry.identity.uaa.scim.ScimGroupExternalMembershipManager;
import org.cloudfoundry.identity.uaa.scim.ScimGroupProvisioning;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.util.ObjectUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/identity-providers"})
@RestController
public class IdentityProviderEndpoints
implements ApplicationEventPublisherAware {
    protected static Log logger = LogFactory.getLog(IdentityProviderEndpoints.class);
    private final IdentityProviderProvisioning identityProviderProvisioning;
    private final ScimGroupExternalMembershipManager scimGroupExternalMembershipManager;
    private final ScimGroupProvisioning scimGroupProvisioning;
    private final NoOpLdapLoginAuthenticationManager noOpManager = new NoOpLdapLoginAuthenticationManager();
    private final SamlIdentityProviderConfigurator samlConfigurator;
    private final IdentityProviderConfigValidator configValidator;
    private ApplicationEventPublisher publisher = null;

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    public IdentityProviderEndpoints(IdentityProviderProvisioning identityProviderProvisioning, ScimGroupExternalMembershipManager scimGroupExternalMembershipManager, ScimGroupProvisioning scimGroupProvisioning, SamlIdentityProviderConfigurator samlConfigurator, IdentityProviderConfigValidator configValidator) {
        this.identityProviderProvisioning = identityProviderProvisioning;
        this.scimGroupExternalMembershipManager = scimGroupExternalMembershipManager;
        this.scimGroupProvisioning = scimGroupProvisioning;
        this.samlConfigurator = samlConfigurator;
        this.configValidator = configValidator;
    }

    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<IdentityProvider> createIdentityProvider(@RequestBody IdentityProvider body, @RequestParam(required=false, defaultValue="false") boolean rawConfig) throws MetadataProviderException {
        body.setSerializeConfigRaw(rawConfig);
        String zoneId = IdentityZoneHolder.get().getId();
        body.setIdentityZoneId(zoneId);
        try {
            this.configValidator.validate((IdentityProvider<? extends AbstractIdentityProviderDefinition>)body);
        }
        catch (IllegalArgumentException e) {
            logger.debug((Object)("IdentityProvider[origin=" + body.getOriginKey() + "; zone=" + body.getIdentityZoneId() + "] - Configuration validation error."), (Throwable)e);
            return new ResponseEntity((Object)body, HttpStatus.UNPROCESSABLE_ENTITY);
        }
        if ("saml".equals(body.getType())) {
            SamlIdentityProviderDefinition definition = (SamlIdentityProviderDefinition)ObjectUtils.castInstance((Object)body.getConfig(), SamlIdentityProviderDefinition.class);
            definition.setZoneId(zoneId);
            definition.setIdpEntityAlias(body.getOriginKey());
            this.samlConfigurator.validateSamlIdentityProviderDefinition(definition);
            body.setConfig((AbstractIdentityProviderDefinition)definition);
        }
        try {
            IdentityProvider createdIdp = this.identityProviderProvisioning.create(body, zoneId);
            createdIdp.setSerializeConfigRaw(rawConfig);
            this.redactSensitiveData(createdIdp);
            return new ResponseEntity((Object)createdIdp, HttpStatus.CREATED);
        }
        catch (IdpAlreadyExistsException e) {
            return new ResponseEntity((Object)body, HttpStatus.CONFLICT);
        }
        catch (Exception x) {
            logger.debug((Object)("Unable to create IdentityProvider[origin=" + body.getOriginKey() + "; zone=" + body.getIdentityZoneId() + "]"), (Throwable)x);
            return new ResponseEntity((Object)body, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE})
    @Transactional
    public ResponseEntity<IdentityProvider> deleteIdentityProvider(@PathVariable String id, @RequestParam(required=false, defaultValue="false") boolean rawConfig) throws MetadataProviderException {
        IdentityProvider existing = this.identityProviderProvisioning.retrieve(id, IdentityZoneHolder.get().getId());
        if (this.publisher != null && existing != null) {
            existing.setSerializeConfigRaw(rawConfig);
            this.publisher.publishEvent(new EntityDeletedEvent<IdentityProvider>(existing, SecurityContextHolder.getContext().getAuthentication()));
            return new ResponseEntity((Object)existing, HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.UNPROCESSABLE_ENTITY);
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.PUT})
    public ResponseEntity<IdentityProvider> updateIdentityProvider(@PathVariable String id, @RequestBody IdentityProvider body, @RequestParam(required=false, defaultValue="false") boolean rawConfig) throws MetadataProviderException {
        body.setSerializeConfigRaw(rawConfig);
        String zoneId = IdentityZoneHolder.get().getId();
        IdentityProvider existing = this.identityProviderProvisioning.retrieve(id, zoneId);
        body.setId(id);
        body.setIdentityZoneId(zoneId);
        this.patchSensitiveData(id, body);
        try {
            this.configValidator.validate((IdentityProvider<? extends AbstractIdentityProviderDefinition>)body);
        }
        catch (IllegalArgumentException e) {
            logger.debug((Object)("IdentityProvider[origin=" + body.getOriginKey() + "; zone=" + body.getIdentityZoneId() + "] - Configuration validation error for update."), (Throwable)e);
            return new ResponseEntity((Object)body, HttpStatus.UNPROCESSABLE_ENTITY);
        }
        if ("saml".equals(body.getType())) {
            body.setOriginKey(existing.getOriginKey());
            SamlIdentityProviderDefinition definition = (SamlIdentityProviderDefinition)ObjectUtils.castInstance((Object)body.getConfig(), SamlIdentityProviderDefinition.class);
            definition.setZoneId(zoneId);
            definition.setIdpEntityAlias(body.getOriginKey());
            this.samlConfigurator.validateSamlIdentityProviderDefinition(definition);
            body.setConfig((AbstractIdentityProviderDefinition)definition);
        }
        IdentityProvider updatedIdp = this.identityProviderProvisioning.update(body, zoneId);
        updatedIdp.setSerializeConfigRaw(rawConfig);
        this.redactSensitiveData(updatedIdp);
        return new ResponseEntity((Object)updatedIdp, HttpStatus.OK);
    }

    @RequestMapping(value={"{id}/status"}, method={RequestMethod.PATCH})
    public ResponseEntity<IdentityProviderStatus> updateIdentityProviderStatus(@PathVariable String id, @RequestBody IdentityProviderStatus body) {
        String zoneId = IdentityZoneHolder.get().getId();
        IdentityProvider existing = this.identityProviderProvisioning.retrieve(id, zoneId);
        if (body.getRequirePasswordChange() == null || !body.getRequirePasswordChange().booleanValue()) {
            logger.debug((Object)"Invalid payload. The property requirePasswordChangeRequired needs to be set");
            return new ResponseEntity((Object)body, HttpStatus.UNPROCESSABLE_ENTITY);
        }
        if (!"uaa".equals(existing.getType())) {
            logger.debug((Object)"Invalid operation. This operation is not supported on external IDP");
            return new ResponseEntity((Object)body, HttpStatus.UNPROCESSABLE_ENTITY);
        }
        UaaIdentityProviderDefinition uaaIdentityProviderDefinition = (UaaIdentityProviderDefinition)ObjectUtils.castInstance((Object)existing.getConfig(), UaaIdentityProviderDefinition.class);
        if (uaaIdentityProviderDefinition == null || uaaIdentityProviderDefinition.getPasswordPolicy() == null) {
            logger.debug((Object)"IDP does not have an existing PasswordPolicy. Operation not supported");
            return new ResponseEntity((Object)body, HttpStatus.UNPROCESSABLE_ENTITY);
        }
        uaaIdentityProviderDefinition.getPasswordPolicy().setPasswordNewerThan(new Date(System.currentTimeMillis()));
        this.identityProviderProvisioning.update(existing, zoneId);
        logger.info((Object)("PasswordChangeRequired property set for Identity Provider: " + existing.getId()));
        return new ResponseEntity((Object)body, HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.GET})
    public ResponseEntity<List<IdentityProvider>> retrieveIdentityProviders(@RequestParam(value="active_only", required=false) String activeOnly, @RequestParam(required=false, defaultValue="false") boolean rawConfig) {
        Boolean retrieveActiveOnly = Boolean.valueOf(activeOnly);
        List<IdentityProvider> identityProviderList = this.identityProviderProvisioning.retrieveAll(retrieveActiveOnly, IdentityZoneHolder.get().getId());
        for (IdentityProvider idp : identityProviderList) {
            idp.setSerializeConfigRaw(rawConfig);
            this.redactSensitiveData(idp);
        }
        return new ResponseEntity(identityProviderList, HttpStatus.OK);
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.GET})
    public ResponseEntity<IdentityProvider> retrieveIdentityProvider(@PathVariable String id, @RequestParam(required=false, defaultValue="false") boolean rawConfig) {
        IdentityProvider identityProvider = this.identityProviderProvisioning.retrieve(id, IdentityZoneHolder.get().getId());
        identityProvider.setSerializeConfigRaw(rawConfig);
        this.redactSensitiveData(identityProvider);
        return new ResponseEntity((Object)identityProvider, HttpStatus.OK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"test"}, method={RequestMethod.POST})
    public ResponseEntity<String> testIdentityProvider(@RequestBody IdentityProviderValidationRequest body) {
        String exception = "ok";
        HttpStatus status = HttpStatus.OK;
        DynamicLdapAuthenticationManager manager = new DynamicLdapAuthenticationManager((LdapIdentityProviderDefinition)ObjectUtils.castInstance((Object)body.getProvider().getConfig(), LdapIdentityProviderDefinition.class), this.scimGroupExternalMembershipManager, this.scimGroupProvisioning, this.noOpManager);
        try {
            Authentication result = manager.authenticate(body.getCredentials());
            if (result == null || result != null && !result.isAuthenticated()) {
                status = HttpStatus.EXPECTATION_FAILED;
            }
        }
        catch (BadCredentialsException x) {
            status = HttpStatus.EXPECTATION_FAILED;
            exception = "bad credentials";
        }
        catch (InternalAuthenticationServiceException x) {
            status = HttpStatus.BAD_REQUEST;
            exception = this.getExceptionString((Exception)((Object)x));
        }
        catch (Exception x) {
            logger.debug((Object)"Identity provider validation failed.", (Throwable)x);
            status = HttpStatus.INTERNAL_SERVER_ERROR;
            exception = "check server logs";
        }
        finally {
            manager.destroy();
        }
        return new ResponseEntity((Object)JsonUtils.writeValueAsString((Object)exception), status);
    }

    @ExceptionHandler(value={MetadataProviderException.class})
    public ResponseEntity<String> handleMetadataProviderException(MetadataProviderException e) {
        if (e.getMessage().contains("Duplicate")) {
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.CONFLICT);
        }
        return new ResponseEntity((Object)e.getMessage(), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={JsonUtils.JsonUtilException.class})
    public ResponseEntity<String> handleMetadataProviderException() {
        return new ResponseEntity((Object)"Invalid provider configuration.", HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={EmptyResultDataAccessException.class})
    public ResponseEntity<String> handleProviderNotFoundException() {
        return new ResponseEntity((Object)"Provider not found.", HttpStatus.NOT_FOUND);
    }

    protected String getExceptionString(Exception x) {
        StringWriter writer = new StringWriter();
        x.printStackTrace(new PrintWriter(writer));
        return writer.getBuffer().toString();
    }

    protected void patchSensitiveData(String id, IdentityProvider provider) {
        String zoneId = IdentityZoneHolder.get().getId();
        if (provider.getConfig() == null) {
            return;
        }
        switch (provider.getType()) {
            case "ldap": {
                IdentityProvider existing;
                LdapIdentityProviderDefinition definition;
                if (!(provider.getConfig() instanceof LdapIdentityProviderDefinition) || (definition = (LdapIdentityProviderDefinition)provider.getConfig()).getBindPassword() != null || (existing = this.identityProviderProvisioning.retrieve(id, zoneId)) == null || existing.getConfig() == null || !(existing.getConfig() instanceof LdapIdentityProviderDefinition)) break;
                LdapIdentityProviderDefinition existingDefinition = (LdapIdentityProviderDefinition)existing.getConfig();
                definition.setBindPassword(existingDefinition.getBindPassword());
                break;
            }
            case "oauth2.0": 
            case "oidc1.0": {
                IdentityProvider existing;
                AbstractXOAuthIdentityProviderDefinition definition;
                if (!(provider.getConfig() instanceof AbstractXOAuthIdentityProviderDefinition) || (definition = (AbstractXOAuthIdentityProviderDefinition)provider.getConfig()).getRelyingPartySecret() != null || (existing = this.identityProviderProvisioning.retrieve(id, zoneId)) == null || existing.getConfig() == null || !(existing.getConfig() instanceof AbstractXOAuthIdentityProviderDefinition)) break;
                AbstractXOAuthIdentityProviderDefinition existingDefinition = (AbstractXOAuthIdentityProviderDefinition)existing.getConfig();
                definition.setRelyingPartySecret(existingDefinition.getRelyingPartySecret());
                break;
            }
        }
    }

    protected void redactSensitiveData(IdentityProvider provider) {
        if (provider.getConfig() == null) {
            return;
        }
        switch (provider.getType()) {
            case "ldap": {
                if (!(provider.getConfig() instanceof LdapIdentityProviderDefinition)) break;
                logger.debug((Object)("Removing bind password from LDAP provider id:" + provider.getId()));
                LdapIdentityProviderDefinition definition = (LdapIdentityProviderDefinition)provider.getConfig();
                definition.setBindPassword(null);
                break;
            }
            case "oauth2.0": 
            case "oidc1.0": {
                if (!(provider.getConfig() instanceof AbstractXOAuthIdentityProviderDefinition)) break;
                logger.debug((Object)("Removing relying secret from OAuth/OIDC provider id:" + provider.getId()));
                AbstractXOAuthIdentityProviderDefinition definition = (AbstractXOAuthIdentityProviderDefinition)provider.getConfig();
                definition.setRelyingPartySecret(null);
                break;
            }
        }
    }

    protected static class NoOpLdapLoginAuthenticationManager
    extends LdapLoginAuthenticationManager {
        public NoOpLdapLoginAuthenticationManager() {
            super(null);
        }

        @Override
        public Authentication authenticate(Authentication request) throws AuthenticationException {
            return request;
        }
    }
}

