/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth.openid;

import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.oauth.TokenEndpointBuilder;
import org.cloudfoundry.identity.uaa.oauth.TokenValidityResolver;
import org.cloudfoundry.identity.uaa.oauth.openid.IdToken;
import org.cloudfoundry.identity.uaa.oauth.openid.IdTokenCreationException;
import org.cloudfoundry.identity.uaa.oauth.openid.UserAuthenticationData;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.cloudfoundry.identity.uaa.user.UaaUserDatabase;
import org.cloudfoundry.identity.uaa.util.TimeService;
import org.cloudfoundry.identity.uaa.util.UaaTokenUtils;
import org.cloudfoundry.identity.uaa.zone.ClientServicesExtension;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.oauth2.provider.ClientDetails;

public class IdTokenCreator {
    private final String ROLES_SCOPE = "roles";
    private final Log logger = LogFactory.getLog(this.getClass());
    private TokenEndpointBuilder tokenEndpointBuilder;
    private TimeService timeService;
    private TokenValidityResolver tokenValidityResolver;
    private UaaUserDatabase uaaUserDatabase;
    private ClientServicesExtension clientServicesExtension;
    private Set<String> excludedClaims;

    public IdTokenCreator(TokenEndpointBuilder tokenEndpointBuilder, TimeService timeService, TokenValidityResolver tokenValidityResolver, UaaUserDatabase uaaUserDatabase, ClientServicesExtension clientServicesExtension, Set<String> excludedClaims) {
        this.timeService = timeService;
        this.tokenValidityResolver = tokenValidityResolver;
        this.uaaUserDatabase = uaaUserDatabase;
        this.clientServicesExtension = clientServicesExtension;
        this.excludedClaims = excludedClaims;
        this.tokenEndpointBuilder = tokenEndpointBuilder;
    }

    public IdToken create(String clientId, String userId, UserAuthenticationData userAuthenticationData) throws IdTokenCreationException {
        UaaUser uaaUser;
        Date expiryDate = this.tokenValidityResolver.resolve(clientId);
        Date issuedAt = this.timeService.getCurrentDate();
        try {
            uaaUser = this.uaaUserDatabase.retrieveUserById(userId);
        }
        catch (UsernameNotFoundException e) {
            this.logger.error((Object)("Could not create ID token for unknown user " + userId), (Throwable)e);
            throw new IdTokenCreationException();
        }
        String givenName = this.getIfScopeContainsProfile(uaaUser.getGivenName(), userAuthenticationData.scopes);
        String familyName = this.getIfScopeContainsProfile(uaaUser.getFamilyName(), userAuthenticationData.scopes);
        String phoneNumber = this.getIfScopeContainsProfile(uaaUser.getPhoneNumber(), userAuthenticationData.scopes);
        String issuerUrl = this.tokenEndpointBuilder.getTokenEndpoint();
        String identityZoneId = IdentityZoneHolder.get().getId();
        Map<String, List<String>> userAttributes = this.buildUserAttributes(userAuthenticationData, uaaUser);
        Set<String> roles = this.buildRoles(userAuthenticationData, uaaUser);
        ClientDetails clientDetails = this.clientServicesExtension.loadClientByClientId(clientId, identityZoneId);
        String clientTokenSalt = (String)clientDetails.getAdditionalInformation().get("token_salt");
        String revSig = UaaTokenUtils.getRevocableTokenSignature(uaaUser, clientTokenSalt, clientId, clientDetails.getClientSecret());
        return new IdToken(this.getIfNotExcluded(userId, "user_id"), this.getIfNotExcluded(Lists.newArrayList((Object[])new String[]{clientId}), "aud"), this.getIfNotExcluded(issuerUrl, "iss"), this.getIfNotExcluded(expiryDate, "exp"), this.getIfNotExcluded(issuedAt, "iat"), this.getIfNotExcluded(userAuthenticationData.authTime, "auth_time"), this.getIfNotExcluded(userAuthenticationData.authenticationMethods, "amr"), this.getIfNotExcluded(userAuthenticationData.contextClassRef, "acr"), this.getIfNotExcluded(clientId, "azp"), this.getIfNotExcluded(givenName, "given_name"), this.getIfNotExcluded(familyName, "family_name"), this.getIfNotExcluded(uaaUser.getPreviousLogonTime(), "previous_logon_time"), this.getIfNotExcluded(phoneNumber, "phone_number"), this.getIfNotExcluded(roles, "roles"), this.getIfNotExcluded(userAttributes, "user_attributes"), this.getIfNotExcluded(uaaUser.isVerified(), "email_verified"), this.getIfNotExcluded(userAuthenticationData.nonce, "nonce"), this.getIfNotExcluded(uaaUser.getEmail(), "email"), this.getIfNotExcluded(clientId, "cid"), this.getIfNotExcluded(userAuthenticationData.grantType, "grant_type"), this.getIfNotExcluded(uaaUser.getUsername(), "user_name"), this.getIfNotExcluded(identityZoneId, "zid"), this.getIfNotExcluded(uaaUser.getOrigin(), "origin"), this.getIfNotExcluded(userAuthenticationData.jti, "jti"), this.getIfNotExcluded(revSig, "rev_sig"));
    }

    private String getIfScopeContainsProfile(String value, Set<String> scopes) {
        return scopes.contains("profile") ? value : null;
    }

    private <T> T getIfNotExcluded(T value, String excludedKey) {
        return this.excludedClaims.contains(excludedKey) ? null : (T)value;
    }

    private Map<String, List<String>> buildUserAttributes(UserAuthenticationData userAuthenticationData, UaaUser user) {
        Map<String, List<String>> attributes = null;
        boolean requestedAttributes = userAuthenticationData.scopes.contains("user_attributes");
        if (requestedAttributes) {
            attributes = userAuthenticationData.userAttributes;
        }
        if (requestedAttributes && attributes == null) {
            this.logger.debug((Object)String.format("Requested id_token containing %s, but no saved attributes available for user with id:%s. Ensure storeCustomAttributes is enabled for origin:%s in zone:%s.", "user_attributes", user.getId(), user.getOrigin(), IdentityZoneHolder.get().getId()));
        }
        return attributes;
    }

    private Set<String> buildRoles(UserAuthenticationData userAuthenticationData, UaaUser user) {
        boolean requestedRoles = userAuthenticationData.scopes.contains("roles");
        Set<String> roles = null;
        if (requestedRoles && userAuthenticationData.roles != null && !userAuthenticationData.roles.isEmpty()) {
            roles = userAuthenticationData.roles;
        }
        if (requestedRoles && roles == null) {
            this.logger.debug((Object)String.format("Requested id_token containing user roles, but no saved roles available for user with id:%s. Ensure storeCustomAttributes is enabled for origin:%s in zone:%s.", user.getId(), user.getOrigin(), IdentityZoneHolder.get().getId()));
        }
        return roles;
    }

    public void setTimeService(TimeService timeService) {
        this.timeService = timeService;
    }
}

