/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth.jwt;

import org.cloudfoundry.identity.uaa.oauth.jwt.HeaderParameters;
import org.cloudfoundry.identity.uaa.oauth.jwt.Jwt;
import org.cloudfoundry.identity.uaa.oauth.jwt.JwtHeader;
import org.cloudfoundry.identity.uaa.oauth.jwt.JwtHelper;
import org.springframework.security.jwt.codec.Codecs;
import org.springframework.security.jwt.crypto.sign.SignatureVerifier;

class JwtImpl
implements Jwt {
    private final JwtHeader header;
    private final byte[] content;
    private final byte[] crypto;
    private String claims;

    JwtImpl(JwtHeader header, byte[] content, byte[] crypto) {
        this.header = header;
        this.content = content;
        this.crypto = crypto;
        this.claims = Codecs.utf8Decode((byte[])content);
    }

    public void verifySignature(SignatureVerifier verifier) {
        verifier.verify(this.signingInput(), this.crypto);
    }

    private byte[] signingInput() {
        return Codecs.concat((byte[][])new byte[][]{this.safeB64UrlEncode(this.header.bytes()), JwtHelper.PERIOD, this.safeB64UrlEncode(this.content)});
    }

    private byte[] safeB64UrlEncode(byte[] bytes) {
        if (bytes.length == 0) {
            return bytes;
        }
        return Codecs.b64UrlEncode((byte[])bytes);
    }

    public byte[] bytes() {
        return Codecs.concat((byte[][])new byte[][]{Codecs.b64UrlEncode((byte[])this.header.bytes()), JwtHelper.PERIOD, Codecs.b64UrlEncode((byte[])this.content), JwtHelper.PERIOD, Codecs.b64UrlEncode((byte[])this.crypto)});
    }

    public String getClaims() {
        return Codecs.utf8Decode((byte[])this.content);
    }

    public String getEncoded() {
        return Codecs.utf8Decode((byte[])this.bytes());
    }

    public String toString() {
        return this.header + " " + this.claims + " [" + this.crypto.length + " crypto bytes]";
    }

    @Override
    public HeaderParameters getHeader() {
        return this.header == null ? null : this.header.parameters;
    }
}

