/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth.jwt;

import org.springframework.security.jwt.crypto.sign.MacSigner;
import org.springframework.security.jwt.crypto.sign.RsaVerifier;
import org.springframework.security.jwt.crypto.sign.SignatureVerifier;

public class CommonSignatureVerifier
implements SignatureVerifier {
    private final SignatureVerifier delegate;

    public CommonSignatureVerifier(String verificationKey) {
        if (verificationKey == null) {
            throw new IllegalArgumentException("verificationKey cannot be null");
        }
        this.delegate = CommonSignatureVerifier.isAssymetricKey(verificationKey) ? new RsaVerifier(verificationKey) : new MacSigner(verificationKey);
    }

    private static boolean isAssymetricKey(String key) {
        return key.startsWith("-----BEGIN");
    }

    public void verify(byte[] content, byte[] signature) {
        this.delegate.verify(content, signature);
    }

    public String algorithm() {
        return this.delegate.algorithm();
    }
}

