/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth.advice;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.oauth.CheckTokenEndpoint;
import org.cloudfoundry.identity.uaa.oauth.IntrospectEndpoint;
import org.cloudfoundry.identity.uaa.oauth.token.UaaTokenEndpoint;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.provider.error.DefaultWebResponseExceptionTranslator;
import org.springframework.security.oauth2.provider.error.WebResponseExceptionTranslator;
import org.springframework.util.MultiValueMap;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice(assignableTypes={CheckTokenEndpoint.class, IntrospectEndpoint.class, UaaTokenEndpoint.class})
public class HttpMethodNotSupportedAdvice {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private WebResponseExceptionTranslator exceptionTranslator = new DefaultWebResponseExceptionTranslator();

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public ResponseEntity<OAuth2Exception> handleMethodNotSupportedException(HttpRequestMethodNotSupportedException e) throws Exception {
        this.logger.info((Object)("Handling error: " + e.getClass().getSimpleName() + ", " + e.getMessage()));
        ResponseEntity result = this.exceptionTranslator.translate((Exception)e);
        if (HttpMethod.POST.matches(e.getMethod())) {
            OAuth2Exception cause = new OAuth2Exception("Parameters must be passed in the body of the request", ((OAuth2Exception)result.getBody()).getCause()){

                public String getOAuth2ErrorCode() {
                    return "query_string_not_allowed";
                }

                public int getHttpErrorCode() {
                    return HttpStatus.NOT_ACCEPTABLE.value();
                }
            };
            result = new ResponseEntity((Object)cause, (MultiValueMap)result.getHeaders(), HttpStatus.NOT_ACCEPTABLE);
        }
        return result;
    }
}

